/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.propertyTesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.ptp.rm.lml.monitor.core.listeners.IMonitorChangedListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class MonitorPropertyTester
extends PropertyTester {
    private static final String NAMESPACE = "org.eclipse.ptp.rm.monitor";
    private static final String IS_ACTIVE = "isActive";
    private String selectedMonitorId = null;

    private void requestEvaluationOfProperty() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IEventBroker b;
            IEvaluationService service = (IEvaluationService)window.getService(IEvaluationService.class);
            if (service != null) {
                service.requestEvaluation("org.eclipse.ptp.rm.monitor.isActive");
            }
            if ((b = (IEventBroker)window.getService(IEventBroker.class)) != null) {
                b.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
            }
        }
    }

    public MonitorPropertyTester() {
        MonitorControlManager.getInstance().addMonitorChangedListener(new IMonitorChangedListener(){

            public void monitorAdded(IMonitorControl[] monitors) {
            }

            public void monitorRemoved(IMonitorControl[] monitors) {
            }

            public void monitorUpdated(IMonitorControl[] monitors) {
                MonitorPropertyTester.this.requestEvaluationOfProperty();
            }
        });
        MonitorControlManager.getInstance().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                MonitorPropertyTester.this.selectedMonitorId = null;
                if (event.getSelection() instanceof IStructuredSelection && !(sel = (IStructuredSelection)event.getSelection()).isEmpty()) {
                    MonitorPropertyTester.this.selectedMonitorId = ((IMonitorControl)sel.getFirstElement()).getControlId();
                }
            }
        });
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Object selected;
        IStructuredSelection sel;
        IWorkbenchPage page;
        ISelection selection;
        IMonitorControl monitor = null;
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (selection = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getSelection("org.eclipse.ptp.rm.ui.views.MonitorView")) != null && selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty() && (selected = sel.getFirstElement()) instanceof IMonitorControl) {
            monitor = (IMonitorControl)selected;
        }
        if (monitor == null) {
            if (receiver instanceof IMonitorControl) {
                monitor = (IMonitorControl)receiver;
            } else if (this.selectedMonitorId != null) {
                monitor = MonitorControlManager.getInstance().getMonitorControl(this.selectedMonitorId);
            }
        }
        if (monitor != null && IS_ACTIVE.equals(property)) {
            return monitor.isActive() == this.toBoolean(expectedValue);
        }
        return false;
    }

    protected boolean toBoolean(Object expectedValue) {
        if (expectedValue instanceof Boolean) {
            return (Boolean)expectedValue;
        }
        return true;
    }
}

