/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.Stream;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.internal.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInputPacketReader
implements IDefinitionScope {
    private final BitBuffer bitBuffer;
    private final StreamInputReader streamInputReader;
    private final StructDefinition tracePacketHeaderDef;
    private final StructDefinition streamPacketContextDef;
    private final StructDefinition streamEventHeaderDef;
    private final StructDefinition streamEventContextDef;
    private StreamInputPacketIndexEntry currentPacket = null;
    private long lastTimestamp = 0L;
    private int currentCpu = 0;
    private int lostEventsInThisPacket;
    private long lostEventsDuration;
    private boolean hasLost = false;

    public StreamInputPacketReader(StreamInputReader streamInputReader) {
        this.streamInputReader = streamInputReader;
        this.bitBuffer = new BitBuffer();
        this.bitBuffer.setByteOrder(streamInputReader.getByteOrder());
        Stream currentStream = streamInputReader.getStreamInput().getStream();
        StructDeclaration tracePacketHeaderDecl = currentStream.getTrace().getPacketHeader();
        this.tracePacketHeaderDef = tracePacketHeaderDecl != null ? tracePacketHeaderDecl.createDefinition(this, "trace.packet.header") : null;
        StructDeclaration streamPacketContextDecl = currentStream.getPacketContextDecl();
        this.streamPacketContextDef = streamPacketContextDecl != null ? streamPacketContextDecl.createDefinition(this, "stream.packet.context") : null;
        StructDeclaration streamEventHeaderDecl = currentStream.getEventHeaderDecl();
        this.streamEventHeaderDef = streamEventHeaderDecl != null ? streamEventHeaderDecl.createDefinition(this, "stream.event.header") : null;
        StructDeclaration streamEventContextDecl = currentStream.getEventContextDecl();
        this.streamEventContextDef = streamEventContextDecl != null ? streamEventContextDecl.createDefinition(this, "stream.event.context") : null;
        Collection<IEventDeclaration> eventDecls = streamInputReader.getStreamInput().getStream().getEvents().values();
        for (IEventDeclaration event : eventDecls) {
            if (streamInputReader.getEventDefinitions().containsKey(event.getId())) continue;
            EventDefinition eventDef = event.createDefinition(streamInputReader);
            streamInputReader.addEventDefinition(event.getId(), eventDef);
        }
    }

    public void dispose() {
        this.bitBuffer.setByteBuffer(null);
    }

    StreamInputPacketIndexEntry getCurrentPacket() {
        return this.currentPacket;
    }

    public StructDefinition getStreamPacketContextDef() {
        return this.streamPacketContextDef;
    }

    public StructDefinition getStreamEventContextDef() {
        return this.streamEventContextDef;
    }

    public int getCPU() {
        return this.currentCpu;
    }

    @Override
    public String getPath() {
        return "";
    }

    void setCurrentPacket(StreamInputPacketIndexEntry currentPacket) {
        StreamInputPacketIndexEntry prevPacket = null;
        this.currentPacket = currentPacket;
        if (this.currentPacket != null) {
            MappedByteBuffer bb = null;
            try {
                bb = this.streamInputReader.getStreamInput().getFileChannel().map(FileChannel.MapMode.READ_ONLY, this.currentPacket.getOffsetBytes(), (this.currentPacket.getPacketSizeBits() + 7) / 8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bitBuffer.setByteBuffer(bb);
            if (this.tracePacketHeaderDef != null) {
                this.tracePacketHeaderDef.read(this.bitBuffer);
            }
            if (this.getStreamPacketContextDef() != null) {
                this.getStreamPacketContextDef().read(this.bitBuffer);
                if (this.getCurrentPacket().getTarget() != null) {
                    this.currentCpu = (int)this.getCurrentPacket().getTargetId();
                }
                this.lostEventsInThisPacket = (int)this.getCurrentPacket().getLostEvents();
                if (this.lostEventsInThisPacket != 0) {
                    long lostEventsStartTime;
                    this.hasLost = true;
                    int index = this.streamInputReader.getStreamInput().getIndex().getEntries().indexOf(currentPacket);
                    if (index == 0) {
                        lostEventsStartTime = currentPacket.getTimestampBegin() + 1L;
                    } else {
                        prevPacket = this.streamInputReader.getStreamInput().getIndex().getEntries().get(index - 1);
                        lostEventsStartTime = prevPacket.getTimestampEnd();
                    }
                    this.lostEventsDuration = Math.abs(lostEventsStartTime - currentPacket.getTimestampBegin());
                }
            }
            this.lastTimestamp = currentPacket.getTimestampBegin();
        } else {
            this.bitBuffer.setByteBuffer(null);
            this.lastTimestamp = 0L;
        }
    }

    public boolean hasMoreEvents() {
        if (this.currentPacket != null) {
            return this.hasLost || this.bitBuffer.position() < this.currentPacket.getContentSizeBits();
        }
        return false;
    }

    public EventDefinition readNextEvent() throws CTFReaderException {
        EventDefinition eventDef;
        long eventID = -2L;
        long timestamp = 0L;
        if (this.hasLost) {
            this.hasLost = false;
            EventDefinition eventDef2 = EventDeclaration.getLostEventDeclaration().createDefinition(this.streamInputReader);
            ((IntegerDefinition)eventDef2.getFields().getDefinitions().get("Lost events")).setValue(this.lostEventsInThisPacket);
            ((IntegerDefinition)eventDef2.getFields().getDefinitions().get("duration")).setValue(this.lostEventsDuration);
            eventDef2.setTimestamp(this.lastTimestamp);
            return eventDef2;
        }
        StructDefinition sehd = this.streamEventHeaderDef;
        BitBuffer currentBitBuffer = this.bitBuffer;
        if (sehd != null) {
            Definition variantDef;
            IntegerDefinition timestampDef;
            sehd.read(currentBitBuffer);
            Definition idDef = sehd.lookupDefinition("id");
            if (idDef instanceof SimpleDatatypeDefinition) {
                eventID = ((SimpleDatatypeDefinition)idDef).getIntegerValue();
            }
            if ((timestampDef = sehd.lookupInteger("timestamp")) != null) {
                timestamp = this.calculateTimestamp(timestampDef);
            }
            if ((variantDef = sehd.lookupDefinition("v")) instanceof VariantDefinition) {
                Definition def;
                StructDefinition variantCurrentField = (StructDefinition)((VariantDefinition)variantDef).getCurrentField();
                Definition idIntegerDef = variantCurrentField.lookupDefinition("id");
                if (idIntegerDef instanceof IntegerDefinition) {
                    eventID = ((IntegerDefinition)idIntegerDef).getValue();
                }
                if ((def = variantCurrentField.lookupDefinition("timestamp")) instanceof IntegerDefinition) {
                    timestamp = this.calculateTimestamp((IntegerDefinition)def);
                }
            }
        }
        if (this.streamEventContextDef != null) {
            this.streamEventContextDef.read(currentBitBuffer);
        }
        if ((eventDef = this.streamInputReader.getEventDefinitions().get(eventID)) == null) {
            throw new CTFReaderException("Incorrect event id : " + eventID);
        }
        if (eventDef.getEventContext() != null) {
            eventDef.getEventContext().read(currentBitBuffer);
        }
        if (eventDef.getFields() != null) {
            eventDef.getFields().read(currentBitBuffer);
        }
        eventDef.setTimestamp(timestamp);
        return eventDef;
    }

    private long calculateTimestamp(IntegerDefinition timestampDef) {
        int len = timestampDef.getDeclaration().getLength();
        if (timestampDef.getDeclaration().getLength() == 64) {
            this.lastTimestamp = timestampDef.getValue();
            return this.lastTimestamp;
        }
        long majorasbitmask = (1L << len) - 1L;
        long newval = timestampDef.getValue();
        if (newval < (this.lastTimestamp & majorasbitmask)) {
            newval += 1L << len;
        }
        this.lastTimestamp &= majorasbitmask ^ 0xFFFFFFFFFFFFFFFFL;
        this.lastTimestamp += newval;
        return this.lastTimestamp;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        return null;
    }
}

