/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Encoding;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.Stream;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;

public class EventDeclaration
implements IEventDeclaration {
    public static final long LOST_EVENT_ID = -1L;
    public static final long UNSET_EVENT_ID = -2L;
    private String name;
    private StructDeclaration context = null;
    private StructDeclaration fields = null;
    private Long id = -2L;
    private Stream stream = null;
    private long logLevel;
    private final Map<String, String> customAttributes = new HashMap<String, String>();

    @Override
    public EventDefinition createDefinition(StreamInputReader streamInputReader) {
        EventDefinition event = new EventDefinition(this, streamInputReader);
        if (this.context != null) {
            event.setContext(this.context.createDefinition(event, "context"));
        }
        if (this.fields != null) {
            event.setFields(this.fields.createDefinition(event, "fields"));
        }
        return event;
    }

    public static synchronized EventDeclaration getLostEventDeclaration() {
        EventDeclaration lostEvent = new EventDeclaration();
        IntegerDeclaration lostEventsDeclaration = new IntegerDeclaration(32, false, 10, ByteOrder.BIG_ENDIAN, Encoding.ASCII, null, 8L);
        IntegerDeclaration timestampDeclaration = new IntegerDeclaration(64, false, 10, ByteOrder.BIG_ENDIAN, Encoding.ASCII, null, 8L);
        lostEvent.fields = new StructDeclaration(1L);
        lostEvent.fields.addField("Lost events", lostEventsDeclaration);
        lostEvent.fields.addField("duration", timestampDeclaration);
        lostEvent.id = -1L;
        lostEvent.name = "Lost event";
        return lostEvent;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setContext(StructDeclaration context) {
        this.context = context;
    }

    public void setFields(StructDeclaration fields) {
        this.fields = fields;
    }

    @Override
    public StructDeclaration getFields() {
        return this.fields;
    }

    @Override
    public StructDeclaration getContext() {
        return this.context;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    @Override
    public Stream getStream() {
        return this.stream;
    }

    public boolean nameIsSet() {
        return this.name != null;
    }

    public boolean contextIsSet() {
        return this.context != null;
    }

    public boolean fieldsIsSet() {
        return this.fields != null;
    }

    public boolean idIsSet() {
        return this.id != null && this.id != -2L;
    }

    public boolean streamIsSet() {
        return this.stream != null;
    }

    @Override
    public long getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(long level) {
        this.logLevel = level;
    }

    @Override
    public Set<String> getCustomAttributes() {
        return this.customAttributes.keySet();
    }

    @Override
    public String getCustomAttribute(String key) {
        return this.customAttributes.get(key);
    }

    public void setCustomAttribute(String key, String value) {
        this.customAttributes.put(key, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDeclaration)) {
            return false;
        }
        EventDeclaration other = (EventDeclaration)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.stream == null ? other.stream != null : !this.stream.equals(other.stream)) {
            return false;
        }
        return this.customAttributes.equals(other.customAttributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.stream == null ? 0 : this.stream.hashCode());
        result = 31 * result + this.customAttributes.hashCode();
        return result;
    }
}

