/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.analysis.flow;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rephraserengine.core.util.ReverseIterator;

public final class FlowGraphNode<T> {
    private final String name;
    private final T data;
    private final List<FlowGraphNode<T>> successors;
    private final List<FlowGraphNode<T>> precedessors;

    public FlowGraphNode(String name, T data) {
        this.name = name;
        this.data = data;
        this.successors = new LinkedList<FlowGraphNode<T>>();
        this.precedessors = new LinkedList<FlowGraphNode<T>>();
    }

    public String getName() {
        return this.name;
    }

    public T getData() {
        return this.data;
    }

    public void connectTo(FlowGraphNode<T> node) {
        this.successors.add(node);
        node.precedessors.add(this);
    }

    public void connectTo(FlowGraphNode<T> ... nodes) {
        FlowGraphNode<T>[] flowGraphNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            FlowGraphNode<T> n3 = flowGraphNodeArray[n2];
            this.connectTo(n3);
            ++n2;
        }
    }

    public List<FlowGraphNode<T>> getSuccessors() {
        return this.successors;
    }

    public Iterable<FlowGraphNode<T>> getSuccessorsInReverse() {
        return new Iterable<FlowGraphNode<T>>(){

            @Override
            public Iterator<FlowGraphNode<T>> iterator() {
                return new ReverseIterator(FlowGraphNode.this.successors);
            }
        };
    }

    public List<FlowGraphNode<T>> getPrecedessors() {
        return this.precedessors;
    }

    Iterable<FlowGraphNode<T>> subgraphInReversePostOrder() {
        final LinkedList<FlowGraphNode<T>> result = new LinkedList<FlowGraphNode<T>>();
        this.inReversePostOrder(new Callback(this){

            @Override
            public void handle(FlowGraphNode<T> node) {
                result.add(node);
            }
        });
        return result;
    }

    Iterable<T> subgraphDataInReversePostOrder() {
        final LinkedList result = new LinkedList();
        this.inReversePostOrder(new Callback(this){

            @Override
            public void handle(FlowGraphNode<T> node) {
                result.add(node.getData());
            }
        });
        return result;
    }

    private void inReversePostOrder(Callback callback) {
        this.inReversePostOrder(new HashSet<FlowGraphNode<T>>(), callback);
    }

    private void inReversePostOrder(HashSet<FlowGraphNode<T>> visited, Callback callback) {
        visited.add(this);
        for (FlowGraphNode<T> n : this.getSuccessorsInReverse()) {
            if (visited.contains(n)) continue;
            super.inReversePostOrder(visited, callback);
        }
        callback.handle(this);
    }

    Iterable<FlowGraphNode<T>> subgraphInPreOrder() {
        final LinkedList<FlowGraphNode<T>> result = new LinkedList<FlowGraphNode<T>>();
        this.inPreOrder(new Callback(this){

            @Override
            public void handle(FlowGraphNode<T> node) {
                result.add(node);
            }
        });
        return result;
    }

    Iterable<T> subgraphDataInPreOrder() {
        final LinkedList result = new LinkedList();
        this.inPreOrder(new Callback(this){

            @Override
            public void handle(FlowGraphNode<T> node) {
                result.add(node.getData());
            }
        });
        return result;
    }

    private void inPreOrder(Callback callback) {
        this.inPreOrder(new HashSet<FlowGraphNode<T>>(), callback);
    }

    private void inPreOrder(HashSet<FlowGraphNode<T>> visited, Callback callback) {
        visited.add(this);
        callback.handle(this);
        for (FlowGraphNode<T> n : this.getSuccessors()) {
            if (visited.contains(n)) continue;
            super.inPreOrder(visited, callback);
        }
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.data.toString());
    }

    private abstract class Callback {
        private Callback() {
        }

        public abstract void handle(FlowGraphNode<T> var1);
    }
}

