/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statesystem;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.statesystem.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;

public class TmfStateSystemExplorer
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.ssview";
    private static final String emptyString = "";
    private static final String FS = File.separator;
    private static final Image FILTER_IMAGE = Activator.getDefault().getImageFromPath(String.valueOf(FS) + "icons" + FS + "elcl16" + FS + "filter_items.gif");
    private static final int ATTRIBUTE_NAME_COL = 0;
    private static final int QUARK_COL = 1;
    private static final int VALUE_COL = 2;
    private static final int TYPE_COL = 3;
    private static final int START_TIME_COL = 4;
    private static final int END_TIME_COL = 5;
    private static final int ATTRIBUTE_FULLPATH_COL = 6;
    private ITmfTrace fTrace;
    private Tree fTree;
    private volatile long fCurrentTimestamp = -1L;
    private boolean filterStatus = false;

    public TmfStateSystemExplorer() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        this.fTree = new Tree(parent, 0);
        TreeColumn nameCol = new TreeColumn(this.fTree, 0, 0);
        TreeColumn quarkCol = new TreeColumn(this.fTree, 0, 1);
        TreeColumn valueCol = new TreeColumn(this.fTree, 0, 2);
        TreeColumn typeCol = new TreeColumn(this.fTree, 0, 3);
        TreeColumn startCol = new TreeColumn(this.fTree, 0, 4);
        TreeColumn endCol = new TreeColumn(this.fTree, 0, 5);
        TreeColumn pathCol = new TreeColumn(this.fTree, 0, 6);
        nameCol.setText(Messages.TreeNodeColumnLabel);
        quarkCol.setText(Messages.QuarkColumnLabel);
        valueCol.setText(Messages.ValueColumnLabel);
        typeCol.setText(Messages.TypeColumnLabel);
        startCol.setText(Messages.StartTimeColumLabel);
        endCol.setText(Messages.EndTimeColumLabel);
        pathCol.setText(Messages.AttributePathColumnLabel);
        this.fTree.setItemCount(0);
        this.fTree.setHeaderVisible(true);
        nameCol.pack();
        valueCol.pack();
        this.fTree.addListener(17, new Listener(){

            public void handleEvent(Event e) {
                TreeItem item = (TreeItem)e.item;
                item.setExpanded(true);
                TmfStateSystemExplorer.this.updateTable();
            }
        });
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.fillToolBar();
    }

    private synchronized void createTable() {
        long ts = this.fCurrentTimestamp;
        if (this.fTrace == null) {
            return;
        }
        this.fTree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TmfStateSystemExplorer.this.fTree.setItemCount(0);
            }
        });
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ITmfTrace currentTrace = iTmfTraceArray[n2];
            final Map sss = currentTrace.getStateSystems();
            final LinkedHashMap<String, List> fullStates = new LinkedHashMap<String, List>();
            for (Map.Entry entry : sss.entrySet()) {
                String ssName = (String)entry.getKey();
                ITmfStateSystem ss = (ITmfStateSystem)entry.getValue();
                ss.waitUntilBuilt();
                if (ts == -1L || ts < ss.getStartTime() || ts > ss.getCurrentEndTime()) {
                    ts = ss.getStartTime();
                }
                try {
                    fullStates.put(ssName, ss.queryFullState(ts));
                }
                catch (TimeRangeException e) {
                    throw new RuntimeException();
                }
                catch (StateSystemDisposedException e) {
                    return;
                }
            }
            this.fTree.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeItem traceRoot = new TreeItem(TmfStateSystemExplorer.this.fTree, 0);
                    traceRoot.setText(0, currentTrace.getName());
                    for (Map.Entry entry : sss.entrySet()) {
                        String ssName = (String)entry.getKey();
                        ITmfStateSystem ss = (ITmfStateSystem)entry.getValue();
                        List fullState = (List)fullStates.get(ssName);
                        TreeItem item = new TreeItem(traceRoot, 0);
                        item.setText(0, ssName);
                        TmfStateSystemExplorer.this.addChildren(ss, fullState, -1, item);
                    }
                    TreeItem[] treeItemArray = TmfStateSystemExplorer.this.fTree.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        item.setExpanded(true);
                        ++n2;
                    }
                    TmfStateSystemExplorer.this.packColumns();
                    if (TmfStateSystemExplorer.this.filterStatus) {
                        TmfStateSystemExplorer.this.filterChildren(traceRoot);
                    }
                }
            });
            ++n2;
        }
    }

    private void addChildren(ITmfStateSystem ss, List<ITmfStateInterval> fullState, int rootQuark, TreeItem root) {
        try {
            Iterator iterator = ss.getSubAttributes(rootQuark, false).iterator();
            while (iterator.hasNext()) {
                int quark = (Integer)iterator.next();
                TreeItem subItem = new TreeItem(root, 0);
                subItem.setText(0, ss.getAttributeName(quark));
                subItem.setText(1, String.valueOf(quark));
                subItem.setText(6, ss.getFullAttributePath(quark));
                ITmfStateInterval interval = fullState.get(quark);
                this.populateColumns(subItem, interval);
                this.addChildren(ss, fullState, quark, subItem);
            }
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException();
        }
    }

    private synchronized void updateTable() {
        ITmfTrace[] traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        long ts = this.fCurrentTimestamp;
        int traceNb = 0;
        while (traceNb < traces.length) {
            Map sss = traces[traceNb].getStateSystems();
            int ssNb = 0;
            for (Map.Entry entry : sss.entrySet()) {
                final ITmfStateSystem ss = (ITmfStateSystem)entry.getValue();
                final int traceNb1 = traceNb;
                final int ssNb1 = ssNb;
                ts = ts == -1L ? ss.getStartTime() : ts;
                try {
                    final List fullState = ss.queryFullState(ts);
                    this.fTree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem traceItem = TmfStateSystemExplorer.this.fTree.getItem(traceNb1);
                            TreeItem item = traceItem.getItem(ssNb1);
                            item.setText(2, TmfStateSystemExplorer.emptyString);
                            TmfStateSystemExplorer.this.updateChildren(ss, fullState, -1, item);
                        }
                    });
                }
                catch (TimeRangeException e) {
                    this.fTree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem traceItem = TmfStateSystemExplorer.this.fTree.getItem(traceNb1);
                            TreeItem item = traceItem.getItem(ssNb1);
                            TmfStateSystemExplorer.this.markOutOfRange(item);
                        }
                    });
                }
                catch (StateSystemDisposedException e) {
                    return;
                }
                ++ssNb;
            }
            ++traceNb;
        }
    }

    private void updateChildren(ITmfStateSystem ss, List<ITmfStateInterval> state, int root_quark, TreeItem root) {
        try {
            TreeItem[] treeItemArray = root.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                int quark = ss.getQuarkRelative(root_quark, new String[]{item.getText(0)});
                ITmfStateInterval interval = state.get(quark);
                this.populateColumns(item, interval);
                this.updateChildren(ss, state, quark, item);
                ++n2;
            }
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException();
        }
    }

    private void populateColumns(TreeItem item, ITmfStateInterval interval) {
        try {
            String value;
            ITmfStateValue state = interval.getStateValue();
            switch (state.getType()) {
                case INTEGER: {
                    value = String.valueOf(state.unboxInt());
                    item.setText(3, Messages.TypeInteger);
                    break;
                }
                case LONG: {
                    value = String.valueOf(state.unboxLong());
                    item.setText(3, Messages.TypeLong);
                    break;
                }
                case STRING: {
                    value = state.unboxStr();
                    item.setText(3, Messages.TypeString);
                    break;
                }
                default: {
                    value = emptyString;
                    item.setText(3, emptyString);
                }
            }
            TmfTimestamp startTime = new TmfTimestamp(interval.getStartTime(), -9);
            item.setText(4, startTime.toString());
            TmfTimestamp endTime = new TmfTimestamp(interval.getEndTime(), -9);
            item.setText(5, endTime.toString());
            item.setBackground(Display.getDefault().getSystemColor(22));
            if (!(this.filterStatus || value.equals(item.getText(2)) && this.fCurrentTimestamp != startTime.getValue())) {
                item.setBackground(Display.getDefault().getSystemColor(7));
            }
            item.setText(2, value);
        }
        catch (StateValueTypeException e) {
            throw new RuntimeException();
        }
    }

    private void markOutOfRange(TreeItem root) {
        root.setText(2, Messages.OutOfRangeMsg);
        root.setText(3, emptyString);
        root.setText(4, emptyString);
        root.setText(5, emptyString);
        TreeItem[] treeItemArray = root.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.markOutOfRange(item);
            ++n2;
        }
    }

    private void packColumns() {
        TreeColumn[] treeColumnArray = this.fTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace != this.fTrace) {
            this.fTrace = trace;
            this.loadTrace();
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fTree.setItemCount(0);
        }
    }

    @TmfSignalHandler
    public void currentTimeUpdated(final TmfTimeSynchSignal signal) {
        Thread thread = new Thread("State system visualizer update"){

            @Override
            public void run() {
                ITmfTimestamp currentTime = signal.getBeginTime().normalize(0L, -9);
                TmfStateSystemExplorer.this.fCurrentTimestamp = currentTime.getValue();
                if (TmfStateSystemExplorer.this.filterStatus) {
                    TmfStateSystemExplorer.this.createTable();
                } else {
                    TmfStateSystemExplorer.this.updateTable();
                }
            }
        };
        thread.start();
    }

    private void loadTrace() {
        Thread thread = new Thread("State system visualizer construction"){

            @Override
            public void run() {
                TmfStateSystemExplorer.this.createTable();
            }
        };
        thread.start();
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        Thread thread = new Thread("State system visualizer update"){

            @Override
            public void run() {
                TmfStateSystemExplorer.this.updateTable();
            }
        };
        thread.start();
    }

    private boolean filterChildren(TreeItem root) {
        boolean valid = false;
        TmfTimestamp startTime = new TmfTimestamp(this.fCurrentTimestamp, -9);
        valid = root.getText(4).equals(startTime.toString());
        root.setExpanded(true);
        TreeItem[] treeItemArray = root.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            valid = this.filterChildren(item) || valid;
            ++n2;
        }
        if (!valid) {
            root.dispose();
        }
        return valid;
    }

    private void fillToolBar() {
        FilterAction fFilterAction = new FilterAction();
        fFilterAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)FILTER_IMAGE));
        fFilterAction.setToolTipText(Messages.FilterButton);
        fFilterAction.setChecked(false);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)fFilterAction);
    }

    private class FilterAction
    extends Action {
        private FilterAction() {
        }

        public void run() {
            TmfStateSystemExplorer.this.filterStatus = !TmfStateSystemExplorer.this.filterStatus;
            if (!TmfStateSystemExplorer.this.filterStatus) {
                TmfStateSystemExplorer.this.createTable();
            }
        }
    }
}

