/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;

public class LSFCommand
implements IRunnableWithProgress {
    private final String[] command;
    private final String commandDescription;
    private final IRemoteConnection remoteConnection;
    protected Vector<String[]> commandResponse;
    protected String[] columnLabels;
    public static final int OK = 0;
    public static final int COMMAND_ERROR = 3;
    public static final int CANCELED = 2;
    public static final int NO_DATA = 3;
    protected IRemoteProcess process;
    protected IStatus runStatus;

    public LSFCommand(String name, IRemoteConnection connection, String[] cmd) {
        this.commandDescription = name;
        this.remoteConnection = connection;
        this.command = cmd;
        this.commandResponse = new Vector();
    }

    public void run(IProgressMonitor monitor) {
        monitor.beginTask(this.commandDescription, -1);
        this.runStatus = this.runCommand(monitor);
        if (this.runStatus.isOK() && this.process.exitValue() == 0) {
            this.runStatus = this.getCommandOutput(monitor);
        }
        monitor.done();
    }

    protected IStatus runCommand(IProgressMonitor monitor) {
        IRemoteProcessBuilder processBuilder = this.remoteConnection.getProcessBuilder(this.command);
        this.process = null;
        try {
            this.process = processBuilder.start();
            try {
                while (!this.process.isCompleted()) {
                    if (monitor.isCanceled()) {
                        this.process.destroy();
                        return new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, Messages.LSFCommandFailed, (Throwable)e);
        }
        return new Status(0, "org.eclipse.ptp.rm.ibm.lsf.ui", 0, Messages.OkMessage, null);
    }

    protected IStatus getCommandOutput(IProgressMonitor monitor) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            String data = reader.readLine();
            boolean headerLine = true;
            while (data != null) {
                if (headerLine) {
                    if (data.equals("No application profiles found.")) {
                        reader.close();
                        return new Status(1, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, Messages.NoProfileMessage, null);
                    }
                    headerLine = false;
                }
                data = reader.readLine();
                if (!monitor.isCanceled()) continue;
                reader.close();
                return new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            data = reader.readLine();
            headerLine = true;
            this.commandResponse.clear();
            while (data != null) {
                if (headerLine) {
                    if (data.equals("No reservation found")) {
                        reader.close();
                        return new Status(1, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, Messages.NoReservationMessage, null);
                    }
                    this.columnLabels = data.split(" +");
                    headerLine = false;
                } else {
                    data = data.replaceAll(" +/ +", "/");
                    String[] columnData = data.split(" +");
                    this.commandResponse.add(columnData);
                }
                data = reader.readLine();
                if (!monitor.isCanceled()) continue;
                reader.close();
                return new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
            }
            reader.close();
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, "Error reading command output", (Throwable)e);
        }
        return new Status(0, "org.eclipse.ptp.rm.ibm.lsf.ui", 0, Messages.OkMessage, null);
    }

    public Vector<String[]> getCommandResponse() {
        return this.commandResponse;
    }

    public String[] getColumnLabels() {
        return this.columnLabels;
    }

    public IStatus getRunStatus() {
        return this.runStatus;
    }
}

