/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.callstack;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public abstract class CallStackStateProvider
extends AbstractTmfStateProvider {
    public static final String ID = "org.eclipse.linuxtools.tmf.callstack";
    public static final String THREADS = "Threads";
    public static final String CALL_STACK = "CallStack";
    public static final String UNDEFINED = "UNDEFINED";
    private static final int VERSION = 0;

    public CallStackStateProvider(ITmfTrace trace) {
        super(trace, ITmfEvent.class, ID);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        String functionEntryName = this.functionEntry(event);
        try {
            if (functionEntryName != null) {
                long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                String thread = this.threadName(event);
                int quark = this.ss.getQuarkAbsoluteAndAdd(THREADS, thread, CALL_STACK);
                TmfStateValue value = TmfStateValue.newValueString(functionEntryName);
                this.ss.pushAttribute(timestamp, value, quark);
            } else if (this.functionExit(event) != null) {
                long timestamp = event.getTimestamp().normalize(0L, -9).getValue();
                String thread = this.threadName(event);
                int quark = this.ss.getQuarkAbsoluteAndAdd(THREADS, thread, CALL_STACK);
                this.ss.popAttribute(timestamp, quark);
            }
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
    }

    public abstract String functionEntry(ITmfEvent var1);

    public abstract String functionExit(ITmfEvent var1);

    public abstract String threadName(ITmfEvent var1);
}

