/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch.provider.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.Messages;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.ProviderFramework;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationTabGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ProviderLaunchConfigurationDelegate
extends ProfileLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (config != null) {
            ProfileLaunchConfigurationDelegate delegate;
            String cProjectName;
            String providerId = config.getAttribute("provider", "");
            String providerToolName = config.getAttribute("toolname", "");
            if ((providerId == null || providerId.isEmpty()) && (cProjectName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "")) != null && !cProjectName.isEmpty()) {
                ProfileLaunchConfigurationTabGroup tabGroupConfig;
                String defaultType = null;
                String[] categories = ProviderFramework.getProviderCategories();
                if (categories.length == 0) {
                    this.infoDialog(Messages.ProviderNoProfilers_title_0, Messages.ProviderNoProfilers_msg_0);
                    return;
                }
                String[] stringArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    String category = stringArray[n2];
                    if (category.equals("timing")) {
                        defaultType = "timing";
                    }
                    ++n2;
                }
                if (defaultType == null) {
                    defaultType = categories[0];
                }
                if ((tabGroupConfig = ProviderFramework.getTabGroupProviderFromId(providerId = ProviderFramework.getProviderIdToRun(null, defaultType))) == null) {
                    this.infoDialog(Messages.ProviderNoProfilers_title_0, Messages.ProviderNoProfilers_msg_0);
                    return;
                }
                AbstractLaunchConfigurationTab[] tabs = tabGroupConfig.getProfileTabs();
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                AbstractLaunchConfigurationTab[] abstractLaunchConfigurationTabArray = tabs;
                int n3 = tabs.length;
                int n4 = 0;
                while (n4 < n3) {
                    AbstractLaunchConfigurationTab tab = abstractLaunchConfigurationTabArray[n4];
                    tab.setDefaults(wc);
                    ++n4;
                }
                config = wc.doSave();
            }
            if ((delegate = ProviderFramework.getConfigurationDelegateFromId(providerId)) != null) {
                delegate.launch(config, mode, launch, monitor);
            } else {
                String message = providerToolName.isEmpty() ? NLS.bind((String)Messages.ProviderProfilerMissing_msg_0, (Object)providerId) : NLS.bind((String)Messages.ProviderProfilerMissing_msg_1, (Object)providerToolName);
                this.infoDialog(Messages.ProviderProfilerMissing_title_0, message);
            }
        }
    }

    private void infoDialog(final String title, final String message) {
        ProfileLaunchPlugin.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)ProfileLaunchPlugin.getShell(), (String)title, (String)message);
            }
        });
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.profiling.launch";
    }
}

