/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

abstract class TimeDraw {
    protected static final long MICROSEC_IN_NS = 1000L;
    protected static final long MILLISEC_IN_NS = 1000000L;
    protected static final long MILLISEC_IN_US = 1000L;
    protected static final long SEC_IN_NS = 1000000000L;
    protected static final long SEC_IN_MS = 1000L;
    private static final String S = "";
    private static final String S0 = "0";
    private static final String S00 = "00";
    protected static final long PAD_1000 = 1000L;
    protected static final SimpleDateFormat SEC_FORMAT_HEADER = new SimpleDateFormat("yyyy MMM dd");
    protected static final SimpleDateFormat SEC_FORMAT = new SimpleDateFormat("HH:mm:ss");
    protected static final SimpleDateFormat MIN_FORMAT_HEADER = new SimpleDateFormat("yyyy MMM dd");
    protected static final SimpleDateFormat MIN_FORMAT = new SimpleDateFormat("HH:mm");
    protected static final SimpleDateFormat HOURS_FORMAT_HEADER = new SimpleDateFormat("yyyy");
    protected static final SimpleDateFormat HOURS_FORMAT = new SimpleDateFormat("MMM dd HH:mm");
    protected static final SimpleDateFormat DAY_FORMAT_HEADER = new SimpleDateFormat("yyyy");
    protected static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("MMM dd");
    protected static final SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("yyyy MMM");
    protected static final SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");
    protected static final SimpleDateFormat[] formatArray = new SimpleDateFormat[]{SEC_FORMAT, SEC_FORMAT_HEADER, MIN_FORMAT, MIN_FORMAT_HEADER, HOURS_FORMAT, HOURS_FORMAT_HEADER, DAY_FORMAT, DAY_FORMAT_HEADER, MONTH_FORMAT, YEAR_FORMAT};

    TimeDraw() {
    }

    public static void updateTimeZone() {
        TimeZone timeZone = TmfTimePreferences.getInstance().getTimeZone();
        SimpleDateFormat[] simpleDateFormatArray = formatArray;
        int n = formatArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleDateFormat sdf = simpleDateFormatArray[n2];
            sdf.setTimeZone(timeZone);
            ++n2;
        }
    }

    static String sep(long n) {
        StringBuilder retVal = new StringBuilder();
        String s = Long.toString(n);
        int i = 0;
        while (i < s.length()) {
            int pos = s.length() - i - 1;
            retVal.append(s.charAt(i));
            if (pos % 3 == 0 && pos != 0) {
                retVal.append(' ');
            }
            ++i;
        }
        return retVal.toString();
    }

    static String pad(long n) {
        String s = n < 10L ? S00 : (n < 100L ? S0 : S);
        return String.valueOf(s) + n;
    }

    public abstract void draw(GC var1, long var2, Rectangle var4);

    public void drawAbsHeader(GC gc, long nanosec, Rectangle absHeaderRect) {
    }
}

