/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class SnaphshotHandler
extends BaseControlViewHandler {
    protected List<TraceSessionComponent> fSessions = new ArrayList<TraceSessionComponent>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fLock.lock();
        try {
            final ArrayList<TraceSessionComponent> sessions = new ArrayList<TraceSessionComponent>();
            sessions.addAll(this.fSessions);
            Job job = new Job(Messages.TraceControl_RecordSnapshotJob){

                protected IStatus run(IProgressMonitor monitor) {
                    MultiStatus status = new MultiStatus("org.eclipse.linuxtools.lttng2.ui", 0, null, null);
                    Iterator iterator = sessions.iterator();
                    while (iterator.hasNext()) {
                        try {
                            TraceSessionComponent session = (TraceSessionComponent)iterator.next();
                            session.recordSnapshot(monitor);
                            if (!monitor.isCanceled()) continue;
                            status.add(Status.CANCEL_STATUS);
                            break;
                        }
                        catch (ExecutionException e) {
                            status.add((IStatus)new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_RecordSnapshotFailure, (Throwable)e));
                        }
                    }
                    return status;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ArrayList<TraceSessionComponent> sessions = new ArrayList<TraceSessionComponent>(0);
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent session;
                if (!(element instanceof TraceSessionComponent) || !(session = (TraceSessionComponent)element).isSnapshotSession() || session.getSessionState() != TraceSessionState.ACTIVE || session.isDestroyed()) continue;
                sessions.add(session);
            }
        }
        boolean isEnabled = !sessions.isEmpty();
        this.fLock.lock();
        try {
            this.fSessions = null;
            if (isEnabled) {
                this.fSessions = sessions;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

