/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCCodeFormatter;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class RemoteCFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList<IDocument> fDocuments = new LinkedList();
    private final LinkedList<TypedPosition> fPartitions = new LinkedList();

    public void format() {
        super.format();
        IDocument document = this.fDocuments.removeFirst();
        TypedPosition partition = this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            try {
                Map preferences = this.getPreferences();
                TextEdit edit = RemoteCFormattingStrategy.format(8, document.get(), partition.getOffset(), partition.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document), preferences);
                if (edit != null) {
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException exception) {
                UIPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                UIPlugin.log(exception);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        Object property = context.getProperty((Object)"formatting.context.partition");
        if (property instanceof TypedPosition) {
            this.fPartitions.addLast((TypedPosition)property);
        }
        if ((property = context.getProperty((Object)"formatting.context.medium")) instanceof IDocument) {
            this.fDocuments.addLast((IDocument)property);
        }
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }

    private static TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator, Map<String, ?> options) {
        if (offset < 0 || length < 0 || offset + length > source.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + offset + ", length: " + length + ", string size: " + source.length());
        }
        if (options == null) {
            options = CCorePlugin.getOptions();
        }
        RemoteCCodeFormatter formatter = new RemoteCCodeFormatter(options);
        return formatter.format(kind, source, offset, length, indentationLevel, lineSeparator);
    }
}

