/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.MessageConsole;

public class RpmConsole
extends IOConsole {
    public static final String ID = "rpmbuild";
    private RPMProject rpmProject;

    public RpmConsole(RPMProject rpmProject) {
        super("rpmbuild(" + rpmProject.getSpecFile().getProject().getName() + ')', ID, null, true);
        this.rpmProject = rpmProject;
    }

    public IResource getSpecfile() {
        return this.rpmProject.getSpecFile();
    }

    public static IOConsole findConsole(String packageName) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        String projectConsoleName = "rpmbuild(" + packageName + ')';
        MessageConsole ret = null;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole cons = iConsoleArray[n2];
            if (cons.getName().equals(projectConsoleName)) {
                ret = (MessageConsole)cons;
            }
            ++n2;
        }
        if (ret == null) {
            ret = new MessageConsole("rpmbuild(" + packageName + ')', null, null, true);
        }
        conMan.addConsoles(new IConsole[]{ret});
        ret.clearConsole();
        ret.activate();
        return ret;
    }
}

