/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.debug.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.ptp.internal.proxy.debug.event.ProxyDebugEventFactory;
import org.eclipse.ptp.proxy.client.AbstractProxyClient;
import org.eclipse.ptp.proxy.debug.client.IProxyDebugClient;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugArgsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugDataEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugErrorEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEventFactory;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEventListener;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugExitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugInfoThreadsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugMemoryInfoEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugOKEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugOutputEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSetThreadSelectEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalExitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStackInfoDepthEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStackframeEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStepEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSuspendEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugTypeEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugVarsEvent;
import org.eclipse.ptp.proxy.event.IProxyConnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyDisconnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyErrorEvent;
import org.eclipse.ptp.proxy.event.IProxyEventListener;
import org.eclipse.ptp.proxy.event.IProxyExtendedEvent;
import org.eclipse.ptp.proxy.event.IProxyMessageEvent;
import org.eclipse.ptp.proxy.event.IProxyOKEvent;
import org.eclipse.ptp.proxy.event.IProxyTimeoutEvent;

public abstract class AbstractProxyDebugClient
extends AbstractProxyClient
implements IProxyDebugClient,
IProxyEventListener {
    private final List<IProxyDebugEventListener> listeners = Collections.synchronizedList(new ArrayList());
    protected boolean waiting = false;
    protected boolean timeout = false;
    protected final ReentrantLock waitLock = new ReentrantLock();
    protected final Condition waitCondition = this.waitLock.newCondition();
    protected volatile DebugProxyState state;
    protected IProxyDebugEventFactory factory = new ProxyDebugEventFactory();

    public AbstractProxyDebugClient() {
        super.setEventFactory(this.factory);
    }

    public void addProxyDebugEventListener(IProxyDebugEventListener listener) {
        this.listeners.add(listener);
    }

    public void doInitialize(int port) throws IOException {
        this.state = DebugProxyState.DISCONNECTED;
        this.addProxyEventListener(this);
        this.sessionCreate(port, 0);
        this.state = DebugProxyState.CONNECTING;
    }

    public void doShutdown() throws IOException {
        this.waitLock.lock();
        try {
            if (this.state == DebugProxyState.CONNECTING || this.state == DebugProxyState.CONNECTED) {
                this.state = DebugProxyState.DISCONNECTING;
                this.sessionFinish();
                while (this.state == DebugProxyState.DISCONNECTING) {
                    this.waiting = true;
                    try {
                        this.waitCondition.await(30000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            this.waitLock.unlock();
            this.state = DebugProxyState.DISCONNECTED;
        }
        this.removeProxyEventListener(this);
    }

    protected void fireProxyDebugArgsEvent(IProxyDebugArgsEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugArgsEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugBreakpointHitEvent(IProxyDebugBreakpointHitEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugBreakpointHitEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugBreakpointSetEvent(IProxyDebugBreakpointSetEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugBreakpointSetEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugDataEvent(IProxyDebugDataEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugDataEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugErrorEvent(IProxyDebugErrorEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugErrorEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugExitEvent(IProxyDebugExitEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugExitEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugInfoThreadsEvent(IProxyDebugInfoThreadsEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugInfoThreadsEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugMemoryInfoEvent(IProxyDebugMemoryInfoEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugMemoryInfoEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugOKEvent(IProxyDebugOKEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugOKEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugOutputEvent(IProxyDebugOutputEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugOutputEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugSetThreadSelectEvent(IProxyDebugSetThreadSelectEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugSetThreadSelectEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugSignalEvent(IProxyDebugSignalEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugSignalEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugSignalExitEvent(IProxyDebugSignalExitEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugSignalExitEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugSignalsEvent(IProxyDebugSignalsEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugSignalsEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugStackframeEvent(IProxyDebugStackframeEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugStackframeEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugStackInfoDepthEvent(IProxyDebugStackInfoDepthEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugStackInfoDepthEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugStepEvent(IProxyDebugStepEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugStepEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugSuspendEvent(IProxyDebugSuspendEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugSuspendEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugTypeEvent(IProxyDebugTypeEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugTypeEvent(e);
            ++n2;
        }
    }

    protected void fireProxyDebugVarsEvent(IProxyDebugVarsEvent e) {
        IProxyDebugEventListener[] la;
        IProxyDebugEventListener[] iProxyDebugEventListenerArray = la = this.listeners.toArray(new IProxyDebugEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyDebugEventListener listener = iProxyDebugEventListenerArray[n2];
            listener.handleProxyDebugVarsEvent(e);
            ++n2;
        }
    }

    public void handleEvent(IProxyConnectedEvent e) {
        this.waitLock.lock();
        try {
            this.state = DebugProxyState.CONNECTED;
            if (this.waiting) {
                this.waitCondition.signalAll();
                this.waiting = false;
            }
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void handleEvent(IProxyDisconnectedEvent e) {
        this.waitLock.lock();
        try {
            if (this.state == DebugProxyState.DISCONNECTING) {
                this.state = DebugProxyState.DISCONNECTED;
                if (this.waiting) {
                    this.waitCondition.signalAll();
                    this.waiting = false;
                }
            }
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void handleEvent(IProxyErrorEvent e) {
    }

    public void handleEvent(IProxyExtendedEvent e) {
        if (e instanceof IProxyDebugArgsEvent) {
            this.fireProxyDebugArgsEvent((IProxyDebugArgsEvent)e);
        } else if (e instanceof IProxyDebugBreakpointHitEvent) {
            this.fireProxyDebugBreakpointHitEvent((IProxyDebugBreakpointHitEvent)e);
        } else if (e instanceof IProxyDebugBreakpointSetEvent) {
            this.fireProxyDebugBreakpointSetEvent((IProxyDebugBreakpointSetEvent)e);
        } else if (e instanceof IProxyDebugDataEvent) {
            this.fireProxyDebugDataEvent((IProxyDebugDataEvent)e);
        } else if (e instanceof IProxyDebugExitEvent) {
            this.fireProxyDebugExitEvent((IProxyDebugExitEvent)e);
        } else if (e instanceof IProxyDebugErrorEvent) {
            this.fireProxyDebugErrorEvent((IProxyDebugErrorEvent)e);
        } else if (e instanceof IProxyDebugInfoThreadsEvent) {
            this.fireProxyDebugInfoThreadsEvent((IProxyDebugInfoThreadsEvent)e);
        } else if (e instanceof IProxyDebugOutputEvent) {
            this.fireProxyDebugOutputEvent((IProxyDebugOutputEvent)e);
        } else if (e instanceof IProxyDebugMemoryInfoEvent) {
            this.fireProxyDebugMemoryInfoEvent((IProxyDebugMemoryInfoEvent)e);
        } else if (e instanceof IProxyDebugOKEvent) {
            this.fireProxyDebugOKEvent((IProxyDebugOKEvent)e);
        } else if (e instanceof IProxyDebugSetThreadSelectEvent) {
            this.fireProxyDebugSetThreadSelectEvent((IProxyDebugSetThreadSelectEvent)e);
        } else if (e instanceof IProxyDebugSignalEvent) {
            this.fireProxyDebugSignalEvent((IProxyDebugSignalEvent)e);
        } else if (e instanceof IProxyDebugSignalExitEvent) {
            this.fireProxyDebugSignalExitEvent((IProxyDebugSignalExitEvent)e);
        } else if (e instanceof IProxyDebugSignalsEvent) {
            this.fireProxyDebugSignalsEvent((IProxyDebugSignalsEvent)e);
        } else if (e instanceof IProxyDebugStackframeEvent) {
            this.fireProxyDebugStackframeEvent((IProxyDebugStackframeEvent)e);
        } else if (e instanceof IProxyDebugStackInfoDepthEvent) {
            this.fireProxyDebugStackInfoDepthEvent((IProxyDebugStackInfoDepthEvent)e);
        } else if (e instanceof IProxyDebugStepEvent) {
            this.fireProxyDebugStepEvent((IProxyDebugStepEvent)e);
        } else if (e instanceof IProxyDebugSuspendEvent) {
            this.fireProxyDebugSuspendEvent((IProxyDebugSuspendEvent)e);
        } else if (e instanceof IProxyDebugTypeEvent) {
            this.fireProxyDebugTypeEvent((IProxyDebugTypeEvent)e);
        } else if (e instanceof IProxyDebugVarsEvent) {
            this.fireProxyDebugVarsEvent((IProxyDebugVarsEvent)e);
        }
    }

    public void handleEvent(IProxyMessageEvent e) {
        this.waitLock.lock();
        try {
            if (this.state == DebugProxyState.DISCONNECTING) {
                this.state = DebugProxyState.DISCONNECTED;
                if (this.waiting) {
                    this.waitCondition.signalAll();
                    this.waiting = false;
                }
            }
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void handleEvent(IProxyOKEvent e) {
    }

    public void handleEvent(IProxyTimeoutEvent e) {
        this.waitLock.lock();
        try {
            this.timeout = true;
            if (this.waiting) {
                this.waitCondition.signalAll();
                this.waiting = false;
            }
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void removeProxyDebugEventListener(IProxyDebugEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DebugProxyState {
        DISCONNECTED,
        DISCONNECTING,
        CONNECTED,
        CONNECTING;

    }
}

