/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.tracepointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.AbstractTracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.ITracepointAction;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.MessagesForTracepointActions;
import org.eclipse.cdt.dsf.gdb.internal.tracepointactions.TracepointActionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class WhileSteppingAction
extends AbstractTracepointAction {
    private static final String WHILE_STEPPING_ACTION_ID = "org.eclipse.cdt.dsf.gdb.tracepointactions.WhileSteppingAction";
    private String fSubActionNames = "";
    private String fSubActionContent = "";
    private int fStepCount = 1;

    public String getDefaultName() {
        return MessagesForTracepointActions.TracepointActions_Untitled_WhileStepping;
    }

    public String getSubActionsNames() {
        return this.fSubActionNames;
    }

    public void setSubActionsNames(String str) {
        this.fSubActionNames = str;
    }

    public String getSubActionsContent() {
        return this.fSubActionContent;
    }

    public void setSubActionsContent(String subActionNames) {
        String[] names = subActionNames.split(",");
        this.fSubActionContent = "";
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ITracepointAction action = TracepointActionManager.getInstance().findAction(name.trim());
            if (action != null) {
                this.fSubActionContent = String.valueOf(this.fSubActionContent) + action.getSummary() + ",";
            }
            ++n2;
        }
        if (this.fSubActionContent.length() > 0) {
            this.fSubActionContent = this.fSubActionContent.substring(0, this.fSubActionContent.length() - 1);
        }
    }

    public int getStepCount() {
        return this.fStepCount;
    }

    public void setStepCount(int count) {
        this.fStepCount = count;
    }

    public String getIdentifier() {
        return WHILE_STEPPING_ACTION_ID;
    }

    public String getMemento() {
        String collectData = new String("");
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("whileSteppingData");
            rootElement.setAttribute("whileSteppingCount", Integer.toString(this.fStepCount));
            rootElement.setAttribute("subActionNames", this.fSubActionNames);
            doc.appendChild(rootElement);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            collectData = s.toString("UTF8");
        }
        catch (Exception e) {
            GdbPlugin.log(e);
        }
        return collectData;
    }

    public String getSummary() {
        return String.format("while-stepping %s %s", this.fStepCount, this.fSubActionContent);
    }

    public String getTypeName() {
        return MessagesForTracepointActions.TracepointActions_WhileStepping_Name;
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            this.setStepCount(Integer.parseInt(root.getAttribute("whileSteppingCount")));
            this.setSubActionsNames(root.getAttribute("subActionNames"));
            if (this.fSubActionNames == null) {
                throw new Exception();
            }
            this.setSubActionsContent(this.fSubActionNames);
        }
        catch (Exception e) {
            GdbPlugin.log(e);
        }
    }

    public String toString() {
        return this.getSummary();
    }
}

