/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;
import org.eclipse.cdt.core.errorparsers.RegexErrorParser;
import org.eclipse.cdt.core.errorparsers.RegexErrorPattern;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ErrorParserExtensionManager {
    private static final String STORAGE_ERRORPARSER_EXTENSIONS = "model.extensions.xml";
    private static final String PREFERENCE_ERRORPARSER_DEFAULT_IDS = "errorparser.default.ids";
    private static final String NONE = "";
    private static final String EXTENSION_POINT_ERROR_PARSER = "org.eclipse.cdt.core.ErrorParser";
    private static final String ELEM_CONTEXT = "context";
    private static final String ELEM_PLUGIN = "plugin";
    private static final String ELEM_EXTENSION = "extension";
    private static final String ELEM_ERRORPARSER = "errorparser";
    private static final String ELEM_PATTERN = "pattern";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_POINT = "point";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_REGEX = "regex";
    private static final String ATTR_SEVERITY = "severity";
    private static final String ATTR_FILE = "file-expr";
    private static final String ATTR_LINE = "line-expr";
    private static final String ATTR_DESCRIPTION = "description-expr";
    private static final String ATTR_VARIABLE = "variable-expr";
    private static final String ATTR_EAT_LINE = "eat-processed-line";
    private static final String ATTR_VALUE_WARNING = "Warning";
    private static final String ATTR_VALUE_ERROR = "Error";
    private static final String ATTR_VALUE_INFO = "Info";
    private static final String ATTR_VALUE_IGNORE = "Ignore";
    private static final LinkedHashMap<String, IErrorParserNamed> fExtensionErrorParsers = new LinkedHashMap();
    private static final LinkedHashMap<String, IErrorParserNamed> fAvailableErrorParsers = new LinkedHashMap();
    private static final Map<String, Set<String>> fErrorParserContexts = new HashMap<String, Set<String>>();
    private static LinkedHashMap<String, IErrorParserNamed> fUserDefinedErrorParsers = null;
    private static List<String> fDefaultErrorParserIds = null;

    static {
        ErrorParserExtensionManager.loadUserDefinedErrorParsers();
        ErrorParserExtensionManager.loadDefaultErrorParserIds();
        ErrorParserExtensionManager.loadErrorParserExtensions();
    }

    public static synchronized void loadUserDefinedErrorParsers() {
        fUserDefinedErrorParsers = null;
        Document doc = null;
        try {
            doc = XmlUtil.loadXml(ErrorParserExtensionManager.getStoreURI(STORAGE_ERRORPARSER_EXTENSIONS));
        }
        catch (Exception e) {
            CCorePlugin.log("Can't load preferences from model.extensions.xml", e);
        }
        if (doc != null) {
            TreeSet<IErrorParserNamed> sortedErrorParsers = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
            ErrorParserExtensionManager.loadErrorParserExtensions(doc, sortedErrorParsers);
            if (sortedErrorParsers.size() > 0) {
                fUserDefinedErrorParsers = new LinkedHashMap();
                for (IErrorParserNamed errorParser : sortedErrorParsers) {
                    fUserDefinedErrorParsers.put(errorParser.getId(), errorParser);
                }
            }
        }
        ErrorParserExtensionManager.recalculateAvailableErrorParsers();
    }

    private static void loadErrorParserExtensions(Document doc, Set<IErrorParserNamed> errorParsers) {
        errorParsers.clear();
        NodeList extensionNodes = doc.getElementsByTagName(ELEM_EXTENSION);
        int iext = 0;
        while (iext < extensionNodes.getLength()) {
            Node extensionNode = extensionNodes.item(iext);
            if (extensionNode.getNodeType() == 1) {
                NodeList errorparserNodes = extensionNode.getChildNodes();
                int ierp = 0;
                while (ierp < errorparserNodes.getLength()) {
                    Node errorparserNode = errorparserNodes.item(ierp);
                    if (errorparserNode.getNodeType() == 1 && ELEM_ERRORPARSER.equals(errorparserNode.getNodeName())) {
                        String className = XmlUtil.determineAttributeValue(errorparserNode, ATTR_CLASS);
                        try {
                            IErrorParserNamed errorParser = ErrorParserExtensionManager.createErrorParserCarcass(className, Platform.getExtensionRegistry());
                            if (errorParser != null) {
                                ErrorParserExtensionManager.configureErrorParser(errorParser, errorparserNode);
                                errorParsers.add(errorParser);
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log("Can't create class [" + className + "] while trying to load error parser extension", e);
                        }
                    }
                    ++ierp;
                }
            }
            ++iext;
        }
    }

    public static synchronized void loadDefaultErrorParserIds() {
        fDefaultErrorParserIds = null;
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
        String ids = preferences.get(PREFERENCE_ERRORPARSER_DEFAULT_IDS, NONE);
        if (ids.equals(NONE)) {
            return;
        }
        fDefaultErrorParserIds = Arrays.asList(ids.split(String.valueOf(';')));
    }

    public static synchronized void loadErrorParserExtensions() {
        TreeSet<IErrorParserNamed> sortedErrorParsers = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
        ErrorParserExtensionManager.loadErrorParserExtensions(Platform.getExtensionRegistry(), sortedErrorParsers);
        fExtensionErrorParsers.clear();
        for (IErrorParserNamed errorParser : sortedErrorParsers) {
            fExtensionErrorParsers.put(errorParser.getId(), errorParser);
        }
        ErrorParserExtensionManager.recalculateAvailableErrorParsers();
    }

    private static void loadErrorParserExtensions(IExtensionRegistry registry, Set<IErrorParserNamed> errorParsers) {
        errorParsers.clear();
        IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                try {
                    String extensionID;
                    String oldStyleId = extensionID = ext.getUniqueIdentifier();
                    String oldStyleName = ext.getLabel();
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IErrorParserNamed errorParser;
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(ELEM_ERRORPARSER) && (errorParser = ErrorParserExtensionManager.createErrorParserCarcass(oldStyleId, oldStyleName, cfgEl)) != null) {
                            ErrorParserExtensionManager.configureErrorParser(errorParser, cfgEl);
                            errorParsers.add(errorParser);
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log("Cannot load ErrorParser extension " + ext.getUniqueIdentifier(), e);
                }
                ++n2;
            }
        }
    }

    private static void recalculateAvailableErrorParsers() {
        IErrorParserNamed errorParser;
        fAvailableErrorParsers.clear();
        ArrayList<String> ids = new ArrayList<String>();
        if (fDefaultErrorParserIds != null) {
            for (String id : fDefaultErrorParserIds) {
                IErrorParserNamed errorParser2 = null;
                if (fUserDefinedErrorParsers != null) {
                    errorParser2 = fUserDefinedErrorParsers.get(id);
                }
                if (errorParser2 == null) {
                    errorParser2 = fExtensionErrorParsers.get(id);
                }
                if (errorParser2 == null) continue;
                fAvailableErrorParsers.put(id, errorParser2);
                ids.add(id);
            }
        }
        TreeSet<IErrorParserNamed> sortedErrorParsers = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
        if (fUserDefinedErrorParsers != null) {
            for (String id : fUserDefinedErrorParsers.keySet()) {
                if (ids.contains(id)) continue;
                errorParser = fUserDefinedErrorParsers.get(id);
                sortedErrorParsers.add(errorParser);
            }
        }
        for (String id : fExtensionErrorParsers.keySet()) {
            if (ids.contains(id)) continue;
            errorParser = fExtensionErrorParsers.get(id);
            sortedErrorParsers.add(errorParser);
        }
        for (IErrorParserNamed errorParser3 : sortedErrorParsers) {
            fAvailableErrorParsers.put(errorParser3.getId(), errorParser3);
        }
    }

    public static void serializeUserDefinedErrorParsers() throws CoreException {
        try {
            URI uri;
            String eol;
            Document doc = XmlUtil.newDocument();
            Element elementPlugin = XmlUtil.appendElement(doc, ELEM_PLUGIN);
            if (fUserDefinedErrorParsers != null) {
                for (Map.Entry<String, IErrorParserNamed> entry : fUserDefinedErrorParsers.entrySet()) {
                    IErrorParserNamed errorParser = entry.getValue();
                    ErrorParserExtensionManager.addErrorParserExtension(elementPlugin, errorParser);
                }
            }
            if ((eol = Util.getLineSeparator(uri = ErrorParserExtensionManager.getStoreURI(STORAGE_ERRORPARSER_EXTENSIONS))) == null) {
                eol = Util.getDefaultLineSeparator();
            }
            XmlUtil.serializeXml(doc, uri, eol);
        }
        catch (Exception e) {
            throw new CoreException(CCorePlugin.createStatus("Failed serializing to file model.extensions.xml", e));
        }
    }

    private static String severityToString(int severity) {
        switch (severity) {
            case 0: {
                return ATTR_VALUE_INFO;
            }
            case 1: {
                return ATTR_VALUE_WARNING;
            }
            case 2: 
            case 3: {
                return ATTR_VALUE_ERROR;
            }
        }
        return ATTR_VALUE_IGNORE;
    }

    private static int stringToSeverity(String attrSeverity) {
        if (ATTR_VALUE_ERROR.equals(attrSeverity)) {
            return 2;
        }
        if (ATTR_VALUE_WARNING.equals(attrSeverity)) {
            return 1;
        }
        if (ATTR_VALUE_INFO.equals(attrSeverity)) {
            return 0;
        }
        return -1;
    }

    private static void addErrorParserExtension(Element elementPlugin, IErrorParserNamed errorParserNamed) {
        String id = errorParserNamed.getId();
        String name = errorParserNamed.getName();
        String simpleId = ErrorParserExtensionManager.getSimpleId(id);
        IErrorParser errorParser = errorParserNamed;
        if (errorParser instanceof ErrorParserNamedWrapper) {
            errorParser = ((ErrorParserNamedWrapper)errorParser).getErrorParser();
        }
        Element elementExtension = XmlUtil.appendElement(elementPlugin, ELEM_EXTENSION, new String[]{ATTR_ID, simpleId, ATTR_NAME, name, ATTR_POINT, EXTENSION_POINT_ERROR_PARSER});
        Element elementErrorParser = XmlUtil.appendElement(elementExtension, ELEM_ERRORPARSER, new String[]{ATTR_ID, id, ATTR_NAME, name, ATTR_CLASS, errorParser.getClass().getCanonicalName()});
        if (errorParserNamed instanceof RegexErrorParser) {
            RegexErrorPattern[] patterns;
            RegexErrorParser regexErrorParser = (RegexErrorParser)errorParserNamed;
            RegexErrorPattern[] regexErrorPatternArray = patterns = regexErrorParser.getPatterns();
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                RegexErrorPattern pattern = regexErrorPatternArray[n2];
                XmlUtil.appendElement(elementErrorParser, ELEM_PATTERN, new String[]{ATTR_SEVERITY, ErrorParserExtensionManager.severityToString(pattern.getSeverity()), ATTR_REGEX, pattern.getPattern(), ATTR_FILE, pattern.getFileExpression(), ATTR_LINE, pattern.getLineExpression(), ATTR_DESCRIPTION, pattern.getDescriptionExpression(), ATTR_EAT_LINE, String.valueOf(pattern.isEatProcessedLine())});
                ++n2;
            }
        }
    }

    private static String getSimpleId(String uniqueId) {
        String simpleId = uniqueId;
        int dot = uniqueId.lastIndexOf(46);
        if (dot >= 0) {
            simpleId = uniqueId.substring(dot + 1);
        }
        return simpleId;
    }

    public static void serializeDefaultErrorParserIds() throws BackingStoreException {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
        String ids = NONE;
        if (fDefaultErrorParserIds != null) {
            ids = ErrorParserManager.toDelimitedString(fDefaultErrorParserIds.toArray(new String[0]));
        }
        preferences.put(PREFERENCE_ERRORPARSER_DEFAULT_IDS, ids);
        preferences.flush();
    }

    private static URI getStoreURI(String store) {
        IPath location = CCorePlugin.getDefault().getStateLocation().append(store);
        URI uri = URIUtil.toURI((IPath)location);
        return uri;
    }

    private static IErrorParserNamed createErrorParserCarcass(String className, IExtensionRegistry registry) {
        if (className == null || className.length() == 0 || className.equals(RegexErrorParser.class.getName())) {
            return new RegexErrorParser();
        }
        try {
            IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
            if (extension != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = extension.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extensionID;
                    IExtension ext = iExtensionArray[n2];
                    String oldStyleId = extensionID = ext.getUniqueIdentifier();
                    String oldStyleName = ext.getLabel();
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(ELEM_ERRORPARSER) && className.equals(cfgEl.getAttribute(ATTR_CLASS))) {
                            return ErrorParserExtensionManager.createErrorParserCarcass(oldStyleId, oldStyleName, cfgEl);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            CCorePlugin.log("Error creating error parser", e);
        }
        return null;
    }

    private static IErrorParserNamed createErrorParserCarcass(String initialId, String initialName, IConfigurationElement ce) throws CoreException {
        IErrorParserNamed errorParser = null;
        if (ce.getAttribute(ATTR_CLASS) != null) {
            IErrorParser ep = (IErrorParser)ce.createExecutableExtension(ATTR_CLASS);
            if (ep instanceof IErrorParserNamed) {
                errorParser = (IErrorParserNamed)ep;
                errorParser.setId(initialId);
                errorParser.setName(initialName);
            } else if (ep != null) {
                errorParser = new ErrorParserNamedWrapper(initialId, initialName, ep);
            }
        }
        if (errorParser == null) {
            errorParser = new RegexErrorParser(initialId, initialName);
        }
        return errorParser;
    }

    private static void configureErrorParser(IErrorParserNamed errorParser, Node errorparserNode) {
        String id = XmlUtil.determineAttributeValue(errorparserNode, ATTR_ID);
        String name = XmlUtil.determineAttributeValue(errorparserNode, ATTR_NAME);
        errorParser.setId(id);
        errorParser.setName(name);
        if (errorParser instanceof RegexErrorParser) {
            RegexErrorParser regexErrorParser = (RegexErrorParser)errorParser;
            NodeList patternNodes = errorparserNode.getChildNodes();
            int ipat = 0;
            while (ipat < patternNodes.getLength()) {
                Node patternNode = patternNodes.item(ipat);
                if (patternNode.getNodeType() == 1 && ELEM_PATTERN.equals(patternNode.getNodeName())) {
                    String attrSeverity = XmlUtil.determineAttributeValue(patternNode, ATTR_SEVERITY);
                    String regex = XmlUtil.determineAttributeValue(patternNode, ATTR_REGEX);
                    String fileExpr = XmlUtil.determineAttributeValue(patternNode, ATTR_FILE);
                    String lineExpr = XmlUtil.determineAttributeValue(patternNode, ATTR_LINE);
                    String DescExpr = XmlUtil.determineAttributeValue(patternNode, ATTR_DESCRIPTION);
                    String attrEatLine = XmlUtil.determineAttributeValue(patternNode, ATTR_EAT_LINE);
                    int severity = ErrorParserExtensionManager.stringToSeverity(attrSeverity);
                    boolean eatLine = !Boolean.FALSE.toString().equals(attrEatLine);
                    regexErrorParser.addPattern(new RegexErrorPattern(regex, fileExpr, lineExpr, DescExpr, null, severity, eatLine));
                }
                ++ipat;
            }
        }
    }

    private static void configureErrorParser(IErrorParserNamed errorParser, IConfigurationElement cfgEl) throws CoreException {
        String name;
        String id = cfgEl.getAttribute(ATTR_ID);
        if (id != null && id.length() > 0) {
            errorParser.setId(id);
        }
        if ((name = cfgEl.getAttribute(ATTR_NAME)) != null && name.length() > 0) {
            errorParser.setName(name);
        }
        if (errorParser instanceof RegexErrorParser) {
            RegexErrorParser regexErrorParser = (RegexErrorParser)errorParser;
            IConfigurationElement[] iConfigurationElementArray = cfgEl.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement cepat = iConfigurationElementArray[n2];
                if (cepat.getName().equals(ELEM_PATTERN)) {
                    boolean eat = !Boolean.FALSE.toString().equals(cepat.getAttribute(ATTR_EAT_LINE));
                    regexErrorParser.addPattern(new RegexErrorPattern(cepat.getAttribute(ATTR_REGEX), cepat.getAttribute(ATTR_FILE), cepat.getAttribute(ATTR_LINE), cepat.getAttribute(ATTR_DESCRIPTION), cepat.getAttribute(ATTR_VARIABLE), ErrorParserExtensionManager.stringToSeverity(cepat.getAttribute(ATTR_SEVERITY)), eat));
                }
                ++n2;
            }
        }
        ErrorParserExtensionManager.findContexts(id, cfgEl);
    }

    private static void findContexts(String errorParserId, IConfigurationElement errorParserElement) {
        Set<String> contexts = fErrorParserContexts.get(errorParserId);
        IConfigurationElement[] contextElements = errorParserElement.getChildren(ELEM_CONTEXT);
        if (contextElements.length == 0) {
            return;
        }
        boolean newContextCreated = false;
        if (contexts == null) {
            contexts = new HashSet<String>();
            newContextCreated = true;
        }
        IConfigurationElement[] iConfigurationElementArray = contextElements;
        int n = contextElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contextElement = iConfigurationElementArray[n2];
            String context = contextElement.getAttribute(ATTR_TYPE);
            if (context != null) {
                contexts.add(context);
            }
            ++n2;
        }
        if (newContextCreated && !contexts.isEmpty()) {
            fErrorParserContexts.put(errorParserId, contexts);
        }
    }

    public static IErrorParser getErrorParserInternal(String id) {
        IErrorParserNamed errorParser = fAvailableErrorParsers.get(id);
        if (errorParser instanceof ErrorParserNamedWrapper) {
            return ((ErrorParserNamedWrapper)errorParser).getErrorParser();
        }
        return errorParser;
    }

    public static void setUserDefinedErrorParsers(IErrorParserNamed[] errorParsers) throws CoreException {
        ErrorParserExtensionManager.setUserDefinedErrorParsersInternal(errorParsers);
        ErrorParserExtensionManager.serializeUserDefinedErrorParsers();
    }

    public static void setUserDefinedErrorParsersInternal(IErrorParserNamed[] errorParsers) {
        if (errorParsers == null) {
            fUserDefinedErrorParsers = null;
        } else {
            TreeSet<IErrorParserNamed> sortedErrorParsers = new TreeSet<IErrorParserNamed>(new ErrorParserComparator());
            sortedErrorParsers.addAll(Arrays.asList(errorParsers));
            fUserDefinedErrorParsers = new LinkedHashMap();
            for (IErrorParserNamed errorParser : sortedErrorParsers) {
                fUserDefinedErrorParsers.put(errorParser.getId(), errorParser);
            }
        }
        ErrorParserExtensionManager.recalculateAvailableErrorParsers();
    }

    public static String[] getErrorParserAvailableIds() {
        return fAvailableErrorParsers.keySet().toArray(new String[fAvailableErrorParsers.size()]);
    }

    public static String[] getErrorParserExtensionIds() {
        return fExtensionErrorParsers.keySet().toArray(new String[fExtensionErrorParsers.size()]);
    }

    public static String[] getUserDefinedErrorParserIds() {
        if (fUserDefinedErrorParsers != null) {
            return fUserDefinedErrorParsers.keySet().toArray(new String[0]);
        }
        return null;
    }

    public static void setDefaultErrorParserIds(String[] ids) throws BackingStoreException {
        ErrorParserExtensionManager.setDefaultErrorParserIdsInternal(ids);
        ErrorParserExtensionManager.serializeDefaultErrorParserIds();
    }

    public static void setDefaultErrorParserIdsInternal(String[] ids) {
        fDefaultErrorParserIds = ids == null ? null : new ArrayList<String>(Arrays.asList(ids));
        ErrorParserExtensionManager.recalculateAvailableErrorParsers();
    }

    public static String[] getDefaultErrorParserIds() {
        if (fDefaultErrorParserIds == null) {
            return fAvailableErrorParsers.keySet().toArray(new String[fAvailableErrorParsers.size()]);
        }
        return fDefaultErrorParserIds.toArray(new String[fDefaultErrorParserIds.size()]);
    }

    public static IErrorParserNamed getErrorParserCopy(String id, boolean isExtension) {
        IErrorParserNamed errorParser = isExtension ? fExtensionErrorParsers.get(id) : fAvailableErrorParsers.get(id);
        try {
            if (errorParser instanceof RegexErrorParser) {
                return (RegexErrorParser)((RegexErrorParser)errorParser).clone();
            }
            if (errorParser instanceof ErrorParserNamedWrapper) {
                return (ErrorParserNamedWrapper)((ErrorParserNamedWrapper)errorParser).clone();
            }
        }
        catch (CloneNotSupportedException e) {
            CCorePlugin.log(e);
        }
        return errorParser;
    }

    public static String[] getErrorParserAvailableIdsInContext(String context) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : fAvailableErrorParsers.keySet()) {
            if (!ErrorParserExtensionManager.getErrorParserContexts(id).contains(context)) continue;
            ids.add(id);
        }
        return ids.toArray(new String[ids.size()]);
    }

    private static Collection<String> getErrorParserContexts(String id) {
        Set<String> contexts = fErrorParserContexts.get(id);
        if (contexts == null) {
            return Collections.singletonList("build");
        }
        return contexts;
    }

    private static class ErrorParserComparator
    implements Comparator<IErrorParserNamed> {
        private ErrorParserComparator() {
        }

        @Override
        public int compare(IErrorParserNamed errorParser1, IErrorParserNamed errorParser2) {
            String DEPRECATED = CCorePlugin.getResourceString("CCorePlugin.Deprecated");
            boolean isTestPlugin1 = errorParser1.getId().startsWith("org.eclipse.cdt.core.tests");
            boolean isTestPlugin2 = errorParser2.getId().startsWith("org.eclipse.cdt.core.tests");
            if (isTestPlugin1 && !isTestPlugin2) {
                return 1;
            }
            if (!isTestPlugin1 && isTestPlugin2) {
                return -1;
            }
            boolean isDeprecated1 = errorParser1.getName().contains(DEPRECATED);
            boolean isDeprecated2 = errorParser2.getName().contains(DEPRECATED);
            if (isDeprecated1 && !isDeprecated2) {
                return 1;
            }
            if (!isDeprecated1 && isDeprecated2) {
                return -1;
            }
            return errorParser1.getName().compareTo(errorParser2.getName());
        }
    }
}

