/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.wizards;

import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.services.ui.ServicesUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilenameStore {
    private static final int HISTORY_LENGTH = 10;
    private static final String STORE_SECTION = "ImportDialog";
    private static final String FILENAMES = "filenames";
    private static final String PREVIOUS = "previous";
    private static String _selectedFilename = null;
    private static IDialogSettings _section;

    private FilenameStore() {
    }

    public static void setDefaultFromSelection(IWorkbench workbench) {
        IWorkbenchWindow wnd = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage pg = wnd.getActivePage();
        ISelection sel = pg.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return;
        }
        Object o = ((IAdaptable)firstElement).getAdapter(IResource.class);
        if (o == null) {
            return;
        }
        IResource resource = (IResource)o;
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.isAccessible()) {
            return;
        }
        String extension = resource.getFileExtension();
        if (extension == null || !extension.equalsIgnoreCase("xml")) {
            return;
        }
        IWorkspace workspace = resource.getWorkspace();
        workspace.getRoot().getFullPath();
        IPath path = resource.getLocation();
        _selectedFilename = path.toOSString();
    }

    public static String getSuggestedDefault() {
        if (_selectedFilename != null) {
            return _selectedFilename;
        }
        return FilenameStore.getPrevious();
    }

    private static String getPrevious() {
        IDialogSettings section = FilenameStore.getSettingsSection();
        String retval = section.get(PREVIOUS);
        if (retval == null) {
            retval = "";
        }
        return retval;
    }

    public static String[] getHistory() {
        IDialogSettings section = FilenameStore.getSettingsSection();
        String[] arr = section.getArray(FILENAMES);
        if (arr == null) {
            arr = new String[]{};
        }
        return arr;
    }

    public static void remember(String filename) {
        Vector<String> filenames = FilenameStore.createVector(FilenameStore.getHistory());
        if (filenames.contains(filename)) {
            filenames.remove(filename);
        }
        filenames.add(0, filename);
        while (filenames.size() > 10) {
            filenames.remove(10);
        }
        String[] arr = filenames.toArray(new String[filenames.size()]);
        IDialogSettings section = FilenameStore.getSettingsSection();
        section.put(FILENAMES, arr);
        section.put(PREVIOUS, filename);
    }

    private static Vector<String> createVector(String[] arr) {
        Vector<String> v = new Vector<String>();
        int ix = 0;
        while (ix < arr.length) {
            v.add(ix, arr[ix]);
            ++ix;
        }
        return v;
    }

    private static IDialogSettings getSettingsSection() {
        if (_section != null) {
            return _section;
        }
        IDialogSettings settings = ServicesUIPlugin.getDefault().getDialogSettings();
        _section = settings.getSection(STORE_SECTION);
        if (_section != null) {
            return _section;
        }
        _section = settings.addNewSection(STORE_SECTION);
        return _section;
    }
}

