/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.ptp.internal.rm.lml.core.model.Pattern;
import org.eclipse.ptp.internal.rm.lml.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.events.ILguiAddedEvent;
import org.eclipse.ptp.rm.lml.core.events.ILguiRemovedEvent;
import org.eclipse.ptp.rm.lml.core.events.IMarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.ISelectObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableFilterEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableSortedEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnmarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnselectedObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IViewUpdateEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILMLListener;
import org.eclipse.ptp.rm.lml.core.model.Cell;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.IPattern;
import org.eclipse.ptp.rm.lml.core.model.ITableColumnLayout;
import org.eclipse.ptp.rm.lml.core.model.LMLColor;
import org.eclipse.ptp.rm.lml.core.model.ObjectStatus;
import org.eclipse.ptp.rm.lml.core.model.Row;
import org.eclipse.ptp.rm.lml.internal.ui.UIUtils;
import org.eclipse.ptp.rm.lml.ui.providers.FilterDialog;
import org.eclipse.ptp.rm.lml.ui.providers.support.ColorConversion;
import org.eclipse.ptp.rm.lml.ui.providers.support.EventForwarder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class TableView
extends ViewPart {
    private Composite composite;
    private Menu headerMenu;
    private Tree tree;
    private TreeColumn[] treeColumns;
    private int[] savedColumnWidths;
    private TreeColumnLayout treeColumnLayout;
    private TreeViewer viewer;
    private ILguiItem fLguiItem = null;
    private String gid = null;
    private final ILMLListener lmlListener = new LMLTableListListener();
    private final LMLManager lmlManager = LMLManager.getInstance();
    private IMenuManager viewMenuManager;
    private ActionContributionItem filterActionItem;
    private ActionContributionItem filterOwnJobsActionItem;
    private TreeItem selectedItem = null;
    private String selectedOid = null;
    private boolean componentAdded = false;
    private boolean viewCreated = false;
    private IViewSite viewSite = null;
    private boolean isMouseDown = false;
    private final EventForwarder eventForwarder = new EventForwarder();
    private boolean updateAfterLastFilter = true;
    private FirstColumnLabelProvider firstColumnlabelProvider;

    public void createPartControl(Composite parent) {
        this.gid = this.getViewSite().getId();
        this.composite = new Composite(parent, 0);
        this.treeColumnLayout = new TreeColumnLayout();
        this.composite.setLayout((Layout)this.treeColumnLayout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer = new TreeViewer(this.composite, 0x10010202);
        this.viewer.getTree().setLayout((Layout)new TableLayout());
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ILazyTreeContentProvider(){
            private Row[] rows;

            public void dispose() {
            }

            public Object getParent(Object element) {
                if (element instanceof Cell) {
                    return ((Cell)element).row;
                }
                return this.rows;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.rows = (Row[])newInput;
            }

            public void updateChildCount(Object element, int currentChildCount) {
            }

            public void updateElement(Object parent, int index) {
                Object element = parent instanceof Row ? ((Row)parent).cells[index] : this.rows[index];
                TableView.this.viewer.replace(parent, index, element);
                this.updateChildCount(element, -1);
            }
        });
        this.viewer.setUseHashlookup(true);
        this.viewer.setAutoExpandLevel(2);
        this.tree = this.viewer.getTree();
        this.headerMenu = new Menu((Control)this.composite);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        final Menu menu = contextMenu.createContextMenu((Control)this.tree);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.tree.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Point pt = TableView.this.tree.getDisplay().map(null, (Control)TableView.this.tree, new Point(event.x, event.y));
                Rectangle clientArea = TableView.this.tree.getClientArea();
                boolean header = clientArea.y <= pt.y && pt.y < clientArea.y + TableView.this.tree.getHeaderHeight();
                TableView.this.tree.setMenu(header ? TableView.this.headerMenu : menu);
            }
        });
        this.fLguiItem = this.lmlManager.getSelectedLguiItem();
        this.viewMenuManager = this.getViewSite().getActionBars().getMenuManager();
        Action filterOwnJobsAction = new Action(Messages.TableView_Show_only_my_jobs, 2){

            public void run() {
                LinkedList<String> columnsTitle = new LinkedList<String>();
                columnsTitle.add("owner");
                TableView.this.fLguiItem.getTableHandler().deleteOldPattern(TableView.this.gid, columnsTitle);
                if (this.isChecked()) {
                    LinkedList<IPattern> filterValuesNew = new LinkedList<IPattern>();
                    filterValuesNew.add(new Pattern("owner", "alpha").setRelation("=", TableView.this.fLguiItem.getUsername()));
                    TableView.this.fLguiItem.getTableHandler().generateNewPattern(TableView.this.gid, filterValuesNew);
                    TableView.this.setViewerInput(TableView.this.fLguiItem.getTableHandler().getPattern(TableView.this.gid));
                } else {
                    TableView.this.setViewerInput();
                }
                TableView.this.updateAfterLastFilter = false;
            }
        };
        Action filterAction = new Action(Messages.TableView_Filters){

            public void run() {
                FilterDialog dialog = new FilterDialog(new Shell(TableView.this.viewSite.getShell()), TableView.this.gid);
                dialog.open();
            }
        };
        this.filterOwnJobsActionItem = new ActionContributionItem((IAction)filterOwnJobsAction);
        this.filterActionItem = new ActionContributionItem((IAction)filterAction);
        this.viewMenuManager.add((IContributionItem)this.filterOwnJobsActionItem);
        this.viewMenuManager.add((IContributionItem)new Separator());
        this.viewMenuManager.add((IContributionItem)this.filterActionItem);
        this.filterOwnJobsActionItem.getAction().setEnabled(false);
        this.filterActionItem.getAction().setEnabled(false);
        this.viewCreated = this.createTable();
        this.tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TableView.this.fLguiItem != null) {
                    TableView.this.saveColumnLayout();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.lmlManager.removeListener(this.lmlListener);
        ColorConversion.disposeColors();
    }

    public void init(IViewSite site) {
        try {
            super.init(site);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this.lmlManager.addListener(this.lmlListener, ((Object)((Object)this)).getClass().getName());
        this.viewSite = site;
    }

    public void refresh() {
        new UIJob(Messages.TableUpdate){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (TableView.this.viewer != null) {
                    TableView.this.updateViewerInput();
                    TableView.this.viewer.refresh();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void setFocus() {
        if (!this.viewCreated) {
            this.viewCreated = this.createTable();
        }
        this.viewer.getControl().setFocus();
    }

    private void createColumns() {
        if (this.fLguiItem.isLayout() || this.fLguiItem.getTableHandler() == null) {
            return;
        }
        ITableColumnLayout[] tableColumnLayouts = this.fLguiItem.getTableHandler().getTableColumnLayout(this.gid);
        if (tableColumnLayouts.length == 0) {
            return;
        }
        this.treeColumns = new TreeColumn[tableColumnLayouts.length];
        this.savedColumnWidths = new int[tableColumnLayouts.length + 1];
        String[] columnTitlesPattern = this.fLguiItem.getColumnTitlePattern(this.gid);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        if (this.firstColumnlabelProvider != null) {
            this.firstColumnlabelProvider.dispose();
        }
        this.firstColumnlabelProvider = new FirstColumnLabelProvider();
        treeViewerColumn.setLabelProvider((CellLabelProvider)this.firstColumnlabelProvider);
        TreeColumn treeColumn = treeViewerColumn.getColumn();
        treeColumn.setMoveable(false);
        treeColumn.setResizable(false);
        treeColumn.setAlignment(16384);
        treeColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                ArrayList<Integer> newOrder = new ArrayList<Integer>();
                newOrder.add(0);
                int[] nArray = TableView.this.tree.getColumnOrder();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int column = nArray[n2];
                    if (column != 0) {
                        newOrder.add(column);
                    }
                    ++n2;
                }
                int[] newOrderArray = new int[newOrder.size()];
                int i = 0;
                while (i < newOrder.size()) {
                    newOrderArray[i] = (Integer)newOrder.get(i);
                    ++i;
                }
                TableView.this.tree.setColumnOrder(newOrderArray);
            }
        });
        this.createMenuItem(this.headerMenu, treeColumn, 0);
        this.treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(40, true));
        int i = 0;
        while (i < tableColumnLayouts.length) {
            treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
            final int cellNumber = i;
            treeViewerColumn.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    String value = "-";
                    Row row = (Row)cell.getElement();
                    if (row != null && row.cells.length > cellNumber) {
                        value = row.cells[cellNumber].value;
                    }
                    cell.setText(value);
                }
            });
            final TreeColumn treeColumnI = treeViewerColumn.getColumn();
            treeColumnI.setMoveable(true);
            boolean isFiltered = false;
            String[] stringArray = columnTitlesPattern;
            int n = columnTitlesPattern.length;
            int n2 = 0;
            while (n2 < n) {
                String title = stringArray[n2];
                if (title.equals(tableColumnLayouts[i].getTitle())) {
                    isFiltered = true;
                }
                ++n2;
            }
            if (isFiltered) {
                treeColumnI.setText(String.valueOf(tableColumnLayouts[i].getTitle()) + " #");
            } else {
                treeColumnI.setText(tableColumnLayouts[i].getTitle());
            }
            treeColumnI.setAlignment(this.getColumnAlignment(tableColumnLayouts[i].getStyle()));
            if (tableColumnLayouts[i].isActive()) {
                treeColumnI.setResizable(true);
                this.createMenuItem(this.headerMenu, treeColumnI, i + 1);
                this.treeColumnLayout.setColumnData((Widget)treeColumnI, (ColumnLayoutData)new ColumnPixelData((int)(tableColumnLayouts[i].getWidth() * (double)this.composite.getClientArea().width), true));
            } else {
                treeColumnI.setResizable(false);
                this.createMenuItem(this.headerMenu, treeColumnI, i + 1);
                this.savedColumnWidths[i + 1] = 0;
                this.treeColumnLayout.setColumnData((Widget)treeColumnI, (ColumnLayoutData)new ColumnPixelData(0, false));
            }
            if (Util.isLinux()) {
                treeColumnI.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        if (treeColumnI.getWidth() < 10) {
                            treeColumnI.setWidth(10);
                        }
                    }
                });
            }
            this.treeColumns[i] = treeColumnI;
            ++i;
        }
        treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        treeViewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        });
        treeColumn = treeViewerColumn.getColumn();
        treeColumn.setMoveable(true);
        treeColumn.setText("");
        treeColumn.setAlignment(131072);
        treeColumn.setResizable(false);
        this.treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnPixelData(0, false));
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TreeColumn currentColumn = (TreeColumn)e.widget;
                if (TableView.this.tree.getSortColumn() == currentColumn) {
                    TableView.this.tree.setSortDirection(TableView.this.tree.getSortDirection() == 128 ? 1024 : 128);
                } else {
                    TableView.this.tree.setSortColumn(currentColumn);
                    TableView.this.tree.setSortDirection(128);
                }
                if (TableView.this.fLguiItem != null && TableView.this.fLguiItem.getTableHandler() != null) {
                    TableView.this.fLguiItem.getTableHandler().setSortProperties(TableView.this.gid, TableView.this.getSortIndex(), TableView.this.getSortDirectionString());
                }
                TableView.this.lmlManager.sortLgui();
            }
        };
        TreeColumn[] treeColumnArray = this.treeColumns;
        int n = this.treeColumns.length;
        int n3 = 0;
        while (n3 < n) {
            TreeColumn col = treeColumnArray[n3];
            col.addListener(13, sortListener);
            ++n3;
        }
        if (this.gid.equals("org.eclipse.ptp.rm.lml.ui.ActiveJobsView")) {
            this.tree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button == 1) {
                        TableView.this.isMouseDown = true;
                        TreeItem item = TableView.this.tree.getItem(new Point(e.x, e.y));
                        if (item != null && !TableView.this.composite.isDisposed()) {
                            TableView.this.lmlManager.selectObject(item.getData().toString());
                            TableView.this.lmlManager.markObject(item.getData().toString());
                        }
                    }
                }

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1) {
                        TreeItem item = TableView.this.tree.getItem(new Point(e.x, e.y));
                        if (item != null && !TableView.this.composite.isDisposed()) {
                            TableView.this.lmlManager.unmarkObject(item.getData().toString());
                            TableView.this.lmlManager.unselectObject(item.getData().toString());
                        }
                        TableView.this.isMouseDown = false;
                    }
                }
            });
        }
    }

    private void createMenuItem(Menu parent, final TreeColumn column, final int index) {
        final MenuItem itemName = new MenuItem(parent, 32);
        itemName.setText(column.getText());
        itemName.setSelection(column.getResizable());
        itemName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean active = true;
                if (itemName.getSelection()) {
                    if (TableView.this.savedColumnWidths[index] <= 50) {
                        ((TableView)TableView.this).savedColumnWidths[index] = 50;
                    }
                    column.setWidth(TableView.this.savedColumnWidths[index]);
                    column.setResizable(true);
                } else {
                    ((TableView)TableView.this).savedColumnWidths[index] = column.getWidth();
                    column.setWidth(0);
                    column.setResizable(false);
                    active = false;
                }
                if (TableView.this.fLguiItem != null) {
                    TableView.this.fLguiItem.getTableHandler().setTableColumnActive(TableView.this.gid, column.getText(), active);
                }
            }
        });
    }

    private boolean createTable() {
        boolean viewChanged = false;
        if (this.fLguiItem != null && !this.fLguiItem.isLayout() && this.composite.getClientArea().width > 0 && this.fLguiItem.getTableHandler() != null && this.fLguiItem.getTableHandler().getTable(this.gid) != null) {
            this.createColumns();
            if (this.fLguiItem.getTableHandler() != null) {
                Object[] sortProperties = this.fLguiItem.getTableHandler().getSortProperties(this.gid);
                if (!((String)sortProperties[1]).equals("NONE") && (Integer)sortProperties[0] != -1) {
                    this.tree.setSortDirection(this.getSortDirectionInt((String)sortProperties[1]));
                    this.tree.setSortColumn(this.getSortColumn((Integer)sortProperties[0]));
                    this.fLguiItem.getTableHandler().sort(this.gid, 128, this.getSortIndex(), this.tree.getSortDirection());
                }
                this.filterOwnJobsActionItem.getAction().setEnabled(true);
                this.filterOwnJobsActionItem.getAction().setChecked(this.fLguiItem.isFilterOwnJobActive(this.gid));
                this.filterActionItem.getAction().setEnabled(true);
            }
            this.updateViewerInput();
            viewChanged = true;
        }
        this.composite.layout();
        return viewChanged;
    }

    private void disposeTable() {
        TreeColumn[] oldColumns;
        this.tree.setSortColumn(null);
        this.tree.setSortDirection(0);
        this.filterOwnJobsActionItem.getAction().setEnabled(false);
        this.filterActionItem.getAction().setEnabled(false);
        TreeColumn[] treeColumnArray = oldColumns = this.tree.getColumns();
        int n = oldColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Listener[] oldListeners;
            TreeColumn oldColumn = treeColumnArray[n2];
            Listener[] listenerArray = oldListeners = oldColumn.getListeners(13);
            int n3 = oldListeners.length;
            int n4 = 0;
            while (n4 < n3) {
                Listener oldListener = listenerArray[n4];
                oldColumn.removeListener(13, oldListener);
                ++n4;
            }
            oldColumn.dispose();
            ++n2;
        }
        this.treeColumns = new TreeColumn[0];
        if (this.firstColumnlabelProvider != null) {
            this.firstColumnlabelProvider.dispose();
            this.firstColumnlabelProvider = null;
        }
        treeColumnArray = this.headerMenu.getItems();
        n = treeColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            TreeColumn item = treeColumnArray[n2];
            item.dispose();
            ++n2;
        }
    }

    private void fixRowHeight() {
        if (!Util.isGtk()) {
            return;
        }
        if (this.tree == null || this.tree.getColumns() == null) {
            return;
        }
        int lastItem = this.tree.getColumns().length - 1;
        if (lastItem >= 0) {
            TreeColumn lastColumn = this.tree.getColumn(lastItem);
            if (lastColumn == null) {
                return;
            }
            int width = lastColumn.getWidth();
            int newWidth = width - 1;
            if (newWidth < 0) {
                newWidth = width + 1;
            }
            lastColumn.setWidth(newWidth);
            lastColumn.setWidth(width);
        }
    }

    private int getColumnAlignment(String alignment) {
        if (alignment.equals("LEFT")) {
            return 16384;
        }
        if (alignment.equals("RIGHT")) {
            return 131072;
        }
        if (alignment.equals("CENTER")) {
            return 0x1000000;
        }
        return 16384;
    }

    private TreeColumn getSortColumn(Integer index) {
        TreeColumn column = null;
        if (index >= 0 && index < this.treeColumns.length) {
            column = this.treeColumns[index];
        }
        return column;
    }

    private int getSortDirectionInt(String sortDirection) {
        if (sortDirection.equals("UP")) {
            return 128;
        }
        if (sortDirection.equals("DOWN")) {
            return 1024;
        }
        return -1;
    }

    private String getSortDirectionString() {
        if (this.tree.getSortDirection() == 128) {
            return "UP";
        }
        if (this.tree.getSortDirection() == 1024) {
            return "DOWN";
        }
        return "NONE";
    }

    private int getSortIndex() {
        int i = 0;
        while (i < this.treeColumns.length) {
            if (this.treeColumns[i].equals(this.tree.getSortColumn())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Double[] getWidths() {
        TreeColumn[] columns = this.tree.getColumns();
        int width = 0;
        TreeColumn[] treeColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            width += column.getWidth();
            ++n2;
        }
        Double[] widths = new Double[columns.length - 2];
        int i = 0;
        while (i < columns.length - 2) {
            TreeColumn column = columns[i + 1];
            Double columnWidth = 0.0;
            if (column.getWidth() > 0) {
                columnWidth = Integer.valueOf(column.getWidth()).doubleValue() / (double)width;
            }
            widths[i] = columnWidth;
            ++i;
        }
        return widths;
    }

    private int[] removeFirstColumn(int[] order) {
        int[] orderNew = new int[order.length - 2];
        int dif = 0;
        int i = 0;
        while (i < order.length - 1) {
            if (order[i] != 0) {
                orderNew[i - dif] = order[i] - 1;
            } else {
                dif = 1;
            }
            ++i;
        }
        return orderNew;
    }

    private void saveColumnLayout() {
        if (this.fLguiItem != null && this.fLguiItem.getTableHandler() != null && this.tree.getColumnOrder().length != 0) {
            int[] indexe = this.removeFirstColumn(this.tree.getColumnOrder());
            this.fLguiItem.getTableHandler().changeTableColumnsOrder(this.gid, indexe);
            this.fLguiItem.getTableHandler().changeTableColumnsWidth(this.gid, this.getWidths());
            int sortIndex = this.getSortIndex();
            String sortDirection = this.getSortDirectionString();
            int index = 0;
            int i = 0;
            while (i < indexe.length) {
                if (indexe[i] == sortIndex) {
                    index = i;
                }
                ++i;
            }
            this.fLguiItem.getTableHandler().setSortProperties(this.gid, index, sortDirection);
        }
    }

    private void setViewerInput() {
        if (!this.isMouseDown) {
            Row[] input = new Row[]{};
            if (this.fLguiItem != null && this.fLguiItem.getTableHandler() != null) {
                input = this.fLguiItem.getTableHandler().getTableDataWithColor(this.gid, this.gid.equals("org.eclipse.ptp.rm.lml.ui.ActiveJobsView"));
            }
            if (!this.composite.isDisposed()) {
                this.viewer.setInput((Object)input);
                this.viewer.setChildCount((Object)input, input.length);
                this.fixRowHeight();
            }
        }
    }

    private void setViewerInput(List<IPattern> filterValues) {
        if (!this.isMouseDown) {
            Row[] input = new Row[]{};
            if (this.fLguiItem != null && this.fLguiItem.getTableHandler() != null) {
                input = this.fLguiItem.getTableHandler().getTableDataWithColor(this.gid, this.gid.equals("org.eclipse.ptp.rm.lml.ui.ActiveJobsView"), filterValues);
            }
            if (!this.composite.isDisposed()) {
                this.viewer.setInput((Object)input);
                this.viewer.setChildCount((Object)input, input.length);
                this.fixRowHeight();
            }
        }
    }

    private void updateViewerInput() {
        if (this.fLguiItem != null && this.fLguiItem.getTableHandler() != null && this.fLguiItem.getTableHandler().getPattern(this.gid).size() > 0) {
            this.setViewerInput(this.fLguiItem.getTableHandler().getPattern(this.gid));
        } else {
            this.setViewerInput();
        }
    }

    private final class FirstColumnLabelProvider
    extends ColumnLabelProvider {
        private final Map<Color, Image> generatedImages = new HashMap<Color, Image>();

        private FirstColumnLabelProvider() {
        }

        public void clearImages() {
            for (Image img : this.generatedImages.values()) {
                img.dispose();
            }
            this.generatedImages.clear();
        }

        public void dispose() {
            super.dispose();
            this.clearImages();
        }

        public Image getImage(Object element) {
            Display display = TableView.this.treeColumns[0].getDisplay();
            Color backgroundColor = null;
            if (((Row)element).oid != null) {
                LMLColor color = ((Row)element).color;
                if (color == null) {
                    color = LMLColor.LIGHT_GRAY;
                }
                backgroundColor = ColorConversion.getColor(color);
            } else {
                backgroundColor = display.getSystemColor(1);
            }
            Image image = null;
            if (this.generatedImages.containsKey(backgroundColor)) {
                image = this.generatedImages.get(backgroundColor);
            } else {
                image = new Image((Device)display, 12, 12);
                GC gc = new GC((Drawable)image);
                gc.setBackground(backgroundColor);
                gc.fillRectangle(image.getBounds().x, image.getBounds().y, image.getBounds().width, image.getBounds().height);
                gc.setForeground(display.getSystemColor(2));
                gc.drawRectangle(image.getBounds().x, image.getBounds().y, image.getBounds().width - 1, image.getBounds().height - 1);
                gc.dispose();
                this.generatedImages.put(backgroundColor, image);
            }
            return image;
        }

        public String getText(Object element) {
            return null;
        }
    }

    private final class LMLTableListListener
    implements ILMLListener {
        private LMLTableListListener() {
        }

        public void handleEvent(ILguiAddedEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (TableView.this.composite != null && !TableView.this.viewCreated) {
                        TableView.this.fLguiItem = TableView.this.lmlManager.getSelectedLguiItem();
                        if (TableView.this.fLguiItem != null) {
                            TableView.this.viewCreated = TableView.this.createTable();
                            if (TableView.this.fLguiItem.getObjectStatus() != null) {
                                TableView.this.fLguiItem.getObjectStatus().addComponent((ObjectStatus.Updatable)TableView.this.eventForwarder);
                                TableView.this.componentAdded = true;
                            }
                        }
                    }
                }
            });
        }

        public void handleEvent(ILguiRemovedEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (TableView.this.composite != null && TableView.this.fLguiItem != null && TableView.this.viewCreated) {
                        if (TableView.this.componentAdded) {
                            TableView.this.fLguiItem.getObjectStatus().removeComponent((ObjectStatus.Updatable)TableView.this.eventForwarder);
                            TableView.this.componentAdded = false;
                        }
                        TableView.this.saveColumnLayout();
                        TableView.this.fLguiItem = null;
                        TableView.this.setViewerInput();
                        TableView.this.disposeTable();
                        TableView.this.viewCreated = false;
                    }
                }
            });
        }

        public void handleEvent(IMarkObjectEvent event) {
            TableView.this.selectedOid = event.getOid();
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (TableView.this.composite != null && !TableView.this.composite.isDisposed() && TableView.this.viewer.getInput() != null) {
                        TableView.this.tree.deselectAll();
                        Row[] rows = null;
                        if (TableView.this.viewer.getInput() instanceof Row[]) {
                            rows = (Row[])TableView.this.viewer.getInput();
                        }
                        int index = -1;
                        if (rows != null) {
                            int i = 0;
                            while (i < rows.length) {
                                if (rows[i].oid != null && rows[i].oid.equals(TableView.this.selectedOid)) {
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (index > -1) {
                            TableView.this.tree.setSelection(TableView.this.tree.getItem(index));
                        }
                    }
                }
            });
        }

        public void handleEvent(ISelectObjectEvent event) {
            final String oid = event.getOid();
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (TableView.this.composite != null && !TableView.this.composite.isDisposed() && TableView.this.viewer.getInput() != null) {
                        TableView.this.tree.deselectAll();
                        Row[] rows = null;
                        if (TableView.this.viewer.getInput() instanceof Row[]) {
                            rows = (Row[])TableView.this.viewer.getInput();
                        }
                        int index = -1;
                        if (rows != null) {
                            int i = 0;
                            while (i < rows.length) {
                                if (rows[i].oid != null && rows[i].oid.equals(oid)) {
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (index > -1) {
                            TableView.this.tree.select(TableView.this.tree.getItem(index));
                        }
                    }
                }
            });
        }

        public void handleEvent(final ITableFilterEvent event) {
            if (event.getGid().equals(TableView.this.gid)) {
                UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        if (event.getGid().equals(TableView.this.gid)) {
                            if (event.getPattern().size() > 0) {
                                TableView.this.setViewerInput(event.getPattern());
                                TableView.this.updateAfterLastFilter = false;
                            } else {
                                TableView.this.setViewerInput();
                            }
                            TableView.this.filterOwnJobsActionItem.getAction().setChecked(TableView.this.fLguiItem.isFilterOwnJobActive(TableView.this.gid));
                        }
                    }
                });
            }
        }

        public void handleEvent(ITableSortedEvent e) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (TableView.this.fLguiItem != null && TableView.this.fLguiItem.getTableHandler() != null && TableView.this.tree.getSortDirection() != 0 && TableView.this.tree.getSortColumn() != null) {
                        TableView.this.fLguiItem.getTableHandler().sort(TableView.this.gid, 128, TableView.this.getSortIndex(), TableView.this.tree.getSortDirection());
                    }
                    if (!TableView.this.updateAfterLastFilter && TableView.this.fLguiItem.getTableHandler().getPattern(TableView.this.gid).size() > 0) {
                        TableView.this.setViewerInput(TableView.this.fLguiItem.getTableHandler().getPattern(TableView.this.gid));
                    } else {
                        TableView.this.setViewerInput();
                    }
                }
            });
        }

        public void handleEvent(IUnmarkObjectEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    TableView.this.selectedOid = null;
                    if (TableView.this.composite != null && !TableView.this.composite.isDisposed()) {
                        TableView.this.tree.deselectAll();
                    }
                }
            });
        }

        public void handleEvent(IUnselectedObjectEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (TableView.this.composite != null && !TableView.this.composite.isDisposed()) {
                        TableView.this.tree.deselectAll();
                    }
                }
            });
        }

        public void handleEvent(IViewUpdateEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (TableView.this.composite != null) {
                        if (TableView.this.viewCreated) {
                            if (TableView.this.firstColumnlabelProvider != null) {
                                TableView.this.firstColumnlabelProvider.clearImages();
                            }
                            if (TableView.this.selectedItem != null && !TableView.this.selectedItem.isDisposed()) {
                                TableView.this.lmlManager.unmarkObject(TableView.this.selectedItem.getData().toString());
                                TableView.this.selectedItem = null;
                            }
                            if (TableView.this.componentAdded) {
                                if (TableView.this.fLguiItem != null && TableView.this.fLguiItem.getObjectStatus() != null) {
                                    TableView.this.fLguiItem.getObjectStatus().removeComponent((ObjectStatus.Updatable)TableView.this.eventForwarder);
                                }
                                TableView.this.componentAdded = false;
                            }
                            TableView.this.fLguiItem = TableView.this.lmlManager.getSelectedLguiItem();
                            if (TableView.this.fLguiItem != null && TableView.this.fLguiItem.getTableHandler() != null && TableView.this.tree.getSortColumn() != null) {
                                TableView.this.fLguiItem.getTableHandler().getSortProperties(TableView.this.gid);
                                TableView.this.fLguiItem.getTableHandler().sort(TableView.this.gid, 128, TableView.this.getSortIndex(), TableView.this.tree.getSortDirection());
                            }
                            TableView.this.updateViewerInput();
                            TableView.this.updateAfterLastFilter = true;
                            if (TableView.this.fLguiItem != null && TableView.this.fLguiItem.getTableHandler() != null) {
                                TableView.this.fLguiItem.getObjectStatus().addComponent((ObjectStatus.Updatable)TableView.this.eventForwarder);
                                TableView.this.componentAdded = true;
                            }
                            TableView.this.viewer.refresh();
                        } else {
                            TableView.this.fLguiItem = TableView.this.lmlManager.getSelectedLguiItem();
                            if (TableView.this.fLguiItem != null) {
                                TableView.this.viewCreated = TableView.this.createTable();
                                if (!TableView.this.componentAdded && TableView.this.fLguiItem != null && TableView.this.fLguiItem.getTableHandler() != null) {
                                    TableView.this.fLguiItem.getObjectStatus().addComponent((ObjectStatus.Updatable)TableView.this.eventForwarder);
                                    TableView.this.componentAdded = true;
                                }
                            }
                        }
                    }
                }
            });
        }
    }
}

