/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.editor.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ptp.internal.rdt.editor.preferences.HeaderFooterFieldEditor;
import org.eclipse.ptp.internal.rdt.editor.preferences.PreferenceMessages;
import org.eclipse.ptp.rdt.editor.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PrintPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected static final String PRINT_KEY = "com.ibm.tpf.util.print";
    protected static final String FONT_KEY = "com.ibm.tpf.util.print.font";
    protected static final String HEADER_KEY = "com.ibm.tpf.util.print.header";
    protected static final String FOOTER_KEY = "com.ibm.tpf.util.print.footer";
    protected static final String LEFT_KEY = ".left";
    protected static final String RIGHT_KEY = ".right";
    protected static final String CENTER_KEY = ".center";
    protected static final String LINE_NUMBER_KEY = "com.ibm.tpf.util.print.lineNumbers";
    protected static final String SEPARATOR = "\t";
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final String PAGE_ID = "org.eclipse.ptp.rdt.ui.editor.PrintPreferencePage";
    protected String SAMPLE = "x=x+1;";

    public PrintPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor(LINE_NUMBER_KEY, PreferenceMessages.LineNumbers, parent));
        this.addField((FieldEditor)new FontFieldEditor(FONT_KEY, PreferenceMessages.Font, this.SAMPLE, parent));
        this.addField(new HeaderFooterFieldEditor(parent));
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(result, "org.eclipse.ptp.rdt.editor.printPreferencePage");
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    public static Font getSavedFont() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        FontData fd = PreferenceConverter.getFontData((IPreferenceStore)store, (String)FONT_KEY);
        return new Font((Device)Display.getCurrent(), fd);
    }

    private static String getHeader(int position) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getString(HEADER_KEY + PrintPreferencePage.getPositionKey(position));
    }

    public static String getHeader() {
        return String.valueOf(PrintPreferencePage.getHeader(0)) + SEPARATOR + PrintPreferencePage.getHeader(2) + SEPARATOR + PrintPreferencePage.getHeader(1);
    }

    private static String getPositionKey(int position) {
        if (position == 0) {
            return LEFT_KEY;
        }
        if (position == 1) {
            return RIGHT_KEY;
        }
        return CENTER_KEY;
    }

    private static String getFooter(int position) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getString(FOOTER_KEY + PrintPreferencePage.getPositionKey(position));
    }

    public static String getFooter() {
        return String.valueOf(PrintPreferencePage.getFooter(0)) + SEPARATOR + PrintPreferencePage.getFooter(2) + SEPARATOR + PrintPreferencePage.getFooter(1);
    }

    public static void setDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)FONT_KEY, (FontData[])JFaceResources.getTextFont().getFontData());
        store.setDefault("com.ibm.tpf.util.print.header.left", "<file>");
        store.setDefault("com.ibm.tpf.util.print.header.right", "<date> <time>");
        store.setDefault("com.ibm.tpf.util.print.header.center", "");
        store.setDefault("com.ibm.tpf.util.print.footer.left", "");
        store.setDefault("com.ibm.tpf.util.print.footer.right", "<page>");
        store.setDefault("com.ibm.tpf.util.print.footer2", "");
        store.setDefault(LINE_NUMBER_KEY, false);
    }

    public static boolean getPrintLineNumbers() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean(LINE_NUMBER_KEY);
    }
}

