/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.ptp.rdt.managedbuilder.gnu.ui.scannerdiscovery;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.internal.ptp.rdt.managedbuilder.gnu.ui.scannerdiscovery.RemoteGCCPerFileBOPConsoleParserUtility;

public class RemoteGCCPerFileBOPConsoleParser
extends AbstractGCCBOPConsoleParser {
    public static String LOG_TAG = "RemoteGCCPerFileBOPConsoleParser:";
    private static final String[] FILE_EXTENSIONS = new String[]{".c", ".cc", ".cpp", ".cxx", ".C", ".CC", ".CPP", ".CXX"};
    private static final List<String> FILE_EXTENSIONS_LIST = Arrays.asList(FILE_EXTENSIONS);
    private RemoteGCCPerFileBOPConsoleParserUtility fUtil;

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fUtil = project != null && workingDirectory != null && markerGenerator != null ? new RemoteGCCPerFileBOPConsoleParserUtility(project, workingDirectory, markerGenerator) : null;
        super.startup(project, collector);
    }

    protected AbstractGCCBOPConsoleParserUtility getUtility() {
        return this.fUtil;
    }

    protected boolean processCommand(String[] tokens) {
        int compilerInvocationIndex = this.findCompilerInvocation(tokens);
        if (compilerInvocationIndex < 0) {
            return false;
        }
        int extensionsIndex = -1;
        boolean found = false;
        String filePath = null;
        int i = compilerInvocationIndex + 1;
        while (i < tokens.length) {
            String fileExtension;
            String token = tokens[i];
            int k = token.lastIndexOf(46);
            if (k != -1 && token.length() - k < 5 && (extensionsIndex = FILE_EXTENSIONS_LIST.indexOf(fileExtension = token.substring(k))) != -1) {
                filePath = token;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            TraceUtil.outputTrace((String)"Error identifying file name :1", (String[])tokens, (String)TraceUtil.EOL);
            return false;
        }
        if (filePath == null || filePath.indexOf(FILE_EXTENSIONS[extensionsIndex]) == -1) {
            TraceUtil.outputTrace((String)"Error identifying file name :2", (String[])tokens, (String)TraceUtil.EOL);
            return false;
        }
        if (this.fUtil != null) {
            IPath pFilePath = this.fUtil.getAbsolutePath(filePath);
            String shortFileName = pFilePath.removeFileExtension().lastSegment();
            int i2 = compilerInvocationIndex + 1;
            while (i2 < tokens.length) {
                String token = tokens[i2];
                if (token.equals("-include")) {
                    ++i2;
                } else if (token.equals("-imacros")) {
                    ++i2;
                } else if (token.equals(filePath)) {
                    tokens[i2] = "LONG_NAME";
                } else if (token.startsWith(shortFileName)) {
                    tokens[i2] = token.replaceFirst(shortFileName, "SHORT_NAME");
                }
                ++i2;
            }
            IFile file = null;
            IPath baseDirectory = this.fUtil.getBaseDirectory();
            if (baseDirectory.isPrefixOf(pFilePath) || baseDirectory.setDevice(null).isPrefixOf(pFilePath)) {
                IPath relPath = pFilePath.removeFirstSegments(baseDirectory.segmentCount());
                file = this.getProject().getFile(relPath);
            } else {
                IProject prj = this.fUtil.getProject();
                file = ResourceLookup.selectFileForLocation((IPath)pFilePath, (IProject)prj);
            }
            if (file != null) {
                CCommandDSC cmd = this.fUtil.getNewCCommandDSC(tokens, compilerInvocationIndex, extensionsIndex > 0);
                CopyOnWriteArrayList<CCommandDSC> cmdList = new CopyOnWriteArrayList<CCommandDSC>();
                cmdList.add(cmd);
                HashMap<ScannerInfoTypes, CopyOnWriteArrayList<CCommandDSC>> sc = new HashMap<ScannerInfoTypes, CopyOnWriteArrayList<CCommandDSC>>(1);
                sc.put(ScannerInfoTypes.COMPILER_COMMAND, cmdList);
                IScannerInfoCollector collector = this.getCollector();
                collector.contributeToScannerConfig((Object)file, sc);
                if (collector != null && collector instanceof IScannerInfoCollector2) {
                    IScannerInfoCollector2 collector2 = (IScannerInfoCollector2)collector;
                    try {
                        collector2.updateScannerConfiguration(null);
                    }
                    catch (CoreException e) {
                        TraceUtil.outputError((String)(String.valueOf(LOG_TAG) + "catch a CoreException when updateing the scanner configuration"), (String)e.toString());
                    }
                }
            } else {
                TraceUtil.outputError((String)("Build command for file outside project: " + pFilePath.toString()), (String[])tokens);
            }
        }
        return true;
    }

    public void shutdown() {
        super.shutdown();
        IScannerInfoCollector fCollector = this.getCollector();
        if (fCollector != null && fCollector instanceof IScannerInfoCollector2) {
            IScannerInfoCollector2 collector = (IScannerInfoCollector2)fCollector;
            try {
                collector.updateScannerConfiguration(null);
            }
            catch (CoreException e) {
                TraceUtil.outputError((String)(String.valueOf(LOG_TAG) + "catch a CoreException when shutting down the parser"), (String)e.toString());
            }
        }
    }
}

