/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import org.eclipse.ptp.internal.remote.terminal.IRemoteSettings;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class RemoteSettings
implements IRemoteSettings {
    public static final String CONNECTION_NAME = "ConnectionName";
    public static final String REMOTE_SERVICES = "RemoteServices";
    public static final String PROJECT_NAME = "Project";
    protected String fRemoteServices;
    protected String fConnectionName;
    protected String fProjectName;

    @Override
    public String getConnectionName() {
        return this.fConnectionName;
    }

    @Override
    public String getRemoteServices() {
        return this.fRemoteServices;
    }

    public String getProjectName() {
        return this.fProjectName;
    }

    @Override
    public String getSummary() {
        return "Remote:" + this.getRemoteServices() + '_' + this.getConnectionName();
    }

    public String toString() {
        return this.getSummary();
    }

    @Override
    public void load(ISettingsStore store) {
        this.fRemoteServices = store.get(REMOTE_SERVICES);
        this.fConnectionName = store.get(CONNECTION_NAME);
        this.fProjectName = store.get(PROJECT_NAME);
    }

    @Override
    public void save(ISettingsStore store) {
        store.put(REMOTE_SERVICES, this.fRemoteServices);
        store.put(CONNECTION_NAME, this.fConnectionName);
        store.put(PROJECT_NAME, this.fProjectName);
    }

    public void setConnectionName(String name) {
        this.fConnectionName = name;
    }

    public void setRemoteServices(String remoteServices) {
        this.fRemoteServices = remoteServices;
    }

    public void setProjectName(String projectName) {
        this.fProjectName = projectName;
    }
}

