/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rephraserengine.core.util.TwoKeyHashMap;

public final class TwoKeyHashMap<RowType, ColType, CellType>
implements Iterable<CellType>,
Serializable {
    protected HashMap<RowType, HashMap<ColType, CellType>> table = new HashMap();

    public CellType put(RowType k1, ColType k2, CellType v) {
        if (!this.table.containsKey(k1)) {
            this.table.put(k1, new HashMap());
        }
        HashMap<ColType, CellType> thisRow = this.table.get(k1);
        thisRow.put(k2, v);
        return v;
    }

    public CellType getEntry(RowType k1, ColType k2) {
        if (!this.table.containsKey(k1)) {
            return null;
        }
        HashMap<ColType, CellType> thisRow = this.table.get(k1);
        if (!thisRow.containsKey(k2)) {
            return null;
        }
        return thisRow.get(k2);
    }

    public HashMap<ColType, CellType> getAllEntriesFor(RowType k1) {
        if (!this.table.containsKey(k1)) {
            return null;
        }
        return this.table.get(k1);
    }

    public Set<RowType> keySet() {
        return this.table.keySet();
    }

    public boolean containsEntry(RowType k1, ColType k2) {
        return this.getEntry(k1, k2) != null;
    }

    public void clear() {
        this.table.clear();
    }

    public void remove(RowType key) {
        this.table.remove(key);
    }

    public void remove(RowType k1, ColType k2) {
        if (this.table.containsKey(k1)) {
            this.table.get(k1).remove(k2);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (RowType r : this.table.keySet()) {
            HashMap<ColType, CellType> thisRow = this.table.get(r);
            if (thisRow == null) continue;
            for (ColType c : thisRow.keySet()) {
                sb.append("   ");
                sb.append("(");
                sb.append(r);
                sb.append(", ");
                sb.append(c);
                sb.append(") ==> ");
                sb.append(thisRow.get(c));
            }
        }
        sb.append("   }");
        return sb.toString();
    }

    @Override
    public Iterator<CellType> iterator() {
        return new ValueIterator();
    }

    public Object clone() {
        TwoKeyHashMap<RowType, ColType, CellType> toReturn = new TwoKeyHashMap<RowType, ColType, CellType>();
        for (RowType r : this.table.keySet()) {
            for (ColType c : this.table.get(r).keySet()) {
                CellType t = this.table.get(r).get(c);
                toReturn.put(r, c, t);
            }
        }
        return toReturn;
    }

    protected final class ValueIterator
    implements Iterator<CellType> {
        protected org.eclipse.rephraserengine.core.util.TwoKeyHashMap$ValueIterator.State currentState;
        protected Iterator<HashMap<ColType, CellType>> rowIterator;
        protected Iterator<CellType> colIterator;
        protected final org.eclipse.rephraserengine.core.util.TwoKeyHashMap$ValueIterator.State INITIAL = new State(this){

            @Override
            CellType getNextValue() {
                rowIterator = ((ValueIterator)this).TwoKeyHashMap.this.table.values().iterator();
                currentState = STARTING_NEW_ROW;
                return currentState.getNextValue();
            }
        };
        protected final org.eclipse.rephraserengine.core.util.TwoKeyHashMap$ValueIterator.State STARTING_NEW_ROW = new State(this){

            @Override
            CellType getNextValue() {
                if (rowIterator.hasNext()) {
                    colIterator = rowIterator.next().values().iterator();
                    currentState = WORKING_THROUGH_ROW;
                } else {
                    currentState = DONE;
                }
                return currentState.getNextValue();
            }
        };
        protected final org.eclipse.rephraserengine.core.util.TwoKeyHashMap$ValueIterator.State WORKING_THROUGH_ROW = new State(this){

            @Override
            CellType getNextValue() {
                if (colIterator.hasNext()) {
                    return colIterator.next();
                }
                currentState = STARTING_NEW_ROW;
                return currentState.getNextValue();
            }
        };
        protected final org.eclipse.rephraserengine.core.util.TwoKeyHashMap$ValueIterator.State DONE = new State(this){

            @Override
            CellType getNextValue() {
                return null;
            }
        };
        protected CellType nextValue;

        ValueIterator() {
            this.currentState = this.INITIAL;
            this.nextValue = this.currentState.getNextValue();
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public CellType next() {
            Object currentValue = this.nextValue;
            this.nextValue = this.currentState.getNextValue();
            if (currentValue == null && this.nextValue == null) {
                throw new NoSuchElementException();
            }
            return currentValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract class State {
            protected State() {
            }

            abstract CellType getNextValue();
        }
    }
}

