/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.model.TmfTraceImportException;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.Messages;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfNavigatorContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfWithFolderElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceTypeHelper;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class TracePackageImportOperation
extends AbstractTracePackageOperation
implements IOverwriteQuery {
    private final TracePackageElement[] fImportTraceElements;
    private final TmfTraceFolder fTmfTraceFolder;

    public TracePackageImportOperation(String fileName, TracePackageElement[] importTraceElements, TmfTraceFolder tmfTraceFolder) {
        super(fileName);
        this.fImportTraceElements = importTraceElements;
        this.fTmfTraceFolder = tmfTraceFolder;
    }

    @Override
    public void run(IProgressMonitor progressMonitor) {
        int totalWork = this.getNbCheckedElements(this.fImportTraceElements) * 2;
        progressMonitor.beginTask(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ImportingPackage, totalWork);
        this.doRun(progressMonitor);
        progressMonitor.done();
    }

    private void doRun(IProgressMonitor progressMonitor) {
        try {
            this.setStatus(this.deleteExistingTraces(progressMonitor));
            if (this.getStatus().getSeverity() != 0) {
                return;
            }
            TracePackageElement[] tracePackageElementArray = this.fImportTraceElements;
            int n = this.fImportTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                TracePackageElement packageElement = tracePackageElementArray[n2];
                TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
                if (TracePackageImportOperation.isFilesChecked(packageElement)) {
                    TracePackageElement[] children;
                    TracePackageElement[] tracePackageElementArray2 = children = traceElement.getChildren();
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TracePackageElement element = tracePackageElementArray2[n4];
                        ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                        if (element instanceof TracePackageFilesElement) {
                            TracePackageFilesElement traceFilesElement = (TracePackageFilesElement)element;
                            this.setStatus(this.importTraceFiles(traceFilesElement, progressMonitor));
                        } else if (element instanceof TracePackageSupplFilesElement) {
                            TracePackageSupplFilesElement suppFilesElement = (TracePackageSupplFilesElement)element;
                            this.setStatus(this.importSupplFiles(suppFilesElement, traceElement, progressMonitor));
                        }
                        if (this.getStatus().getSeverity() != 0) {
                            return;
                        }
                        ++n4;
                    }
                    String traceName = traceElement.getText();
                    IResource traceRes = this.fTmfTraceFolder.getResource().findMember(traceName);
                    if (traceRes == null || !traceRes.exists()) {
                        this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorFindingImportedTrace, traceName)));
                        return;
                    }
                    TraceTypeHelper traceType = null;
                    String traceTypeStr = traceElement.getTraceType();
                    if (traceTypeStr != null) {
                        traceType = TmfTraceType.getInstance().getTraceType(traceTypeStr);
                        if (traceType == null) {
                            this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorSettingTraceType, traceElement.getTraceType(), traceName)));
                            return;
                        }
                    } else {
                        try {
                            progressMonitor.subTask(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_DetectingTraceType, traceName));
                            traceType = TmfTraceType.getInstance().selectTraceType(traceRes.getLocation().toOSString(), null, null);
                        }
                        catch (TmfTraceImportException suppFilesElement) {
                            // empty catch block
                        }
                    }
                    if (traceType != null) {
                        try {
                            TmfTraceType.setTraceType(traceRes.getFullPath(), traceType);
                        }
                        catch (CoreException e) {
                            this.setStatus((IStatus)new Status(4, "org.eclipse.linuxtools.tmf.ui", MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.ImportTracePackageWizardPage_ErrorSettingTraceType, traceElement.getTraceType(), traceName), (Throwable)e));
                        }
                    }
                    this.importBookmarks(traceRes, traceElement, progressMonitor);
                }
                ++n2;
            }
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
        }
    }

    private IStatus deleteExistingTraces(IProgressMonitor progressMonitor) {
        List<TmfTraceElement> traces = this.fTmfTraceFolder.getTraces();
        TracePackageElement[] tracePackageElementArray = this.fImportTraceElements;
        int n = this.fImportTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement packageElement = tracePackageElementArray[n2];
            TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
            if (TracePackageImportOperation.isFilesChecked(traceElement)) {
                TmfTraceElement existingTrace = null;
                for (TmfTraceElement t : traces) {
                    if (!t.getName().equals(traceElement.getText())) continue;
                    existingTrace = t;
                    break;
                }
                if (existingTrace != null) {
                    try {
                        existingTrace.delete((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1, 4));
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
                    }
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private void importBookmarks(IResource traceRes, TracePackageTraceElement traceElement, IProgressMonitor monitor) {
        TracePackageElement[] tracePackageElementArray = traceElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement o = tracePackageElementArray[n2];
            if (o instanceof TracePackageBookmarkElement && o.isChecked()) {
                IFile bookmarksFile = null;
                List<TmfTraceElement> traces = this.fTmfTraceFolder.getTraces();
                for (TmfTraceElement t : traces) {
                    if (!t.getName().equals(traceRes.getName())) continue;
                    try {
                        bookmarksFile = t.createBookmarksFile();
                        String traceEditorId = t.getEditorId();
                        String editorId = traceEditorId != null ? traceEditorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                        IDE.setDefaultEditor((IFile)bookmarksFile, (String)editorId);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmarkFile, traceRes.getName()), e);
                    }
                    break;
                }
                if (bookmarksFile == null) break;
                TracePackageBookmarkElement bookmarkElement = (TracePackageBookmarkElement)o;
                List<Map<String, String>> bookmarks = bookmarkElement.getBookmarks();
                for (Map<String, String> attrs : bookmarks) {
                    IMarker createMarker = null;
                    try {
                        createMarker = bookmarksFile.createMarker("org.eclipse.core.resources.bookmark");
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmark, traceRes.getName()), e);
                    }
                    if (createMarker == null || !createMarker.exists()) continue;
                    try {
                        for (String key : attrs.keySet()) {
                            String value = attrs.get(key);
                            if (key.equals("location")) {
                                createMarker.setAttribute("location", Integer.valueOf(value).intValue());
                                continue;
                            }
                            createMarker.setAttribute(key, (Object)value);
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(MessageFormat.format(org.eclipse.linuxtools.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages.TracePackageImportOperation_ErrorCreatingBookmark, traceRes.getName()), e);
                    }
                }
            }
            ++n2;
        }
        monitor.worked(1);
    }

    private static boolean fileNameMatches(String fileName, String entryName) {
        boolean fileMatch = entryName.equalsIgnoreCase(fileName);
        boolean folderMatch = entryName.startsWith(String.valueOf(fileName) + "/");
        return fileMatch || folderMatch;
    }

    private IStatus importTraceFiles(TracePackageFilesElement traceFilesElement, IProgressMonitor monitor) {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(traceFilesElement.getFileName());
        IPath containerPath = this.fTmfTraceFolder.getPath();
        IStatus status = this.importFiles(this.getSpecifiedArchiveFile(), fileNames, containerPath, monitor);
        if (status.isOK()) {
            new TmfNavigatorContentProvider().getChildren(this.fTmfTraceFolder);
        }
        return status;
    }

    private IStatus importSupplFiles(TracePackageSupplFilesElement suppFilesElement, TracePackageTraceElement traceElement, IProgressMonitor monitor) {
        ArrayList<String> fileNames = new ArrayList<String>();
        TracePackageElement[] tracePackageElementArray = suppFilesElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement child = tracePackageElementArray[n2];
            TracePackageSupplFileElement supplFile = (TracePackageSupplFileElement)child;
            fileNames.add(supplFile.getText());
            ++n2;
        }
        if (!fileNames.isEmpty()) {
            List<TmfTraceElement> traces = this.fTmfTraceFolder.getTraces();
            TmfWithFolderElement tmfTraceElement = null;
            for (TmfTraceElement t : traces) {
                if (!t.getName().equals(traceElement.getText())) continue;
                tmfTraceElement = t;
                break;
            }
            if (tmfTraceElement != null) {
                AbstractTracePackageOperation.ArchiveFile archiveFile = this.getSpecifiedArchiveFile();
                tmfTraceElement.refreshSupplementaryFolder();
                String traceName = tmfTraceElement.getResource().getName();
                IPath destinationContainerPath = tmfTraceElement.getTraceSupplementaryFolder(traceName).getFullPath();
                return this.importFiles(archiveFile, fileNames, destinationContainerPath, monitor);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus importFiles(AbstractTracePackageOperation.ArchiveFile archiveFile, List<String> fileNames, IPath destinationContainerPath, IProgressMonitor monitor) {
        ArrayList<ArchiveProviderElement> objects = new ArrayList<ArchiveProviderElement>();
        Enumeration<? extends AbstractTracePackageOperation.ArchiveEntry> entries = archiveFile.entries();
        block4: while (entries.hasMoreElements()) {
            AbstractTracePackageOperation.ArchiveEntry entry = entries.nextElement();
            String entryName = entry.getName();
            Path fullArchivePath = new Path(entryName);
            if (fullArchivePath.hasTrailingSeparator()) continue;
            for (String fileName : fileNames) {
                Path searchedArchivePath = new Path(fileName);
                if (!TracePackageImportOperation.fileNameMatches(searchedArchivePath.toString(), entryName)) continue;
                IPath searchedArchivePathContainer = searchedArchivePath.removeLastSegments(1);
                IPath destinationPath = fullArchivePath.makeRelativeTo(searchedArchivePathContainer);
                String resourceLabel = fullArchivePath.lastSegment();
                ArchiveProviderElement pe = new ArchiveProviderElement(destinationPath.toString(), resourceLabel, archiveFile, entry);
                objects.add(pe);
                continue block4;
            }
        }
        ImportProvider provider = new ImportProvider();
        ImportOperation operation = new ImportOperation(destinationContainerPath, null, (IImportStructureProvider)provider, (IOverwriteQuery)this, objects);
        operation.setCreateContainerStructure(true);
        operation.setOverwriteResources(true);
        try {
            operation.run((IProgressMonitor)new SubProgressMonitor(monitor, fileNames.size(), 4));
            archiveFile.close();
        }
        catch (InvocationTargetException e) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)e);
        }
        if (provider.getException() != null) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TracePackage_ErrorOperation, (Throwable)provider.getException());
        }
        return operation.getStatus();
    }

    public String queryOverwrite(String pathString) {
        return null;
    }

    private class ArchiveProviderElement {
        private final String fPath;
        private final String fLabel;
        private AbstractTracePackageOperation.ArchiveFile fArchiveFile;
        private AbstractTracePackageOperation.ArchiveEntry fEntry;

        public ArchiveProviderElement(String destinationPath, String label, AbstractTracePackageOperation.ArchiveFile archiveFile, AbstractTracePackageOperation.ArchiveEntry entry) {
            this.fPath = destinationPath;
            this.fLabel = label;
            this.fArchiveFile = archiveFile;
            this.fEntry = entry;
        }

        public InputStream getContents() throws TarException, IOException {
            return this.fArchiveFile.getInputStream(this.fEntry);
        }

        public String getFullPath() {
            return this.fPath;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public boolean isFolder() {
            return false;
        }
    }

    private class ImportProvider
    implements IImportStructureProvider {
        private Exception fException;

        private ImportProvider() {
        }

        public List getChildren(Object element) {
            return null;
        }

        public InputStream getContents(Object element) {
            InputStream inputStream = null;
            try {
                inputStream = ((ArchiveProviderElement)element).getContents();
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (TarException e) {
                this.fException = e;
            }
            return inputStream;
        }

        public String getFullPath(Object element) {
            return ((ArchiveProviderElement)element).getFullPath();
        }

        public String getLabel(Object element) {
            return ((ArchiveProviderElement)element).getLabel();
        }

        public boolean isFolder(Object element) {
            return ((ArchiveProviderElement)element).isFolder();
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

