/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.request;

import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;

public abstract class TmfEventRequest
extends TmfDataRequest
implements ITmfEventRequest {
    private final TmfTimeRange fRange;

    public TmfEventRequest(Class<? extends ITmfEvent> dataType) {
        this(dataType, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, ITmfDataRequest.ExecutionType priority) {
        this(dataType, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range) {
        this(dataType, range, 0L, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, 0L, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, int nbRequested) {
        this(dataType, range, 0L, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, int nbRequested, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, 0L, nbRequested, 1000, priority);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, int nbRequested, int blockSize) {
        this(dataType, range, 0L, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, long index, int nbRequested, int blockSize) {
        this(dataType, range, index, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, 0L, nbRequested, blockSize, priority);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, long index, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        super(dataType, index, nbRequested, blockSize, priority);
        this.fRange = range;
        if (TmfCoreTracer.isRequestTraced()) {
            String type = this.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            String message = "CREATED " + (this.getExecType() == ITmfDataRequest.ExecutionType.BACKGROUND ? "(BG)" : "(FG)") + " Type=" + type + " Index=" + this.getIndex() + " NbReq=" + this.getNbRequested() + " Range=" + this.getRange() + " DataType=" + this.getDataType().getSimpleName();
            TmfCoreTracer.traceRequest(this, message);
        }
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    @Override
    public void setStartIndex(int index) {
        this.setIndex(index);
    }

    @Override
    public int hashCode() {
        return this.getRequestId();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfEventRequest) {
            TmfEventRequest request = (TmfEventRequest)other;
            return super.equals(other) && request.fRange.equals(this.fRange);
        }
        return false;
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(dot + 1);
        }
        return "[" + name + "(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + (Object)((Object)this.getExecType()) + "," + this.getRange() + "," + this.getIndex() + "," + this.getNbRequested() + "," + this.getBlockSize() + ")]";
    }
}

