/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.IntegerStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.LongStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.NullStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.StringStateValue;

public abstract class TmfStateValue
implements ITmfStateValue {
    private static TmfStateValue nullValue = new NullStateValue();

    protected abstract Object getValue();

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TmfStateValue)) {
            return false;
        }
        if (this.getType() != ((TmfStateValue)other).getType()) {
            return false;
        }
        if (this.isNull()) {
            return true;
        }
        return this.getValue().equals(((TmfStateValue)other).getValue());
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.getValue().hashCode();
    }

    public static final TmfStateValue nullValue() {
        return nullValue;
    }

    public static TmfStateValue newValueInt(int intValue) {
        if (intValue == -1) {
            return TmfStateValue.nullValue();
        }
        return new IntegerStateValue(intValue);
    }

    public static TmfStateValue newValueLong(long longValue) {
        if (longValue == -1L) {
            return TmfStateValue.nullValue();
        }
        return new LongStateValue(longValue);
    }

    public static TmfStateValue newValueString(@Nullable String strValue) {
        if (strValue == null) {
            return TmfStateValue.nullValue();
        }
        return new StringStateValue(strValue);
    }

    private String unboxErrMsg(String targetType) {
        return "Type " + this.getClass().getSimpleName() + "cannot be unboxed into a " + targetType + " value.";
    }

    @Override
    public int unboxInt() throws StateValueTypeException {
        throw new StateValueTypeException(this.unboxErrMsg("Int"));
    }

    @Override
    public long unboxLong() throws StateValueTypeException {
        throw new StateValueTypeException(this.unboxErrMsg("Long"));
    }

    @Override
    public String unboxStr() throws StateValueTypeException {
        throw new StateValueTypeException(this.unboxErrMsg("String"));
    }
}

