/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.SourceManipulation;
import org.eclipse.ptp.internal.rdt.core.model.StructureInfo;

public class StructureDeclaration
extends SourceManipulation
implements IStructureDeclaration {
    private static final long serialVersionUID = 1L;
    protected boolean fIsStatic;
    protected boolean fIsVolatile;
    protected boolean fIsConst;
    protected String fTypeName;

    public StructureDeclaration(Parent parent, String className, int kind) {
        super((ICElement)parent, kind, className);
    }

    public StructureDeclaration(Parent parent, IStructureDeclaration element) throws CModelException {
        super((ICElement)parent, (ICElement)element, (ISourceReference)element);
        this.fTypeName = element.getTypeName();
        this.fIsStatic = element.isStatic();
        this.fIsVolatile = element.isVolatile();
        this.fIsConst = element.isConst();
    }

    public StructureDeclaration(Parent parent, int type, ICompositeType binding) {
        super((ICElement)parent, type, binding.getName());
    }

    public StructureDeclaration(Parent parent, ICompositeType binding) throws DOMException {
        super((ICElement)parent, StructureDeclaration.adaptASTType(binding), binding.getName());
    }

    static int adaptASTType(ICompositeType type) throws DOMException {
        switch (type.getKey()) {
            case 1: {
                return 66;
            }
            case 2: {
                return 68;
            }
        }
        return 64;
    }

    public String getTypeName() throws CModelException {
        return this.fTypeName;
    }

    public boolean isClass() {
        switch (this.getElementType()) {
            case 64: 
            case 65: 
            case 82: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    public boolean isStruct() {
        switch (this.getElementType()) {
            case 66: 
            case 67: 
            case 84: 
            case 85: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnion() {
        switch (this.getElementType()) {
            case 68: 
            case 69: 
            case 86: 
            case 87: {
                return true;
            }
        }
        return false;
    }

    public boolean isConst() {
        return this.fIsConst;
    }

    public void setConst(boolean isConst) {
        this.fIsConst = isConst;
    }

    public boolean isStatic() {
        return this.fIsStatic;
    }

    public void setStatic(boolean isStatic) {
        this.fIsStatic = isStatic;
    }

    public boolean isVolatile() {
        return this.fIsVolatile;
    }

    public void setVolatile(boolean isVolatile) {
        this.fIsVolatile = isVolatile;
    }

    public void setTypeName(String type) {
        this.fTypeName = type;
    }

    public StructureInfo getStructureInfo() {
        if (this.fInfo == null) {
            this.fInfo = new StructureInfo(this);
        }
        return (StructureInfo)this.fInfo;
    }

    @Override
    public StructureInfo getElementInfo() {
        return this.getStructureInfo();
    }
}

