/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.profiling.launch.LocalFileProxy;
import org.eclipse.linuxtools.internal.profiling.launch.LocalLauncher;
import org.eclipse.linuxtools.internal.profiling.launch.Messages;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteProxyManager;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyNatureMapping;

public class RemoteProxyManager
implements IRemoteProxyManager {
    private static final String EXT_ATTR_CLASS = "class";
    protected static final String LOCALSCHEME = "file";
    private static RemoteProxyManager manager;
    private LocalFileProxy lfp;
    protected RemoteProxyNatureMapping mapping = new RemoteProxyNatureMapping();
    private Map<String, IRemoteProxyManager> remoteManagers = new HashMap<String, IRemoteProxyManager>();

    protected RemoteProxyManager() {
    }

    public static RemoteProxyManager getInstance() {
        if (manager == null) {
            manager = new RemoteProxyManager();
        }
        return manager;
    }

    LocalFileProxy getLocalFileProxy(URI uri) {
        if (this.lfp == null) {
            this.lfp = new LocalFileProxy(uri);
        }
        return this.lfp;
    }

    protected IRemoteProxyManager getRemoteManager(String schemeId) throws CoreException {
        IRemoteProxyManager remoteManager = this.remoteManagers.get(schemeId);
        if (remoteManager == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.profiling.launch", "RemoteProxyManager");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < infos.length) {
                Object obj;
                IConfigurationElement configurationElement = infos[i];
                if (configurationElement.getName().equals("manager") && configurationElement.getAttribute("scheme").equals(schemeId) && (obj = configurationElement.createExecutableExtension(EXT_ATTR_CLASS)) instanceof IRemoteProxyManager) {
                    remoteManager = (IRemoteProxyManager)obj;
                    this.remoteManagers.put(schemeId, remoteManager);
                    break;
                }
                ++i;
            }
        }
        return remoteManager;
    }

    @Override
    public IRemoteFileProxy getFileProxy(URI uri) throws CoreException {
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equals(LOCALSCHEME)) {
            IRemoteProxyManager manager = this.getRemoteManager(scheme);
            if (manager != null) {
                return manager.getFileProxy(uri);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.profiling.launch", 0, String.valueOf(Messages.RemoteProxyManager_unrecognized_scheme) + scheme, null));
        }
        return this.getLocalFileProxy(uri);
    }

    @Override
    public IRemoteFileProxy getFileProxy(IProject project) throws CoreException {
        IRemoteProxyManager manager;
        if (project == null) {
            return this.getLocalFileProxy(null);
        }
        String scheme = this.mapping.getSchemeFromNature(project);
        if (scheme != null && (manager = this.getRemoteManager(scheme)) != null) {
            return manager.getFileProxy(project);
        }
        URI projectURI = project.getLocationURI();
        return this.getFileProxy(projectURI);
    }

    @Override
    public IRemoteCommandLauncher getLauncher(URI uri) throws CoreException {
        IRemoteProxyManager manager;
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equals(LOCALSCHEME) && (manager = this.getRemoteManager(scheme)) != null) {
            return manager.getLauncher(uri);
        }
        return new LocalLauncher();
    }

    @Override
    public IRemoteCommandLauncher getLauncher(IProject project) throws CoreException {
        if (project == null) {
            return new LocalLauncher();
        }
        String scheme = this.mapping.getSchemeFromNature(project);
        if (scheme != null) {
            IRemoteProxyManager manager = this.getRemoteManager(scheme);
            return manager.getLauncher(project);
        }
        URI projectURI = project.getLocationURI();
        return this.getLauncher(projectURI);
    }

    @Override
    public String getOS(URI uri) throws CoreException {
        IRemoteProxyManager manager;
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equals(LOCALSCHEME) && (manager = this.getRemoteManager(scheme)) != null) {
            return manager.getOS(uri);
        }
        return Platform.getOS();
    }

    @Override
    public String getOS(IProject project) throws CoreException {
        String scheme = this.mapping.getSchemeFromNature(project);
        if (scheme != null) {
            IRemoteProxyManager manager = this.getRemoteManager(scheme);
            return manager.getOS(project);
        }
        URI projectURI = project.getLocationURI();
        return this.getOS(projectURI);
    }

    public String getRemoteProjectLocation(IProject project) throws CoreException {
        if (project != null) {
            IRemoteFileProxy remoteFileProxy = null;
            remoteFileProxy = this.getFileProxy(project);
            URI workingDirURI = remoteFileProxy.getWorkingDir();
            return workingDirURI.toString();
        }
        return null;
    }
}

