/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.feedback.views;

import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.etfw.feedback.AbstractFeedbackAction;
import org.eclipse.ptp.etfw.feedback.IFeedbackItem;
import org.eclipse.ptp.internal.etfw.feedback.Activator;
import org.eclipse.ptp.internal.etfw.feedback.messages.Messages;
import org.eclipse.ptp.internal.etfw.feedback.views.FeedbackActionCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.osgi.framework.Bundle;

public class SimpleTreeTableMarkerView
extends ViewPart {
    protected TreeViewer viewer;
    protected String parentMarkerAttrib = "parent";
    private Tree tree;
    protected Action infoAction;
    protected Action extensionAction;
    protected AbstractFeedbackAction feedbackAction;
    protected Action filterAction;
    protected Action doubleClickAction;
    protected Action removeMarkerAction;
    protected Action expandAllAction;
    protected Action collapseAllAction;
    protected int expandCollapseStatus;
    protected static final int EXPAND_COLLAPSE_NONE = 0;
    protected static final int EXPAND_COLLAPSE_EXPANDALL = 1;
    protected static final int EXPAND_COLLAPSE_COLLAPSEALL = 2;
    private static final boolean traceOn = false;
    private static final boolean traceStatusLine = false;
    protected ViewerSorter nameSorter;
    protected GenericSorter lineNoSorter;
    protected FilenameSorter filenameSorter;
    protected GenericSorter orderSorter;
    protected GenericSorter nameArtifactSorter;
    protected GenericSorter constructSorter;
    private IMarker selectedMarker_ = null;
    protected StackList changedArts_ = new StackList();
    protected StackList changedMarkers_ = new StackList();
    protected UpdateVisitor visitor_ = new UpdateVisitor();
    protected String thingname_ = Messages.SimpleTreeTableMarkerView_artifact;
    protected String thingnames_ = Messages.SimpleTreeTableMarkerView_artifacts;
    private String columnName_ = Messages.SimpleTreeTableMarkerView_value;
    private AbstractUIPlugin thePlugin_;
    private String iconName_ = "icons/feedback.png";
    private String viewName_;
    private String viewID_;
    private String markerID_;
    private String[] columnNames_;
    private int[] widths_ = null;
    private static final int DEFAULT_WIDTH = 100;
    private String[] markerAttrNames_;
    protected String uniqueID_ = "uniqueID";
    protected String columnID_ = "constructType";
    private boolean createParentsIfNeeded = false;
    protected static final String NAME = "name";
    protected static final String FILENAME = "filename";
    protected static final String LINE = "lineNumber";
    protected static final String DESCRIPTION = "description";
    public static final int NONE = 0;
    public static final int FUNCTION_CALL = 1;
    public static final int CONSTANT = 2;
    public static final String[] CONSTRUCT_TYPE_NAMES = new String[]{Messages.SimpleTreeTableMarkerView_none, Messages.SimpleTreeTableMarkerView_functionCall, Messages.SimpleTreeTableMarkerView_constant};
    private final HashMap iconHash = new HashMap();

    public SimpleTreeTableMarkerView(AbstractUIPlugin thePlugin, String thingname, String thingnames, String columnName, String markerID, String parentMarkerAttrName) {
        this.thePlugin_ = thePlugin == null ? Activator.getDefault() : thePlugin;
        if (thingname != null) {
            this.thingname_ = thingname;
        }
        if (thingnames != null) {
            this.thingnames_ = thingnames;
        }
        if (columnName != null) {
            this.columnName_ = columnName;
        }
        this.markerID_ = markerID;
        this.parentMarkerAttrib = parentMarkerAttrName;
        this.findViewInfo();
    }

    public SimpleTreeTableMarkerView(AbstractUIPlugin thePlugin, String thingname, String thingnames, String columnName, String markerID, String parentMarkerAttrName, boolean createParentsIfNeeded) {
        this(thePlugin, thingname, thingnames, columnName, markerID, parentMarkerAttrName);
        this.createParentsIfNeeded = createParentsIfNeeded;
    }

    public SimpleTreeTableMarkerView(AbstractUIPlugin thePlugin, String thingname, String thingnames, String[] attrNames, String[] colNames, String markerID, String parentMarkerAttribName) {
        this(thePlugin, thingname, thingnames, attrNames, colNames, null, markerID, parentMarkerAttribName, false);
    }

    public SimpleTreeTableMarkerView(AbstractUIPlugin thePlugin, String thingname, String thingnames, String[] attrNames, String[] colNames, int[] widths, String markerID, String parentMarkerAttribName, boolean createParentsIfNeeded) {
        this(thePlugin, thingname, thingnames, null, markerID, parentMarkerAttribName);
        this.columnNames_ = colNames;
        this.columnName_ = null;
        this.markerAttrNames_ = attrNames;
        this.widths_ = widths;
        this.createParentsIfNeeded = createParentsIfNeeded;
        int len1 = attrNames.length;
        int len2 = colNames.length;
        int len3 = widths.length;
        if (len1 != len2 || len2 != len3) {
            System.out.println("WARNING: SimpleTreeTableMarkerView expects attrNames, colNames, and widths to all be the same length.");
        }
    }

    public SimpleTreeTableMarkerView() {
        this(null, null, null, null, null, null);
    }

    protected void findViewInfo() {
        String classname = ((Object)((Object)this)).getClass().getName();
        IExtension[] ext = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.views").getExtensions();
        int i = 0;
        while (i < ext.length) {
            IExtension extension = ext[i];
            IConfigurationElement[] ces = extension.getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                IConfigurationElement cElement = ces[j];
                String iconName = cElement.getAttribute("icon");
                String classN = cElement.getAttribute("class");
                String name = cElement.getAttribute(NAME);
                if (classname.equals(classN)) {
                    if (iconName != null) {
                        this.iconName_ = iconName;
                    }
                    this.viewName_ = name;
                    this.viewID_ = cElement.getAttribute("id");
                    if (this.markerID_ == null) {
                        this.markerID_ = this.viewID_;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean validForAnalysis(String filename) {
        return true;
    }

    protected String getConstructStr(IMarker marker) throws CoreException {
        Integer temp = (Integer)marker.getAttribute(this.columnID_);
        if (temp != null) {
            Integer constructType = temp;
            return CONSTRUCT_TYPE_NAMES[constructType];
        }
        return " ";
    }

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 2048);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.createTreeColumns();
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.nameSorter = new NameSorter();
        this.viewer.setSorter(this.nameSorter);
        this.lineNoSorter = new LineNoSorter();
        this.nameArtifactSorter = new NameArtifactSorter();
        this.filenameSorter = new FilenameSorter();
        this.constructSorter = new ConstructSorter();
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof IMarker) {
                    SimpleTreeTableMarkerView.this.selectedMarker_ = (IMarker)obj;
                }
                SimpleTreeTableMarkerView.this.showStatusMessage("", "selectionChanged");
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void createTreeColumns() {
        int i;
        int numCols = this.markerAttrNames_.length;
        int i2 = 0;
        while (i2 < numCols) {
            new TreeColumn(this.tree, 16384);
            ++i2;
        }
        TreeColumn[] columns = this.tree.getColumns();
        int numColumns = columns.length;
        assert (numCols == numColumns);
        SelectionListener[] columnListeners = new SelectionListener[numColumns];
        int[] widths = null;
        if (this.widths_ != null) {
            widths = this.widths_;
        } else {
            widths = new int[this.columnNames_.length];
            i = 0;
            while (i < widths.length) {
                widths[i] = 100;
                ++i;
            }
        }
        i = 0;
        while (i < numColumns) {
            int colNo = i++;
            columns[colNo].setText(this.columnNames_[colNo]);
            columns[colNo].setWidth(this.widths_[colNo]);
            columns[colNo].setResizable(true);
            columns[colNo].setMoveable(true);
            SelectionAdapter columnListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Object src = event.getSource();
                    if (src instanceof TreeColumn) {
                        TreeColumn tc = (TreeColumn)src;
                        String text = tc.getText();
                        System.out.println("tree column selected: " + text);
                        Object data = tc.getData();
                        if (data instanceof ViewerSorter) {
                            GenericSorter sorter = (GenericSorter)((Object)data);
                            sorter.sort();
                        } else {
                            System.out.println("** not a sorter ** " + data);
                        }
                    }
                }
            };
            columns[colNo].addSelectionListener((SelectionListener)columnListener);
            columnListeners[colNo] = columnListener;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SimpleTreeTableMarkerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.infoAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.filterAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.infoAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.infoAction);
        if (this.extensionAction != null) {
            manager.add((IAction)this.extensionAction);
        }
        manager.add((IAction)this.removeMarkerAction);
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
    }

    private void makeActions() {
        this.makeShowInfoAction();
        this.makeExtensionAction();
        this.makeFilterAction();
        this.makeDoubleClickAction();
        this.makeRemoveMarkerAction();
        this.makeExpandCollapseActions();
    }

    protected void makeShowInfoAction() {
        this.infoAction = new Action(){

            public void run() {
                String title = String.valueOf(SimpleTreeTableMarkerView.this.thingname_) + Messages.SimpleTreeTableMarkerView_information;
                if (SimpleTreeTableMarkerView.this.selectedMarker_ != null) {
                    String info = null;
                    String idFromMarker = SimpleTreeTableMarkerView.this.selectedMarker_.getAttribute(SimpleTreeTableMarkerView.this.uniqueID_, null);
                    if (idFromMarker == null) {
                        info = SimpleTreeTableMarkerView.this.extractMarkerInfo(SimpleTreeTableMarkerView.this.selectedMarker_);
                        if (info == null) {
                            System.out.println("STTMV: Info action: exception reading marker ID; no info in extraceMarkerInfo either.");
                            return;
                        }
                    } else {
                        info = "STTMV: no info, no ArtifactManager";
                    }
                    MessageDialog.openInformation(null, (String)title, (String)info);
                } else {
                    MessageDialog.openInformation(null, (String)title, (String)(String.valueOf(Messages.SimpleTreeTableMarkerView_no) + SimpleTreeTableMarkerView.this.thingname_ + Messages.SimpleTreeTableMarkerView_selected));
                }
            }
        };
        this.infoAction.setText(Messages.SimpleTreeTableMarkerView_showInfo);
        this.infoAction.setToolTipText(String.valueOf(Messages.SimpleTreeTableMarkerView_showInfoForSelected) + this.thingname_);
        this.infoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void makeFilterAction() {
        this.filterAction = new Action(){

            public void run() {
                SimpleTreeTableMarkerView.this.showMessage(String.valueOf(Messages.SimpleTreeTableMarkerView_filter) + SimpleTreeTableMarkerView.this.thingnames_ + Messages.SimpleTreeTableMarkerView_determineWhich + SimpleTreeTableMarkerView.this.thingnames_ + Messages.SimpleTreeTableMarkerView_areShownInThisViewPeriod);
            }
        };
        this.filterAction.setText(String.valueOf(Messages.SimpleTreeTableMarkerView_filter) + this.thingnames_);
        this.filterAction.setToolTipText(String.valueOf(Messages.SimpleTreeTableMarkerView_filterWhich) + this.thingnames_ + Messages.SimpleTreeTableMarkerView_areShownInThisView);
    }

    private void makeDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SimpleTreeTableMarkerView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (!(obj instanceof IMarker)) {
                    return;
                }
                IMarker marker = (IMarker)obj;
                try {
                    IFile f = (IFile)marker.getResource();
                    int lineNo = SimpleTreeTableMarkerView.this.getMarkerLineNo(marker);
                    if (f != null && f.exists()) {
                        IWorkbenchPage wbp = SimpleTreeTableMarkerView.this.getSite().getPage();
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)wbp, (IFile)f);
                        MarkerUtilities.setLineNumber((IMarker)marker, (int)lineNo);
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                        SimpleTreeTableMarkerView.this.showStatusMessage("", "double click action");
                    }
                }
                catch (Exception e) {
                    System.out.println("STTMV.doubleclickAction: Error positioning editor page from marker line number");
                    SimpleTreeTableMarkerView.this.showStatusMessage(Messages.SimpleTreeTableMarkerView_errorPositioningEditorFromMarkerLineNumber, "error marker goto");
                    e.printStackTrace();
                }
                SimpleTreeTableMarkerView.this.maintainExpandCollapseStatus();
            }
        };
    }

    protected void makeRemoveMarkerAction() {
        this.removeMarkerAction = new Action(){

            public void run() {
                final IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            int depth = 2;
                            IMarker[] m = wsResource.findMarkers(SimpleTreeTableMarkerView.this.markerID_, true, depth);
                            int cfr_ignored_0 = m.length;
                            wsResource.deleteMarkers(SimpleTreeTableMarkerView.this.markerID_, false, depth);
                            wsResource.findMarkers(SimpleTreeTableMarkerView.this.markerID_, true, depth);
                        }
                        catch (CoreException coreException) {
                            System.out.println("STTMV: exception deleting markers.");
                        }
                    }
                };
                try {
                    runnable.run(null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        this.removeMarkerAction.setText(Messages.SimpleTreeTableMarkerView_removeMarkers);
        this.removeMarkerAction.setToolTipText(Messages.SimpleTreeTableMarkerView_removeMarkers);
        this.removeMarkerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    private void makeExpandCollapseActions() {
        this.expandAllAction = new Action(){

            public void run() {
                SimpleTreeTableMarkerView.this.viewer.expandAll();
                SimpleTreeTableMarkerView.this.expandCollapseStatus = 1;
            }
        };
        this.expandAllAction.setText(Messages.SimpleTreeTableMarkerView_expandAll);
        this.expandAllAction.setToolTipText(Messages.SimpleTreeTableMarkerView_expandAllNodesInTheTree);
        ImageDescriptor descExpand = this.createImageDescriptor("icons/expandall.gif", "expandall");
        this.expandAllAction.setImageDescriptor(descExpand);
        this.collapseAllAction = new Action(){

            public void run() {
                SimpleTreeTableMarkerView.this.viewer.collapseAll();
                SimpleTreeTableMarkerView.this.expandCollapseStatus = 2;
            }
        };
        this.collapseAllAction.setText(Messages.SimpleTreeTableMarkerView_collapseAll);
        this.collapseAllAction.setToolTipText(Messages.SimpleTreeTableMarkerView_collapseAllNodesInTheTree);
        ImageDescriptor descCollapse = this.createImageDescriptor("icons/collapseall.gif", "collapseall");
        this.collapseAllAction.setImageDescriptor(descCollapse);
    }

    protected void maintainExpandCollapseStatus() {
    }

    protected void makeExtensionAction() {
        FeedbackActionCreator creator = new FeedbackActionCreator();
        this.thePlugin_.toString();
        this.feedbackAction = creator.findFeedbackAction(this.viewID_);
        if (this.feedbackAction != null) {
            this.extensionAction = new Action(){

                public void run() {
                    if (SimpleTreeTableMarkerView.this.selectedMarker_ != null) {
                        SimpleTreeTableMarkerView.this.feedbackAction.run(SimpleTreeTableMarkerView.this.selectedMarker_);
                    } else {
                        MessageDialog.openInformation(null, (String)Messages.SimpleTreeTableMarkerView_selectAnItemInTheView, (String)Messages.SimpleTreeTableMarkerView_NoFeedbackItemSelected);
                    }
                }
            };
            this.extensionAction.setText(this.feedbackAction.getText());
            this.extensionAction.setToolTipText(this.feedbackAction.getToolTip());
            this.extensionAction.setImageDescriptor(this.feedbackAction.getIconImageDescriptor());
        }
    }

    ImageDescriptor createImageDescriptor(String iconLoc, String key) {
        String pluginID = "org.eclipse.ptp.etfw.feedback";
        Bundle bundle = Platform.getBundle((String)pluginID);
        Path path = new Path(iconLoc);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        Activator.getDefault().getImageRegistry().put(String.valueOf(pluginID) + "." + key, desc);
        return desc;
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SimpleTreeTableMarkerView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)this.viewName_, (String)message);
    }

    private void showStatusMessage(String message, String debugMessage) {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
        this.getViewSite().getActionBars().getStatusLineManager().update(true);
    }

    public void setFocus() {
        this.showStatusMessage("", "setFocus");
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
    }

    public void showMarker(IMarker marker) {
        System.out.println("Marker-------  IMarker.LINE_NUMBER=lineNumber");
        try {
            Map attrs = marker.getAttributes();
            for (Map.Entry e : attrs.entrySet()) {
                System.out.println("   " + e.getKey() + " " + e.getValue());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ImageDescriptor makeImageDescriptor(String iconName) {
        URL url = this.thePlugin_.find((IPath)new Path(iconName));
        ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
        return id;
    }

    protected void checkUndoStatus() {
    }

    protected int getMarkerLineNo(IMarker marker) {
        int lineNo = this.getIntAttr(marker, LINE);
        return lineNo;
    }

    protected int getIntAttr(IMarker marker, String attr) {
        String temp = null;
        try {
            temp = marker.getAttribute(attr).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("STTMV: Marker lineNo(" + attr + ") invalid; using 0");
            return 0;
        }
        int lineNo = 0;
        try {
            lineNo = Integer.parseInt(temp);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("STTMV: Marker lineNo(" + temp + " from attr " + attr + ") invalid (NumberFormatException); using 0");
        }
        return lineNo;
    }

    protected String getAttribute(IMarker marker, String attr) {
        String result = null;
        try {
            result = (String)marker.getAttribute(attr);
        }
        catch (Exception e) {
            System.out.println("** Exception getting marker attribute " + e);
            e.printStackTrace();
        }
        return result;
    }

    public String extractMarkerInfo(IMarker marker) {
        return null;
    }

    public String removeSpaces(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", false);
        String t = "";
        while (st.hasMoreElements()) {
            t = String.valueOf(t) + st.nextElement();
        }
        return t;
    }

    class ConstructSorter
    extends GenericSorter {
        ConstructSorter() {
        }

        protected String combine(String name, String file, String line, String construct) {
            StringBuffer result = new StringBuffer(construct);
            result.append(" - ");
            result.append(name);
            result.append(" - ");
            result.append(file);
            result.append(" - ");
            result.append(line);
            return result.toString();
        }
    }

    class FilenameSorter
    extends GenericSorter {
        FilenameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            int res = 0;
            try {
                IMarker m1 = (IMarker)e1;
                IMarker m2 = (IMarker)e2;
                String file1 = (String)m1.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                String file2 = (String)m2.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                res = this.ascending ? this.collator.compare(file1, file2) : this.collator.compare(file2, file1);
                if (res == 0) {
                    String line1 = m1.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    String line2 = m2.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    int l1 = Integer.parseInt(line1);
                    int l2 = Integer.parseInt(line2);
                    res = this.ascending ? l1 - l2 : l2 - l1;
                }
                if (res == 0) {
                    res = this.ascending ? this.collator.compare(SimpleTreeTableMarkerView.this.getConstructStr(m1), SimpleTreeTableMarkerView.this.getConstructStr(m2)) : this.collator.compare(SimpleTreeTableMarkerView.this.getConstructStr(m2), SimpleTreeTableMarkerView.this.getConstructStr(m1));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return res;
        }
    }

    abstract class GenericSorter
    extends ViewerSorter {
        protected boolean ascending = true;

        GenericSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int result = 0;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            Collator collator = this.getCollator();
            if (e1 instanceof IMarker) {
                try {
                    IMarker m1 = (IMarker)e1;
                    IMarker m2 = (IMarker)e2;
                    String name1 = (String)m1.getAttribute(SimpleTreeTableMarkerView.NAME);
                    String file1 = (String)m1.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                    String line1 = m1.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    String construct1 = SimpleTreeTableMarkerView.this.getConstructStr(m1);
                    String sort1 = this.combine(name1, file1, line1, construct1);
                    String name2 = (String)m2.getAttribute(SimpleTreeTableMarkerView.NAME);
                    String file2 = (String)m2.getAttribute(SimpleTreeTableMarkerView.FILENAME);
                    String line2 = m2.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
                    String construct2 = SimpleTreeTableMarkerView.this.getConstructStr(m2);
                    String sort2 = this.combine(name2, file2, line2, construct2);
                    result = this.ascending ? collator.compare(sort1, sort2) : collator.compare(sort2, sort1);
                    return result;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }

        protected String combine(String name, String file, String line, String construct) {
            return null;
        }

        public void sort() {
            if (this == SimpleTreeTableMarkerView.this.viewer.getSorter()) {
                this.ascending = !this.ascending;
                SimpleTreeTableMarkerView.this.viewer.setSorter(null);
            } else {
                this.ascending = true;
            }
            SimpleTreeTableMarkerView.this.viewer.setSorter((ViewerSorter)this);
        }
    }

    class LineNoSorter
    extends GenericSorter {
        LineNoSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof IMarker) {
                try {
                    IMarker m1 = (IMarker)e1;
                    Object tempObj = m1.getAttribute(SimpleTreeTableMarkerView.LINE);
                    int line1 = 0;
                    int line2 = 0;
                    if (tempObj instanceof Integer) {
                        line1 = (Integer)tempObj;
                        IMarker m2 = (IMarker)e2;
                        tempObj = m2.getAttribute(SimpleTreeTableMarkerView.LINE);
                        assert (tempObj instanceof Integer);
                        line2 = (Integer)tempObj;
                    }
                    int result = 0;
                    result = this.ascending ? line1 - line2 : line2 - line1;
                    return result;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
    }

    class NameArtifactSorter
    extends GenericSorter {
        NameArtifactSorter() {
        }

        protected String combine(String name, String file, String line, String construct) {
            StringBuffer result = new StringBuffer(name);
            result.append(" - ");
            result.append(file);
            result.append(" - ");
            result.append(line);
            result.append(" - ");
            result.append(construct);
            return result.toString();
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    public class ParentNode {
        private final String parentAttrName;

        public ParentNode(String parentName) {
            this.parentAttrName = parentName;
        }

        public String getParentAttrName() {
            return this.parentAttrName;
        }

        public String toString() {
            return "ParentNode  parentName=" + this.parentAttrName;
        }
    }

    public class StackList {
        private final LinkedList list = new LinkedList();

        public void push(Object v) {
            this.list.addFirst(v);
        }

        public Object top() {
            return this.list.getFirst();
        }

        public Object pop() {
            return this.list.removeFirst();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    public class UpdateVisitor
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            String name = resource.getName();
            if (resource.getType() == 1) {
                if (delta.getKind() == 4) {
                    IFile f = (IFile)resource;
                    int flags = delta.getFlags();
                    int contentChanged = flags & 0x100;
                    if (SimpleTreeTableMarkerView.this.validForAnalysis(f.getName())) {
                        IMarkerDelta[] mDeltas = delta.getMarkerDeltas();
                        int len = mDeltas.length;
                        int j = 0;
                        while (j < len) {
                            IMarkerDelta delta3 = mDeltas[j];
                            IMarker m = delta3.getMarker();
                            String ln = SimpleTreeTableMarkerView.LINE;
                            String[] props = new String[]{ln};
                            SimpleTreeTableMarkerView.this.viewer.update((Object)m, props);
                            ++j;
                        }
                    }
                } else if (delta.getKind() == 1) {
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 262144) {
                    this.checkMarkerDeltas(delta);
                } else if (delta.getKind() == 2) {
                    this.checkMarkerDeltas(delta);
                }
            }
            return true;
        }

        private void checkMarkerDeltas(IResourceDelta delta) {
            IMarkerDelta[] md1 = delta.getMarkerDeltas();
            int cfr_ignored_0 = md1.length;
        }

        private void showMarkerDeltaKind(IMarkerDelta delta3) {
            IMarker m = delta3.getMarker();
            String kind = "UNKNOWN";
            switch (delta3.getKind()) {
                case 1: {
                    kind = "ADDED";
                    break;
                }
                case 4: {
                    kind = "CHANGED";
                    break;
                }
                case 2: {
                    kind = "REMOVED";
                    break;
                }
                default: {
                    kind = "UNKNOWN";
                }
            }
            String mid = "";
            String ml = "";
            String mlpi = "";
            try {
                mid = m.getAttribute(SimpleTreeTableMarkerView.this.uniqueID_).toString();
                ml = m.getAttribute(SimpleTreeTableMarkerView.LINE).toString();
            }
            catch (Exception e1) {
                System.out.println("STTMV.UpdateVisitor error getting marker info ");
                e1.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider,
    IResourceChangeListener {
        private IResource input;
        private List<ParentNode> parentList = new ArrayList<ParentNode>();
        private boolean hasRegistered = false;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (!this.hasRegistered) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
                this.hasRegistered = true;
            }
            if (newInput instanceof IResource) {
                this.input = (IResource)newInput;
            }
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public Object[] getElements(Object parent) {
            Object[] markers = null;
            ArrayList<Object> rootNodeList = new ArrayList<Object>();
            try {
                String id = SimpleTreeTableMarkerView.this.markerID_;
                if (this.input == null) {
                    // empty if block
                }
                markers = this.input.findMarkers(id, false, 2);
                if (SimpleTreeTableMarkerView.this.createParentsIfNeeded) {
                    this.parentList = this.createParents(markers);
                }
                int i = 0;
                while (i < markers.length) {
                    Object marker = markers[i];
                    String cfr_ignored_0 = (String)marker.getAttribute("itemID");
                    String parentID = (String)marker.getAttribute("parent");
                    if (parentID == null || parentID.length() == 0) {
                        rootNodeList.add(marker);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                System.out.println("STTMV, exception getting model elements (markers for Table view)");
                e.printStackTrace();
            }
            if (SimpleTreeTableMarkerView.this.createParentsIfNeeded) {
                this.parentList.size();
                return this.parentList.toArray();
            }
            return rootNodeList.toArray();
        }

        private List<ParentNode> createParents(Object[] objs) {
            ArrayList<ParentNode> list = new ArrayList<ParentNode>();
            IMarker[] markers = (IMarker[])objs;
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String parentName = this.getParentAttr(marker);
                if (parentName == null) {
                    list.add((ParentNode)marker);
                } else {
                    this.getParentNode(parentName);
                }
                ++i;
            }
            if (SimpleTreeTableMarkerView.this.createParentsIfNeeded) {
                this.parentList.size();
                return this.parentList;
            }
            return list;
        }

        private String getParentAttr(IMarker marker) {
            return this.getStrAttr(marker, SimpleTreeTableMarkerView.this.parentMarkerAttrib);
        }

        private String getStrAttr(IMarker marker, String attrName) {
            String attrValue = null;
            try {
                attrValue = (String)marker.getAttribute(attrName);
            }
            catch (CoreException e) {
                System.out.println("Exception getting  attr from marker " + marker + ": " + e.getMessage());
            }
            return attrValue;
        }

        private ParentNode getParentNode(String parentName, boolean createIfNeeded) {
            ParentNode parentNode2;
            for (ParentNode parentNode2 : this.parentList) {
                if (!parentNode2.parentAttrName.equals(parentName)) continue;
                return parentNode2;
            }
            parentNode2 = null;
            if (createIfNeeded) {
                parentNode2 = new ParentNode(parentName);
                this.parentList.add(parentNode2);
            }
            return parentNode2;
        }

        protected ParentNode getParentNode(String parentName) {
            return this.getParentNode(parentName, SimpleTreeTableMarkerView.this.createParentsIfNeeded);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final IResourceDelta delta = event.getDelta();
            Control ctrl = SimpleTreeTableMarkerView.this.viewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            ViewContentProvider.this.processResourceChangeDelta(delta);
                            ((ViewContentProvider)ViewContentProvider.this).SimpleTreeTableMarkerView.this.viewer.refresh();
                        }
                        catch (Exception e) {
                            System.out.println("STTMV: Exception refreshing viewer: " + e);
                            e.printStackTrace();
                        }
                    }
                });
            }
        }

        private void printResourcesChanged(IResourceDelta delta, int indent) {
            this.printOneResourceChanged(delta, indent);
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.printResourcesChanged(children[i], indent + 1);
                ++i;
            }
        }

        private void printOneResourceChanged(IResourceDelta delta, int indent) {
            StringBuffer buf = new StringBuffer(80);
            int i = 0;
            while (i < indent) {
                buf.append("  ");
                ++i;
            }
            switch (delta.getKind()) {
                case 1: {
                    buf.append("ADDED");
                    break;
                }
                case 2: {
                    buf.append("REMOVED");
                    break;
                }
                case 4: {
                    buf.append("CHANGED");
                    this.testDelta(delta);
                    break;
                }
                default: {
                    buf.append("[");
                    buf.append(delta.getKind());
                    buf.append("]");
                }
            }
            buf.append(" ");
            buf.append(delta.getResource());
            System.out.println(buf);
        }

        private void testDelta(IResourceDelta delta) {
            System.out.print("Resource ");
            System.out.print(delta.getFullPath());
            System.out.println(" has changed.");
            int flags = delta.getFlags();
            if ((flags & 0x100) != 0) {
                System.out.println("--> Content Change");
            }
            if ((flags & 0x40000) != 0) {
                System.out.println("--> Content Replaced");
            }
            if ((flags & 0x20000) != 0) {
                System.out.println("--> Marker Change");
            }
        }

        protected void processResourceChangeDelta(IResourceDelta delta) {
            try {
                delta.accept((IResourceDeltaVisitor)SimpleTreeTableMarkerView.this.visitor_);
            }
            catch (CoreException e2) {
                System.out.println("Error in PITV.processResourceChangeDelta()..");
                e2.printStackTrace();
            }
        }

        public Object[] getChildren(Object parentElement) {
            String parentName = null;
            if (parentElement instanceof IMarker) {
                IMarker parentMarker = (IMarker)parentElement;
                try {
                    parentName = (String)parentMarker.getAttribute("itemID");
                }
                catch (CoreException e1) {
                    System.out.println("unable to get id attr of marker in order to find children with that parent id.");
                    e1.printStackTrace();
                    return null;
                }
            } else if (parentElement instanceof ParentNode) {
                ParentNode parentNode = (ParentNode)parentElement;
                parentName = parentNode.getParentAttrName();
            }
            IMarker[] markers = null;
            try {
                markers = this.input.findMarkers(SimpleTreeTableMarkerView.this.markerID_, false, 2);
            }
            catch (CoreException e) {
                System.out.println("Exception getting children of " + parentElement + " " + e.getMessage());
                e.printStackTrace();
            }
            ArrayList<IMarker> children = new ArrayList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String parentAttr = this.getParentAttr(marker);
                this.getStrAttr(marker, "itemID");
                if (parentAttr != null && parentAttr.equals(parentName)) {
                    children.add(marker);
                }
                ++i;
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof IMarker) {
                IMarker marker = (IMarker)element;
                String parentName = this.getParentAttr(marker);
                ParentNode parent = this.getParentNode(parentName, false);
                return parent;
            }
            return null;
        }

        private ParentNode getParent(IMarker marker, boolean b) {
            return (ParentNode)this.getParent(marker);
        }

        public boolean hasChildren(Object element) {
            Object[] kids = this.getChildren(element);
            if (kids != null) {
                return kids.length > 0;
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final HashMap iconHash = new HashMap();

        ViewLabelProvider() {
        }

        public String getText(Object o) {
            String temp = super.getText(o);
            return temp;
        }

        public String getColumnText(Object obj, int index) {
            if (obj == null) {
                System.out.println("STTMV: LabelProv obj is null; index=" + index);
                return "STTMV obj null";
            }
            if (!(obj instanceof IMarker)) {
                if (obj instanceof ParentNode) {
                    ParentNode parentNode = (ParentNode)obj;
                    if (index == 0) {
                        String name = parentNode.getParentAttrName();
                        return name;
                    }
                    return "";
                }
                return "!marker";
            }
            IMarker marker = (IMarker)obj;
            if (!marker.exists()) {
                return "";
            }
            IFeedbackItem item = this.getFeedbackItem(marker);
            try {
                String attrname = SimpleTreeTableMarkerView.this.markerAttrNames_[index];
                String itemVal = item.getAttr(attrname);
                if (itemVal != null) {
                    if (attrname.equals(SimpleTreeTableMarkerView.FILENAME)) {
                        itemVal = this.lastSegmentOnly(itemVal);
                    }
                    return itemVal;
                }
                String value = itemVal;
                if (itemVal == null || itemVal.length() == 0) {
                    itemVal = "[" + attrname + "]";
                }
                return value;
            }
            catch (Exception exception) {
                return "STTMV error";
            }
        }

        String lastSegmentOnly(String filename) {
            if (filename.contains("/")) {
                Path path = new Path(filename);
                filename = path.segment(path.segmentCount() - 1);
            }
            return filename;
        }

        private IFeedbackItem getFeedbackItem(IMarker marker) {
            IFeedbackItem item = null;
            Object obji = null;
            try {
                obji = marker.getAttribute("item");
                if (obji instanceof IFeedbackItem) {
                    item = (IFeedbackItem)obji;
                }
            }
            catch (CoreException e) {
                marker.exists();
                e.printStackTrace();
            }
            return item;
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                case 0: {
                    return this.getCustomImage(obj);
                }
            }
            return null;
        }

        protected Image getCustomImage(Object obj) {
            Image img = (Image)this.iconHash.get(SimpleTreeTableMarkerView.this.iconName_);
            if (img == null) {
                Path path = new Path(SimpleTreeTableMarkerView.this.iconName_);
                URL url = SimpleTreeTableMarkerView.this.thePlugin_.find((IPath)path);
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
                img = id.createImage();
                this.iconHash.put(SimpleTreeTableMarkerView.this.iconName_, img);
            }
            return img;
        }

        public void dispose() {
            for (Image img : this.iconHash.values()) {
                img.dispose();
            }
            super.dispose();
        }
    }
}

