/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProviderFactory;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.navigation.FoldingRegionsResult;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteCCodeFoldingService;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class RemoteCCodeFoldingService
extends AbstractRemoteService
implements IRemoteCCodeFoldingService {
    public RemoteCCodeFoldingService(IConnectorService connectorService) {
        super(connectorService);
    }

    public RemoteCCodeFoldingService(ICIndexSubsystem subsystem) {
        super(subsystem);
    }

    @Override
    public FoldingRegionsResult computeCodeFoldingRegions(IWorkingCopy workingCopy, int docLength, boolean fPreprocessorBranchFoldingEnabled, boolean fStatementsFoldingEnabled) {
        ITranslationUnit targetUnit;
        ICIndexSubsystem subsystem = this.getSubSystem();
        if (subsystem == null) {
            return null;
        }
        ITranslationUnit unit = workingCopy.getTranslationUnit();
        try {
            targetUnit = (ITranslationUnit)ModelAdapter.adaptElement(null, (ICElement)unit, (int)0, (boolean)true);
        }
        catch (CModelException e1) {
            RDTLog.logError((Throwable)e1);
            return null;
        }
        catch (Exception e) {
            RDTLog.logError((Throwable)e);
            return null;
        }
        IProject project = unit.getCProject().getProject();
        NullProgressMonitor monitor = new NullProgressMonitor();
        subsystem.checkProject(project, (IProgressMonitor)monitor);
        if (targetUnit instanceof TranslationUnit) {
            RemoteScannerInfo scannerInfo = RemoteIndexerInfoProviderFactory.getScannerInfo((IResource)unit.getResource());
            Map langaugeProperties = null;
            try {
                String languageId = unit.getLanguage().getId();
                langaugeProperties = RemoteIndexerInfoProviderFactory.getLanguageProperties((String)languageId, (IProject)project);
            }
            catch (Exception e) {
                RDTLog.logError((Throwable)e);
            }
            ((TranslationUnit)targetUnit).setASTContext((IScannerInfo)scannerInfo, langaugeProperties);
        }
        return subsystem.computeFoldingRegions(targetUnit, docLength, fPreprocessorBranchFoldingEnabled, fStatementsFoldingEnabled);
    }
}

