/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SimpleDatatypeDefinition;

public class EnumDefinition
extends SimpleDatatypeDefinition {
    private final EnumDeclaration declaration;
    private final IntegerDefinition integerValue;
    private String value;

    public EnumDefinition(EnumDeclaration declaration, IDefinitionScope definitionScope, String fieldName) {
        super(definitionScope, fieldName);
        this.declaration = declaration;
        this.integerValue = declaration.getContainerType().createDefinition(definitionScope, fieldName);
        this.value = declaration.query(this.integerValue.getValue());
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public Long getIntegerValue() {
        return this.integerValue.getValue();
    }

    public void setIntegerValue(long value) {
        this.integerValue.setValue(value);
        this.value = this.declaration.query(value);
    }

    @Override
    public EnumDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public void read(BitBuffer input) {
        EnumDefinition.alignRead(input, this.declaration);
        this.integerValue.read(input);
        long val = this.integerValue.getValue();
        this.value = this.declaration.query(val);
    }

    @Override
    public String toString() {
        return "{ value = " + this.getValue() + ", container = " + this.integerValue.toString() + " }";
    }
}

