/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTBindingAttrNode;
import org.eclipse.photran.internal.core.parser.ASTProcComponentDefStmtNode;
import org.eclipse.photran.internal.core.parser.ASTProcDeclNode;
import org.eclipse.photran.internal.core.parser.ASTSpecificBindingNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.vpg.AnnotationType;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;

class DerivedTypeCollector
extends BindingCollector {
    DerivedTypeCollector() {
    }

    @Override
    public void visitASTProcComponentDefStmtNode(ASTProcComponentDefStmtNode node) {
        int argStart;
        super.traverseChildren(node);
        IASTListNode<ASTProcDeclNode> decls = node.getProcDeclList();
        PhotranTokenRef procRef = ((ASTProcDeclNode)decls.get(0)).getProcedureEntityName().getTokenRef();
        Token bindingInterface = node.getProcInterface().getInterfaceName();
        String compText = null;
        ArrayList<Definition> intDefs = this.vpg.findAllDeclarationsInInterfacesForExternalSubprogram(bindingInterface.getText());
        if (intDefs != null) {
            Definition subDef = intDefs.get(0);
            compText = subDef.getCompletionText();
        }
        compText = compText != null ? ((argStart = compText.indexOf(40)) >= 0 ? compText.substring(argStart) : "()") : "()";
        Definition def = this.vpg.getDefinitionFor(procRef);
        compText = String.valueOf(def.getDeclaredName()) + compText;
        def.setCompletionText(compText.toString());
        this.vpgProvider.setDefinitionFor(procRef, def);
    }

    @Override
    public void visitASTSpecificBindingNode(ASTSpecificBindingNode node) {
        super.traverseChildren(node);
        boolean skipFirst = true;
        PhotranTokenRef procRef = node.getBindingName().getTokenRef();
        IASTListNode<ASTBindingAttrNode> bindAttrs = node.getBindingAttrList();
        if (bindAttrs != null) {
            for (ASTBindingAttrNode bindAttr : bindAttrs) {
                if (!bindAttr.isNoPass()) continue;
                skipFirst = false;
            }
        }
        Token bindingInterface = node.getInterfaceName();
        PhotranTokenRef tokenRef = null;
        if (bindingInterface != null) {
            ScopingNode enclosingScope = bindingInterface.getEnclosingScope().getGlobalScope();
            List<PhotranTokenRef> possParents = enclosingScope.manuallyResolve(bindingInterface);
            tokenRef = possParents.get(0);
        } else {
            Token proToken = node.getProcedureName();
            if (proToken == null) {
                return;
            }
            ScopingNode enclosingScope = proToken.getEnclosingScope();
            List<PhotranTokenRef> possParents = enclosingScope.manuallyResolve(proToken);
            tokenRef = possParents.get(0);
        }
        Definition subDef = (Definition)tokenRef.getAnnotation(AnnotationType.DEFINITION_ANNOTATION_TYPE);
        String compText = subDef.getCompletionText();
        if (compText != null) {
            int argStart = compText.indexOf(40);
            compText = argStart >= 0 ? compText.substring(argStart) : "()";
            if (skipFirst) {
                argStart = compText.indexOf(44);
                compText = argStart >= 0 ? compText.substring(argStart + 1) : ")";
                compText = "(" + compText;
            }
        } else {
            compText = "()";
        }
        Definition def = this.vpg.getDefinitionFor(procRef);
        compText = String.valueOf(def.getDeclaredName()) + compText;
        def.setCompletionText(compText.toString());
        this.vpgProvider.setDefinitionFor(procRef, def);
    }
}

