/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.IASTNode;

public class SourcePrinter {
    private static final String EOL = System.getProperty("line.separator");

    private SourcePrinter() {
    }

    public static String getSourceCodeFromAST(IFortranAST ast) {
        return SourcePrinter.getSourceCodeFromAST(ast.getRoot());
    }

    public static String getSourceCodeFromAST(ASTExecutableProgramNode ast) {
        String result = SourcePrinter.getSourceCodeFromASTNode(ast);
        result = result.substring(0, Math.max(0, result.length() - EOL.length()));
        return result;
    }

    public static String getSourceCodeFromASTNode(IASTNode node) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        node.printOn(new PrintStream(out), null);
        return out.toString();
    }
}

