/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event;

import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;

public class EventDefinition
implements IDefinitionScope {
    private final IEventDeclaration declaration;
    private long timestamp;
    private StructDefinition context;
    private StructDefinition fields;
    private final StreamInputReader streamInputReader;

    public EventDefinition(IEventDeclaration declaration, StreamInputReader streamInputReader) {
        this.declaration = declaration;
        this.streamInputReader = streamInputReader;
    }

    @Override
    public String getPath() {
        return "event";
    }

    public IEventDeclaration getDeclaration() {
        return this.declaration;
    }

    public StructDefinition getFields() {
        return this.fields;
    }

    public StructDefinition getEventContext() {
        return this.context;
    }

    public StructDefinition getContext() {
        StructDefinition streamContext = this.streamInputReader.getPacketReader().getStreamEventContextDef();
        if (streamContext == null) {
            return this.context;
        }
        if (this.context == null) {
            return streamContext;
        }
        StructDeclaration mergedDeclaration = new StructDeclaration(1L);
        Map<String, Definition> defs = streamContext.getDefinitions();
        for (Map.Entry<String, Definition> entry : defs.entrySet()) {
            mergedDeclaration.addField(entry.getKey(), entry.getValue().getDeclaration());
        }
        for (Map.Entry<String, Definition> entry : this.context.getDefinitions().entrySet()) {
            mergedDeclaration.addField(entry.getKey(), entry.getValue().getDeclaration());
        }
        StructDefinition mergedContext = mergedDeclaration.createDefinition(null, "context");
        for (String key : mergedContext.getDefinitions().keySet()) {
            Definition lookupDefinition = this.context.lookupDefinition(key);
            if (lookupDefinition != null) {
                mergedContext.getDefinitions().put(key, lookupDefinition);
                continue;
            }
            mergedContext.getDefinitions().put(key, streamContext.lookupDefinition(key));
        }
        return mergedContext;
    }

    public StreamInputReader getStreamInputReader() {
        return this.streamInputReader;
    }

    public StructDefinition getPacketContext() {
        return this.streamInputReader.getCurrentPacketContext();
    }

    public int getCPU() {
        return this.streamInputReader.getCPU();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setContext(StructDefinition context) {
        this.context = context;
    }

    public void setFields(StructDefinition fields) {
        this.fields = fields;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals("context")) {
            return this.context;
        }
        if (lookupPath.equals("fields")) {
            return this.fields;
        }
        return null;
    }

    public String toString() {
        List<String> list;
        Map<String, Definition> definitions;
        StringBuilder retString = new StringBuilder();
        String cr = System.getProperty("line.separator");
        retString.append("Event type: " + this.declaration.getName() + cr);
        retString.append("Timestamp: " + Long.toString(this.timestamp) + cr);
        if (this.context != null) {
            definitions = this.context.getDefinitions();
            list = this.context.getDeclaration().getFieldsList();
            for (String field : list) {
                retString.append(String.valueOf(field) + " : " + definitions.get(field).toString() + cr);
            }
        }
        if (this.fields != null) {
            definitions = this.fields.getDefinitions();
            list = this.fields.getDeclaration().getFieldsList();
            for (String field : list) {
                retString.append(String.valueOf(field) + " : " + definitions.get(field).toString() + cr);
            }
        }
        return retString.toString();
    }
}

