/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.formatter.align.AlignmentException;
import org.eclipse.cdt.internal.formatter.scanner.Scanner;
import org.eclipse.cdt.internal.formatter.scanner.Token;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.jface.text.Position;
import org.eclipse.ptp.internal.rdt.core.formatter.RemoteDefaultCodeFormatterOptions;
import org.eclipse.ptp.internal.rdt.core.miners.formatter.Alignment;
import org.eclipse.ptp.internal.rdt.core.miners.formatter.Scribe;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.text.edits.TextEdit;

public class RemoteCodeFormatterVisitor
extends ASTVisitor
implements ICPPASTVisitor,
ICASTVisitor {
    private final Scanner localScanner;
    final RemoteDefaultCodeFormatterOptions preferences;
    private final Scribe scribe;
    private boolean fInsideFor;
    private boolean fExpectSemicolonAfterDeclaration;
    private int fOpenAngleBrackets;
    private IASTTranslationUnit ast;
    private String LOG_TAG;
    private DataStore fDStore;

    public RemoteCodeFormatterVisitor(RemoteDefaultCodeFormatterOptions preferences, int offset, int length, String logTag, DataStore dataStore) {
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitTypeIds = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitTemplateParameters = true;
        this.fExpectSemicolonAfterDeclaration = true;
        this.localScanner = new Scanner(){

            public Token nextToken() {
                Token t = super.nextToken();
                while (t != null && (t.isWhiteSpace() || t.isPreprocessor())) {
                    t = super.nextToken();
                }
                return t;
            }
        };
        this.preferences = preferences;
        this.scribe = new Scribe(this, offset, length);
        this.LOG_TAG = logTag;
        this.fDStore = dataStore;
    }

    public TextEdit format(String string, IASTTranslationUnit unit) {
        this.scribe.reset();
        char[] compilationUnitSource = string.toCharArray();
        this.localScanner.setSource(compilationUnitSource);
        this.scribe.initializeScanner(compilationUnitSource);
        this.scribe.setSkipPositions(RemoteCodeFormatterVisitor.collectInactiveCodePositions(unit));
        try {
            unit.accept((ASTVisitor)this);
        }
        catch (RuntimeException e) {
            this.reportFormattingProblem(e);
        }
        return this.scribe.getRootEdit();
    }

    private void reportFormattingProblem(RuntimeException e) {
        UniversalServerUtilities.logDebugMessage((String)this.LOG_TAG, (String)"No index files found", (DataStore)this.fDStore);
    }

    public int visit(IASTTranslationUnit tu) {
        this.ast = tu;
        this.scribe.lastNumberOfNewLines = 1;
        this.scribe.startNewLine();
        int indentLevel = this.scribe.indentationLevel;
        IASTDeclaration[] decls = tu.getDeclarations();
        this.formatDeclarations(decls, indentLevel);
        this.scribe.printEndOfTranslationUnit();
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private void formatDeclarations(IASTDeclaration[] decls, int indentLevel) {
        macroExpansions = this.ast.getMacroExpansions();
        m = 0;
        i = 0;
        while (i < decls.length) {
            block11: {
                declaration = decls[i];
                if (declaration.isPartOfTranslationUnitFile()) {
                    try {
                        pos = this.getCurrentPosition();
                        declarationLocation = declaration.getFileLocation();
                        declarationOffset = declarationLocation.getNodeOffset();
                        while (m < macroExpansions.length) {
                            macroExpansion = macroExpansions[m];
                            macroLocation = macroExpansion.getFileLocation();
                            macroOffset = macroLocation.getNodeOffset();
                            if (macroOffset > declarationOffset) break;
                            macroEndOffset = macroOffset + macroLocation.getNodeLength();
                            if (this.isFunctionStyleMacroExpansion(macroExpansion) && macroOffset >= pos) {
                                j = i + 1;
                                while (j < decls.length) {
                                    next = decls[j];
                                    if (next.isPartOfTranslationUnitFile()) {
                                        nextLocation = next.getFileLocation();
                                        nextOffset = nextLocation.getNodeOffset();
                                        if (macroEndOffset <= nextOffset) break;
                                        i = j;
                                        declaration = next;
                                        declarationLocation = nextLocation;
                                        declarationOffset = declarationLocation.getNodeOffset();
                                    }
                                    ++j;
                                }
                                declarationEndOffset = declarationOffset + declarationLocation.getNodeLength();
                                if (macroEndOffset <= declarationOffset || macroEndOffset >= declarationEndOffset || macroEndOffset == declarationEndOffset - 1 && this.isSemicolonAtPosition(macroEndOffset)) {
                                    this.formatFunctionStyleMacroExpansion(macroExpansion);
                                }
                            }
                            ++m;
                        }
                        declaration.accept((ASTVisitor)this);
                        this.scribe.startNewLine();
                        break block11;
                    }
                    catch (RuntimeException e) {
                        this.reportFormattingProblem(e);
                        if (i >= decls.length - 1) break block11;
                        this.exitAlignments();
                        this.skipToNode((IASTNode)decls[i + 1]);
                        ** while (this.scribe.indentationLevel < indentLevel)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.scribe.indent();
                        continue;
                    }
lbl48:
                    // 2 sources

                    while (this.scribe.indentationLevel > indentLevel) {
                        this.scribe.unIndent();
                    }
                }
            }
            ++i;
        }
    }

    private boolean isFunctionStyleMacroExpansion(IASTPreprocessorMacroExpansion macroExpansion) {
        IASTName name = macroExpansion.getMacroReference();
        IMacroBinding binding = (IMacroBinding)name.resolveBinding();
        return binding.isFunctionStyle() && binding.getParameterList().length > 0;
    }

    private void formatFunctionStyleMacroExpansion(IASTPreprocessorMacroExpansion macroExpansion) {
        IASTName name = macroExpansion.getMacroReference();
        IASTFileLocation fileLocation = name.getFileLocation();
        if (fileLocation != null) {
            this.scribe.printRaw(fileLocation.getNodeOffset(), fileLocation.getNodeLength());
        }
        fileLocation = macroExpansion.getFileLocation();
        this.scribe.printNextToken(8);
        IMacroBinding binding = (IMacroBinding)name.resolveBinding();
        if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
            this.scribe.space();
        }
        int continuationIndentation = this.preferences.continuation_indentation;
        Alignment listAlignment = this.scribe.createAlignment("macroArguments", this.preferences.alignment_for_arguments_in_method_invocation, 1, binding.getParameterList().length, this.getCurrentPosition(), continuationIndentation, false);
        this.scribe.enterAlignment(listAlignment);
        boolean ok = false;
        do {
            try {
                int fragment = 0;
                this.scribe.alignFragment(listAlignment, fragment);
                int parenLevel = 0;
                boolean done = false;
                block10: while (!done) {
                    boolean hasWhitespace = this.scribe.printComment();
                    int token = this.peekNextToken();
                    switch (token) {
                        case 8: {
                            ++parenLevel;
                            this.scribe.printNextToken(token, hasWhitespace);
                            break;
                        }
                        case 9: {
                            if (parenLevel > 0) {
                                --parenLevel;
                                this.scribe.printNextToken(token, hasWhitespace);
                                break;
                            }
                            if (this.preferences.insert_space_before_closing_paren_in_method_invocation) {
                                this.scribe.space();
                            }
                            this.scribe.printNextToken(token);
                            done = true;
                            break;
                        }
                        case 6: {
                            if (parenLevel == 0 && this.preferences.insert_space_before_comma_in_method_invocation_arguments) {
                                this.scribe.space();
                            }
                            this.scribe.printNextToken(token);
                            if (parenLevel != 0) continue block10;
                            if (this.preferences.insert_space_after_comma_in_method_invocation_arguments) {
                                this.scribe.space();
                            }
                            this.scribe.printComment();
                            if (++fragment >= listAlignment.fragmentCount) continue block10;
                            this.scribe.alignFragment(listAlignment, fragment);
                            break;
                        }
                        case 129: 
                        case 131: 
                        case 133: {
                            boolean needSpace = hasWhitespace;
                            while (true) {
                                this.scribe.printNextToken(token, needSpace);
                                if (this.peekNextToken() != token) continue block10;
                                this.scribe.printCommentPreservingNewLines();
                                needSpace = true;
                            }
                        }
                        case 1006: {
                            this.scribe.exitAlignment(listAlignment, true);
                            return;
                        }
                        default: {
                            this.scribe.printNextToken(token, hasWhitespace);
                        }
                    }
                }
                int token = this.peekNextToken();
                if (token == 5) {
                    this.scribe.printNextToken(token);
                    this.scribe.startNewLine();
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(listAlignment, true);
    }

    public int visit(IASTDeclaration node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            int n = this.formatDeclaration(node);
            return n;
        }
        finally {
            this.exitNode((IASTNode)node);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int formatDeclaration(IASTDeclaration node) {
        block17: {
            indentLevel = this.scribe.indentationLevel;
            try {
                if (node instanceof IASTFunctionDefinition) {
                    return this.visit((IASTFunctionDefinition)node);
                }
                if (node instanceof IASTSimpleDeclaration) {
                    return this.visit((IASTSimpleDeclaration)node);
                }
                if (node instanceof IASTASMDeclaration) {
                    return this.visit((IASTASMDeclaration)node);
                }
                if (node instanceof ICPPASTVisibilityLabel) {
                    return this.visit((ICPPASTVisibilityLabel)node);
                }
                if (node instanceof ICPPASTNamespaceDefinition) {
                    return this.visit((ICPPASTNamespaceDefinition)node);
                }
                if (node instanceof ICPPASTNamespaceAlias) {
                    return this.visit((ICPPASTNamespaceAlias)node);
                }
                if (node instanceof ICPPASTUsingDeclaration) {
                    return this.visit((ICPPASTUsingDeclaration)node);
                }
                if (node instanceof ICPPASTUsingDirective) {
                    return this.visit((ICPPASTUsingDirective)node);
                }
                if (node instanceof ICPPASTLinkageSpecification) {
                    return this.visit((ICPPASTLinkageSpecification)node);
                }
                if (node instanceof ICPPASTTemplateDeclaration) {
                    return this.visit((ICPPASTTemplateDeclaration)node);
                }
                if (node instanceof ICPPASTTemplateSpecialization) {
                    return this.visit((ICPPASTTemplateSpecialization)node);
                }
                if (node instanceof ICPPASTExplicitTemplateInstantiation) {
                    return this.visit((ICPPASTExplicitTemplateInstantiation)node);
                }
                if (node instanceof IASTProblemDeclaration) {
                    return this.visit((IASTProblemDeclaration)node);
                }
                this.formatRaw((IASTNode)node);
                break block17;
            }
            catch (ASTProblemException e) {
                if (node instanceof IASTProblemDeclaration) {
                    throw e;
                }
                this.skipNode((IASTNode)node);
                ** while (this.scribe.indentationLevel > indentLevel)
            }
lbl-1000:
            // 1 sources

            {
                this.scribe.unIndent();
                continue;
            }
        }
        return 1;
    }

    public int visit(IASTName node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            if (node instanceof ICPPASTQualifiedName) {
                this.visit((ICPPASTQualifiedName)node);
            } else if (node instanceof ICPPASTTemplateId) {
                this.visit((ICPPASTTemplateId)node);
            } else {
                this.formatRaw((IASTNode)node);
            }
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    public int visit(IASTInitializer node) {
        if (node instanceof ICPPASTConstructorInitializer) {
            return this.visit((ICPPASTConstructorInitializer)node);
        }
        if (this.peekNextToken() == 38) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
        }
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            if (node instanceof IASTEqualsInitializer) {
                this.visit((IASTEqualsInitializer)node);
            } else if (node instanceof IASTInitializerList) {
                this.visit((IASTInitializerList)node);
            } else if (node instanceof ICASTDesignatedInitializer) {
                this.visit((ICASTDesignatedInitializer)node);
            } else {
                this.formatRaw((IASTNode)node);
            }
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    public int visit(IASTParameterDeclaration node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            IASTDeclarator declarator;
            IASTDeclSpecifier declSpec = node.getDeclSpecifier();
            if (declSpec != null) {
                declSpec.accept((ASTVisitor)this);
            }
            if ((declarator = node.getDeclarator()) != null) {
                boolean needSpace;
                boolean bl = needSpace = declarator.getPointerOperators().length > 0 && this.scribe.printComment();
                if (needSpace) {
                    this.scribe.space();
                }
                declarator.accept((ASTVisitor)this);
            }
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    public int visit(IASTDeclarator node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            IASTPointerOperator[] pointerOperators = node.getPointerOperators();
            this.formatPointers(pointerOperators);
            if (node instanceof IASTStandardFunctionDeclarator) {
                if (this.preferences.insert_new_line_before_identifier_in_function_declaration) {
                    this.scribe.startNewLine();
                } else if (this.scribe.printCommentPreservingNewLines()) {
                    this.scribe.space();
                }
            }
            IASTName name = node.getName();
            IASTDeclarator nestedDecl = node.getNestedDeclarator();
            if (name != null && name.getSimpleID().length != 0 || nestedDecl != null) {
                if (node.getPropertyInParent() != IASTDeclarator.NESTED_DECLARATOR && this.isFirstDeclarator(node) && (pointerOperators.length == 0 || this.scribe.printComment())) {
                    this.scribe.space();
                }
                if (name != null) {
                    name.accept((ASTVisitor)this);
                }
            }
            if (nestedDecl != null) {
                this.scribe.printNextToken(8, false);
                nestedDecl.accept((ASTVisitor)this);
                this.scribe.printNextToken(9, false);
            }
            if (node instanceof ICPPASTFunctionDeclarator) {
                int n = this.visit((ICPPASTFunctionDeclarator)node);
                return n;
            }
            if (node instanceof IASTStandardFunctionDeclarator) {
                this.visit((IASTStandardFunctionDeclarator)node);
            } else if (node instanceof ICASTKnRFunctionDeclarator) {
                this.visit((ICASTKnRFunctionDeclarator)node);
            } else if (node instanceof IASTFieldDeclarator) {
                this.visit((IASTFieldDeclarator)node);
            } else if (node instanceof IASTArrayDeclarator) {
                this.visit((IASTArrayDeclarator)node);
            }
            IASTInitializer initializer = node.getInitializer();
            if (initializer != null) {
                initializer.accept((ASTVisitor)this);
            }
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    private boolean isFirstDeclarator(IASTDeclarator node) {
        IASTNode parent = node.getParent();
        if (parent instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)parent;
            return simpleDecl.getDeclarators()[0] == node;
        }
        return true;
    }

    public int visit(IASTDeclSpecifier node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                this.visit((ICPPASTCompositeTypeSpecifier)node);
            } else if (node instanceof ICASTCompositeTypeSpecifier) {
                this.visit((ICASTCompositeTypeSpecifier)node);
            } else if (node instanceof IASTElaboratedTypeSpecifier) {
                this.visit((IASTElaboratedTypeSpecifier)node);
            } else if (node instanceof IASTEnumerationSpecifier) {
                this.visit((IASTEnumerationSpecifier)node);
            } else if (node instanceof IASTSimpleDeclSpecifier) {
                this.visit((IASTSimpleDeclSpecifier)node);
            } else if (node instanceof IASTNamedTypeSpecifier) {
                this.visit((IASTNamedTypeSpecifier)node);
            } else {
                this.formatRaw((IASTNode)node);
            }
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    public int visit(IASTExpression node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            if (node instanceof IASTArraySubscriptExpression) {
                this.visit((IASTArraySubscriptExpression)node);
            } else if (node instanceof IASTConditionalExpression) {
                this.visit((IASTConditionalExpression)node);
            } else if (node instanceof IASTFunctionCallExpression) {
                this.visit((IASTFunctionCallExpression)node);
            } else if (node instanceof IASTExpressionList) {
                this.visit((IASTExpressionList)node);
            } else if (node instanceof IASTTypeIdExpression) {
                this.visit((IASTTypeIdExpression)node);
            } else if (node instanceof IASTBinaryExpression) {
                this.visit((IASTBinaryExpression)node);
            } else if (node instanceof IASTLiteralExpression) {
                this.visit((IASTLiteralExpression)node);
            } else if (node instanceof IASTIdExpression) {
                this.visit((IASTIdExpression)node);
            } else if (node instanceof IASTCastExpression) {
                this.visit((IASTCastExpression)node);
            } else if (node instanceof IASTUnaryExpression) {
                this.visit((IASTUnaryExpression)node);
            } else if (node instanceof IASTFieldReference) {
                this.visit((IASTFieldReference)node);
            } else if (node instanceof IASTTypeIdInitializerExpression) {
                this.visit((IASTTypeIdInitializerExpression)node);
            } else if (node instanceof ICPPASTNewExpression) {
                this.visit((ICPPASTNewExpression)node);
            } else if (node instanceof ICPPASTDeleteExpression) {
                this.visit((ICPPASTDeleteExpression)node);
            } else if (node instanceof ICPPASTSimpleTypeConstructorExpression) {
                this.visit((ICPPASTSimpleTypeConstructorExpression)node);
            } else if (node instanceof IASTProblemExpression) {
                this.visit((IASTProblemExpression)node);
            } else {
                this.formatRaw((IASTNode)node);
            }
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public int visit(IASTStatement node) {
        block47: {
            if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)node) && RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)node)) {
                this.scribe.printCommentPreservingNewLines();
            }
            if (!this.enterNode((IASTNode)node)) {
                return 1;
            }
            indentLevel = this.scribe.indentationLevel;
            try {
                try {
                    if (node instanceof IASTCompoundStatement) {
                        this.visit((IASTCompoundStatement)node);
                    } else if (node instanceof IASTNullStatement) {
                        this.visit((IASTNullStatement)node);
                    } else if (node instanceof IASTDeclarationStatement) {
                        this.visit((IASTDeclarationStatement)node);
                    } else if (node instanceof IASTForStatement) {
                        this.visit((IASTForStatement)node);
                    } else if (node instanceof ICPPASTRangeBasedForStatement) {
                        this.visit((ICPPASTRangeBasedForStatement)node);
                    } else if (node instanceof IASTIfStatement) {
                        this.visit((IASTIfStatement)node);
                    } else if (node instanceof ICPPASTCatchHandler) {
                        this.visit((ICPPASTCatchHandler)node);
                    } else if (node instanceof ICPPASTTryBlockStatement) {
                        this.visit((ICPPASTTryBlockStatement)node);
                    } else if (node instanceof IASTWhileStatement) {
                        this.visit((IASTWhileStatement)node);
                    } else if (node instanceof IASTDoStatement) {
                        this.visit((IASTDoStatement)node);
                    } else if (node instanceof IASTSwitchStatement) {
                        this.visit((IASTSwitchStatement)node);
                    } else if (node instanceof IASTExpressionStatement) {
                        this.visit((IASTExpressionStatement)node);
                    } else if (node instanceof IASTContinueStatement) {
                        this.visit((IASTContinueStatement)node);
                    } else if (node instanceof IASTReturnStatement) {
                        this.visit((IASTReturnStatement)node);
                    } else if (node instanceof IASTBreakStatement) {
                        this.visit((IASTBreakStatement)node);
                    } else if (node instanceof IASTCaseStatement) {
                        this.visit((IASTCaseStatement)node);
                    } else if (node instanceof IASTDefaultStatement) {
                        this.visit((IASTDefaultStatement)node);
                    } else if (node instanceof IASTLabelStatement) {
                        this.visit((IASTLabelStatement)node);
                    } else if (node instanceof IASTProblemStatement) {
                        this.visit((IASTProblemStatement)node);
                    } else {
                        this.formatRaw((IASTNode)node);
                    }
                    break block47;
                }
                catch (ASTProblemException e) {
                    if (node instanceof IASTProblemStatement) {
                        throw e;
                    }
                    this.skipNode((IASTNode)node);
                    ** while (this.scribe.indentationLevel > indentLevel)
                }
lbl-1000:
                // 1 sources

                {
                    this.scribe.unIndent();
                    continue;
lbl94:
                    // 1 sources

                }
            }
            finally {
                this.exitNode((IASTNode)node);
            }
        }
        return 1;
    }

    public int visit(IASTTypeId node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            IASTDeclarator declarator;
            if (node instanceof IASTProblemHolder) {
                throw new ASTProblemException(((IASTProblemHolder)node).getProblem());
            }
            IASTDeclSpecifier declSpec = node.getDeclSpecifier();
            if (declSpec != null) {
                declSpec.accept((ASTVisitor)this);
            }
            if ((declarator = node.getAbstractDeclarator()) != null) {
                boolean needSpace;
                boolean bl = needSpace = declarator.getPointerOperators().length > 0 && this.scribe.printComment();
                if (needSpace) {
                    this.scribe.space();
                }
                declarator.accept((ASTVisitor)this);
            }
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        if (!this.enterNode((IASTNode)enumerator)) {
            return 1;
        }
        try {
            enumerator.getName().accept((ASTVisitor)this);
            IASTExpression value = enumerator.getValue();
            if (value != null) {
                this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
                if (this.preferences.insert_space_after_assignment_operator) {
                    this.scribe.space();
                }
                value.accept((ASTVisitor)this);
            }
        }
        finally {
            this.exitNode((IASTNode)enumerator);
        }
        return 1;
    }

    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier specifier) {
        if (!this.enterNode((IASTNode)specifier)) {
            return 1;
        }
        try {
            boolean needSpace = false;
            block6: while (true) {
                int token = this.peekNextToken();
                switch (token) {
                    case 98: 
                    case 99: 
                    case 100: 
                    case 122: {
                        this.scribe.printNextToken(token, needSpace);
                        needSpace = true;
                        continue block6;
                    }
                }
                break;
            }
            if (needSpace) {
                this.scribe.space();
            }
            specifier.getName().accept((ASTVisitor)this);
        }
        finally {
            this.exitNode((IASTNode)specifier);
        }
        return 1;
    }

    public int visit(ICPPASTNamespaceDefinition node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            int line = this.scribe.line;
            this.scribe.printNextToken(91, false);
            this.scribe.space();
            node.getName().accept((ASTVisitor)this);
            IASTDeclaration[] memberDecls = node.getDeclarations();
            this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_namespace_declaration);
            this.formatOpeningBrace(this.preferences.brace_position_for_namespace_declaration, this.preferences.insert_space_before_opening_brace_in_namespace_declaration);
            if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
                this.scribe.indent();
            }
            this.scribe.startNewLine();
            this.formatDeclarations(memberDecls, this.scribe.indentationLevel);
            if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
                this.scribe.unIndent();
            }
            this.formatClosingBrace(this.preferences.brace_position_for_namespace_declaration);
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    private int visit(ICPPASTLinkageSpecification node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        this.scribe.printNextToken(80, false);
        this.scribe.space();
        this.scribe.printNextToken(129);
        IASTDeclaration[] memberDecls = node.getDeclarations();
        if (memberDecls.length == 1 && this.peekNextToken() != 12) {
            this.scribe.space();
            memberDecls[0].accept((ASTVisitor)this);
        } else {
            this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_namespace_declaration);
            this.formatOpeningBrace(this.preferences.brace_position_for_namespace_declaration, this.preferences.insert_space_before_opening_brace_in_namespace_declaration);
            if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
                this.scribe.indent();
            }
            this.scribe.startNewLine();
            IASTDeclaration[] iASTDeclarationArray = memberDecls;
            int n = memberDecls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration declaration = iASTDeclarationArray[n2];
                declaration.accept((ASTVisitor)this);
                this.scribe.startNewLine();
                ++n2;
            }
            if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
                this.scribe.unIndent();
            }
            this.formatClosingBrace(this.preferences.brace_position_for_namespace_declaration);
        }
        return 1;
    }

    private int visit(ICPPASTNamespaceAlias node) {
        this.scribe.printNextToken(91);
        this.scribe.space();
        node.getAlias().accept((ASTVisitor)this);
        this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
        if (this.preferences.insert_space_after_assignment_operator) {
            this.scribe.space();
        }
        node.getMappingName().accept((ASTVisitor)this);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        return 1;
    }

    private int visit(ICPPASTUsingDeclaration node) {
        int token = this.peekNextToken();
        if (token == 121) {
            this.scribe.printNextToken(token);
        }
        if ((token = this.peekNextToken()) == 118) {
            this.scribe.printNextToken(token, true);
        }
        this.scribe.space();
        node.getName().accept((ASTVisitor)this);
        token = this.peekNextToken();
        if (token == 5) {
            this.scribe.printNextToken(token, this.preferences.insert_space_before_semicolon);
        }
        return 1;
    }

    private int visit(ICPPASTUsingDirective node) {
        this.scribe.printNextToken(121);
        this.scribe.printNextToken(91, true);
        this.scribe.space();
        node.getQualifiedName().accept((ASTVisitor)this);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        return 1;
    }

    public int visit(ICPPASTTemplateParameter node) {
        block8: {
            if (!this.enterNode((IASTNode)node)) {
                return 1;
            }
            try {
                try {
                    if (node instanceof ICPPASTSimpleTypeTemplateParameter) {
                        this.visit((ICPPASTSimpleTypeTemplateParameter)node);
                        break block8;
                    }
                    if (node instanceof ICPPASTTemplatedTypeTemplateParameter) {
                        this.visit((ICPPASTTemplatedTypeTemplateParameter)node);
                        break block8;
                    }
                    this.visit((IASTParameterDeclaration)node);
                }
                catch (ASTProblemException aSTProblemException) {
                    this.skipNode((IASTNode)node);
                    this.exitNode((IASTNode)node);
                }
            }
            finally {
                this.exitNode((IASTNode)node);
            }
        }
        return 1;
    }

    private int visit(ICPPASTSimpleTypeTemplateParameter node) {
        switch (node.getParameterType()) {
            case 1: {
                this.scribe.printNextToken(65);
                this.scribe.space();
                break;
            }
            case 2: {
                this.scribe.printNextToken(118);
                this.scribe.space();
                break;
            }
            default: {
                assert (false) : "Unknown template paramter type";
                this.formatRaw((IASTNode)node);
                return 1;
            }
        }
        node.getName().accept((ASTVisitor)this);
        IASTTypeId defaultType = node.getDefaultType();
        if (defaultType != null) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
            defaultType.accept((ASTVisitor)this);
        }
        return 1;
    }

    private int visit(ICPPASTTemplatedTypeTemplateParameter node) {
        IASTExpression defaultValue;
        IASTName name;
        ICPPASTTemplateParameter[] templateParameters;
        this.scribe.printNextToken(111, this.scribe.printComment());
        this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_parameters);
        if (this.preferences.insert_space_after_opening_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        if ((templateParameters = node.getTemplateParameters()).length > 0) {
            ListOptions options = new ListOptions(16);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_template_parameters;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_template_parameters;
            options.fTieBreakRule = 1;
            this.formatList(Arrays.asList(templateParameters), options, false, false, null);
        }
        this.scribe.printNextToken(new int[]{46, 44}, this.preferences.insert_space_before_closing_angle_bracket_in_template_parameters);
        if (this.preferences.insert_space_after_closing_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        if ((name = node.getName()) != null) {
            name.accept((ASTVisitor)this);
        }
        if ((defaultValue = node.getDefaultValue()) != null) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
            defaultValue.accept((ASTVisitor)this);
        }
        return 1;
    }

    private int visit(ICPPASTConstructorInitializer node) {
        if (!this.enterNode((IASTNode)node)) {
            return 1;
        }
        try {
            this.formatFunctionCallArguments(node.getArguments());
        }
        finally {
            this.exitNode((IASTNode)node);
        }
        return 1;
    }

    private int visit(ICPPASTConstructorChainInitializer node) {
        IASTName member = node.getMemberInitializerId();
        IASTInitializer init = node.getInitializer();
        if (member != null && init != null) {
            member.accept((ASTVisitor)this);
            init.accept((ASTVisitor)this);
        } else {
            this.formatRaw((IASTNode)node);
        }
        return 1;
    }

    private int visit(IASTFunctionDefinition node) {
        ICPPASTConstructorChainInitializer[] constructorChain;
        boolean needSpace;
        this.scribe.printComment();
        int line = this.scribe.line;
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept((ASTVisitor)this);
        IASTFunctionDeclarator declarator = node.getDeclarator();
        this.skipNonWhitespaceToNode((IASTNode)declarator);
        boolean hasSpace = this.scribe.printComment();
        boolean hasPointerOps = declarator.getPointerOperators().length > 0;
        boolean bl = needSpace = hasPointerOps && hasSpace || !hasPointerOps && this.peekNextToken() == 1;
        if (needSpace) {
            this.scribe.space();
        }
        TrailingTokenFormatter tailFormatter = null;
        IASTStatement bodyStmt = node.getBody();
        if ("end_of_line".equals(this.preferences.brace_position_for_method_declaration) && !this.hasMemberInitializers(node) && !(node instanceof ICPPASTFunctionWithTryBlock) && bodyStmt instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)bodyStmt)) {
            tailFormatter = new TrailingTokenFormatter(12, RemoteCodeFormatterVisitor.nodeOffset((IASTNode)bodyStmt), this.preferences.insert_space_before_opening_brace_in_method_declaration, false);
            this.scribe.setTailFormatter(tailFormatter);
        }
        declarator.accept((ASTVisitor)this);
        if (node instanceof ICPPASTFunctionWithTryBlock) {
            this.scribe.startNewLine();
            this.scribe.printNextToken(115, false);
            this.scribe.printTrailingComment();
        }
        if (node instanceof ICPPASTFunctionDefinition && (constructorChain = ((ICPPASTFunctionDefinition)node).getMemberInitializers()) != null && constructorChain.length > 0) {
            if (this.preferences.insert_new_line_before_colon_in_constructor_initializer_list) {
                this.scribe.printTrailingComment();
                this.scribe.startNewLine();
                this.scribe.indentForContinuation();
            }
            this.scribe.printNextToken(4, !this.preferences.insert_new_line_before_colon_in_constructor_initializer_list);
            if (this.preferences.insert_new_line_before_colon_in_constructor_initializer_list) {
                this.scribe.space();
            } else {
                this.scribe.printTrailingComment();
                this.scribe.startNewLine();
                this.scribe.indentForContinuation();
            }
            ListOptions options = new ListOptions(this.preferences.alignment_for_constructor_initializer_list);
            options.fTieBreakRule = 1;
            this.formatList(Arrays.asList(constructorChain), options, false, false, null);
            this.scribe.unIndentForContinuation();
        }
        if (tailFormatter != null) {
            this.scribe.runTailFormatter();
            this.scribe.setTailFormatter(null);
        }
        if (bodyStmt instanceof IASTCompoundStatement) {
            if (this.enterNode((IASTNode)bodyStmt)) {
                try {
                    if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)bodyStmt)) {
                        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_method_declaration);
                    }
                    this.formatBlock((IASTCompoundStatement)bodyStmt, this.preferences.brace_position_for_method_declaration, this.preferences.insert_space_before_opening_brace_in_method_declaration, this.preferences.indent_statements_compare_to_body);
                }
                finally {
                    this.exitNode((IASTNode)bodyStmt);
                }
            }
        } else {
            bodyStmt.accept((ASTVisitor)this);
        }
        this.scribe.printTrailingComment();
        this.scribe.startNewLine();
        if (node instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTCatchHandler[] catchHandlers;
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = catchHandlers = ((ICPPASTFunctionWithTryBlock)node).getCatchHandlers();
            int n = catchHandlers.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
                catchHandler.accept((ASTVisitor)this);
                this.scribe.printTrailingComment();
                this.scribe.startNewLine();
                ++n2;
            }
        }
        return 1;
    }

    private int visit(IASTASMDeclaration node) {
        this.formatRaw((IASTNode)node);
        return 1;
    }

    private int visit(ICPPASTFunctionDeclarator node) {
        List<ICPPASTParameterDeclaration> parameters = Arrays.asList(node.getParameters());
        ListOptions options = this.createListOptionsForFunctionDeclarationParameters();
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        this.formatList(parameters, options, true, node.takesVarArgs(), new FunctionDeclaratorTailFormatter((IASTFunctionDeclarator)node, tailFormatter));
        return 1;
    }

    private void formatExceptionSpecification(IASTTypeId[] exceptionSpecification) {
        if (exceptionSpecification.length > 0) {
            Alignment alignment = this.scribe.createAlignment("exceptionSpecification", this.preferences.alignment_for_throws_clause_in_method_declaration, exceptionSpecification.length, this.getCurrentPosition());
            this.scribe.enterAlignment(alignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(alignment, 0);
                    this.scribe.printNextToken(113, true);
                    this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_exception_specification);
                    if (this.preferences.insert_space_after_opening_paren_in_exception_specification) {
                        this.scribe.space();
                    }
                    exceptionSpecification[0].accept((ASTVisitor)this);
                    int i = 1;
                    while (i < exceptionSpecification.length) {
                        this.scribe.printNextToken(6, this.preferences.insert_space_before_comma_in_method_declaration_throws);
                        this.scribe.printTrailingComment();
                        if (this.preferences.insert_space_after_comma_in_method_declaration_throws) {
                            this.scribe.space();
                        }
                        this.scribe.alignFragment(alignment, i);
                        exceptionSpecification[i].accept((ASTVisitor)this);
                        ++i;
                    }
                    if (this.peekNextToken() == 9) {
                        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_exception_specification);
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        } else {
            this.scribe.printNextToken(113, true);
            this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_exception_specification);
            this.scribe.printNextToken(9, this.preferences.insert_space_between_empty_parens_in_exception_specification);
        }
    }

    private boolean skipConstVolatileRestrict() {
        boolean skipped = false;
        int token = this.peekNextToken();
        while (token == 67 || token == 124 || token == 136) {
            this.scribe.printNextToken(token, true);
            token = this.peekNextToken();
            skipped = true;
        }
        return skipped;
    }

    private int visit(IASTStandardFunctionDeclarator node) {
        List<IASTParameterDeclaration> parameters = Arrays.asList(node.getParameters());
        ListOptions options = this.createListOptionsForFunctionDeclarationParameters();
        this.formatList(parameters, options, true, node.takesVarArgs(), new TrailingSemicolonFormatter((IASTNode)node));
        return 1;
    }

    private ListOptions createListOptionsForFunctionDeclarationParameters() {
        ListOptions options = new ListOptions(this.preferences.alignment_for_parameters_in_method_declaration);
        options.fSpaceBeforeOpeningParen = this.preferences.insert_space_before_opening_paren_in_method_declaration;
        options.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_declaration;
        options.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_declaration;
        options.fSpaceBetweenEmptyParen = this.preferences.insert_space_between_empty_parens_in_method_declaration;
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_method_declaration_parameters;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_method_declaration_parameters;
        options.fTieBreakRule = 1;
        return options;
    }

    private static int getLastNodeCharacterPosition(IASTNode node) {
        IASTNodeLocation lastLocation;
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length > 0 && !((lastLocation = locations[locations.length - 1]) instanceof IASTMacroExpansionLocation)) {
            IASTFileLocation fileLocation = lastLocation.asFileLocation();
            return fileLocation.getNodeOffset() + fileLocation.getNodeLength() - 1;
        }
        return -1;
    }

    private void formatPointers(IASTPointerOperator[] pointers) {
        IASTPointerOperator[] iASTPointerOperatorArray = pointers;
        int n = pointers.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
            if (this.scribe.printModifiers()) {
                this.scribe.space();
            }
            if (pointer instanceof ICPPASTReferenceOperator) {
                this.scribe.printNextToken(30, false);
            } else if (pointer instanceof ICPPASTPointerToMember) {
                ICPPASTPointerToMember ptrToMember = (ICPPASTPointerToMember)pointer;
                IASTName name = ptrToMember.getName();
                if (name != null) {
                    name.accept((ASTVisitor)this);
                }
                this.scribe.printNextToken(23, false);
                if (this.skipConstVolatileRestrict()) {
                    this.scribe.space();
                }
            } else {
                this.scribe.printNextToken(23, false);
                if (this.skipConstVolatileRestrict()) {
                    this.scribe.space();
                }
            }
            ++n2;
        }
    }

    private int visit(ICASTKnRFunctionDeclarator node) {
        List<IASTName> parameters = Arrays.asList(node.getParameterNames());
        ListOptions options = this.createListOptionsForFunctionDeclarationParameters();
        this.formatList(parameters, options, true, false, null);
        IASTDeclaration[] parameterDecls = node.getParameterDeclarations();
        this.scribe.startNewLine();
        this.scribe.indent();
        try {
            IASTDeclaration[] iASTDeclarationArray = parameterDecls;
            int n = parameterDecls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration declaration = iASTDeclarationArray[n2];
                declaration.accept((ASTVisitor)this);
                ++n2;
            }
        }
        finally {
            this.scribe.unIndent();
        }
        return 1;
    }

    private int visit(IASTFieldDeclarator node) {
        IASTExpression bitFieldSizeExpr = node.getBitFieldSize();
        if (bitFieldSizeExpr != null) {
            this.scribe.printNextToken(4, true);
            bitFieldSizeExpr.accept((ASTVisitor)this);
        }
        return 1;
    }

    private int visit(IASTArrayDeclarator node) {
        IASTArrayModifier[] arrayModifiers = node.getArrayModifiers();
        if (arrayModifiers != null) {
            IASTArrayModifier[] iASTArrayModifierArray = arrayModifiers;
            int n = arrayModifiers.length;
            int n2 = 0;
            while (n2 < n) {
                boolean emptyBrackets;
                block12: {
                    IASTArrayModifier arrayModifier = iASTArrayModifierArray[n2];
                    this.scribe.printNextToken(10, this.preferences.insert_space_before_opening_bracket);
                    boolean bl = emptyBrackets = arrayModifier.getConstantExpression() == null && !(arrayModifier instanceof ICASTArrayModifier);
                    if (!emptyBrackets && this.preferences.insert_space_after_opening_bracket) {
                        this.scribe.space();
                    }
                    if (arrayModifier instanceof ICASTArrayModifier) {
                        ICASTArrayModifier cArrayModifier = (ICASTArrayModifier)arrayModifier;
                        if (this.scribe.printModifiers()) {
                            this.scribe.space();
                        }
                        if (cArrayModifier.isVariableSized()) {
                            this.scribe.printNextToken(23, this.scribe.printComment());
                        }
                        if (this.scribe.printComment()) {
                            this.scribe.space();
                        }
                    }
                    Runnable tailFormatter = this.scribe.takeTailFormatter();
                    try {
                        try {
                            arrayModifier.accept((ASTVisitor)this);
                        }
                        catch (ASTProblemException aSTProblemException) {
                            this.scribe.skipToToken(11);
                            this.scribe.setTailFormatter(tailFormatter);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        this.scribe.setTailFormatter(tailFormatter);
                        throw throwable;
                    }
                    this.scribe.setTailFormatter(tailFormatter);
                }
                boolean insertSpace = emptyBrackets ? this.preferences.insert_space_between_empty_brackets : this.preferences.insert_space_before_closing_bracket;
                this.scribe.printNextToken(11, insertSpace);
                ++n2;
            }
        }
        return 1;
    }

    private int visit(IASTSimpleDeclaration node) {
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept((ASTVisitor)this);
        List<IASTDeclarator> declarators = Arrays.asList(node.getDeclarators());
        if (!declarators.isEmpty()) {
            TrailingSemicolonFormatter tailFormatter;
            if (declarators.size() == 1 && declarators.get(0) instanceof IASTFunctionDeclarator) {
                if (this.scribe.printCommentPreservingNewLines()) {
                    this.scribe.space();
                }
            } else if (this.scribe.printComment()) {
                this.scribe.space();
            }
            TrailingSemicolonFormatter trailingSemicolonFormatter = tailFormatter = this.fExpectSemicolonAfterDeclaration ? new TrailingSemicolonFormatter((IASTNode)node) : null;
            if (declarators.size() == 1) {
                if (tailFormatter != null) {
                    this.scribe.setTailFormatter(tailFormatter);
                    try {
                        this.visit(declarators.get(0));
                        this.scribe.runTailFormatter();
                    }
                    finally {
                        this.scribe.setTailFormatter(null);
                    }
                } else {
                    this.visit(declarators.get(0));
                }
            } else {
                ListOptions options = new ListOptions(this.preferences.alignment_for_declarator_list);
                options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_declarator_list;
                options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_declarator_list;
                this.formatList(declarators, options, false, false, tailFormatter);
            }
        }
        return 1;
    }

    private int visit(ICPPASTTemplateDeclaration node) {
        ICPPASTTemplateParameter[] templateParameters;
        if (node.isExported()) {
            this.scribe.printNextToken(79);
            this.scribe.space();
        }
        this.scribe.printNextToken(111);
        this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_parameters);
        if (this.preferences.insert_space_after_opening_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        if ((templateParameters = node.getTemplateParameters()).length > 0) {
            ListOptions options = new ListOptions(16);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_template_parameters;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_template_parameters;
            this.formatList(Arrays.asList(templateParameters), options, false, false, null);
        }
        this.scribe.printNextToken(new int[]{46, 44}, this.preferences.insert_space_before_closing_angle_bracket_in_template_parameters);
        if (this.preferences.insert_space_after_closing_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        IASTDeclaration declaration = node.getDeclaration();
        if (this.preferences.insert_new_line_after_template_declaration) {
            this.scribe.startNewLine();
            if (this.preferences.indent_declaration_compare_to_template_header) {
                this.scribe.indent();
            }
        } else {
            this.scribe.printCommentPreservingNewLines();
        }
        declaration.accept((ASTVisitor)this);
        if (this.preferences.insert_new_line_after_template_declaration && this.preferences.indent_declaration_compare_to_template_header) {
            this.scribe.unIndent();
        }
        return 1;
    }

    private int visit(ICPPASTTemplateSpecialization node) {
        this.scribe.printNextToken(111);
        this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_parameters);
        this.scribe.printNextToken(46, this.scribe.printComment());
        if (this.preferences.insert_space_after_closing_angle_bracket_in_template_parameters) {
            this.scribe.space();
        }
        node.getDeclaration().accept((ASTVisitor)this);
        return 1;
    }

    private int visit(ICPPASTExplicitTemplateInstantiation node) {
        node.getDeclaration().accept((ASTVisitor)this);
        return 1;
    }

    private int visit(IASTSimpleDeclSpecifier node) {
        this.formatRaw((IASTNode)node);
        return 1;
    }

    private int visit(IASTNamedTypeSpecifier node) {
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        if (node instanceof ICPPASTNamedTypeSpecifier && ((ICPPASTNamedTypeSpecifier)node).isTypename()) {
            this.scribe.printNextToken(118);
            this.scribe.space();
        }
        node.getName().accept((ASTVisitor)this);
        return 1;
    }

    private int visit(ICASTCompositeTypeSpecifier node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        if (RemoteCodeFormatterVisitor.withinMacroExpansion((IASTNode)node, this.getCurrentPosition())) {
            this.scribe.printNextToken(this.peekNextToken());
            this.continueNode((IASTNode)node);
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
        }
        switch (node.getKey()) {
            case 1: {
                this.scribe.printNextToken(109, true);
                break;
            }
            case 2: {
                this.scribe.printNextToken(119, true);
                break;
            }
            default: {
                assert (false) : "Unexpected composite type specifier";
                break;
            }
        }
        IASTName name = node.getName();
        if (name != null) {
            this.scribe.space();
            name.accept((ASTVisitor)this);
        }
        IASTDeclaration[] memberDecls = node.getMembers();
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.indent();
        }
        this.scribe.startNewLine();
        IASTDeclaration[] iASTDeclarationArray = memberDecls;
        int n = memberDecls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            declaration.accept((ASTVisitor)this);
            this.scribe.startNewLine();
            ++n2;
        }
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.unIndent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        return 1;
    }

    private int visit(ICPPASTCompositeTypeSpecifier node) {
        IASTDeclaration[] memberDecls;
        List<ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier> baseSpecifiers;
        IASTName name;
        int token;
        this.scribe.printComment();
        int line = this.scribe.line;
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        int headerIndent = this.scribe.numberOfIndentations;
        if (RemoteCodeFormatterVisitor.withinMacroExpansion((IASTNode)node, this.getCurrentPosition())) {
            this.scribe.printNextToken(this.peekNextToken());
            this.continueNode((IASTNode)node);
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
        }
        if ((token = this.peekNextToken()) == 109 || token == 65 || token == 119) {
            this.scribe.printNextToken(token, false);
        }
        if ((name = node.getName()) != null) {
            this.scribe.space();
            name.accept((ASTVisitor)this);
        }
        if ((baseSpecifiers = Arrays.asList(node.getBaseSpecifiers())).size() > 0) {
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier = baseSpecifiers.get(0);
            try {
                if (baseSpecifier.getLeadingSyntax().getType() == 4) {
                    this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_base_clause);
                    if (this.preferences.insert_space_after_colon_in_base_clause) {
                        this.scribe.space();
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {}
            ListOptions options = new ListOptions(this.preferences.alignment_for_base_clause_in_type_declaration);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_base_types;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_base_types;
            this.formatList(baseSpecifiers, options, false, false, null);
        }
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        int braceIndent = this.scribe.numberOfIndentations;
        if (braceIndent > headerIndent) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.indent();
        }
        if (this.getCurrentPosition() >= RemoteCodeFormatterVisitor.nodeEndOffset((IASTNode)node)) {
            return 1;
        }
        this.scribe.startNewLine();
        IASTDeclaration[] iASTDeclarationArray = memberDecls = node.getMembers();
        int n = memberDecls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                this.scribe.indent();
            }
            this.scribe.printComment();
            if (declaration instanceof ICPPASTVisibilityLabel) {
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.unIndent();
                }
                if (this.enterNode((IASTNode)declaration)) {
                    try {
                        this.scribe.startNewLine();
                        this.visit((ICPPASTVisibilityLabel)declaration);
                        this.scribe.startNewLine();
                    }
                    finally {
                        this.exitNode((IASTNode)declaration);
                    }
                }
            } else {
                if (this.enterNode((IASTNode)declaration)) {
                    try {
                        if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)declaration)) {
                            this.scribe.startNewLine();
                        }
                        this.formatDeclaration(declaration);
                    }
                    finally {
                        this.exitNode((IASTNode)declaration);
                    }
                } else {
                    this.skipNode((IASTNode)declaration);
                }
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.unIndent();
                }
            }
            ++n2;
        }
        this.scribe.startNewLine();
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.indent();
        }
        this.scribe.printComment();
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.unIndent();
        }
        if (this.scribe.numberOfIndentations < braceIndent) {
            this.scribe.indent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        return 1;
    }

    private int visit(ICPPASTVisibilityLabel node) {
        if (node.getNodeLocations()[0] instanceof IASTMacroExpansionLocation) {
            this.skipNode((IASTNode)node);
        } else {
            this.scribe.printSpaces(this.preferences.indent_access_specifier_extra_spaces);
            switch (node.getVisibility()) {
                case 3: {
                    this.scribe.printNextToken(98, false);
                    break;
                }
                case 2: {
                    this.scribe.printNextToken(99, false);
                    break;
                }
                case 1: {
                    this.scribe.printNextToken(100, false);
                }
            }
            if (this.peekNextToken() != 4) {
                this.scribe.skipToToken(4);
            }
            this.scribe.printNextToken(4, false);
        }
        return 1;
    }

    private int visit(IASTElaboratedTypeSpecifier node) {
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        switch (node.getKind()) {
            case 0: {
                this.scribe.printNextToken(77, false);
                break;
            }
            case 1: {
                this.scribe.printNextToken(109, false);
                break;
            }
            case 2: {
                this.scribe.printNextToken(119, false);
                break;
            }
            case 3: {
                this.scribe.printNextToken(65, false);
                break;
            }
            default: {
                assert (false) : "Unexpected elaborated type specifier";
                break;
            }
        }
        this.scribe.space();
        node.getName().accept((ASTVisitor)this);
        return 1;
    }

    private int visit(IASTEnumerationSpecifier node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        if (this.scribe.printModifiers()) {
            this.scribe.space();
        }
        int headerIndent = this.scribe.numberOfIndentations;
        this.scribe.printNextToken(77, true);
        IASTName name = node.getName();
        if (name != null) {
            this.scribe.space();
            name.accept((ASTVisitor)this);
        }
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        int braceIndent = this.scribe.numberOfIndentations;
        this.scribe.startNewLine();
        if (braceIndent == headerIndent) {
            this.scribe.indent();
        }
        int enumIndent = this.scribe.numberOfIndentations;
        IASTEnumerationSpecifier.IASTEnumerator[] enumerators = node.getEnumerators();
        ListOptions options = new ListOptions(this.preferences.alignment_for_enumerator_list);
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_enum_declarations;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_enum_declarations;
        options.fContinuationIndentation = enumIndent == headerIndent ? 1 : 0;
        this.formatList(Arrays.asList(enumerators), options, false, false, null);
        if (this.peekNextToken() == 6) {
            this.scribe.printNextToken(6, options.fSpaceBeforeSeparator);
            if (options.fSpaceAfterSeparator) {
                this.scribe.space();
            }
        }
        this.scribe.printTrailingComment();
        if (enumIndent > braceIndent) {
            this.scribe.unIndent();
        }
        this.scribe.startNewLine();
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        return 1;
    }

    private void formatList(List<? extends IASTNode> elements, ListOptions options, boolean encloseInParen, boolean addEllipsis, Runnable tailFormatter) {
        if (encloseInParen) {
            this.scribe.printNextToken(8, options.fSpaceBeforeOpeningParen);
        }
        int elementsLength = elements.size();
        if (encloseInParen) {
            boolean spaceBeforeClosingParen = elements.isEmpty() && !addEllipsis ? options.fSpaceBetweenEmptyParen : options.fSpaceBeforeClosingParen;
            tailFormatter = new ClosingParensesisTailFormatter(spaceBeforeClosingParen, tailFormatter);
        }
        if (!elements.isEmpty() || addEllipsis) {
            if (options.fSpaceAfterOpeningParen) {
                this.scribe.space();
            }
            int continuationIndentation = options.fContinuationIndentation >= 0 ? options.fContinuationIndentation : this.preferences.continuation_indentation;
            Alignment alignment = this.scribe.createAlignment("listElements_" + (elements.isEmpty() ? "ellipsis" : elements.get(0).getClass().getSimpleName()), options.fMode, options.fTieBreakRule, elementsLength + (addEllipsis ? 1 : 0), this.getCurrentPosition(), continuationIndentation, false);
            this.scribe.enterAlignment(alignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < elementsLength) {
                        IASTNode node = elements.get(i);
                        if (i < elementsLength - 1) {
                            this.scribe.setTailFormatter(new TrailingTokenFormatter(options.fSeparatorToken, this.findTokenAfterNode(options.fSeparatorToken, node), options.fSpaceBeforeSeparator, options.fSpaceAfterSeparator));
                        } else {
                            this.scribe.setTailFormatter(tailFormatter);
                        }
                        this.scribe.alignFragment(alignment, i);
                        if (node instanceof ICPPASTConstructorChainInitializer) {
                            this.visit((ICPPASTConstructorChainInitializer)node);
                        } else {
                            node.accept((ASTVisitor)this);
                        }
                        if (i < elementsLength - 1) {
                            this.scribe.runTailFormatter();
                        }
                        ++i;
                    }
                    if (addEllipsis) {
                        if (i > 0) {
                            this.scribe.printNextToken(options.fSeparatorToken, options.fSpaceBeforeSeparator);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(alignment, i);
                        if (i > 0 && options.fSpaceAfterSeparator) {
                            this.scribe.space();
                        }
                        this.scribe.printNextToken(48);
                    }
                    this.scribe.runTailFormatter();
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
                catch (ASTProblemException aSTProblemException) {}
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        } else if (tailFormatter != null) {
            tailFormatter.run();
        }
    }

    private int visit(ICPPASTTryBlockStatement node) {
        ICPPASTCatchHandler[] catchHandlers;
        this.scribe.printNextToken(115, this.scribe.printComment());
        IASTStatement tryBody = node.getTryBody();
        if (tryBody != null) {
            tryBody.accept((ASTVisitor)this);
        }
        this.scribe.printTrailingComment();
        ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = catchHandlers = node.getCatchHandlers();
        int n = catchHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
            catchHandler.accept((ASTVisitor)this);
            this.scribe.printTrailingComment();
            ++n2;
        }
        return 1;
    }

    private int visit(ICPPASTCatchHandler node) {
        IASTStatement catchBody;
        IASTDeclaration decl;
        int token = this.peekNextToken();
        if (token == 63) {
            if (this.preferences.insert_new_line_before_catch_in_try_statement) {
                this.scribe.startNewLine();
            }
            this.scribe.printNextToken(token, true);
        }
        if ((token = this.peekNextToken()) == 8) {
            this.scribe.printNextToken(token, this.preferences.insert_space_before_opening_paren_in_catch);
            if (this.preferences.insert_space_after_opening_paren_in_catch) {
                this.scribe.space();
            }
        }
        if ((decl = node.getDeclaration()) != null) {
            this.formatInlineDeclaration(decl);
        } else if (node.isCatchAll() && (token = this.peekNextToken()) == 48) {
            this.scribe.printNextToken(token, false);
        }
        token = this.peekNextToken();
        if (token == 9) {
            this.scribe.printNextToken(token, this.preferences.insert_space_before_closing_paren_in_catch);
        }
        if ((catchBody = node.getCatchBody()) != null) {
            catchBody.accept((ASTVisitor)this);
        }
        return 1;
    }

    private void formatInlineDeclaration(IASTDeclaration decl) {
        this.fExpectSemicolonAfterDeclaration = false;
        try {
            decl.accept((ASTVisitor)this);
        }
        finally {
            this.fExpectSemicolonAfterDeclaration = true;
        }
    }

    private int visit(IASTCompoundStatement node) {
        this.formatBlock(node, this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
        return 1;
    }

    private int visit(IASTBreakStatement node) {
        this.scribe.printNextToken(61);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTConditionalExpression node) {
        int numConditions = 0;
        IASTConditionalExpression expression = node;
        while (expression instanceof IASTConditionalExpression) {
            ++numConditions;
            expression = expression.getNegativeResultExpression();
        }
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        Alignment alignment = this.scribe.createAlignment("conditionalExpressionChain", this.preferences.alignment_for_conditional_expression_chain, 1, numConditions, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                IASTConditionalExpression expression2 = node;
                int i = 0;
                while (true) {
                    this.scribe.alignFragment(alignment, i);
                    boolean last = i == numConditions - 1;
                    this.formatConditionalExpression(expression2, last ? tailFormatter : null);
                    if (last) break;
                    expression2 = (IASTConditionalExpression)expression2.getNegativeResultExpression();
                    ++i;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        return 1;
    }

    private void formatConditionalExpression(IASTConditionalExpression node, Runnable tailFormatter) {
        this.scribe.setTailFormatter(new TrailingTokenFormatter(7, (IASTNode)node, this.preferences.insert_space_before_question_in_conditional, this.preferences.insert_space_after_question_in_conditional));
        node.getLogicalConditionExpression().accept((ASTVisitor)this);
        this.scribe.runTailFormatter();
        IASTExpression positiveExpression = node.getPositiveResultExpression();
        IASTExpression negativeExpression = node.getNegativeResultExpression();
        Alignment alignment = this.scribe.createAlignment("conditionalExpression", this.preferences.alignment_for_conditional_expression, 1, negativeExpression instanceof IASTConditionalExpression ? 1 : 2, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                if (positiveExpression != null && this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)positiveExpression)) {
                    this.scribe.alignFragment(alignment, 0);
                }
                this.scribe.setTailFormatter(new TrailingTokenFormatter(4, (IASTNode)node, this.preferences.insert_space_before_colon_in_conditional, this.preferences.insert_space_after_colon_in_conditional));
                if (positiveExpression != null) {
                    positiveExpression.accept((ASTVisitor)this);
                }
                this.scribe.runTailFormatter();
                if (!(negativeExpression instanceof IASTConditionalExpression)) {
                    if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)negativeExpression)) {
                        this.scribe.alignFragment(alignment, 1);
                    }
                    this.scribe.setTailFormatter(tailFormatter);
                    negativeExpression.accept((ASTVisitor)this);
                    this.scribe.runTailFormatter();
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
    }

    private int visit(IASTFunctionCallExpression node) {
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        try {
            node.getFunctionNameExpression().accept((ASTVisitor)this);
        }
        finally {
            this.scribe.setTailFormatter(tailFormatter);
        }
        IASTInitializerClause[] paramExpr = node.getArguments();
        if (this.peekNextToken() == 1) {
            this.skipNode((IASTNode)node);
        } else {
            this.formatFunctionCallArguments(paramExpr);
        }
        return 1;
    }

    private void formatFunctionCallArguments(IASTInitializerClause[] args) {
        if (this.peekNextToken() != 8 && (args == null || args.length == 0 || RemoteCodeFormatterVisitor.enclosedInMacroExpansion((IASTNode)args[0]))) {
            return;
        }
        List<Object> expressions = args != null ? Arrays.asList(args) : Collections.emptyList();
        ListOptions options = new ListOptions(this.preferences.alignment_for_arguments_in_method_invocation);
        options.fSeparatorToken = 6;
        options.fSpaceBeforeOpeningParen = this.preferences.insert_space_before_opening_paren_in_method_invocation;
        options.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_invocation;
        options.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_invocation;
        options.fSpaceBetweenEmptyParen = this.preferences.insert_space_between_empty_parens_in_method_invocation;
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_method_invocation_arguments;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_method_invocation_arguments;
        options.fTieBreakRule = 1;
        this.formatList(expressions, options, true, false, this.scribe.takeTailFormatter());
    }

    private int visit(IASTExpressionList node) {
        List<IASTExpression> expressions = Arrays.asList(node.getExpressions());
        ListOptions options = new ListOptions(this.preferences.alignment_for_expression_list);
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_expression_list;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_expression_list;
        this.formatList(expressions, options, false, false, null);
        return 1;
    }

    private int visit(IASTIdExpression node) {
        node.getName().accept((ASTVisitor)this);
        return 1;
    }

    private int visit(IASTCastExpression node) {
        switch (node.getOperator()) {
            case 0: {
                this.scribe.printNextToken(8, false);
                if (this.preferences.insert_space_after_opening_paren_in_cast) {
                    this.scribe.space();
                }
                node.getTypeId().accept((ASTVisitor)this);
                try {
                    if (node.getTypeId().getTrailingSyntax().getType() == 9) {
                        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_cast);
                        if (this.preferences.insert_space_after_closing_paren_in_cast) {
                            this.scribe.space();
                        }
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
                    this.scribe.space();
                }
                node.getOperand().accept((ASTVisitor)this);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.scribe.printNextToken(this.peekNextToken(), false);
                this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_arguments);
                if (this.preferences.insert_space_after_opening_angle_bracket_in_template_arguments) {
                    this.scribe.space();
                }
                node.getTypeId().accept((ASTVisitor)this);
                this.scribe.printNextToken(46, this.preferences.insert_space_before_closing_angle_bracket_in_template_arguments);
                if (this.preferences.insert_space_before_opening_paren_in_method_invocation) {
                    this.scribe.space();
                }
                this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_method_invocation);
                if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
                    this.scribe.space();
                }
                Runnable tailFormatter = this.scribe.takeTailFormatter();
                try {
                    node.getOperand().accept((ASTVisitor)this);
                }
                finally {
                    this.scribe.setTailFormatter(tailFormatter);
                }
                this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_method_invocation);
                break;
            }
            default: {
                this.skipToNode((IASTNode)node.getOperand());
            }
        }
        return 1;
    }

    private int visit(IASTTypeIdExpression node) {
        this.scribe.printNextToken(this.peekNextToken());
        this.scribe.printNextToken(8);
        node.getTypeId().accept((ASTVisitor)this);
        if (this.peekNextToken() == 6) {
            this.scribe.printNextToken(6, this.preferences.insert_space_before_comma_in_method_invocation_arguments);
            this.scribe.printNextToken(this.peekNextToken(), this.preferences.insert_space_after_comma_in_method_invocation_arguments);
            this.scribe.skipToToken(9);
        }
        this.scribe.printNextToken(9);
        return 1;
    }

    private int visit(IASTEqualsInitializer node) {
        if (node.getPropertyInParent() == IASTInitializerList.NESTED_INITIALIZER) {
            assert (false);
        } else {
            Alignment alignment = this.scribe.createAlignment("declarationInitializer", this.preferences.alignment_for_assignment, 2, 1, this.getCurrentPosition());
            Runnable tailFormatter = this.scribe.getTailFormatter();
            this.scribe.enterAlignment(alignment);
            this.scribe.setTailFormatter(tailFormatter);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(alignment, 0);
                    node.getInitializerClause().accept((ASTVisitor)this);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        }
        return 1;
    }

    private int visit(ICASTDesignatedInitializer node) {
        ICASTDesignator[] designators;
        this.scribe.printComment();
        ICASTDesignator[] iCASTDesignatorArray = designators = node.getDesignators();
        int n = designators.length;
        int n2 = 0;
        while (n2 < n) {
            ICASTDesignator designator = iCASTDesignatorArray[n2];
            designator.accept((ASTVisitor)this);
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
            ++n2;
        }
        if (this.peekNextToken() == 38) {
            this.scribe.printNextToken(38, this.preferences.insert_space_before_assignment_operator);
            if (this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
        }
        Alignment expressionAlignment = this.scribe.createAlignment("designatedInitializer", this.preferences.alignment_for_assignment, 1, this.getCurrentPosition());
        this.scribe.enterAlignment(expressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(expressionAlignment, 0);
                IASTInitializerClause initializer = node.getOperand();
                initializer.accept((ASTVisitor)this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(expressionAlignment, true);
        return 1;
    }

    private int visit(IASTInitializerList node) {
        this.scribe.printComment();
        List<IASTInitializerClause> initializers = Arrays.asList(node.getClauses());
        if (initializers.isEmpty() && this.preferences.keep_empty_initializer_list_on_one_line) {
            this.scribe.printNextToken(12, this.preferences.insert_space_before_opening_brace_in_initializer_list);
            this.scribe.printNextToken(13, this.preferences.insert_space_between_empty_braces_in_initializer_list);
        } else {
            int line = this.scribe.line;
            String brace_position = this.preferences.brace_position_for_initializer_list;
            this.formatLeftCurlyBrace(line, brace_position);
            this.formatOpeningBrace(brace_position, this.preferences.insert_space_before_opening_brace_in_initializer_list);
            if (this.preferences.insert_new_line_after_opening_brace_in_initializer_list) {
                this.scribe.startNewLine();
            }
            if (this.preferences.insert_space_after_opening_brace_in_initializer_list) {
                this.scribe.space();
            }
            ListOptions options = new ListOptions(this.preferences.alignment_for_expressions_in_initializer_list);
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_initializer_list;
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_initializer_list;
            options.fContinuationIndentation = this.preferences.continuation_indentation_for_initializer_list;
            this.formatList(initializers, options, false, false, null);
            if (this.peekNextToken() == 6) {
                this.scribe.printNextToken(6, options.fSpaceBeforeSeparator);
                if (options.fSpaceAfterSeparator) {
                    this.scribe.space();
                }
            }
            if (this.preferences.insert_new_line_before_closing_brace_in_initializer_list) {
                this.scribe.startNewLine();
            }
            if (this.preferences.insert_space_before_closing_brace_in_initializer_list) {
                this.scribe.space();
            }
            this.formatClosingBrace(brace_position);
        }
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTUnaryExpression node) {
        IASTExpression operand = node.getOperand();
        int operator = node.getOperator();
        switch (operator) {
            case 11: {
                this.formatParenthesizedExpression(operand);
                break;
            }
            case 0: 
            case 1: {
                this.scribe.printNextToken(this.peekNextToken(), this.preferences.insert_space_before_prefix_operator);
                if (this.preferences.insert_space_after_prefix_operator) {
                    this.scribe.space();
                }
                operand.accept((ASTVisitor)this);
                break;
            }
            case 9: 
            case 10: {
                operand.accept((ASTVisitor)this);
                this.scribe.printNextToken(this.peekNextToken(), this.preferences.insert_space_before_postfix_operator);
                if (!this.preferences.insert_space_after_postfix_operator) break;
                this.scribe.space();
                break;
            }
            case 8: {
                this.scribe.printNextToken(105, this.scribe.printComment());
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept((ASTVisitor)this);
                break;
            }
            case 16: {
                this.scribe.printNextToken(105, this.scribe.printComment());
                this.scribe.printNextToken(48, this.scribe.printComment());
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept((ASTVisitor)this);
                break;
            }
            case 12: {
                this.scribe.printNextToken(113, this.scribe.printComment());
                if (operand == null) break;
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept((ASTVisitor)this);
                break;
            }
            case 13: {
                this.scribe.printNextToken(117, this.scribe.printComment());
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept((ASTVisitor)this);
                break;
            }
            default: {
                int operatorToken = this.peekNextToken();
                boolean forceSpace = Character.isJavaIdentifierStart(this.peekNextChar());
                this.scribe.printNextToken(operatorToken, this.preferences.insert_space_before_unary_operator);
                if (forceSpace || this.preferences.insert_space_after_unary_operator) {
                    this.scribe.space();
                } else if (operatorToken == 1 && this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept((ASTVisitor)this);
            }
        }
        return 1;
    }

    private int visit(IASTBinaryExpression node) {
        if (RemoteCodeFormatterVisitor.enclosedInMacroExpansion((IASTNode)node)) {
            return 1;
        }
        if (RemoteCodeFormatterVisitor.doNodeLocationsOverlap((IASTNode)node.getOperand1(), (IASTNode)node.getOperand2())) {
            node.getOperand1().accept((ASTVisitor)this);
            node.getOperand2().accept((ASTVisitor)this);
            return 1;
        }
        if (this.isAssignment(node)) {
            return this.formatAssignment(node);
        }
        if (this.isOverloadedLeftShift(node)) {
            return this.formatOverloadedLeftShiftChain(node);
        }
        IASTExpression[] operands = CPPVisitor.getOperandsOfMultiExpression((IASTBinaryExpression)node);
        Runnable tailFormatter = RemoteCodeFormatterVisitor.endsWithMacroExpansion((IASTNode)node) ? null : this.scribe.takeTailFormatter();
        Alignment alignment = this.scribe.createAlignment("binaryExpression", this.preferences.alignment_for_binary_expression, 1, operands.length, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                int i = 0;
                while (i < operands.length) {
                    IASTExpression operand = operands[i];
                    if (i > 0 && this.getCurrentPosition() < RemoteCodeFormatterVisitor.nodeOffset((IASTNode)operand)) {
                        this.scribe.alignFragment(alignment, i);
                        int nextToken = this.peekNextToken();
                        boolean forceSpace = Character.isJavaIdentifierStart(this.peekNextChar());
                        switch (node.getOperator()) {
                            case 30: 
                            case 31: {
                                this.scribe.printNextToken(nextToken, false);
                                break;
                            }
                            default: {
                                this.scribe.printNextToken(nextToken, forceSpace || this.preferences.insert_space_before_binary_operator);
                                if (!forceSpace && !this.preferences.insert_space_after_binary_operator) break;
                                this.scribe.space();
                            }
                        }
                        this.scribe.printTrailingComment();
                    }
                    if (i == alignment.fragmentCount - 1) {
                        this.scribe.setTailFormatter(tailFormatter);
                    }
                    operand.accept((ASTVisitor)this);
                    this.scribe.restartAtOffset(RemoteCodeFormatterVisitor.nodeEndOffset((IASTNode)operand));
                    this.scribe.printTrailingComment();
                    ++i;
                }
                this.scribe.runTailFormatter();
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        return 1;
    }

    private int formatAssignment(IASTBinaryExpression node) {
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        IASTExpression op1 = node.getOperand1();
        op1.accept((ASTVisitor)this);
        if (this.getCurrentPosition() < RemoteCodeFormatterVisitor.nodeOffset((IASTNode)node.getOperand2())) {
            int nextToken = this.peekNextToken();
            boolean forceSpace = Character.isJavaIdentifierStart(this.peekNextChar());
            this.scribe.printNextToken(nextToken, forceSpace || this.preferences.insert_space_before_assignment_operator);
            if (forceSpace || this.preferences.insert_space_after_assignment_operator) {
                this.scribe.space();
            }
        }
        Alignment expressionAlignment = this.scribe.createAlignment("assignmentExpression", this.preferences.alignment_for_assignment, 2, 1, this.getCurrentPosition());
        this.scribe.enterAlignment(expressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(expressionAlignment, 0);
                this.scribe.setTailFormatter(tailFormatter);
                IASTExpression op2 = node.getOperand2();
                op2.accept((ASTVisitor)this);
                this.scribe.runTailFormatter();
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(expressionAlignment, true);
        return 1;
    }

    private boolean isAssignment(IASTBinaryExpression node) {
        switch (node.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private int formatOverloadedLeftShiftChain(IASTBinaryExpression binaryExpression) {
        IASTExpression node;
        ArrayList<IASTExpression> elements = new ArrayList<IASTExpression>();
        do {
            elements.add(binaryExpression.getOperand2());
        } while ((node = binaryExpression.getOperand1()) instanceof IASTBinaryExpression && this.isOverloadedLeftShift(binaryExpression = (IASTBinaryExpression)node));
        Collections.reverse(elements);
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        node.accept((ASTVisitor)this);
        this.scribe.printComment();
        if (this.preferences.insert_space_before_binary_operator) {
            this.scribe.space();
        }
        Alignment alignment = this.scribe.createAlignment("overloadedLeftShiftChain", this.preferences.alignment_for_overloaded_left_shift_chain, 1, elements.size(), this.getCurrentPosition(), this.preferences.continuation_indentation, false);
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                int i = 0;
                while (i < elements.size()) {
                    node = (IASTExpression)elements.get(i);
                    if (this.getCurrentPosition() < RemoteCodeFormatterVisitor.nodeOffset((IASTNode)node)) {
                        this.scribe.alignFragment(alignment, i);
                        int token = this.peekNextToken();
                        if (token == 40) {
                            this.scribe.printNextToken(token, this.preferences.insert_space_before_binary_operator);
                            this.scribe.printTrailingComment();
                            if (this.preferences.insert_space_after_binary_operator) {
                                this.scribe.space();
                            }
                        }
                    }
                    if (i == alignment.fragmentCount - 1) {
                        this.scribe.setTailFormatter(tailFormatter);
                    }
                    node.accept((ASTVisitor)this);
                    ++i;
                }
                this.scribe.runTailFormatter();
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
            catch (ASTProblemException aSTProblemException) {}
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        return 1;
    }

    private boolean isOverloadedLeftShift(IASTBinaryExpression node) {
        return node.getOperator() == 6 && node instanceof ICPPASTBinaryExpression && ((ICPPASTBinaryExpression)node).getOverload() != null;
    }

    private int visit(IASTLiteralExpression node) {
        block11: {
            if (node.getKind() == 3) {
                boolean needSpace = false;
                int line = this.scribe.line;
                boolean indented = false;
                int indentationLevel = this.scribe.indentationLevel;
                int numberOfIndentations = this.scribe.numberOfIndentations;
                try {
                    int[] stringLiterals = new int[]{129, 131, 133};
                    while (true) {
                        this.scribe.printNextToken(stringLiterals, needSpace);
                        int token = this.peekNextToken();
                        if (token != 129 && token != 131 && token != 133) {
                            break block11;
                        }
                        this.scribe.printCommentPreservingNewLines();
                        if (!indented && line != this.scribe.line) {
                            Alignment alignment = this.scribe.currentAlignment;
                            if (alignment != null && (alignment.mode & 2) != 0) {
                                this.scribe.indentationLevel = alignment.breakIndentationLevel;
                            } else if (alignment != null && (alignment.mode & 4) != 0) {
                                indented = true;
                                this.scribe.indent();
                            } else {
                                indented = true;
                                this.scribe.indentForContinuation();
                            }
                        }
                        needSpace = true;
                    }
                }
                finally {
                    this.scribe.indentationLevel = indentationLevel;
                    this.scribe.numberOfIndentations = numberOfIndentations;
                }
            }
            this.scribe.printNextToken(this.peekNextToken());
        }
        return 1;
    }

    private int visit(IASTFieldReference node) {
        IASTName fieldName;
        IASTExpression expr = node.getFieldOwner();
        if (expr != null) {
            Runnable tailFormatter = this.scribe.takeTailFormatter();
            try {
                expr.accept((ASTVisitor)this);
            }
            finally {
                this.scribe.setTailFormatter(tailFormatter);
            }
        }
        if ((fieldName = node.getFieldName()) != null) {
            Alignment alignment = this.scribe.createAlignment("fieldReference", this.preferences.alignment_for_member_access, 1, 1, this.getCurrentPosition());
            this.scribe.enterAlignment(alignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(alignment, 0);
                    this.scribe.printComment();
                    int token = this.peekNextToken();
                    if (token == 20 || token == 50) {
                        this.scribe.printNextToken(token, false);
                    }
                    this.scribe.printComment();
                    if (node instanceof ICPPASTFieldReference && ((ICPPASTFieldReference)node).isTemplate()) {
                        this.scribe.printNextToken(111);
                        this.scribe.space();
                    }
                    fieldName.accept((ASTVisitor)this);
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        }
        return 1;
    }

    private int visit(IASTArraySubscriptExpression node) {
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        try {
            node.getArrayExpression().accept((ASTVisitor)this);
            this.scribe.printNextToken(10, this.preferences.insert_space_before_opening_bracket);
            if (this.preferences.insert_space_after_opening_bracket) {
                this.scribe.space();
            }
            node.getArgument().accept((ASTVisitor)this);
            this.scribe.printNextToken(11, this.preferences.insert_space_before_closing_bracket);
        }
        finally {
            this.scribe.setTailFormatter(tailFormatter);
        }
        return 1;
    }

    private int visit(IASTTypeIdInitializerExpression node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        node.getTypeId().accept((ASTVisitor)this);
        String brace_position = this.preferences.brace_position_for_initializer_list;
        this.formatLeftCurlyBrace(line, brace_position);
        this.formatOpeningBrace(brace_position, this.preferences.insert_space_before_opening_brace_in_initializer_list);
        if (this.preferences.insert_new_line_after_opening_brace_in_initializer_list) {
            this.scribe.printNewLine();
        }
        if (this.preferences.insert_space_after_opening_brace_in_initializer_list) {
            this.scribe.space();
        }
        node.getInitializer().accept((ASTVisitor)this);
        if (this.preferences.insert_new_line_before_closing_brace_in_initializer_list) {
            this.scribe.startNewLine();
        }
        if (this.preferences.insert_space_before_closing_brace_in_initializer_list) {
            this.scribe.space();
        }
        this.formatClosingBrace(brace_position);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(ICPPASTNewExpression node) {
        IASTInitializer newInitializer;
        boolean expectParen;
        if (node.isGlobal()) {
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(92);
        this.scribe.space();
        IASTInitializerClause[] newPlacement = node.getPlacementArguments();
        if (newPlacement != null) {
            Runnable tailFormatter = this.scribe.takeTailFormatter();
            this.formatFunctionCallArguments(newPlacement);
            this.scribe.setTailFormatter(tailFormatter);
        }
        this.scribe.space();
        IASTTypeId typeId = node.getTypeId();
        boolean bl = expectParen = !node.isNewTypeId() && this.peekNextToken() == 8;
        if (expectParen) {
            this.scribe.printNextToken(8, false);
        }
        typeId.accept((ASTVisitor)this);
        if (expectParen) {
            this.scribe.printNextToken(9);
        }
        if ((newInitializer = node.getInitializer()) != null) {
            this.visit(newInitializer);
        }
        return 1;
    }

    private int visit(ICPPASTDeleteExpression node) {
        if (node.isGlobal()) {
            this.scribe.printNextToken(3);
        }
        this.scribe.printNextToken(72);
        if (node.isVectored()) {
            this.scribe.printNextToken(10, this.preferences.insert_space_before_opening_bracket);
            this.scribe.printNextToken(11, this.preferences.insert_space_between_empty_brackets);
        }
        this.scribe.space();
        node.getOperand().accept((ASTVisitor)this);
        return 1;
    }

    private int visit(ICPPASTSimpleTypeConstructorExpression node) {
        ICPPASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept((ASTVisitor)this);
        IASTInitializer initializer = node.getInitializer();
        initializer.accept((ASTVisitor)this);
        return 1;
    }

    private int visit(IASTContinueStatement node) {
        this.scribe.printNextToken(70);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTDoStatement node) {
        int token = this.peekNextToken();
        if (token == 73) {
            this.scribe.printNextToken(token);
        }
        int line = this.scribe.line;
        IASTStatement action = node.getBody();
        this.formatAction(line, action, this.preferences.brace_position_for_block);
        if (this.getCurrentPosition() < RemoteCodeFormatterVisitor.nodeEndOffset((IASTNode)node)) {
            if (this.peekNextToken() == 126) {
                if (this.preferences.insert_new_line_before_while_in_do_statement) {
                    this.scribe.startNewLine();
                }
                this.scribe.printNextToken(126, this.preferences.insert_space_after_closing_brace_in_block);
                this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_while);
                if (this.preferences.insert_space_after_opening_paren_in_while) {
                    this.scribe.space();
                }
                node.getCondition().accept((ASTVisitor)this);
                this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_while);
            }
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        }
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTNullStatement node) {
        if (!this.fInsideFor && RemoteCodeFormatterVisitor.nodeOffset((IASTNode)node) == this.getCurrentPosition()) {
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return 1;
    }

    private int visit(IASTDeclarationStatement node) {
        node.getDeclaration().accept((ASTVisitor)this);
        if (!this.fInsideFor) {
            this.scribe.startNewLine();
        }
        return 1;
    }

    private int visit(IASTExpressionStatement node) {
        TrailingSemicolonFormatter semicolonFormatter = null;
        if (!this.fInsideFor) {
            semicolonFormatter = new TrailingSemicolonFormatter((IASTNode)node);
            this.scribe.setTailFormatter(semicolonFormatter);
        }
        node.getExpression().accept((ASTVisitor)this);
        if (semicolonFormatter != null) {
            semicolonFormatter.run();
            this.scribe.setTailFormatter(null);
        }
        if (!this.fInsideFor) {
            this.scribe.startNewLine();
        }
        return 1;
    }

    private int visit(IASTForStatement node) {
        if (!RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)node)) {
            this.scribe.printNextToken(83);
        }
        int line = this.scribe.line;
        IASTStatement initializerStmt = node.getInitializerStatement();
        IASTStatement body = node.getBody();
        Runnable tailFormatter = null;
        if (!RemoteCodeFormatterVisitor.doNodesHaveSameOffset((IASTNode)node, (IASTNode)initializerStmt)) {
            this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_for);
            this.fInsideFor = true;
            if (this.preferences.insert_space_after_opening_paren_in_for) {
                this.scribe.space();
            }
            if ("end_of_line".equals(this.preferences.brace_position_for_block) && body instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)body)) {
                tailFormatter = new TrailingTokenFormatter(12, RemoteCodeFormatterVisitor.nodeOffset((IASTNode)body), this.preferences.insert_space_before_opening_brace_in_block, false);
            }
            tailFormatter = new ClosingParensesisTailFormatter(this.preferences.insert_space_before_closing_paren_in_for, tailFormatter);
        }
        initializerStmt.accept((ASTVisitor)this);
        if (this.peekNextToken() == 5) {
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon_in_for);
        }
        Alignment alignment = this.scribe.createAlignment("for", 16, 1, 2, this.getCurrentPosition());
        this.scribe.enterAlignment(alignment);
        boolean ok = false;
        do {
            try {
                try {
                    IASTDeclaration conditionDecl;
                    this.scribe.alignFragment(alignment, 0);
                    IASTExpression condition = node.getConditionExpression();
                    if (condition != null) {
                        if (this.preferences.insert_space_after_semicolon_in_for) {
                            this.scribe.space();
                        }
                        condition.accept((ASTVisitor)this);
                    } else if (node instanceof ICPPASTForStatement && (conditionDecl = ((ICPPASTForStatement)node).getConditionDeclaration()) != null) {
                        if (this.preferences.insert_space_after_semicolon_in_for) {
                            this.scribe.space();
                        }
                        conditionDecl.accept((ASTVisitor)this);
                    }
                    if (this.peekNextToken() == 5) {
                        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon_in_for);
                    }
                    this.scribe.setTailFormatter(tailFormatter);
                    this.scribe.alignFragment(alignment, 1);
                    IASTExpression iterationExpr = node.getIterationExpression();
                    if (iterationExpr != null) {
                        if (this.preferences.insert_space_after_semicolon_in_for) {
                            this.scribe.space();
                        }
                        iterationExpr.accept((ASTVisitor)this);
                    }
                    if (tailFormatter != null) {
                        this.scribe.runTailFormatter();
                        this.scribe.setTailFormatter(null);
                    }
                }
                finally {
                    this.fInsideFor = false;
                }
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(alignment, true);
        if (body instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)body)) {
            if (this.enterNode((IASTNode)body)) {
                try {
                    if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)body)) {
                        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                    }
                    this.formatBlock((IASTCompoundStatement)body, this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
                }
                finally {
                    this.exitNode((IASTNode)body);
                }
            }
        } else {
            this.formatAction(line, body, this.preferences.brace_position_for_block);
        }
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(ICPPASTRangeBasedForStatement node) {
        this.scribe.printNextToken(83);
        int line = this.scribe.line;
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_for);
        this.fInsideFor = true;
        try {
            if (this.preferences.insert_space_after_opening_paren_in_for) {
                this.scribe.space();
            }
            IASTDeclaration declaration = node.getDeclaration();
            declaration.accept((ASTVisitor)this);
            this.scribe.printNextToken(4, true);
            IASTInitializerClause initializer = node.getInitializerClause();
            this.scribe.space();
            initializer.accept((ASTVisitor)this);
        }
        finally {
            this.fInsideFor = false;
        }
        if (this.peekNextToken() == 9) {
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_for);
        }
        this.formatAction(line, node.getBody(), this.preferences.brace_position_for_block);
        return 1;
    }

    private int visit(IASTIfStatement node) {
        if (!RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)node)) {
            this.scribe.printNextToken(86);
        }
        int line = this.scribe.line;
        IASTExpression condition = node.getConditionExpression();
        if (condition == null && node instanceof ICPPASTIfStatement) {
            condition = ((ICPPASTIfStatement)node).getConditionDeclaration();
        }
        IASTStatement thenStatement = node.getThenClause();
        IASTStatement elseStatement = node.getElseClause();
        this.fExpectSemicolonAfterDeclaration = false;
        try {
            if (condition == null || !RemoteCodeFormatterVisitor.doNodesHaveSameOffset((IASTNode)node, (IASTNode)condition)) {
                this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_if);
                if (this.preferences.insert_space_after_opening_paren_in_if) {
                    this.scribe.space();
                }
                Runnable tailFormatter = null;
                if ("end_of_line".equals(this.preferences.brace_position_for_block) && thenStatement instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)thenStatement)) {
                    tailFormatter = new TrailingTokenFormatter(12, RemoteCodeFormatterVisitor.nodeOffset((IASTNode)thenStatement), this.preferences.insert_space_before_opening_brace_in_block, false);
                }
                tailFormatter = new ClosingParensesisTailFormatter(this.preferences.insert_space_before_closing_paren_in_if, tailFormatter);
                this.scribe.setTailFormatter(tailFormatter);
                if (condition == null || condition instanceof IASTProblemHolder) {
                    this.scribe.skipToToken(9);
                } else {
                    condition.accept((ASTVisitor)this);
                }
                this.scribe.runTailFormatter();
                this.scribe.setTailFormatter(null);
            } else if (!(condition instanceof IASTProblemHolder)) {
                condition.accept((ASTVisitor)this);
            }
        }
        finally {
            this.fExpectSemicolonAfterDeclaration = true;
        }
        boolean thenStatementIsBlock = false;
        if (thenStatement != null) {
            if (condition != null && RemoteCodeFormatterVisitor.doNodeLocationsOverlap((IASTNode)condition, (IASTNode)thenStatement)) {
                thenStatement.accept((ASTVisitor)this);
            } else if (thenStatement instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)thenStatement)) {
                IASTCompoundStatement block = (IASTCompoundStatement)thenStatement;
                thenStatementIsBlock = true;
                List<IASTStatement> statements = Arrays.asList(block.getStatements());
                if (this.isGuardClause(block, statements) && elseStatement == null && this.preferences.keep_guardian_clause_on_one_line) {
                    if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)thenStatement)) {
                        this.scribe.printNextToken(12, this.preferences.insert_space_before_opening_brace_in_block);
                        this.scribe.space();
                    }
                    statements.get(0).accept((ASTVisitor)this);
                    this.scribe.printNextToken(13, true);
                    this.scribe.printTrailingComment();
                } else {
                    if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)thenStatement)) {
                        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                    }
                    thenStatement.accept((ASTVisitor)this);
                    if (elseStatement != null && this.preferences.insert_new_line_before_else_in_if_statement) {
                        this.scribe.startNewLine();
                    }
                }
            } else {
                if (RemoteCodeFormatterVisitor.doNodesHaveSameOffset((IASTNode)node, (IASTNode)thenStatement)) {
                    this.enterNode((IASTNode)thenStatement);
                }
                if (elseStatement == null && this.preferences.keep_simple_if_on_one_line) {
                    Alignment compactIfAlignment = this.scribe.createAlignment("compactIf", this.preferences.alignment_for_compact_if, 1, 1, this.getCurrentPosition(), 1, false);
                    this.scribe.enterAlignment(compactIfAlignment);
                    boolean ok = false;
                    do {
                        try {
                            this.scribe.alignFragment(compactIfAlignment, 0);
                            this.scribe.space();
                            thenStatement.accept((ASTVisitor)this);
                            ok = true;
                        }
                        catch (AlignmentException e) {
                            this.scribe.redoAlignment(e);
                        }
                    } while (!ok);
                    this.scribe.exitAlignment(compactIfAlignment, true);
                } else if (this.preferences.keep_then_statement_on_same_line) {
                    this.scribe.space();
                    thenStatement.accept((ASTVisitor)this);
                    if (elseStatement != null) {
                        this.scribe.startNewLine();
                    }
                } else if (thenStatement instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.enclosedInMacroExpansion((IASTNode)thenStatement)) {
                    thenStatement.accept((ASTVisitor)this);
                } else {
                    this.scribe.printTrailingComment();
                    this.scribe.startNewLine();
                    this.scribe.indent();
                    thenStatement.accept((ASTVisitor)this);
                    if (elseStatement != null) {
                        this.scribe.startNewLine();
                    }
                    this.scribe.unIndent();
                }
            }
        }
        if (elseStatement != null) {
            if (condition != null && RemoteCodeFormatterVisitor.doNodeLocationsOverlap((IASTNode)condition, (IASTNode)elseStatement)) {
                elseStatement.accept((ASTVisitor)this);
            } else {
                if (this.peekNextToken() == 76) {
                    if (thenStatementIsBlock) {
                        this.scribe.printNextToken(76, this.preferences.insert_space_after_closing_brace_in_block);
                    } else {
                        this.scribe.printNextToken(76, true);
                    }
                }
                if (elseStatement instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.enclosedInMacroExpansion((IASTNode)elseStatement)) {
                    elseStatement.accept((ASTVisitor)this);
                } else if (elseStatement instanceof IASTIfStatement) {
                    if (!this.preferences.compact_else_if) {
                        this.scribe.startNewLine();
                        this.scribe.indent();
                    }
                    this.scribe.space();
                    elseStatement.accept((ASTVisitor)this);
                    if (!this.preferences.compact_else_if) {
                        this.scribe.unIndent();
                    }
                } else if (this.preferences.keep_else_statement_on_same_line) {
                    this.scribe.space();
                    elseStatement.accept((ASTVisitor)this);
                } else {
                    this.scribe.startNewLine();
                    this.scribe.indent();
                    elseStatement.accept((ASTVisitor)this);
                    this.scribe.unIndent();
                }
            }
        }
        return 1;
    }

    private int visit(ICPPASTQualifiedName node) {
        if (node.isFullyQualified()) {
            this.scribe.printNextToken(3);
        }
        IASTName[] names = node.getNames();
        int i = 0;
        while (i < names.length - 1) {
            names[i].accept((ASTVisitor)this);
            this.scribe.printNextToken(3);
            ++i;
        }
        if (this.peekNextToken() == 34) {
            this.scribe.printNextToken(34, false);
        }
        names[names.length - 1].accept((ASTVisitor)this);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int visit(ICPPASTTemplateId node) {
        IASTName name = node.getTemplateName();
        name.accept((ASTVisitor)this);
        this.scribe.printNextToken(42, this.preferences.insert_space_before_opening_angle_bracket_in_template_arguments);
        if (this.preferences.insert_space_after_opening_angle_bracket_in_template_arguments) {
            this.scribe.space();
        }
        int angleBrackets = this.fOpenAngleBrackets++;
        IASTNode[] templateArguments = node.getTemplateArguments();
        if (templateArguments.length > 0) {
            ListOptions options = new ListOptions(16);
            options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_template_arguments;
            options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_template_arguments;
            options.fTieBreakRule = 1;
            this.formatList(Arrays.asList(templateArguments), options, false, false, null);
        }
        if (this.peekNextToken() == 44) {
            if (this.fOpenAngleBrackets != angleBrackets + 2) {
                this.scribe.printComment();
                if (!this.preferences.insert_space_before_closing_angle_bracket_in_template_arguments) return 1;
                this.scribe.space();
                return 1;
            }
            this.fOpenAngleBrackets -= 2;
            this.scribe.printNextToken(44, this.preferences.insert_space_before_closing_angle_bracket_in_template_arguments);
        } else {
            --this.fOpenAngleBrackets;
            this.scribe.printNextToken(46, this.preferences.insert_space_before_closing_angle_bracket_in_template_arguments);
        }
        int nextToken = this.peekNextToken();
        if (node.getPropertyInParent() == ICPPASTQualifiedName.SEGMENT_NAME) {
            if (nextToken != 46) return 1;
        }
        if (nextToken == 8) {
            if (!this.preferences.insert_space_before_opening_paren_in_method_invocation) return 1;
            this.scribe.space();
            return 1;
        }
        if (this.preferences.insert_space_after_closing_angle_bracket_in_template_arguments) {
            if (nextToken == 23) return 1;
            if (nextToken == 30) return 1;
            this.scribe.space();
            return 1;
        }
        this.scribe.printComment();
        this.scribe.needSpace = false;
        this.scribe.pendingSpace = false;
        return 1;
    }

    private int visit(IASTReturnStatement node) {
        this.scribe.printNextToken(103);
        IASTExpression expression = node.getReturnValue();
        if (expression != null) {
            this.scribe.space();
            expression.accept((ASTVisitor)this);
        }
        if (expression == null && this.peekNextToken() != 5) {
            this.scribe.skipToToken(5);
        }
        if (this.peekNextToken() == 5) {
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return 1;
    }

    private int visit(IASTLabelStatement node) {
        node.getName().accept((ASTVisitor)this);
        this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_labeled_statement);
        if (this.preferences.insert_space_after_colon_in_labeled_statement) {
            this.scribe.space();
        }
        node.getNestedStatement().accept((ASTVisitor)this);
        return 1;
    }

    private int visit(IASTCaseStatement node) {
        IASTExpression constant = node.getExpression();
        if (constant == null) {
            this.scribe.printNextToken(71);
            this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_default);
        } else {
            this.scribe.printNextToken(62);
            this.scribe.space();
            constant.accept((ASTVisitor)this);
            this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_case);
        }
        return 1;
    }

    private int visit(IASTDefaultStatement node) {
        this.scribe.printNextToken(71);
        this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_default);
        return 1;
    }

    private int visit(IASTSwitchStatement node) {
        IASTExpression controllerExpression;
        int headerIndent = this.scribe.numberOfIndentations;
        if (!RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)node)) {
            this.scribe.printNextToken(110);
        }
        if (!RemoteCodeFormatterVisitor.doNodesHaveSameOffset((IASTNode)node, (IASTNode)(controllerExpression = node.getControllerExpression()))) {
            this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_switch);
            if (this.preferences.insert_space_after_opening_paren_in_switch) {
                this.scribe.space();
            }
        }
        controllerExpression.accept((ASTVisitor)this);
        if (this.peekNextToken() == 9) {
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_switch);
        }
        String brace_position = this.preferences.brace_position_for_switch;
        int braceIndent = -1;
        IASTStatement bodyStmt = node.getBody();
        if (!RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)bodyStmt)) {
            this.formatOpeningBrace(brace_position, this.preferences.insert_space_before_opening_brace_in_switch);
            this.scribe.startNewLine();
            braceIndent = this.scribe.numberOfIndentations;
            if (braceIndent > headerIndent) {
                this.scribe.unIndent();
            }
            if (this.preferences.indent_switchstatements_compare_to_switch) {
                this.scribe.indent();
            }
        }
        List<IASTStatement> statements = bodyStmt instanceof IASTCompoundStatement ? Arrays.asList(((IASTCompoundStatement)bodyStmt).getStatements()) : Collections.singletonList(bodyStmt);
        if (!this.enterNode((IASTNode)bodyStmt)) {
            return 1;
        }
        try {
            int statementsLength = statements.size();
            if (statementsLength != 0) {
                boolean wasACase = false;
                boolean wasAStatement = false;
                int i = 0;
                while (i < statementsLength) {
                    IASTStatement statement = statements.get(i);
                    if (RemoteCodeFormatterVisitor.doNodeLocationsOverlap((IASTNode)controllerExpression, (IASTNode)statement)) {
                        statement.accept((ASTVisitor)this);
                    } else {
                        if (statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement) {
                            if (wasACase) {
                                this.scribe.startNewLine();
                            }
                            if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.unIndent();
                            }
                            statement.accept((ASTVisitor)this);
                            this.scribe.printTrailingComment();
                            wasACase = true;
                            wasAStatement = false;
                            if (this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.indent();
                            }
                        } else if (statement instanceof IASTBreakStatement) {
                            if (this.preferences.indent_breaks_compare_to_cases) {
                                if (!this.preferences.indent_switchstatements_compare_to_cases) {
                                    this.scribe.indent();
                                }
                            } else if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.unIndent();
                            }
                            if (wasACase) {
                                this.scribe.startNewLine();
                            }
                            statement.accept((ASTVisitor)this);
                            if (this.preferences.indent_breaks_compare_to_cases) {
                                if (!this.preferences.indent_switchstatements_compare_to_cases) {
                                    this.scribe.unIndent();
                                }
                            } else if (this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.indent();
                            }
                            wasACase = false;
                            wasAStatement = true;
                        } else if (statement instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)statement)) {
                            block57: {
                                IASTStatement nextStatement;
                                String bracePosition;
                                if (wasACase) {
                                    block55: {
                                        if (this.preferences.indent_switchstatements_compare_to_cases) {
                                            this.scribe.unIndent();
                                        }
                                        bracePosition = this.preferences.brace_position_for_block_in_case;
                                        try {
                                            try {
                                                this.enterNode((IASTNode)statement);
                                                this.formatBlock((IASTCompoundStatement)statement, bracePosition, this.preferences.insert_space_after_colon_in_case, this.preferences.indent_statements_compare_to_block);
                                            }
                                            catch (ASTProblemException aSTProblemException) {
                                                if (i < statementsLength - 1) {
                                                    nextStatement = statements.get(i + 1);
                                                    this.skipToNode((IASTNode)nextStatement);
                                                }
                                                this.exitNode((IASTNode)statement);
                                                break block55;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            this.exitNode((IASTNode)statement);
                                            throw throwable;
                                        }
                                        this.exitNode((IASTNode)statement);
                                    }
                                    if (this.preferences.indent_switchstatements_compare_to_cases) {
                                        this.scribe.indent();
                                    }
                                } else {
                                    bracePosition = this.preferences.brace_position_for_block;
                                    try {
                                        try {
                                            this.enterNode((IASTNode)statement);
                                            this.formatBlock((IASTCompoundStatement)statement, bracePosition, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
                                        }
                                        catch (ASTProblemException aSTProblemException) {
                                            if (i < statementsLength - 1) {
                                                nextStatement = statements.get(i + 1);
                                                this.skipToNode((IASTNode)nextStatement);
                                            }
                                            this.exitNode((IASTNode)statement);
                                            break block57;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        this.exitNode((IASTNode)statement);
                                        throw throwable;
                                    }
                                    this.exitNode((IASTNode)statement);
                                }
                            }
                            wasAStatement = true;
                            wasACase = false;
                        } else {
                            block58: {
                                this.scribe.startNewLine();
                                try {
                                    statement.accept((ASTVisitor)this);
                                }
                                catch (ASTProblemException aSTProblemException) {
                                    if (i >= statementsLength - 1) break block58;
                                    IASTStatement nextStatement = statements.get(i + 1);
                                    this.skipToNode((IASTNode)nextStatement);
                                }
                            }
                            wasAStatement = true;
                            wasACase = false;
                        }
                        if (!wasACase) {
                            this.scribe.startNewLine();
                        }
                        this.scribe.printComment();
                    }
                    ++i;
                }
                if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                    this.scribe.unIndent();
                }
            }
            if (!RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)bodyStmt)) {
                if (this.preferences.indent_switchstatements_compare_to_switch) {
                    this.scribe.unIndent();
                }
                if (this.scribe.numberOfIndentations < braceIndent) {
                    this.scribe.indent();
                }
                this.scribe.startNewLine();
                this.formatClosingBrace(brace_position);
            }
        }
        finally {
            this.exitNode((IASTNode)bodyStmt);
        }
        return 1;
    }

    private int visit(IASTWhileStatement node) {
        IASTDeclaration conditionDecl;
        IASTExpression condition;
        this.scribe.printNextToken(126);
        int line = this.scribe.line;
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_while);
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.scribe.space();
        }
        if ((condition = node.getCondition()) != null) {
            condition.accept((ASTVisitor)this);
        } else if (node instanceof ICPPASTWhileStatement && (conditionDecl = ((ICPPASTWhileStatement)node).getConditionDeclaration()) != null) {
            conditionDecl.accept((ASTVisitor)this);
        }
        if (this.peekNextToken() == 9) {
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_while);
        }
        this.formatAction(line, node.getBody(), this.preferences.brace_position_for_block);
        return 1;
    }

    private int visit(IASTProblemStatement node) {
        throw new ASTProblemException(node.getProblem());
    }

    private int visit(IASTProblemExpression node) {
        throw new ASTProblemException(node.getProblem());
    }

    private int visit(IASTProblemDeclaration node) {
        throw new ASTProblemException(node.getProblem());
    }

    private void formatRaw(IASTNode node) {
        this.scribe.printComment();
        this.skipNode(node);
    }

    private void exitAlignments() {
        while (this.scribe.currentAlignment != null) {
            this.scribe.exitAlignment(this.scribe.currentAlignment, true);
        }
    }

    private boolean enterNode(IASTNode node) {
        this.scribe.enterNode();
        if (node instanceof IASTProblemHolder) {
            return false;
        }
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length != 0) {
            if (locations[0] instanceof IASTMacroExpansionLocation) {
                IASTMacroExpansionLocation location = (IASTMacroExpansionLocation)locations[0];
                if (locations.length <= 2 && node instanceof IASTStatement) {
                    IASTPreprocessorMacroExpansion macroExpansion = location.getExpansion();
                    IASTFileLocation macroLocation = macroExpansion.getFileLocation();
                    IASTFileLocation nodeLocation = node.getFileLocation();
                    if (macroLocation.getNodeOffset() >= this.getCurrentPosition() && !this.scribe.shouldSkip(macroLocation.getNodeOffset()) && (nodeLocation.getNodeOffset() + nodeLocation.getNodeLength() == macroLocation.getNodeOffset() + macroLocation.getNodeLength() || locations.length == 2 && this.isSemicolonLocation(locations[1])) && this.isFunctionStyleMacroExpansion(macroExpansion)) {
                        this.formatFunctionStyleMacroExpansion(macroExpansion);
                        return false;
                    }
                }
                IASTFileLocation expansionLocation = location.asFileLocation();
                int startOffset = expansionLocation.getNodeOffset();
                int endOffset = startOffset + expansionLocation.getNodeLength();
                this.scribe.skipRange(startOffset, endOffset);
                if (locations.length == 1 && endOffset <= this.getCurrentPosition()) {
                    this.scribe.restartAtOffset(endOffset);
                    this.continueNode(node.getParent());
                    return false;
                }
            } else {
                IASTFileLocation fileLocation = node.getFileLocation();
                this.scribe.restartAtOffset(fileLocation.getNodeOffset());
            }
        }
        return true;
    }

    private void exitNode(IASTNode node) {
        if (node instanceof IASTProblemHolder) {
            return;
        }
        if (this.scribe.skipRange()) {
            IASTFileLocation fileLocation = node.getFileLocation();
            if (fileLocation != null) {
                int nodeEndOffset = fileLocation.getNodeOffset() + fileLocation.getNodeLength();
                this.scribe.restartAtOffset(nodeEndOffset);
            }
        } else if (this.scribe.currentAlignmentException == null) {
            this.skipNode(node);
        }
        this.continueNode(node.getParent());
    }

    private void continueNode(IASTNode node) {
        if (node instanceof IASTProblemHolder || node instanceof IASTTranslationUnit) {
            return;
        }
        IASTFileLocation fileLocation = node.getFileLocation();
        if (fileLocation == null) {
            return;
        }
        int nodeOffset = fileLocation.getNodeOffset();
        int nodeEndOffset = nodeOffset + fileLocation.getNodeLength();
        int currentOffset = this.getCurrentPosition();
        if (currentOffset > nodeEndOffset) {
            return;
        }
        IASTNodeLocation[] locations = node.getNodeLocations();
        int i = 0;
        while (i < locations.length) {
            IASTNodeLocation nodeLocation = locations[i];
            if (nodeLocation instanceof IASTMacroExpansionLocation) {
                IASTFileLocation expansionLocation = nodeLocation.asFileLocation();
                int startOffset = expansionLocation.getNodeOffset();
                int endOffset = startOffset + expansionLocation.getNodeLength();
                if (currentOffset <= startOffset) break;
                if (currentOffset < endOffset || currentOffset == endOffset && i == locations.length - 1) {
                    this.scribe.skipRange(startOffset, endOffset);
                    break;
                }
            }
            ++i;
        }
    }

    private int getNextTokenOffset() {
        this.localScanner.resetTo(this.getCurrentPosition(), this.scribe.scannerEndPosition);
        this.localScanner.getNextToken();
        return this.localScanner.getCurrentTokenStartPosition();
    }

    private void skipNode(IASTNode node) {
        int currentOffset;
        int endOffset;
        int restLength;
        IASTFileLocation fileLocation = node.getFileLocation();
        if (fileLocation != null && fileLocation.getNodeLength() > 0 && (restLength = (endOffset = fileLocation.getNodeOffset() + fileLocation.getNodeLength()) - (currentOffset = this.getCurrentPosition())) > 0) {
            this.scribe.printRaw(currentOffset, restLength);
        }
    }

    private void skipToNode(IASTNode node) {
        int currentOffset;
        int startOffset;
        int restLength;
        IASTFileLocation fileLocation = node.getFileLocation();
        if (fileLocation != null && (restLength = (startOffset = fileLocation.getNodeOffset()) - (currentOffset = this.getCurrentPosition())) > 0) {
            this.scribe.printRaw(currentOffset, restLength);
        }
    }

    private void skipNonWhitespaceToNode(IASTNode node) {
        IASTFileLocation fileLocation = node.getFileLocation();
        if (fileLocation != null) {
            int currentOffset;
            int restLength;
            int startOffset = fileLocation.getNodeOffset();
            int nextTokenOffset = this.getNextTokenOffset();
            if (nextTokenOffset < startOffset && (restLength = startOffset - (currentOffset = this.getCurrentPosition())) > 0) {
                this.scribe.printRaw(currentOffset, restLength);
            }
        }
    }

    private void formatParenthesizedExpression(IASTExpression operand) {
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_parenthesized_expression);
        if (this.preferences.insert_space_after_opening_paren_in_parenthesized_expression) {
            this.scribe.space();
        }
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        try {
            if (operand != null) {
                operand.accept((ASTVisitor)this);
            }
        }
        finally {
            this.scribe.setTailFormatter(tailFormatter);
        }
        if (this.peekNextToken() != 9 && !RemoteCodeFormatterVisitor.enclosedInMacroExpansion((IASTNode)operand)) {
            this.scribe.skipToToken(9);
        }
        if (this.peekNextToken() == 9) {
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_parenthesized_expression);
        }
    }

    private void formatAction(int line, IASTStatement stmt, String brace_position) {
        if (stmt != null) {
            if (stmt instanceof IASTCompoundStatement && !RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)stmt)) {
                this.formatLeftCurlyBrace(line, brace_position);
                if (this.enterNode((IASTNode)stmt)) {
                    try {
                        this.formatBlock((IASTCompoundStatement)stmt, brace_position, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
                    }
                    finally {
                        this.exitNode((IASTNode)stmt);
                    }
                }
            } else if (stmt instanceof IASTNullStatement) {
                this.scribe.indent();
                if (this.preferences.put_empty_statement_on_new_line) {
                    this.scribe.startNewLine();
                }
                stmt.accept((ASTVisitor)this);
                this.scribe.unIndent();
            } else {
                boolean indented = false;
                if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)stmt)) {
                    this.scribe.printTrailingComment();
                    this.scribe.startNewLine();
                    this.scribe.indent();
                    indented = true;
                }
                stmt.accept((ASTVisitor)this);
                if (indented) {
                    this.scribe.unIndent();
                }
            }
        }
    }

    private static boolean startsWithMacroExpansion(IASTNode node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (!(node instanceof IASTProblemHolder) && locations.length != 0 && locations[0] instanceof IASTMacroExpansionLocation) {
            IASTFileLocation expansionLocation = locations[0].asFileLocation();
            IASTFileLocation fileLocation = node.getFileLocation();
            return expansionLocation.getNodeOffset() == fileLocation.getNodeOffset();
        }
        return false;
    }

    private static boolean endsWithMacroExpansion(IASTNode node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        return !(node instanceof IASTProblemHolder) && locations.length != 0 && locations[locations.length - 1] instanceof IASTMacroExpansionLocation;
    }

    private static boolean enclosedInMacroExpansion(IASTNode node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        return locations.length == 1 && locations[0] instanceof IASTMacroExpansionLocation;
    }

    private static boolean withinMacroExpansion(IASTNode node, int offset) {
        IASTNodeLocation[] locations;
        IASTFileLocation loc = node.getFileLocation();
        if (loc == null || offset < loc.getNodeOffset() || offset >= loc.getNodeOffset() + loc.getNodeLength()) {
            return false;
        }
        IASTNodeLocation[] iASTNodeLocationArray = locations = node.getNodeLocations();
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNodeLocation location = iASTNodeLocationArray[n2];
            IASTFileLocation fileLocation = location.asFileLocation();
            if (fileLocation != null) {
                int nodeOffset = fileLocation.getNodeOffset();
                int endOffset = nodeOffset + fileLocation.getNodeLength();
                if (offset >= nodeOffset && offset < endOffset) {
                    return location instanceof IASTMacroExpansionLocation;
                }
            }
            ++n2;
        }
        return true;
    }

    private int getCurrentPosition() {
        return this.scribe.scanner.getCurrentPosition();
    }

    private boolean looksLikeStatement(IASTMacroExpansionLocation location) {
        int c;
        IASTFileLocation fileLocation = location.asFileLocation();
        if (fileLocation == null) {
            return false;
        }
        int pos = fileLocation.getNodeOffset() + fileLocation.getNodeLength();
        this.localScanner.resetTo(pos, this.scribe.scannerEndPosition);
        Token token = this.localScanner.nextToken();
        if (token == null || token.getType() != 5) {
            return false;
        }
        this.localScanner.resetTo(pos, token.getOffset());
        while ((c = this.localScanner.getNextChar()) != -1) {
            if (c != 10) continue;
            return false;
        }
        return true;
    }

    private static boolean doNodeLocationsOverlap(IASTNode node1, IASTNode node2) {
        IASTFileLocation loc1 = node1.getFileLocation();
        IASTFileLocation loc2 = node2.getFileLocation();
        return loc1.getNodeOffset() + loc1.getNodeLength() > loc2.getNodeOffset() && loc1.getNodeOffset() < loc2.getNodeOffset() + loc2.getNodeLength();
    }

    private static boolean doNodesHaveSameOffset(IASTNode node1, IASTNode node2) {
        return RemoteCodeFormatterVisitor.nodeOffset(node1) == RemoteCodeFormatterVisitor.nodeOffset(node2);
    }

    private static int nodeOffset(IASTNode node) {
        return node.getFileLocation().getNodeOffset();
    }

    private static int nodeEndOffset(IASTNode node) {
        IASTFileLocation loc = node.getFileLocation();
        return loc.getNodeOffset() + loc.getNodeLength();
    }

    private void formatBlock(IASTCompoundStatement block, String block_brace_position, boolean insertSpaceBeforeOpeningBrace, boolean indentStatements) {
        this.formatBlockOpening(block, block_brace_position, insertSpaceBeforeOpeningBrace);
        this.formatOpenedBlock(block, block_brace_position, indentStatements);
    }

    private void formatBlockOpening(IASTCompoundStatement block, String block_brace_position, boolean insertSpaceBeforeOpeningBrace) {
        if (RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)block)) {
            if (!this.looksLikeStatement((IASTMacroExpansionLocation)block.getNodeLocations()[0])) {
                this.scribe.startNewLine();
                this.scribe.printComment();
            }
        } else if (this.getCurrentPosition() <= RemoteCodeFormatterVisitor.nodeOffset((IASTNode)block)) {
            this.formatOpeningBrace(block_brace_position, insertSpaceBeforeOpeningBrace);
        }
    }

    private void formatOpenedBlock(IASTCompoundStatement block, String block_brace_position, boolean indentStatements) {
        boolean startsWithStatementLikeMacro = RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)block) && this.looksLikeStatement((IASTMacroExpansionLocation)block.getNodeLocations()[0]);
        boolean endsWithMacroExpansion = RemoteCodeFormatterVisitor.endsWithMacroExpansion((IASTNode)block);
        IASTStatement[] statements = block.getStatements();
        int statementsLength = statements.length;
        if (statementsLength != 0) {
            if (!startsWithStatementLikeMacro) {
                this.scribe.startNewLine();
                if (indentStatements) {
                    this.scribe.indent();
                }
            }
            this.formatStatements(Arrays.asList(statements), !endsWithMacroExpansion);
        } else if (!startsWithStatementLikeMacro) {
            if (this.preferences.insert_new_line_in_empty_block) {
                this.scribe.startNewLine();
            }
            if (indentStatements) {
                this.scribe.indent();
            }
        }
        this.scribe.printComment();
        if (indentStatements && !startsWithStatementLikeMacro) {
            this.scribe.unIndent();
        }
        if (!endsWithMacroExpansion) {
            this.formatClosingBrace(block_brace_position);
        } else if (!RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)block) && "next_line_shifted".equals(block_brace_position)) {
            this.scribe.unIndent();
        }
    }

    private void formatLeftCurlyBrace(int line, String bracePosition) {
        this.scribe.formatBrace = true;
        try {
            this.scribe.printComment();
            if ("next_line_on_wrap".equals(bracePosition) && (this.scribe.line > line || this.scribe.column >= this.preferences.page_width)) {
                this.scribe.startNewLine();
            }
        }
        finally {
            this.scribe.formatBrace = false;
        }
    }

    private void formatOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace) {
        if ("next_line".equals(bracePosition)) {
            this.scribe.startNewLine();
        } else if ("next_line_shifted".equals(bracePosition)) {
            this.scribe.startNewLine();
            this.scribe.indent();
        }
        int token = this.peekNextToken();
        if (token == 12) {
            this.scribe.printNextToken(token, insertSpaceBeforeBrace);
        }
        this.scribe.printTrailingComment();
    }

    private void formatClosingBrace(String brace_position) {
        int token = this.peekNextToken();
        if (token == 13) {
            this.scribe.printNextToken(token);
        }
        this.scribe.printTrailingComment();
        if ("next_line_shifted".equals(brace_position)) {
            this.scribe.unIndent();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void formatStatements(List<IASTStatement> statements, boolean insertNewLineAfterLastStatement) {
        statementsLength = statements.size();
        if (statementsLength > 1) {
            firstStatement = statements.get(0);
            try {
                firstStatement.accept((ASTVisitor)this);
            }
            catch (ASTProblemException v0) {
                this.skipToNode((IASTNode)statements.get(1));
            }
            indentLevel = this.scribe.indentationLevel;
            i = 1;
            while (i < statementsLength - 1) {
                block14: {
                    statement = statements.get(i);
                    if (!(statement instanceof IASTNullStatement) && !RemoteCodeFormatterVisitor.doNodeLocationsOverlap((IASTNode)statement, (IASTNode)statements.get(i - 1))) {
                        this.scribe.startNewLine();
                    }
                    if (this.enterNode((IASTNode)statement)) {
                        try {
                            statement.accept((ASTVisitor)this);
                            break block14;
                        }
                        catch (RuntimeException e) {
                            if (i >= statementsLength - 1) {
                                throw e;
                            }
                            this.reportFormattingProblem(e);
                            this.exitAlignments();
                            this.skipToNode((IASTNode)statements.get(i + 1));
                            ** while (this.scribe.indentationLevel < indentLevel)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.scribe.indent();
                            continue;
                        }
lbl30:
                        // 2 sources

                        while (this.scribe.indentationLevel > indentLevel) {
                            this.scribe.unIndent();
                        }
                    }
                }
                ++i;
            }
            statement = statements.get(statementsLength - 1);
            if (!(statement instanceof IASTNullStatement || RemoteCodeFormatterVisitor.startsWithMacroExpansion((IASTNode)statement) && this.looksLikeStatement((IASTMacroExpansionLocation)statement.getNodeLocations()[0]))) {
                this.scribe.startNewLine();
            }
            statement.accept((ASTVisitor)this);
        } else {
            statement = statements.get(0);
            statement.accept((ASTVisitor)this);
        }
        if (insertNewLineAfterLastStatement) {
            this.scribe.startNewLine();
        }
    }

    private boolean commentStartsBlock(int start, int end) {
        this.localScanner.resetTo(start, end);
        if (this.localScanner.getNextToken() == 12) {
            switch (this.localScanner.getNextToken()) {
                case 1001: 
                case 1002: {
                    return true;
                }
            }
        }
        return false;
    }

    private char peekNextChar() {
        char[] text;
        if (this.peekNextToken() != 1006 && (text = this.localScanner.getCurrentTokenSource()).length > 0) {
            return text[0];
        }
        return '\u0000';
    }

    private int peekTokenAtPosition(int pos) {
        this.localScanner.resetTo(pos, this.scribe.scannerEndPosition);
        int token = this.localScanner.getNextToken();
        while (token == 1002 || token == 1001) {
            token = this.localScanner.getNextToken();
        }
        return token;
    }

    private int peekNextToken() {
        return this.peekNextToken(false);
    }

    private int peekNextToken(boolean ignoreSkip) {
        if (!ignoreSkip && this.scribe.shouldSkip(this.getCurrentPosition())) {
            return 1006;
        }
        this.localScanner.resetTo(this.getCurrentPosition(), this.scribe.scannerEndPosition);
        int token = this.localScanner.getNextToken();
        while (token == 1002 || token == 1001) {
            token = this.localScanner.getNextToken();
        }
        return token;
    }

    private boolean isSemicolonLocation(IASTNodeLocation location) {
        return location instanceof IASTFileLocation && location.getNodeLength() == 1 && this.peekTokenAtPosition(location.getNodeOffset()) == 5 && this.localScanner.getCurrentTokenEndPosition() + 1 == location.getNodeOffset() + location.getNodeLength();
    }

    private boolean isSemicolonAtPosition(int pos) {
        return this.peekTokenAtPosition(pos) == 5 && this.localScanner.getCurrentTokenStartPosition() == pos;
    }

    private boolean isGuardClause(IASTCompoundStatement block, List<IASTStatement> statements) {
        int blockLength;
        IASTFileLocation fileLocation = block.getFileLocation();
        if (fileLocation == null) {
            return false;
        }
        int blockStartPosition = RemoteCodeFormatterVisitor.nodeOffset((IASTNode)block);
        if (this.commentStartsBlock(blockStartPosition, blockLength = block.getFileLocation().getNodeLength())) {
            return false;
        }
        int statementsLength = statements.size();
        if (statementsLength != 1) {
            return false;
        }
        return statements.get(0) instanceof IASTReturnStatement;
    }

    private static List<Position> collectInactiveCodePositions(IASTTranslationUnit translationUnit) {
        IASTPreprocessorStatement[] preprocStmts;
        if (translationUnit == null) {
            return Collections.emptyList();
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.emptyList();
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = translationUnit.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation nodeLocation;
            IASTPreprocessorStatement preprocStmt = iASTPreprocessorStatementArray[n2];
            IASTPreprocessorStatement statement = preprocStmt;
            if (statement.isPartOfTranslationUnitFile() && (nodeLocation = statement.getFileLocation()) != null) {
                int inactiveCodeEnd;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = nodeLocation.getNodeOffset();
                        positions.add(new Position(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = nodeLocation.getNodeOffset();
                        positions.add(new Position(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = nodeLocation.getNodeOffset();
                            positions.add(new Position(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart));
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {}
                }
            }
            ++n2;
        }
        return positions;
    }

    private boolean hasMemberInitializers(IASTFunctionDefinition node) {
        return node instanceof ICPPASTFunctionDefinition && ((ICPPASTFunctionDefinition)node).getMemberInitializers().length > 0;
    }

    private int findTokenWithinNode(int tokenType, IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int endOffset = location.getNodeOffset() + location.getNodeLength();
        return this.scribe.findToken(tokenType, endOffset);
    }

    private int findTokenAfterNode(int tokenType, IASTNode node) {
        IASTFileLocation location = node.getFileLocation();
        int startOffset = location.getNodeOffset() + location.getNodeLength();
        return this.scribe.findToken(tokenType, startOffset, this.scribe.scannerEndPosition - 1);
    }

    private static class ASTProblemException
    extends RuntimeException {
        ASTProblemException(IASTProblem problem) {
            super(problem.getMessageWithLocation());
        }
    }

    private class ClosingParensesisTailFormatter
    implements Runnable {
        private final boolean spaceBeforeClosingParen;
        private final Runnable continuationFormatter;
        private final int parenPosition;

        public ClosingParensesisTailFormatter(boolean spaceBeforeClosingParen, Runnable tailFormatter) {
            this.spaceBeforeClosingParen = spaceBeforeClosingParen;
            this.continuationFormatter = tailFormatter;
            this.parenPosition = RemoteCodeFormatterVisitor.this.scribe.findToken(9);
        }

        @Override
        public void run() {
            int offset = ((RemoteCodeFormatterVisitor)RemoteCodeFormatterVisitor.this).scribe.scanner.getCurrentPosition();
            if (this.parenPosition >= 0 && offset <= this.parenPosition) {
                if (offset < this.parenPosition) {
                    RemoteCodeFormatterVisitor.this.scribe.restartAtOffset(this.parenPosition);
                }
                RemoteCodeFormatterVisitor.this.scribe.undoSpace();
                RemoteCodeFormatterVisitor.this.scribe.printNextToken(9, this.spaceBeforeClosingParen);
            }
            if (this.continuationFormatter != null) {
                this.continuationFormatter.run();
            }
        }
    }

    private class FunctionDeclaratorTailFormatter
    implements Runnable {
        private final IASTFunctionDeclarator node;
        private final Runnable continuationFormatter;

        public FunctionDeclaratorTailFormatter(IASTFunctionDeclarator node, Runnable tailFormatter) {
            this.node = node;
            this.continuationFormatter = tailFormatter;
        }

        @Override
        public void run() {
            boolean needSpace = RemoteCodeFormatterVisitor.this.skipConstVolatileRestrict();
            int token = RemoteCodeFormatterVisitor.this.peekNextToken();
            if (token == 113 || token == 1) {
                IASTTypeId[] exceptionSpecification;
                if (this.node instanceof ICPPASTFunctionDeclarator && (exceptionSpecification = ((ICPPASTFunctionDeclarator)this.node).getExceptionSpecification()) != null && token == 113) {
                    RemoteCodeFormatterVisitor.this.formatExceptionSpecification(exceptionSpecification);
                }
                if (RemoteCodeFormatterVisitor.this.peekNextToken() == 1) {
                    Alignment alignment = RemoteCodeFormatterVisitor.this.scribe.createAlignment("trailingText", 16, 1, ((RemoteCodeFormatterVisitor)RemoteCodeFormatterVisitor.this).scribe.scanner.getCurrentPosition());
                    RemoteCodeFormatterVisitor.this.scribe.enterAlignment(alignment);
                    boolean ok = false;
                    do {
                        try {
                            RemoteCodeFormatterVisitor.this.scribe.alignFragment(alignment, 0);
                            RemoteCodeFormatterVisitor.this.scribe.printTrailingComment();
                            RemoteCodeFormatterVisitor.this.scribe.space();
                            if (this.continuationFormatter != null) {
                                this.continuationFormatter.run();
                            }
                            RemoteCodeFormatterVisitor.this.skipNode((IASTNode)this.node);
                            ok = true;
                        }
                        catch (AlignmentException e) {
                            RemoteCodeFormatterVisitor.this.scribe.redoAlignment(e);
                        }
                    } while (!ok);
                    RemoteCodeFormatterVisitor.this.scribe.exitAlignment(alignment, true);
                }
            } else {
                if (needSpace && RemoteCodeFormatterVisitor.this.scribe.printComment()) {
                    RemoteCodeFormatterVisitor.this.scribe.space();
                }
                RemoteCodeFormatterVisitor.this.skipNode((IASTNode)this.node);
                if (this.continuationFormatter != null) {
                    this.continuationFormatter.run();
                }
            }
        }
    }

    private static class ListOptions {
        final int fMode;
        int fSeparatorToken = 6;
        boolean fSpaceBeforeSeparator;
        boolean fSpaceAfterSeparator = true;
        boolean fSpaceAfterOpeningParen;
        boolean fSpaceBeforeClosingParen;
        boolean fSpaceBetweenEmptyParen;
        boolean fSpaceBeforeOpeningParen;
        int fContinuationIndentation = -1;
        int fTieBreakRule = 2;

        ListOptions(int mode) {
            this.fMode = mode;
        }
    }

    private class TrailingSemicolonFormatter
    extends TrailingTokenFormatter {
        TrailingSemicolonFormatter(IASTNode node) {
            super(5, RemoteCodeFormatterVisitor.getLastNodeCharacterPosition(node), RemoteCodeFormatterVisitor.this.fInsideFor ? RemoteCodeFormatterVisitor.this.preferences.insert_space_before_semicolon_in_for : RemoteCodeFormatterVisitor.this.preferences.insert_space_before_semicolon, false);
        }
    }

    private class TrailingTokenFormatter
    implements Runnable {
        private final int tokenType;
        private final int tokenPosition;
        private final boolean spaceBeforeToken;
        private final boolean spaceAfterToken;

        TrailingTokenFormatter(int tokenType, int tokenPosition, boolean spaceBeforeToken, boolean spaceAfterToken) {
            this.tokenType = tokenType;
            this.tokenPosition = tokenPosition;
            this.spaceBeforeToken = spaceBeforeToken;
            this.spaceAfterToken = spaceAfterToken;
        }

        TrailingTokenFormatter(int tokenType, IASTNode containingNode, boolean spaceBeforeToken, boolean spaceAfterToken) {
            this(tokenType, remoteCodeFormatterVisitor.findTokenWithinNode(tokenType, containingNode), spaceBeforeToken, spaceAfterToken);
        }

        @Override
        public void run() {
            int token;
            int offset = ((RemoteCodeFormatterVisitor)RemoteCodeFormatterVisitor.this).scribe.scanner.getCurrentPosition();
            if (this.tokenPosition < 0 || offset > this.tokenPosition) {
                return;
            }
            if (offset < this.tokenPosition) {
                RemoteCodeFormatterVisitor.this.scribe.restartAtOffset(this.tokenPosition);
            }
            if ((token = RemoteCodeFormatterVisitor.this.peekNextToken()) == this.tokenType) {
                RemoteCodeFormatterVisitor.this.scribe.undoSpace();
                RemoteCodeFormatterVisitor.this.scribe.printNextToken(this.tokenType, this.spaceBeforeToken);
                RemoteCodeFormatterVisitor.this.scribe.printTrailingComment();
                if (this.spaceAfterToken) {
                    RemoteCodeFormatterVisitor.this.scribe.space();
                }
            }
        }
    }
}

