/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEnvironmentEventListener;
import org.eclipse.ptp.remotetools.environment.core.ITargetEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentEventManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetTypeExtension;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetEnvironmentManager {
    private static String ENVIRONMENTS = "Environments";
    private static String ENVIRONMENTS_TYPE = "Type";
    private static String ENVIRONMENTS_TYPE_NAME = "Name";
    private static String ENVIRONMENTS_TYPE_CONFIG = "Configuration";
    private static String ENVIRONMENTS_TYPE_CONFIG_NAME = "CfgName";
    private final List<TargetTypeElement> targetTypeElements = new ArrayList<TargetTypeElement>();
    private final ListenerList eventListeners = new ListenerList();
    private final ListenerList modelChangedListeners = new ListenerList();
    private final Map<String, Set<String>> storedCypherEnvToKeyMap;

    public TargetEnvironmentManager() {
        new TargetEnvironmentEventManager(this);
        Map<String, ITargetTypeExtension> targets = EnvironmentPlugin.getDefault().getControls();
        ISecurePreferences cypherEnvTypeMap = SecurePreferencesFactory.getDefault();
        this.storedCypherEnvToKeyMap = new HashMap<String, Set<String>>();
        File file = EnvironmentPlugin.getDefault().getStateLocation().append("environments.xml").toFile();
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                targets = this.initContentFromFile(memento, targets, cypherEnvTypeMap);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (WorkbenchException e) {
                throw new RuntimeException(e);
            }
        }
        HashSet<String> cipherKeySet = new HashSet<String>();
        for (String name : targets.keySet()) {
            ITargetTypeExtension env = targets.get(name);
            this.targetTypeElements.add(new TargetTypeElement(name, env, this));
            String[] controlKeysCypher = env.getControlAttributeNamesForCipheredKeys();
            if (controlKeysCypher != null) {
                List<String> keyList = Arrays.asList(controlKeysCypher);
                cipherKeySet.addAll(keyList);
            }
            this.storedCypherEnvToKeyMap.put(name, cipherKeySet);
        }
    }

    public Map<String, ITargetTypeExtension> initContentFromFile(XMLMemento memento, Map<String, ITargetTypeExtension> targets, ISecurePreferences cypherEnvTypeMap) {
        IMemento[] children = memento.getChildren(ENVIRONMENTS_TYPE);
        int i = 0;
        while (i < children.length) {
            String name = children[i].getString(ENVIRONMENTS_TYPE_NAME);
            ITargetTypeExtension env = targets.get(name);
            ISecurePreferences cypherConfigNameMap = null;
            if (cypherEnvTypeMap != null) {
                cypherConfigNameMap = cypherEnvTypeMap.node(name);
            }
            if (env != null) {
                HashSet<String> cipherKeySet = new HashSet<String>();
                String[] controlKeysCypher = env.getControlAttributeNamesForCipheredKeys();
                if (controlKeysCypher != null) {
                    List<String> keyList = Arrays.asList(controlKeysCypher);
                    cipherKeySet.addAll(keyList);
                }
                this.storedCypherEnvToKeyMap.put(name, cipherKeySet);
                TargetTypeElement typeElement = new TargetTypeElement(name, env, this);
                IMemento[] childrenElements = children[i].getChildren(ENVIRONMENTS_TYPE_CONFIG);
                int j = 0;
                while (j < childrenElements.length) {
                    String nameElement = childrenElements[j].getString(ENVIRONMENTS_TYPE_CONFIG_NAME);
                    HashMap<String, String> attrsElement = new HashMap<String, String>();
                    String[] controlKeys = env.getControlAttributeNames();
                    int k = 0;
                    while (k < controlKeys.length) {
                        attrsElement.put(controlKeys[k], childrenElements[j].getString(controlKeys[k]));
                        ++k;
                    }
                    ISecurePreferences cypherPasswdKeyMap = null;
                    if (cypherConfigNameMap != null) {
                        cypherPasswdKeyMap = cypherConfigNameMap.node(nameElement);
                    }
                    if (controlKeysCypher != null) {
                        int k2 = 0;
                        while (k2 < controlKeysCypher.length) {
                            if (cypherPasswdKeyMap == null) {
                                attrsElement.put(controlKeysCypher[k2], "");
                            } else {
                                try {
                                    attrsElement.put(controlKeysCypher[k2], cypherPasswdKeyMap.get(controlKeysCypher[k2], ""));
                                }
                                catch (StorageException storageException) {
                                    attrsElement.put(controlKeysCypher[k2], "");
                                }
                            }
                            cipherKeySet.add(controlKeysCypher[k2]);
                            ++k2;
                        }
                    }
                    String id = childrenElements[j].getString("core-environmentid") == null ? EnvironmentPlugin.getDefault().getEnvironmentUniqueID() : childrenElements[j].getString("core-environmentid");
                    typeElement.addElement(new TargetElement(typeElement, nameElement, attrsElement, id));
                    ++j;
                }
                this.targetTypeElements.add(typeElement);
                targets.remove(name);
            }
            ++i;
        }
        return targets;
    }

    public void writeToFile() throws StorageException {
        ISecurePreferences cypherEnvTypeMap = SecurePreferencesFactory.getDefault();
        File file = EnvironmentPlugin.getDefault().getStateLocation().append("environments.xml").toFile();
        XMLMemento memento = XMLMemento.createWriteRoot((String)ENVIRONMENTS);
        for (TargetTypeElement type : this.targetTypeElements) {
            IMemento typeMemento = memento.createChild(ENVIRONMENTS_TYPE);
            typeMemento.putString(ENVIRONMENTS_TYPE_NAME, type.getName());
            ISecurePreferences cypherConfigNameMap = cypherEnvTypeMap.node(type.getName());
            Set<String> cypherKeySet = this.storedCypherEnvToKeyMap.get(type.getName());
            for (ITargetElement element : type.getElements()) {
                IMemento elementMemento = typeMemento.createChild(ENVIRONMENTS_TYPE_CONFIG);
                elementMemento.putString(ENVIRONMENTS_TYPE_CONFIG_NAME, element.getName());
                ControlAttributes elementAttr = element.getAttributes();
                ISecurePreferences cypherPasswdKeyMap = cypherConfigNameMap.node(element.getName());
                for (String key : elementAttr.keySet()) {
                    if (cypherKeySet.contains(key)) {
                        cypherPasswdKeyMap.put(key, elementAttr.getString(key), true);
                        continue;
                    }
                    elementMemento.putString(key, elementAttr.getString(key));
                }
                elementMemento.putString("core-environmentid", element.getId());
            }
        }
        try {
            FileWriter writer = new FileWriter(file);
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TargetTypeElement> getTypeElements() {
        return this.targetTypeElements;
    }

    public synchronized ITargetElement[] getConfigElements() {
        ArrayList<ITargetElement> rsp = new ArrayList<ITargetElement>();
        for (TargetTypeElement element : this.targetTypeElements) {
            rsp.addAll(element.getElements());
        }
        ITargetElement[] rspObj = null;
        if (rsp.size() > 0) {
            rspObj = rsp.toArray(new ITargetElement[0]);
        }
        return rspObj;
    }

    public synchronized void addModelEventListener(ITargetEventListener listener) {
        if (listener != null) {
            this.eventListeners.add((Object)listener);
        }
    }

    public synchronized void removeModelEventListener(ITargetEventListener listener) {
        if (listener != null) {
            this.eventListeners.remove((Object)listener);
        }
    }

    public synchronized void addModelChangedListener(ITargetEnvironmentEventListener listener) {
        if (listener != null) {
            this.modelChangedListeners.add((Object)listener);
        }
    }

    public synchronized void removeModelChangedListener(ITargetEnvironmentEventListener listener) {
        if (listener != null) {
            this.modelChangedListeners.remove((Object)listener);
        }
    }

    public void fireModelChanged(int action, ITargetElement oldElement, TargetElement newElement) {
        block3: {
            block2: {
                if (oldElement != null || newElement == null) break block2;
                Object[] objectArray = this.modelChangedListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((ITargetEnvironmentEventListener)listener).elementAdded(newElement);
                    ++n2;
                }
                break block3;
            }
            if (oldElement == null || newElement != null) break block3;
            Object[] objectArray = this.modelChangedListeners.getListeners();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object listener = objectArray[n3];
                ((ITargetEnvironmentEventListener)listener).elementRemoved(oldElement);
                ++n3;
            }
        }
    }

    public synchronized void fireElementEvent(int event, TargetElement element) {
        int status = 1;
        switch (event) {
            case 0: {
                status = 0;
                break;
            }
            case 1: {
                status = 1;
                break;
            }
            case 2: {
                status = 2;
                break;
            }
            case 3: {
                status = 3;
            }
        }
        element.setStatus(status);
        Object[] objectArray = this.eventListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ITargetEventListener)listener).handleStateChangeEvent(status, element);
            ++n2;
        }
    }

    public ITargetControl selectControl(String id) {
        ITargetElement[] elements = this.getConfigElements();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                ITargetElement element = elements[i];
                if (element.getName().equals(id)) {
                    try {
                        return element.getControl();
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getAllConfigNames() {
        ITargetElement[] elements = this.getConfigElements();
        ArrayList<String> names = new ArrayList<String>();
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                ITargetElement element = elements[i];
                names.add(element.getName());
                ++i;
            }
        }
        return names.toArray(new String[0]);
    }
}

