/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsFileSystem;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsServices;
import org.eclipse.ptp.internal.remote.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.remote.core.AbstractRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsConnectionManager
extends AbstractRemoteConnectionManager
implements ITargetEventListener {
    private final TargetTypeElement fRemoteHost;
    private final Map<String, IRemoteConnection> fConnections = new HashMap<String, IRemoteConnection>();

    public RemoteToolsConnectionManager(IRemoteServices services) {
        super(services);
        this.fRemoteHost = RemoteToolsServices.getTargetTypeElement();
        TargetEnvironmentManager targetMgr = EnvironmentPlugin.getDefault().getTargetsManager();
        targetMgr.addModelEventListener((ITargetEventListener)this);
        this.refreshConnections();
    }

    public IRemoteConnection getConnection(String name) {
        this.refreshConnections();
        return this.fConnections.get(name);
    }

    public IRemoteConnection getConnection(URI uri) {
        String connName = RemoteToolsFileSystem.getConnectionNameFor(uri);
        if (connName != null) {
            return this.getConnection(connName);
        }
        return null;
    }

    public List<IRemoteConnection> getConnections() {
        this.refreshConnections();
        return new ArrayList<IRemoteConnection>(this.fConnections.values());
    }

    public void handleStateChangeEvent(int event, ITargetElement element) {
        IRemoteConnection conn = this.fConnections.get(element.getName());
        if (conn != null) {
            switch (event) {
                case 2: {
                    ((RemoteToolsConnection)conn).fireConnectionChangeEvent(2);
                    break;
                }
                case 1: {
                    ((RemoteToolsConnection)conn).fireConnectionChangeEvent(1);
                    break;
                }
            }
        }
    }

    public IRemoteConnectionWorkingCopy newConnection(String name) throws RemoteConnectionException {
        if (this.getConnection(name) != null) {
            throw new RemoteConnectionException(NLS.bind((String)Messages.RemoteToolsConnectionManager_Connection_with_name_already_exists, (Object)name));
        }
        TargetElement element = this.newTargetElement(name);
        return this.createConnection(element).getWorkingCopy();
    }

    public TargetElement newTargetElement(String name) {
        String id = EnvironmentPlugin.getDefault().getEnvironmentUniqueID();
        return new TargetElement(this.fRemoteHost, name, id);
    }

    public void addConnection(RemoteToolsConnection connection) {
        this.fRemoteHost.addElement(connection.getTargetElement());
    }

    public void removeConnection(IRemoteConnection conn) throws RemoteConnectionException {
        if (!(conn instanceof RemoteToolsConnection)) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnectionManager_invalidConnectionType);
        }
        if (conn.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnectionManager_cannotRemoveOpenConnection);
        }
        this.fConnections.remove(conn);
        ((RemoteToolsConnection)conn).dispose();
    }

    private IRemoteConnection createConnection(TargetElement element) {
        return new RemoteToolsConnection(element.getName(), element, this.getRemoteServices());
    }

    private void refreshConnections() {
        if (this.fRemoteHost != null) {
            HashMap<String, IRemoteConnection> newConns = new HashMap<String, IRemoteConnection>();
            for (Object obj : this.fRemoteHost.getElements()) {
                if (!(obj instanceof TargetElement)) continue;
                TargetElement element = (TargetElement)obj;
                IRemoteConnection conn = this.fConnections.get(element.getName());
                if (conn == null) {
                    conn = this.createConnection(element);
                }
                newConns.put(element.getName(), conn);
            }
            this.fConnections.clear();
            this.fConnections.putAll(newConns);
        }
    }
}

