/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class Checksums {
    private static final String KEY_ALGORITHM = "//algorithm//";
    private static final String DEFAULT_ALGORITHM = "MD5";

    public static MessageDigest getDefaultAlgorithm() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(DEFAULT_ALGORITHM);
    }

    public static MessageDigest getAlgorithm(Map<?, ?> persistedMap) throws NoSuchAlgorithmException {
        Object obj = persistedMap.get(KEY_ALGORITHM);
        String alg = obj instanceof String ? (String)obj : DEFAULT_ALGORITHM;
        return MessageDigest.getInstance(alg);
    }

    public static void putAlgorithm(Map<String, Object> mapToPersist, MessageDigest md) {
        mapToPersist.put(KEY_ALGORITHM, md.getAlgorithm());
    }

    public static byte[] computeChecksum(MessageDigest md, File file) throws IOException {
        md.reset();
        try (FileInputStream fi = new FileInputStream(file);){
            int read;
            byte[] buf = new byte[65536];
            while ((read = fi.read(buf)) >= 0) {
                md.update(buf, 0, read);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
    }

    public static byte[] getChecksum(Map<?, ?> persistedMap, IFile file) {
        IPath prjRel = file.getProjectRelativePath();
        Object checksum = persistedMap.get(prjRel.toString());
        if (checksum instanceof byte[]) {
            return (byte[])checksum;
        }
        return null;
    }

    public static void putChecksum(Map<String, Object> mapToPersist, IFile file, byte[] checksum) {
        IPath prjRel = file.getProjectRelativePath();
        mapToPersist.put(prjRel.toString(), checksum);
    }

    public static Map<String, Object> createChecksumMap(IFile[] tus, MessageDigest md, IProgressMonitor pm) throws OperationCanceledException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Checksums.putAlgorithm(result, md);
        pm.beginTask(Messages.Checksums_taskComputeChecksums, tus.length);
        IFile[] iFileArray = tus;
        int n = tus.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            IPath location;
            IFile file = iFileArray[n2];
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (file != null && (location = file.getLocation()) != null && (f = location.toFile()).isFile()) {
                try {
                    byte[] checksum = Checksums.computeChecksum(md, f);
                    Checksums.putChecksum(result, file, checksum);
                }
                catch (IOException e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
            pm.worked(1);
            ++n2;
        }
        pm.done();
        return result;
    }
}

