/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.model.BindingAdapter;
import org.eclipse.ptp.internal.rdt.core.model.CElement;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.IIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.LocalIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.rdt.core.RDTLog;

public class IndexQueries {
    private static final ICElement[] EMPTY_ELEMENTS = new ICElement[0];

    public static IIndexBinding elementToBinding(IIndex index, ICElement element, String path) throws CoreException {
        return IndexQueries.elementToBinding(index, element, path, -1);
    }

    public static IIndexBinding elementToBinding(IIndex index, ICElement element, String path, int linkageID) throws CoreException {
        if (element instanceof ISourceReference) {
            ISourceReference sf = (ISourceReference)element;
            ISourceRange range = sf.getSourceRange();
            if (range.getIdLength() != 0) {
                IIndexName name = IndexQueries.remoteElementToName(index, element, path, linkageID);
                if (name != null) {
                    return index.findBinding((IName)name);
                }
            } else {
                IIndexBinding[] bindings;
                String name = element.getElementName();
                name = name.substring(name.lastIndexOf(58) + 1);
                IIndexBinding[] iIndexBindingArray = bindings = index.findBindings(name.toCharArray(), IndexFilter.ALL, (IProgressMonitor)new NullProgressMonitor());
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexBinding binding = iIndexBindingArray[n2];
                    if (IndexQueries.checkBinding(binding, element)) {
                        return binding;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private static boolean checkBinding(IIndexBinding binding, ICElement element) {
        switch (element.getElementType()) {
            case 63: {
                return binding instanceof IEnumeration;
            }
            case 61: {
                return binding instanceof ICPPNamespace;
            }
            case 66: 
            case 67: {
                return binding instanceof ICompositeType && ((ICompositeType)binding).getKey() == 1;
            }
            case 64: 
            case 65: {
                return binding instanceof ICPPClassType && ((ICompositeType)binding).getKey() == 3;
            }
            case 68: 
            case 69: {
                return binding instanceof ICompositeType && ((ICompositeType)binding).getKey() == 2;
            }
            case 80: {
                return binding instanceof ITypedef;
            }
            case 70: 
            case 71: {
                return binding instanceof ICPPMethod;
            }
            case 72: {
                return binding instanceof IField;
            }
            case 73: 
            case 74: {
                return binding instanceof ICPPFunction && !(binding instanceof ICPPMethod);
            }
            case 76: 
            case 77: {
                return binding instanceof IVariable;
            }
            case 81: {
                return binding instanceof IEnumerator;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                return binding instanceof ICPPClassTemplate;
            }
            case 88: 
            case 89: {
                return binding instanceof ICPPFunctionTemplate && !(binding instanceof ICPPMethod);
            }
            case 90: 
            case 91: {
                return binding instanceof ICPPFunctionTemplate && binding instanceof ICPPMethod;
            }
            case 92: {
                return binding instanceof ICPPTemplateParameter;
            }
        }
        return false;
    }

    public static IIndexName elementToName(IIndex index, ICElement element) throws CoreException {
        return IndexQueries.elementToName(index, element, -1);
    }

    public static IIndexName elementToName(IIndex index, ICElement element, int linkageID) throws CoreException {
        IIndexFileLocation location;
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files;
            IIndexFile[] iIndexFileArray = files = index.getFiles(location);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFile file = iIndexFileArray[n2];
                if (linkageID == -1 || file.getLinkageID() == linkageID) {
                    IIndexName[] names;
                    String elementName = element.getElementName();
                    int idx = elementName.lastIndexOf(":") + 1;
                    ISourceRange pos = sf.getSourceRange();
                    int offset = pos.getIdStartPos() + idx;
                    int length = pos.getIdLength() - idx;
                    IIndexName[] iIndexNameArray = names = file.findNames(offset, length);
                    int n3 = names.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IIndexName name2 = iIndexNameArray[n4];
                        IIndexName name = name2;
                        if (!name.isReference() && elementName.endsWith(new String(name.getSimpleID()))) {
                            return name;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public static IIndexName remoteElementToName(IIndex index, ICElement element, String path) throws CoreException {
        return IndexQueries.remoteElementToName(index, element, path, -1);
    }

    public static IIndexName remoteElementToName(IIndex index, ICElement element, String path, int linkageID) throws CoreException {
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null) {
            URI uri = null;
            try {
                uri = IndexQueries.convertPathToLocalURI(path);
            }
            catch (URISyntaxException e) {
                RDTLog.logError((Throwable)e);
            }
            IndexFileLocation location = null;
            if (uri != null) {
                location = new IndexFileLocation(uri, path);
            }
            if (location != null) {
                IIndexFile[] files;
                IIndexFile[] iIndexFileArray = files = index.getFiles(location);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFile file = iIndexFileArray[n2];
                    if (linkageID == -1 || file.getLinkageID() == linkageID) {
                        IIndexName[] names;
                        String elementName = element.getElementName();
                        int idx = elementName.lastIndexOf(":") + 1;
                        ISourceRange pos = sf.getSourceRange();
                        int offset = pos.getIdStartPos() + idx;
                        int length = pos.getIdLength() - idx;
                        IIndexName[] iIndexNameArray = names = file.findNames(offset, length);
                        int n3 = names.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IIndexName name2 = iIndexNameArray[n4];
                            IIndexName name = name2;
                            if (!name.isReference() && elementName.endsWith(new String(name.getSimpleID()))) {
                                return name;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private static URI convertPathToLocalURI(String path) throws URISyntaxException {
        URI uri = new URI("file", null, path, null);
        return uri;
    }

    public static boolean isIndexed(IIndex index, ICElement element) throws CoreException {
        IIndexFileLocation location;
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files = index.getFiles(location);
            return files.length > 0;
        }
        return false;
    }

    public static IIndexInclude elementToInclude(IIndex index, IInclude include) throws CoreException {
        IIndexFileLocation location;
        ITranslationUnit tu;
        if (include != null && (tu = include.getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files;
            IIndexFile[] iIndexFileArray = files = index.getFiles(location);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFile file = iIndexFileArray[n2];
                String elementName = include.getElementName();
                ISourceRange pos = include.getSourceRange();
                int offset = pos.getIdStartPos();
                IIndexInclude[] includes = index.findIncludes(file);
                int bestDiff = Integer.MAX_VALUE;
                IIndexInclude best = null;
                IIndexInclude[] iIndexIncludeArray = includes;
                int n3 = includes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IIndexInclude candidate = iIndexIncludeArray[n4];
                    int diff = Math.abs(candidate.getNameOffset() - offset);
                    if (diff > bestDiff) break;
                    if (candidate.getFullName().endsWith(elementName)) {
                        bestDiff = diff;
                        best = candidate;
                    }
                    ++n4;
                }
                if (best != null) {
                    return best;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ICElement[] findRepresentative(IIndex index, IBinding binding, IIndexLocationConverterFactory converter, ICProject preferProject, ICProjectFactory projectFactory) throws CoreException {
        ICElement elem;
        ICElement[] defs = IndexQueries.findAllDefinitions(index, binding, converter, preferProject, projectFactory);
        if (defs.length == 0 && (elem = IndexQueries.findAnyDeclaration(index, preferProject, binding, converter, projectFactory)) != null) {
            defs = new ICElement[]{elem};
        }
        return defs;
    }

    public static String[] findRepresentitivePaths(IIndex index, IBinding binding, IIndexLocationConverterFactory converter, ICProject preferProject, ICProjectFactory projectFactory) throws CoreException {
        IIndexName[] defs = index.findNames(binding, 10);
        ArrayList<String> paths = new ArrayList<String>();
        IIndexName[] iIndexNameArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexName name = iIndexNameArray[n2];
            String path = null;
            URI locationURI = name.getFile().getLocation().getURI();
            if (converter instanceof LocalIndexLocationConverterFactory) {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(locationURI);
                if (files != null && files.length > 0) {
                    path = files[0].getFullPath().toString();
                }
            } else {
                path = locationURI.getPath();
            }
            if (path != null) {
                paths.add(path);
            }
            ++n2;
        }
        return paths.toArray(new String[0]);
    }

    public static ICElement[] findAllDefinitions(IIndex index, IBinding binding, IIndexLocationConverterFactory converter, ICProject preferProject, ICProjectFactory projectFactory) throws CoreException {
        if (binding != null) {
            IIndexName[] defs = index.findNames(binding, 10);
            ArrayList<ICElement> result = new ArrayList<ICElement>();
            IIndexName[] iIndexNameArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName in = iIndexNameArray[n2];
                ICElement definition = IndexQueries.getCElementForName(preferProject, index, in, converter, projectFactory);
                if (definition != null) {
                    result.add(definition);
                }
                ++n2;
            }
            return result.toArray(new ICElement[result.size()]);
        }
        return EMPTY_ELEMENTS;
    }

    public static ICElement getCElementForName(ICProject preferProject, IIndex index, IASTName declName, IIndexLocationConverterFactory converter, ICProjectFactory projectFactory) throws CoreException {
        assert (!declName.isReference());
        IBinding binding = declName.resolveBinding();
        if (binding != null) {
            ITranslationUnit tu;
            ICProject cProject = preferProject;
            if (preferProject == null) {
                cProject = projectFactory.getProjectForFile(declName.getFileLocation().getFileName());
            }
            if ((tu = IndexQueries.getTranslationUnit(cProject, (IName)declName, converter)) != null) {
                IASTFileLocation loc = declName.getFileLocation();
                try {
                    return BindingAdapter.adaptBinding(tu, binding, loc.getNodeOffset(), loc.getNodeLength(), declName.isDefinition());
                }
                catch (DOMException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.core", "", (Throwable)e));
                }
            }
        }
        return null;
    }

    public static ITranslationUnit getTranslationUnit(ICProject cproject, IName name, IIndexLocationConverterFactory converter) {
        return IndexQueries.getTranslationUnit(cproject, name.getFileLocation(), converter);
    }

    private static ITranslationUnit getTranslationUnit(ICProject cproject, IASTFileLocation fileLocation, IIndexLocationConverterFactory converter) {
        if (converter == null) {
            throw new IllegalArgumentException();
        }
        if (fileLocation != null) {
            IPath path = Path.fromOSString((String)fileLocation.getFileName());
            if (converter != null) {
                IIndexFileLocation location = converter.getConverter(cproject).fromInternalFormat(fileLocation.getFileName());
                if (location == null) {
                    try {
                        return CoreModelUtil.findTranslationUnitForLocation((IPath)path, (ICProject)cproject);
                    }
                    catch (CModelException e) {
                        RDTLog.logError((Throwable)e);
                    }
                }
                TranslationUnit unit = new TranslationUnit((ICElement)cproject, path.lastSegment(), cproject == null ? null : cproject.getElementName(), location.getURI());
                return unit;
            }
        }
        return null;
    }

    public static ICElement getCElementForName(ICProject preferProject, IIndex index, IIndexName declName, IIndexLocationConverterFactory converter, ICProjectFactory projectFactory) throws CoreException {
        ITranslationUnit tu;
        assert (!declName.isReference());
        ICProject cProject = preferProject;
        if (preferProject == null) {
            cProject = projectFactory.getProjectForFile(declName.getFileLocation().getFileName());
        }
        if ((tu = IndexQueries.getTranslationUnit(cProject, (IName)declName, converter)) != null) {
            return IndexQueries.getCElementForName(tu, index, declName, projectFactory);
        }
        return null;
    }

    public static ICElement getCElementForName(ITranslationUnit tu, IIndex index, IIndexName declName, ICProjectFactory projectFactory) throws CoreException {
        try {
            return BindingAdapter.adaptBinding(tu, (IBinding)index.findBinding((IName)declName), declName.getNodeOffset(), declName.getNodeLength(), declName.isDefinition());
        }
        catch (DOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.core", "", (Throwable)e));
        }
    }

    public static ICElement findAnyDeclaration(IIndex index, ICProject preferProject, IBinding binding, IIndexLocationConverterFactory converter, ICProjectFactory projectFactory) throws CoreException {
        if (binding != null) {
            IIndexName[] names;
            IIndexName[] iIndexNameArray = names = index.findNames(binding, 1);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName name = iIndexNameArray[n2];
                ICElement elem = IndexQueries.getCElementForName(preferProject, index, name, converter, projectFactory);
                if (elem != null) {
                    return elem;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ICElement attemptConvertionToHandle(IIndex index, ICElement input, IIndexLocationConverterFactory converter, ICProjectFactory projectFactory) throws CoreException {
        ICElement handle;
        if (input instanceof CElement) {
            return input;
        }
        IIndexName name = IndexQueries.elementToName(index, input);
        if (name != null && (handle = IndexQueries.getCElementForName(input.getCProject(), index, name, converter, projectFactory)) != null) {
            return handle;
        }
        return input;
    }

    public static IASTName getSelectedName(IIndex index, ITranslationUnit workingCopy, int selectionStart, int selectionLength) throws CoreException {
        if (workingCopy == null) {
            return null;
        }
        int options = 2;
        IASTTranslationUnit ast = workingCopy.getAST(index, options);
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTName name = nodeSelector.findEnclosingName(selectionStart, selectionLength);
        if (name == null) {
            name = nodeSelector.findImplicitName(selectionStart, selectionLength);
        }
        if (name != null && name.getParent() instanceof IASTPreprocessorMacroExpansion) {
            IASTFileLocation floc = name.getParent().getFileLocation();
            IASTNode node = nodeSelector.findEnclosingNodeInExpansion(floc.getNodeOffset(), floc.getNodeLength());
            if (node instanceof IASTName) {
                name = (IASTName)node;
            } else if (node instanceof IASTFunctionCallExpression) {
                IASTExpression expr = ((IASTFunctionCallExpression)node).getFunctionNameExpression();
                if (expr instanceof IASTIdExpression) {
                    name = ((IASTIdExpression)expr).getName();
                }
            } else {
                if (node instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] dtors = ((IASTSimpleDeclaration)node).getDeclarators();
                    if (dtors != null && dtors.length > 0) {
                        node = dtors[0];
                    }
                } else if (node instanceof IASTFunctionDefinition) {
                    node = ((IASTFunctionDefinition)node).getDeclarator();
                }
                if (node instanceof IASTDeclarator) {
                    IASTDeclarator dtor = ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)((IASTDeclarator)node));
                    name = dtor.getName();
                }
            }
        }
        return name;
    }

    public static List<? extends IBinding> findSpecializations(IBinding binding) throws CoreException {
        List<ICPPTemplateInstance> instances;
        List<? extends IBinding> specializedOwners;
        ArrayList<Object> result = null;
        IBinding owner = binding.getOwner();
        if (owner != null && !(specializedOwners = IndexQueries.findSpecializations(owner)).isEmpty()) {
            result = new ArrayList<Object>(specializedOwners.size());
            for (IBinding iBinding : specializedOwners) {
                if (!(iBinding instanceof ICPPClassSpecialization)) continue;
                result.add(((ICPPClassSpecialization)iBinding).specializeMember(binding));
            }
        }
        if (binding instanceof ICPPInstanceCache && !(instances = Arrays.asList(((ICPPInstanceCache)binding).getAllInstances())).isEmpty()) {
            if (result == null) {
                result = new ArrayList(instances.size());
            }
            for (ICPPTemplateInstance iCPPTemplateInstance : instances) {
                if (IndexFilter.ALL_DECLARED.acceptBinding((IBinding)iCPPTemplateInstance)) continue;
                result.add(iCPPTemplateInstance);
            }
        }
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }
}

