/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.JSchConnectionManager;
import org.eclipse.remote.internal.jsch.ui.Activator;
import org.eclipse.remote.internal.jsch.ui.messages.Messages;
import org.eclipse.remote.internal.jsch.ui.wizards.JSchConnectionWizard;
import org.eclipse.remote.ui.AbstractRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.widgets.Shell;

public class JSchUIConnectionManager
extends AbstractRemoteUIConnectionManager {
    private final JSchConnectionManager fConnMgr;

    public JSchUIConnectionManager(IRemoteServices services) {
        this.fConnMgr = (JSchConnectionManager)services.getConnectionManager();
    }

    public IRemoteUIConnectionWizard getConnectionWizard(Shell shell) {
        return new JSchConnectionWizard(shell, (IRemoteConnectionManager)this.fConnMgr);
    }

    public void openConnectionWithProgress(Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        if (!connection.isOpen()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        throw new InvocationTargetException(e);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                if (context != null) {
                    context.run(true, true, op);
                } else {
                    new ProgressMonitorDialog(shell).run(true, true, op);
                }
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.JSchUIConnectionManager_Connection_Error, (String)Messages.JSchUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getCause().getMessage()));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.JSchUIConnectionManager_Connection_Error, (String)Messages.JSchUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, Activator.getUniqueIdentifier(), e.getMessage()));
            }
        }
    }
}

