/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.ChannelExec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.remote.core.AbstractRemoteProcess;

public class JSchProcess
extends AbstractRemoteProcess {
    private static int WAIT_TIMEOUT = 1000;
    private static int refCount = 0;
    private final ChannelExec fChannel;
    private InputStream fProcStdout;
    private InputStream fProcStderr;
    private Thread fStdoutReader;
    private Thread fStderrReader;

    public JSchProcess(ChannelExec channel, boolean merge) throws IOException {
        this.fChannel = channel;
        if (merge) {
            PipedOutputStream pipedOutput = new PipedOutputStream();
            this.fProcStdout = new PipedInputStream(pipedOutput);
            this.fProcStderr = new NullInputStream();
            this.fStderrReader = new Thread(new ProcReader(channel.getErrStream(), pipedOutput));
            this.fStdoutReader = new Thread(new ProcReader(channel.getInputStream(), pipedOutput));
            this.fStderrReader.start();
            this.fStdoutReader.start();
        } else {
            this.fProcStdout = channel.getInputStream();
            this.fProcStderr = channel.getErrStream();
        }
    }

    public void destroy() {
        this.fChannel.disconnect();
    }

    public int exitValue() {
        return this.fChannel.getExitStatus();
    }

    public InputStream getErrorStream() {
        return this.fProcStderr;
    }

    public InputStream getInputStream() {
        return this.fProcStdout;
    }

    public OutputStream getOutputStream() {
        try {
            return this.fChannel.getOutputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int waitFor() throws InterruptedException {
        while (!this.isCompleted()) {
            Thread.sleep(WAIT_TIMEOUT);
        }
        return this.exitValue();
    }

    public boolean isCompleted() {
        return this.fChannel.isClosed();
    }

    public class NullInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }

    private class ProcReader
    implements Runnable {
        private static final int BUF_SIZE = 8192;
        private final InputStream fInput;
        private final OutputStream fOutput;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcReader(InputStream input, OutputStream output) {
            this.fInput = input;
            OutputStream outputStream = this.fOutput = output;
            synchronized (outputStream) {
                refCount = refCount + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] b = new byte[8192];
            try {
                int len;
                while ((len = this.fInput.read(b)) > 0) {
                    this.fOutput.write(b, 0, len);
                }
            }
            catch (IOException iOException) {}
            OutputStream outputStream = this.fOutput;
            synchronized (outputStream) {
                int n = refCount - 1;
                refCount = n;
                if (n == 0) {
                    try {
                        this.fOutput.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

