/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public final class TypeMarshalBuffer
implements ITypeMarshalBuffer {
    public static final byte[] EMPTY = new byte[6];
    public static final byte NULL_TYPE = 0;
    public static final byte INDIRECT_TYPE = 31;
    public static final byte BINDING_TYPE = 30;
    public static final byte UNSTORABLE_TYPE = 29;
    public static final IType UNSTORABLE_TYPE_PROBLEM = new ProblemType(10005);
    private final PDOMLinkage fLinkage;
    private int fPos;
    private byte[] fBuffer;

    static {
        assert (EMPTY.length == 6);
    }

    public TypeMarshalBuffer(PDOMLinkage linkage) {
        this.fLinkage = linkage;
    }

    public TypeMarshalBuffer(PDOMLinkage linkage, byte[] data) {
        this.fLinkage = linkage;
        this.fBuffer = data;
    }

    public int getPosition() {
        return this.fPos;
    }

    public void setPosition(int pos) {
        assert (pos >= 0 && pos <= this.fPos);
        this.fPos = pos;
    }

    public byte[] getBuffer() {
        return this.fBuffer;
    }

    @Override
    public void marshalBinding(IBinding binding) throws CoreException {
        if (binding instanceof ISerializableType) {
            ((ISerializableType)((Object)binding)).marshal(this);
        } else if (binding == null) {
            this.putShort((short)0);
        } else {
            PDOMBinding pb = this.fLinkage.addTypeBinding(binding);
            if (pb == null) {
                this.putShort((short)29);
            } else {
                this.putShort((short)30);
                this.putByte((byte)0);
                this.putRecordPointer(pb.getRecord());
            }
        }
    }

    @Override
    public IBinding unmarshalBinding() throws CoreException {
        int oldPos = this.fPos++;
        short firstBytes = this.getShort();
        if (firstBytes == 30) {
            long rec = this.getRecordPointer();
            return (IBinding)((Object)PDOMNode.load(this.fLinkage.getPDOM(), rec));
        }
        if (firstBytes == 0 || firstBytes == 29) {
            return null;
        }
        this.fPos = oldPos;
        return this.fLinkage.unmarshalBinding(this);
    }

    @Override
    public void marshalType(IType type) throws CoreException {
        if (type instanceof ISerializableType) {
            ((ISerializableType)((Object)type)).marshal(this);
        } else if (type == null) {
            this.putShort((short)0);
        } else if (type instanceof IBinding) {
            this.marshalBinding((IBinding)((Object)type));
        } else {
            assert (false) : "Cannot serialize " + ASTTypeUtil.getType(type) + " (" + type.getClass().getName() + ")";
            this.putShort((short)29);
        }
    }

    @Override
    public IType unmarshalType() throws CoreException {
        int oldPos = this.fPos++;
        short firstBytes = this.getShort();
        if (firstBytes == 30) {
            long rec = this.getRecordPointer();
            return (IType)((Object)PDOMNode.load(this.fLinkage.getPDOM(), rec));
        }
        if (firstBytes == 0) {
            return null;
        }
        if (firstBytes == 29) {
            return UNSTORABLE_TYPE_PROBLEM;
        }
        this.fPos = oldPos;
        return this.fLinkage.unmarshalType(this);
    }

    @Override
    public void marshalEvaluation(ISerializableEvaluation eval, boolean includeValues) throws CoreException {
        if (eval == null) {
            this.putShort((short)0);
        } else {
            eval.marshal(this, includeValues);
        }
    }

    @Override
    public ISerializableEvaluation unmarshalEvaluation() throws CoreException {
        return this.fLinkage.unmarshalEvaluation(this);
    }

    @Override
    public void marshalValue(IValue value) throws CoreException {
        if (value instanceof Value) {
            ((Value)value).marshal(this);
        } else {
            this.putShort((short)0);
        }
    }

    @Override
    public IValue unmarshalValue() throws CoreException {
        if (this.fPos >= this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        return Value.unmarshal(this);
    }

    @Override
    public void marshalTemplateArgument(ICPPTemplateArgument arg) throws CoreException {
        if (arg.isNonTypeValue()) {
            this.putShort((short)10);
            arg.getNonTypeEvaluation().marshal(this, true);
        } else {
            IType typeValue = arg.getTypeValue();
            IType originalTypeValue = arg.getOriginalTypeValue();
            this.marshalType(typeValue);
            if (typeValue != originalTypeValue) {
                this.marshalType(originalTypeValue);
            } else {
                this.marshalType(null);
            }
        }
    }

    @Override
    public ICPPTemplateArgument unmarshalTemplateArgument() throws CoreException {
        int oldPos = this.fPos;
        short firstBytes = this.getShort();
        if (firstBytes == 10) {
            return new CPPTemplateNonTypeArgument((ICPPEvaluation)this.unmarshalEvaluation(), null);
        }
        this.fPos = oldPos;
        IType type = this.unmarshalType();
        IType originalType = this.unmarshalType();
        if (originalType == null || originalType == UNSTORABLE_TYPE_PROBLEM) {
            originalType = type;
        }
        return new CPPTemplateTypeArgument(type, originalType);
    }

    private void request(int i) {
        if (this.fBuffer == null) {
            this.fBuffer = i <= 6 ? new byte[6] : new byte[i];
        } else {
            int needLen = this.fPos + i;
            int bufLen = this.fBuffer.length;
            if (needLen > bufLen) {
                needLen = Math.max(needLen, 2 * bufLen);
                byte[] newBuffer = new byte[needLen];
                System.arraycopy(this.fBuffer, 0, newBuffer, 0, this.fPos);
                this.fBuffer = newBuffer;
            }
        }
    }

    @Override
    public void putByte(byte b) {
        this.request(1);
        this.fBuffer[this.fPos++] = b;
    }

    @Override
    public int getByte() throws CoreException {
        if (this.fPos + 1 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        return 0xFF & this.fBuffer[this.fPos++];
    }

    @Override
    public CoreException unmarshallingError() {
        return new CoreException(CCorePlugin.createStatus("Unmarshalling error"));
    }

    public CoreException marshallingError() {
        return new CoreException(CCorePlugin.createStatus("Marshalling error"));
    }

    @Override
    public void putFixedInt(int value) {
        this.request(4);
        this.fPos += 4;
        int p = this.fPos;
        this.fBuffer[--p] = (byte)value;
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
        this.fBuffer[--p] = (byte)(value >>= 8);
    }

    @Override
    public int getFixedInt() throws CoreException {
        if (this.fPos + 4 > this.fBuffer.length) {
            throw this.unmarshallingError();
        }
        int result = 0;
        result |= this.fBuffer[this.fPos++] & 0xFF;
        result <<= 8;
        result |= this.fBuffer[this.fPos++] & 0xFF;
        result <<= 8;
        result |= this.fBuffer[this.fPos++] & 0xFF;
        result <<= 8;
        return result |= this.fBuffer[this.fPos++] & 0xFF;
    }

    @Override
    public void putShort(short value) {
        this.putInt(value);
    }

    @Override
    public void putInt(int value) {
        do {
            int b = value & 0x7F;
            if ((value >>>= 7) != 0) {
                b |= 0x80;
            }
            this.putByte((byte)b);
        } while (value != 0);
    }

    @Override
    public void putLong(long value) {
        do {
            int b = (int)value & 0x7F;
            if ((value >>>= 7) != 0L) {
                b |= 0x80;
            }
            this.putByte((byte)b);
        } while (value != 0L);
    }

    @Override
    public short getShort() throws CoreException {
        int result = this.getInt();
        if (result > Short.MAX_VALUE) {
            this.unmarshallingError();
        }
        return (short)result;
    }

    @Override
    public int getInt() throws CoreException {
        int b = this.getByte();
        int value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.getByte();
            value |= (b & 0x7F) << shift;
            shift += 7;
        }
        return value;
    }

    @Override
    public long getLong() throws CoreException {
        int b = this.getByte();
        long value = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.getByte();
            value |= (long)((b & 0x7F) << shift);
            shift += 7;
        }
        return value;
    }

    private void putRecordPointer(long record) {
        this.request(4);
        Chunk.putRecPtr(record, this.fBuffer, this.fPos);
        this.fPos += 4;
    }

    private long getRecordPointer() throws CoreException {
        int pos = this.fPos;
        this.fPos += 4;
        if (this.fPos > this.fBuffer.length) {
            this.fPos = this.fBuffer.length;
            throw this.unmarshallingError();
        }
        return Chunk.getRecPtr(this.fBuffer, pos);
    }

    @Override
    public void putCharArray(char[] chars) {
        this.putInt(chars.length);
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.putInt(c & 0xFFFF);
            ++n2;
        }
    }

    @Override
    public char[] getCharArray() throws CoreException {
        int len = this.getInt();
        char[] chars = new char[len];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)this.getInt();
            ++i;
        }
        return chars;
    }
}

