/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.AbstractRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.JSchFileSystem;
import org.eclipse.remote.internal.jsch.core.messages.Messages;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSchConnectionManager
extends AbstractRemoteConnectionManager {
    private Map<String, JSchConnection> fConnections;

    public JSchConnectionManager(IRemoteServices services) {
        super(services);
    }

    public IRemoteConnection getConnection(String name) {
        this.loadConnections();
        return this.fConnections.get(name);
    }

    public IRemoteConnection getConnection(URI uri) {
        String connName = JSchFileSystem.getConnectionNameFor(uri);
        if (connName != null) {
            return this.getConnection(connName);
        }
        return null;
    }

    public JSchConnection createConnection(String name) {
        return new JSchConnection(name, this.getRemoteServices());
    }

    public List<IRemoteConnection> getConnections() {
        this.loadConnections();
        ArrayList<IRemoteConnection> conns = new ArrayList<IRemoteConnection>();
        conns.addAll(this.fConnections.values());
        return conns;
    }

    private synchronized void loadConnections() {
        if (this.fConnections == null) {
            this.fConnections = Collections.synchronizedMap(new HashMap());
            IEclipsePreferences root = InstanceScope.INSTANCE.getNode(Activator.getUniqueIdentifier());
            Preferences connections = root.node("connections");
            try {
                String[] stringArray = connections.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    JSchConnection connection = new JSchConnection(name, this.getRemoteServices());
                    this.fConnections.put(name, connection);
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                Activator.log(e.getMessage());
            }
        }
    }

    public IRemoteConnectionWorkingCopy newConnection(String name) throws RemoteConnectionException {
        if (this.getConnection(name) != null) {
            throw new RemoteConnectionException(NLS.bind((String)Messages.JSchConnectionManager_connection_with_name_exists, (Object)name));
        }
        return this.createConnection(name).getWorkingCopy();
    }

    public void add(JSchConnection conn) {
        if (!this.fConnections.containsKey(conn.getName())) {
            this.fConnections.put(conn.getName(), conn);
        }
    }

    public void remove(JSchConnection conn) {
        if (this.fConnections.containsKey(conn.getName())) {
            this.fConnections.remove(conn.getName());
        }
    }

    public void removeConnection(IRemoteConnection conn) throws RemoteConnectionException {
        if (!(conn instanceof JSchConnection)) {
            throw new RemoteConnectionException(Messages.JSchConnectionManager_invalidConnectionType);
        }
        if (conn.isOpen()) {
            throw new RemoteConnectionException(Messages.JSchConnectionManager_cannotRemoveOpenConnection);
        }
        ((JSchConnection)conn).getInfo().remove();
        this.fConnections.remove(conn.getName());
    }
}

