/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.ITAULaunchConfigurationConstants;
import org.eclipse.ptp.etfw.tau.LaunchImages;
import org.eclipse.ptp.etfw.tau.messages.Messages;
import org.eclipse.ptp.etfw.tau.papiselect.PapiListSelectionDialog;
import org.eclipse.ptp.etfw.tau.papiselect.papic.EventTreeDialog;
import org.eclipse.ptp.etfw.tau.perfdmf.PerfDMFUIPlugin;
import org.eclipse.ptp.etfw.tau.perfdmf.views.PerfDMFView;
import org.eclipse.ptp.etfw.toolopts.IToolUITab;
import org.eclipse.ptp.etfw.toolopts.ToolPane;
import org.eclipse.ptp.etfw.toolopts.ToolPaneListener;
import org.eclipse.ptp.etfw.ui.AbstractToolConfigurationTab;
import org.eclipse.ptp.internal.etfw.BuildLaunchUtils;
import org.eclipse.ptp.internal.etfw.RemoteBuildLaunchUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUAnalysisTab
extends AbstractToolConfigurationTab {
    protected boolean noPTP = false;
    protected CheckItem[] checks = new CheckItem[]{new CheckItem("mpi", "MPI", "", "use_mpi", true), new CheckItem("callpath", "Callpath Profiling", "", "use_callpath_profiling", false), new CheckItem("phase", "Phase Based Profiling", "", "use_tau_phases", false), new CheckItem("memory", "Memory Profiling", "", "use_memory_profiling", false), new CheckItem("opari", "OPARI", "", "use_opari", false), new CheckItem("openmp", "OpenMP", "", "use_openmp", false), new CheckItem("epilog", "Epilog", "", "use_epilog", false), new CheckItem("vampirtrace", "VampirTrace", "", "use_vampirtrace", false), new CheckItem("papi", "PAPI", "", "use_papi_library", false), new CheckItem("perf", "Perflib", "", "use_perf_library", false), new CheckItem("trace", Messages.TAUAnalysisTab_31, "", "use_tau_tracing", false), new CheckItem("pdt", "PDT", "", "use_tau_with_PDT", false)};
    protected int mpiIndex = 0;
    protected int callpathIndex = 1;
    protected Button runTauinc;
    protected int papiIndex = 8;
    protected int pdtIndex = 11;
    protected Button papiSelect;
    protected Button[] papiCountRadios;
    protected Button[] pdtRadios;
    protected Composite papiComp;
    protected Composite pdtComp;
    protected Composite mpiComp;
    protected Composite selComp;
    protected Label selectLabel;
    protected Button[] selectRadios;
    protected Text compiler;
    protected Button nocleanCheck;
    protected Button keepprofsCheck;
    protected Button profSummaryCheck;
    protected Button portalCheck;
    protected Text tauSelectFile = null;
    protected Button browseSelfileButton = null;
    protected LinkedHashSet<String> allmakefiles = null;
    protected LinkedHashSet<String> selmakefiles = null;
    protected LinkedHashSet<String> allopts = null;
    protected LinkedHashSet<String> selopts = null;
    protected Combo makecombo = null;
    protected Combo dbCombo = null;
    protected String selmakefile = null;
    private IFileStore taulib = null;
    protected Map<String, String> archvarmap = null;
    protected Map<String, String> varmap = null;
    private static final String UNIX_SLASH = "/";
    private static final String selFileValConf = "Tau Compiler.performance.options.configuration_id_-OPTTAUSELECTFILE_ARGUMENT_SAVED";
    private static final String selFileButtonConf = "Tau Compiler.performance.options.configuration_id_-OPTTAUSELECTFILE_BUTTON_STATE";
    String selectFieldVal = null;
    boolean selectFieldChecked = false;
    protected WidgetListener listener = new WidgetListener();
    private IBuildLaunchUtils blt;
    private static final String TAU_MAKEFILE_PREFIX = "Makefile.tau";
    private static final String BIN = "bin";
    private static final String EQ = "=";
    private static final String PAPI = "papi";
    private static final String PAPI_EVENT_CHOOSER = "papi_event_chooser";
    private static final String PAPIDIR = "PAPIDIR=";
    private static final String UTILS = "utils";
    private static final String SHARE = "share";
    private static final String PAPI_XML_BIN = "papi_xml_event_info";

    public TAUAnalysisTab(boolean noPar) {
        this.noPTP = noPar;
    }

    public TAUAnalysisTab() {
    }

    private void reinitMakeChecks() {
        LinkedHashSet<String> goodopts = new LinkedHashSet<String>(this.allopts.size());
        String holdmake = null;
        String check2 = null;
        if (this.selopts == null || this.selopts.size() == 0) {
            goodopts.addAll(this.allopts);
        } else {
            Iterator makes = this.allmakefiles.iterator();
            boolean allgood = true;
            while (makes.hasNext()) {
                holdmake = (String)makes.next();
                for (String check2 : this.selopts) {
                    if (holdmake.indexOf("-" + check2) > 0) continue;
                    allgood = false;
                    break;
                }
                if (allgood) {
                    goodopts.addAll(Arrays.asList(holdmake.split("-")));
                    continue;
                }
                allgood = true;
            }
        }
        int i = 0;
        while (i < this.checks.length) {
            if (!goodopts.contains(this.checks[i].makeCmd)) {
                this.checks[i].unitCheck.setEnabled(false);
            } else {
                this.checks[i].unitCheck.setEnabled(true);
            }
            ++i;
        }
    }

    private void initMakeChecks() {
        if (this.allmakefiles == null || this.allmakefiles.size() == 0 || this.allopts == null || this.allopts.size() == 0) {
            CheckItem[] checkItemArray = this.checks;
            int n = this.checks.length;
            int n2 = 0;
            while (n2 < n) {
                CheckItem check = checkItemArray[n2];
                check.unitCheck.setEnabled(false);
                ++n2;
            }
            return;
        }
        int i = 0;
        while (i < this.checks.length) {
            if (!this.allopts.contains(this.checks[i].makeCmd)) {
                this.checks[i].unitCheck.setEnabled(false);
            }
            ++i;
        }
    }

    private void initMakefiles() {
        String binpath = this.blt.getToolPath("tau");
        IFileStore bindir = null;
        if (binpath == null || binpath.length() == 0) {
            binpath = this.blt.checkToolEnvPath("pprof");
            if (binpath != null && binpath.length() > 0) {
                bindir = this.blt.getFile(binpath);
            }
        } else {
            bindir = this.blt.getFile(binpath);
        }
        List<IFileStore> mfiles = this.testTAUEnv(bindir);
        this.allmakefiles = new LinkedHashSet();
        this.allopts = new LinkedHashSet();
        String name = null;
        if (mfiles == null) {
            return;
        }
        int i = 0;
        while (i < mfiles.size()) {
            name = mfiles.get(i).getName();
            this.allmakefiles.add(name);
            this.allopts.addAll(Arrays.asList(name.split("-")));
            ++i;
        }
        this.allopts.remove(TAU_MAKEFILE_PREFIX);
    }

    private List<IFileStore> testTAUEnv(IFileStore bindir) {
        if (bindir == null || !bindir.fetchInfo().exists()) {
            return null;
        }
        this.taulib = bindir.getParent().getChild("lib");
        IFileStore[] mfiles = null;
        ArrayList<IFileStore> tmfiles = null;
        if (this.taulib.fetchInfo().exists()) {
            try {
                mfiles = this.taulib.childStores(0, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            tmfiles = new ArrayList<IFileStore>();
            IFileStore[] iFileStoreArray = mfiles;
            int n = mfiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore mfile = iFileStoreArray[n2];
                IFileInfo finf = mfile.fetchInfo();
                if (!finf.isDirectory() && finf.getName().startsWith(TAU_MAKEFILE_PREFIX)) {
                    tmfiles.add(mfile);
                }
                ++n2;
            }
        }
        return tmfiles;
    }

    private void initMakeCombo() {
        try {
            String adding2 = "";
            this.makecombo.removeAll();
            this.selectMakefiles();
            String select = "";
            if (this.selmakefiles != null && this.selmakefiles.size() > 0) {
                for (String adding2 : this.selmakefiles) {
                    if (select.length() > adding2.length() || select.equals("")) {
                        select = adding2;
                    }
                    this.makecombo.add(adding2);
                }
                if (this.selmakefile != null && this.makecombo.indexOf(this.selmakefile) >= 0) {
                    this.makecombo.select(this.makecombo.indexOf(this.selmakefile));
                } else {
                    this.makecombo.select(this.makecombo.indexOf(select));
                }
            } else {
                this.makecombo.add(Messages.TAUAnalysisTab_NoValidMakefiles);
                this.makecombo.select(0);
            }
            String makeStub = this.makecombo.getItem(this.makecombo.getSelectionIndex());
            this.updateComboDerivedOptions(makeStub);
            this.makecombo.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateComboDerivedOptions(String makeStub) {
        if (makeStub.indexOf("-papi") > 0) {
            this.papiSelect.setEnabled(true);
        } else {
            this.papiSelect.setEnabled(false);
        }
        if (makeStub.indexOf("-pdt") >= 0) {
            if (!this.pdtRadios[0].getEnabled()) {
                this.pdtRadios[0].setEnabled(true);
            }
        } else {
            this.pdtRadios[0].setEnabled(false);
            this.pdtRadios[0].setSelection(false);
            this.pdtRadios[1].setSelection(true);
        }
        if (makeStub.indexOf("-callpath") >= 0 && makeStub.indexOf("-mpi") >= 0) {
            this.runTauinc.setEnabled(true);
        } else {
            this.runTauinc.setSelection(false);
            this.runTauinc.setEnabled(false);
        }
    }

    private void selectMakefiles() {
        this.selmakefiles = new LinkedHashSet();
        Iterator allit = this.allmakefiles.iterator();
        String curmake = "";
        String curopt = "";
        while (allit.hasNext()) {
            Iterator nameit = this.selopts.iterator();
            boolean hasall = true;
            curmake = (String)allit.next();
            while (nameit.hasNext()) {
                curopt = (String)nameit.next();
                if (curmake.indexOf("-" + curopt) > 0) continue;
                hasall = false;
                break;
            }
            if (hasall) {
                this.selmakefiles.add(curmake);
                continue;
            }
            hasall = true;
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        FillLayout topLayout = new FillLayout();
        comp.setLayout((Layout)topLayout);
        TabFolder tabParent = new TabFolder(comp, 2048);
        TabItem anaTab = new TabItem(tabParent, 0);
        anaTab.setText(Messages.TAUAnalysisTab_AnalysisOptions);
        ScrolledComposite scrollAna = new ScrolledComposite((Composite)tabParent, 512);
        Composite anaComp = new Composite((Composite)scrollAna, 0);
        anaTab.setControl((Control)scrollAna);
        anaComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)1, (boolean)false, (int)0, (int)0));
        anaComp.setLayoutData((Object)TAUAnalysisTab.spanGridData((int)768, (int)5));
        this.createVerticalSpacer(anaComp, 2);
        int i = 0;
        while (i < this.checks.length) {
            if (i == this.papiIndex) {
                this.papiComp = new Composite(anaComp, 0);
                this.papiComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)5, (boolean)false, (int)0, (int)0));
                this.papiComp.setLayoutData((Object)new GridData(768));
                this.checks[i].unitCheck = this.createCheckButton(this.papiComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
                this.papiSelect = this.createPushButton(this.papiComp, Messages.TAUAnalysisTab_SelectPapiCounters, null);
                this.papiSelect.setToolTipText(Messages.TAUAnalysisTab_SetPapiEnvVar);
                this.papiSelect.addSelectionListener((SelectionListener)this.listener);
                this.papiCountRadios = new Button[2];
                this.papiCountRadios[0] = this.createRadioButton(this.papiComp, Messages.TAUAnalysisTab_PresetCounters);
                this.papiCountRadios[1] = this.createRadioButton(this.papiComp, Messages.TAUAnalysisTab_NativeCounters);
            } else if (i == this.pdtIndex) {
                this.pdtComp = new Composite(anaComp, 0);
                this.pdtComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)5, (boolean)false, (int)0, (int)0));
                this.pdtComp.setLayoutData((Object)new GridData(768));
                this.checks[i].unitCheck = this.createCheckButton(this.pdtComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
                this.pdtRadios = new Button[2];
                this.pdtRadios[0] = this.createRadioButton(this.pdtComp, Messages.TAUAnalysisTab_PDTInstrumentation);
                this.pdtRadios[1] = this.createRadioButton(this.pdtComp, Messages.TAUAnalysisTab_CompilerInstrumentation);
                this.pdtRadios[0].addSelectionListener((SelectionListener)this.listener);
                this.pdtRadios[1].addSelectionListener((SelectionListener)this.listener);
            } else if (i == this.mpiIndex) {
                this.mpiComp = new Composite(anaComp, 0);
                this.mpiComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)5, (boolean)false, (int)0, (int)0));
                this.mpiComp.setLayoutData((Object)new GridData(768));
                this.checks[i].unitCheck = this.createCheckButton(this.mpiComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
                this.runTauinc = this.createCheckButton(this.mpiComp, Messages.TAUAnalysisTab_GenerateMPIIncludeList);
                this.runTauinc.addSelectionListener((SelectionListener)this.listener);
            } else {
                this.checks[i].unitCheck = this.createCheckButton(anaComp, this.checks[i].buttonText);
                this.checks[i].unitCheck.setToolTipText(this.checks[i].toolText);
                this.checks[i].unitCheck.addSelectionListener((SelectionListener)this.listener);
            }
            ++i;
        }
        Composite makeComp = new Composite(anaComp, 0);
        makeComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)2, (boolean)false, (int)0, (int)0));
        makeComp.setLayoutData((Object)new GridData(768));
        Label makeLab = new Label(makeComp, 0);
        makeLab.setText(Messages.TAUAnalysisTab_SelectMakefile);
        this.makecombo = new Combo(makeComp, 2060);
        this.makecombo.addSelectionListener((SelectionListener)this.listener);
        anaComp.pack();
        int anaCompHeight = anaComp.computeSize((int)-1, (int)-1).y;
        scrollAna.setContent((Control)anaComp);
        scrollAna.setMinSize(400, anaCompHeight);
        scrollAna.setExpandHorizontal(true);
        scrollAna.setExpandVertical(true);
        TabItem selinstTab = new TabItem(tabParent, 0);
        selinstTab.setText(Messages.TAUAnalysisTab_SelectiveInstrumentation);
        Composite selinstComp = new Composite((Composite)tabParent, 0);
        selinstTab.setControl((Control)selinstComp);
        selinstComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)1, (boolean)false, (int)0, (int)0));
        selinstComp.setLayoutData((Object)TAUAnalysisTab.spanGridData((int)768, (int)5));
        this.createVerticalSpacer(selinstComp, 1);
        this.selectRadios = new Button[4];
        this.selectRadios[0] = this.createRadioButton(selinstComp, Messages.TAUAnalysisTab_None);
        this.selectRadios[0].setToolTipText(Messages.TAUAnalysisTab_NoSelectiveInstrumentation);
        this.selectRadios[1] = this.createRadioButton(selinstComp, Messages.TAUAnalysisTab_Internal);
        this.selectRadios[1].setToolTipText(String.valueOf(Messages.TAUAnalysisTab_UseGeneratedSelInstFile) + Messages.TAUAnalysisTab_ByWorkspaceCommands);
        this.selectRadios[2] = this.createRadioButton(selinstComp, Messages.TAUAnalysisTab_UserDefined);
        this.selectRadios[2].setToolTipText(String.valueOf(Messages.TAUAnalysisTab_SpecPreExistingSelInst) + Messages.TAUAnalysisTab_File);
        this.selComp = new Composite(selinstComp, 0);
        this.selComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)2, (boolean)false, (int)0, (int)0));
        this.selComp.setLayoutData((Object)new GridData(768));
        this.tauSelectFile = new Text(this.selComp, 2052);
        this.tauSelectFile.setLayoutData((Object)new GridData(768));
        this.tauSelectFile.addModifyListener((ModifyListener)this.listener);
        this.browseSelfileButton = this.createPushButton(this.selComp, Messages.TAUAnalysisTab_Browse, null);
        this.browseSelfileButton.addSelectionListener((SelectionListener)this.listener);
        this.selectRadios[3] = this.createRadioButton(selinstComp, Messages.TAUAnalysisTab_Automatic);
        Button[] buttonArray = this.selectRadios;
        int n = this.selectRadios.length;
        int n2 = 0;
        while (n2 < n) {
            Button selectRadio = buttonArray[n2];
            selectRadio.addSelectionListener((SelectionListener)this.listener);
            ++n2;
        }
        TabItem dataTab = new TabItem(tabParent, 0);
        dataTab.setText(Messages.TAUAnalysisTab_DataCollection);
        Composite dataComp = new Composite((Composite)tabParent, 0);
        dataTab.setControl((Control)dataComp);
        dataComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)1, (boolean)false, (int)0, (int)0));
        dataComp.setLayoutData((Object)TAUAnalysisTab.spanGridData((int)768, (int)5));
        this.createVerticalSpacer(dataComp, 1);
        Composite dbComp = new Composite(dataComp, 0);
        dbComp.setLayout((Layout)TAUAnalysisTab.createGridLayout((int)2, (boolean)false, (int)0, (int)0));
        dbComp.setLayoutData((Object)new GridData(768));
        Label dbLab = new Label(dbComp, 0);
        dbLab.setText(Messages.TAUAnalysisTab_SelectDatabase);
        this.dbCombo = new Combo(dbComp, 2060);
        this.dbCombo.addSelectionListener((SelectionListener)this.listener);
        this.keepprofsCheck = this.createCheckButton(dataComp, Messages.TAUAnalysisTab_KeepProfiles);
        this.keepprofsCheck.addSelectionListener((SelectionListener)this.listener);
        this.profSummaryCheck = this.createCheckButton(dataComp, Messages.TAUAnalysisTab_ProfileSummary);
        this.profSummaryCheck.addSelectionListener((SelectionListener)this.listener);
        this.portalCheck = this.createCheckButton(dataComp, Messages.TAUAnalysisTab_UploadDataToTauPortal);
        this.portalCheck.addSelectionListener((SelectionListener)this.listener);
    }

    public void updateComboFromSelection() {
        System.out.println("change startup");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("use_mpi", !this.noPTP);
        configuration.setAttribute("use_tauinc_script", false);
        configuration.setAttribute("use_callpath_profiling", false);
        configuration.setAttribute("use_memory_profiling", false);
        configuration.setAttribute("use_papi_library", false);
        configuration.setAttribute("use_perf_library", false);
        configuration.setAttribute("use_tau_tracing", false);
        configuration.setAttribute("use_tau_phases", false);
        configuration.setAttribute("use_this_compiler", "");
        configuration.setAttribute("use_epilog", false);
        configuration.setAttribute("use_vampirtrace", false);
        configuration.setAttribute("keep_profile_files", false);
        configuration.setAttribute("selective_instrumentation", 0);
        configuration.setAttribute("selective_instrumentation_file_path_shown", "");
        configuration.setAttribute("environment_variable_map", null);
        configuration.setAttribute("tau_makefile.performance.options.configuration_id_", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.blt = LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration) != null ? new RemoteBuildLaunchUtils(configuration) : new BuildLaunchUtils();
            this.selopts = new LinkedHashSet();
            this.initMakefiles();
            this.initMakeChecks();
            CheckItem[] checkItemArray = this.checks;
            int n = this.checks.length;
            int n2 = 0;
            while (n2 < n) {
                CheckItem check = checkItemArray[n2];
                check.unitCheck.setSelection(configuration.getAttribute(check.confString, check.defState));
                if (check.unitCheck.getSelection() && check.unitCheck.getEnabled()) {
                    this.selopts.add(check.makeCmd);
                }
                ++n2;
            }
            if (this.checks[this.mpiIndex].unitCheck.getSelection() && this.checks[this.callpathIndex].unitCheck.getSelection() && this.checks[this.mpiIndex].unitCheck.getEnabled()) {
                this.runTauinc.setEnabled(true);
            } else {
                this.runTauinc.setEnabled(false);
            }
            this.runTauinc.setSelection(configuration.getAttribute("use_tauinc_script", false));
            int pcr = configuration.getAttribute("papi_counter_type_selection", 0);
            if (pcr > 1) {
                pcr = 0;
            }
            this.papiCountRadios[pcr].setSelection(true);
            int pdtSel = configuration.getAttribute("pdt_or_compiler_inst_selection", 0);
            if (pdtSel > 1) {
                pdtSel = 0;
            }
            this.pdtRadios[pdtSel].setSelection(true);
            this.selmakefile = configuration.getAttribute("filename_of_last_selected_makefile", null);
            this.initMakeCombo();
            this.reinitMakeChecks();
            int selected = configuration.getAttribute("selective_instrumentation", 0);
            this.selectRadios[selected].setSelection(true);
            this.tauSelectFile.setText(configuration.getAttribute("selective_instrumentation_file_path_shown", ""));
            if (!this.selectRadios[2].getSelection()) {
                this.selComp.setEnabled(false);
                this.tauSelectFile.setEnabled(false);
                this.tauSelectFile.setEnabled(false);
            }
            this.selectFieldVal = configuration.getAttribute(selFileValConf, "");
            this.selectFieldChecked = configuration.getAttribute(selFileButtonConf, false);
            this.initDBCombo(configuration.getAttribute("perfdmf_database_configuration", null));
            this.keepprofsCheck.setSelection(configuration.getAttribute("keep_profile_files", false));
            this.profSummaryCheck.setSelection(configuration.getAttribute("print_profile_summary_only", false));
            this.portalCheck.setSelection(configuration.getAttribute("upload_profiles_to_portal", false));
            this.varmap = this.archvarmap = configuration.getAttribute("environment_variable_map", null);
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(Messages.TAUAnalysisTab_CoreExceptionInitAnalysisTab) + e.getMessage());
        }
    }

    private void initDBCombo(String selected) {
        String[] dbs = null;
        try {
            dbs = PerfDMFUIPlugin.getPerfDMFView().getDatabaseNames();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println(Messages.TAUAnalysisTab_WarnTauJarsNotFound);
        }
        this.dbCombo.clearSelection();
        this.dbCombo.removeAll();
        if (dbs == null || dbs.length < 1) {
            this.dbCombo.add(ITAULaunchConfigurationConstants.NODB);
            this.dbCombo.select(0);
            return;
        }
        String[] stringArray = dbs;
        int n = dbs.length;
        int n2 = 0;
        while (n2 < n) {
            String db = stringArray[n2];
            this.dbCombo.add(db);
            ++n2;
        }
        if (selected == null || this.dbCombo.indexOf(selected) < 0) {
            this.dbCombo.select(0);
        } else {
            this.dbCombo.select(this.dbCombo.indexOf(selected));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        CheckItem[] checkItemArray = this.checks;
        int n = this.checks.length;
        int n2 = 0;
        while (n2 < n) {
            CheckItem check = checkItemArray[n2];
            configuration.setAttribute(check.confString, check.unitCheck.getSelection());
            ++n2;
        }
        configuration.setAttribute("use_tauinc_script", this.runTauinc.getSelection());
        configuration.setAttribute("keep_profile_files", this.keepprofsCheck.getSelection());
        configuration.setAttribute("print_profile_summary_only", this.profSummaryCheck.getSelection());
        configuration.setAttribute("upload_profiles_to_portal", this.portalCheck.getSelection());
        if (this.varmap == null && this.archvarmap != null || this.varmap != null && this.archvarmap == null || this.varmap != null && this.archvarmap != null && !this.varmap.equals(this.archvarmap)) {
            HashMap<String, String> envvars = null;
            try {
                envvars = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (envvars != null && envvars.size() > 0 && this.archvarmap != null && this.archvarmap.size() > 0) {
                Iterator<String> archit = this.archvarmap.keySet().iterator();
                while (archit.hasNext()) {
                    envvars.remove(archit.next());
                }
            }
            if (this.varmap != null && this.varmap.size() > 0) {
                if (envvars == null) {
                    envvars = new HashMap<String, String>();
                }
                envvars.putAll(this.varmap);
            }
            configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, (Map)envvars);
            configuration.setAttribute("environment_variable_map", this.varmap);
        }
        if (this.papiCountRadios[0].getSelection()) {
            configuration.setAttribute("papi_counter_type_selection", 0);
        } else if (this.papiCountRadios[1].getSelection()) {
            configuration.setAttribute("papi_counter_type_selection", 1);
        }
        if (this.pdtRadios[0].getSelection()) {
            configuration.setAttribute("pdt_or_compiler_inst_selection", 0);
        } else {
            configuration.setAttribute("pdt_or_compiler_inst_selection", 1);
        }
        int selected = 0;
        int i = 0;
        while (i < this.selectRadios.length) {
            if (this.selectRadios[i].getSelection()) {
                selected = i;
                break;
            }
            ++i;
        }
        if (selected == 3) {
            configuration.setAttribute("use_automatic_tau_reduce", true);
        } else {
            configuration.setAttribute("use_automatic_tau_reduce", false);
        }
        configuration.setAttribute("selective_instrumentation", selected);
        configuration.setAttribute(selFileValConf, this.selectFieldVal);
        configuration.setAttribute(selFileButtonConf, this.selectFieldChecked);
        int seldex = this.makecombo.getSelectionIndex();
        if (seldex < 0 || this.taulib == null) {
            return;
        }
        String tauMakeName = this.makecombo.getItem(seldex);
        configuration.setAttribute("filename_of_last_selected_makefile", tauMakeName);
        configuration.setAttribute("tau_makefile.performance.options.configuration_id_", "-tau_makefile=" + this.taulib.toURI().getPath() + UNIX_SLASH + this.makecombo.getItem(this.makecombo.getSelectionIndex()));
        configuration.setAttribute("perfdmf_database_configuration", this.dbCombo.getItem(this.dbCombo.getSelectionIndex()));
        configuration.setAttribute("perfdmf_database_simple_name", PerfDMFView.extractDatabaseName((String)this.dbCombo.getItem(this.dbCombo.getSelectionIndex())));
        configuration.setAttribute("performance_tool_build_configuration_name_modifier.TAU", "_" + tauMakeName.substring(tauMakeName.lastIndexOf(".") + 1));
    }

    protected String getFieldContent(IntegerFieldEditor editorField) {
        return this.getFieldContent(editorField.getStringValue());
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    protected void handleSelfileBrowseButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(Messages.TAUAnalysisTab_SelectTauSelInstFile);
        String correctPath = this.getFieldContent(this.tauSelectFile.getText());
        String selectedPath = dialog.open();
        if (selectedPath != null) {
            this.tauSelectFile.setText(selectedPath);
        }
    }

    private IFileStore getPapiLoc() throws FileNotFoundException {
        if (this.makecombo == null || this.taulib == null) {
            return null;
        }
        int selDex = this.makecombo.getSelectionIndex();
        if (selDex == -1) {
            return null;
        }
        String selItem = this.makecombo.getItem(selDex);
        if (selItem == null) {
            return null;
        }
        IFileStore papimakefile = this.blt.getFile(this.taulib.toURI().getPath());
        if (!(papimakefile = papimakefile.getChild(selItem)).fetchInfo().exists()) {
            System.out.println(Messages.TAUAnalysisTab_InvalidPAPIMakefile);
        }
        String papiline = "";
        boolean found = false;
        try {
            BufferedReader readmake = new BufferedReader(new InputStreamReader(papimakefile.openInputStream(0, null)));
            papiline = readmake.readLine();
            while (papiline != null) {
                if (papiline.indexOf(PAPIDIR) == 0) {
                    found = true;
                    break;
                }
                papiline = readmake.readLine();
            }
            readmake.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFileStore papibin = null;
        if (found) {
            IFileStore papihome = this.blt.getFile(papiline = papiline.substring(papiline.indexOf(EQ) + 1));
            papibin = papihome.getChild(BIN).getChild(PAPI_EVENT_CHOOSER);
            if (!papibin.fetchInfo().exists()) {
                papibin = papihome.getChild(SHARE).getChild(PAPI).getChild(UTILS).getChild(PAPI_EVENT_CHOOSER);
            }
            if (!papibin.fetchInfo().exists()) {
                throw new FileNotFoundException(Messages.TAUAnalysisTab_CouldNotLocatePapiUtils);
            }
        } else {
            System.out.println(Messages.TAUAnalysisTab_NoPapiDirInMakefile);
        }
        return papibin.getParent();
    }

    protected void handlePapiSelect() {
        Object[] selected = null;
        try {
            IFileStore pdir = this.getPapiLoc();
            if (pdir == null || !pdir.fetchInfo().exists() || !pdir.fetchInfo().isDirectory()) {
                return;
            }
            IFileStore pcxi = pdir.getChild(PAPI_XML_BIN);
            if (pcxi.fetchInfo().exists()) {
                EventTreeDialog treeD = new EventTreeDialog(this.getShell(), pdir, this.blt);
                if (treeD.open() == 0) {
                    selected = treeD.getCommands().toArray();
                }
            } else {
                LabelProvider papilab = new LabelProvider();
                ArrayContentProvider paprov = new ArrayContentProvider();
                int papiCountType = 0;
                if (this.papiCountRadios[1].getSelection()) {
                    papiCountType = 1;
                }
                PapiListSelectionDialog papidialog = new PapiListSelectionDialog(this.getShell(), pdir, this.blt, (IStructuredContentProvider)paprov, (ILabelProvider)papilab, Messages.TAUAnalysisTab_SelectPapiCountersForTau, papiCountType);
                papidialog.setTitle(Messages.TAUAnalysisTab_PapiCounters);
                papidialog.setHelpAvailable(false);
                if (this.varmap != null && this.varmap.size() > 0) {
                    papidialog.setInitialSelections(this.varmap.values().toArray());
                }
                if (papidialog.open() == 0) {
                    selected = papidialog.getResult();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (selected != null && selected.length > 0) {
            LinkedHashSet selset = new LinkedHashSet(Arrays.asList(selected));
            String pn = "PAPI_NATIVE_";
            String pPre = "PAPI_";
            this.varmap = new HashMap<String, String>(selset.size());
            this.varmap.put("COUNTER1", "GET_TIME_OF_DAY");
            Iterator varit = selset.iterator();
            int counter = 2;
            while (varit.hasNext()) {
                String varTxt = (String)varit.next();
                if (varTxt.indexOf(pPre) != 0) {
                    varTxt = String.valueOf(pn) + varTxt;
                }
                this.varmap.put("COUNTER" + counter, varTxt);
                ++counter;
            }
        } else {
            this.varmap = null;
        }
    }

    public String getName() {
        return "TAU";
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    public Image getImage() {
        return LaunchImages.getImage("org.eclipse.ptp.etfw.tau.core.tauLogo.gif");
    }

    protected class CheckItem {
        protected Button unitCheck;
        protected String makeCmd;
        protected String buttonText;
        protected String toolText;
        protected String confString;
        protected boolean defState;

        CheckItem() {
        }

        CheckItem(String cmd, String bText, String tText, String cString, boolean def) {
            this.defState = def;
            this.makeCmd = cmd;
            this.buttonText = bText;
            this.toolText = tText;
            this.confString = cString;
        }
    }

    protected class TauPaneListener
    extends ToolPaneListener {
        TauPaneListener(ToolPane tool) {
            super((IToolUITab)tool);
        }

        protected void localAction() {
            TAUAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == TAUAnalysisTab.this.makecombo) {
                TAUAnalysisTab.this.selmakefile = TAUAnalysisTab.this.makecombo.getItem(TAUAnalysisTab.this.makecombo.getSelectionIndex());
                TAUAnalysisTab.this.updateComboDerivedOptions(TAUAnalysisTab.this.selmakefile);
                TAUAnalysisTab.this.updateLaunchConfigurationDialog();
            } else if (source == TAUAnalysisTab.this.browseSelfileButton) {
                TAUAnalysisTab.this.handleSelfileBrowseButtonSelected();
            } else if (source == TAUAnalysisTab.this.papiSelect) {
                TAUAnalysisTab.this.handlePapiSelect();
            } else if (source.equals(TAUAnalysisTab.this.selectRadios[0]) || source.equals(TAUAnalysisTab.this.selectRadios[3])) {
                if (TAUAnalysisTab.this.selectRadios[0].getSelection() || TAUAnalysisTab.this.selectRadios[3].getSelection()) {
                    TAUAnalysisTab.this.selectFieldChecked = false;
                }
            } else if (source.equals(TAUAnalysisTab.this.selectRadios[1])) {
                if (TAUAnalysisTab.this.selectRadios[1].getSelection()) {
                    TAUAnalysisTab.this.selectFieldChecked = true;
                    TAUAnalysisTab.this.selectFieldVal = "%%REPLACE_WITH_PROJECT_ROOT_DIR%%/tau.selective";
                }
            } else if (source.equals(TAUAnalysisTab.this.selectRadios[2])) {
                if (!TAUAnalysisTab.this.selectRadios[2].getSelection()) {
                    TAUAnalysisTab.this.selComp.setEnabled(false);
                    TAUAnalysisTab.this.tauSelectFile.setEnabled(false);
                    TAUAnalysisTab.this.tauSelectFile.setEnabled(false);
                } else {
                    TAUAnalysisTab.this.selComp.setEnabled(true);
                    TAUAnalysisTab.this.tauSelectFile.setEnabled(true);
                    TAUAnalysisTab.this.tauSelectFile.setEnabled(true);
                    TAUAnalysisTab.this.selectFieldChecked = true;
                    TAUAnalysisTab.this.selectFieldVal = TAUAnalysisTab.this.tauSelectFile.getText();
                }
            } else {
                CheckItem[] checkItemArray = TAUAnalysisTab.this.checks;
                int n = TAUAnalysisTab.this.checks.length;
                int n2 = 0;
                while (n2 < n) {
                    CheckItem check = checkItemArray[n2];
                    if (source == check.unitCheck) {
                        if (((Button)source).getSelection()) {
                            TAUAnalysisTab.this.selopts.add(check.makeCmd);
                        } else {
                            TAUAnalysisTab.this.selopts.remove(check.makeCmd);
                        }
                        TAUAnalysisTab.this.initMakeCombo();
                        TAUAnalysisTab.this.reinitMakeChecks();
                    }
                    ++n2;
                }
            }
            TAUAnalysisTab.this.updateLaunchConfigurationDialog();
        }

        public void propertyChange(PropertyChangeEvent event) {
            TAUAnalysisTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (source == TAUAnalysisTab.this.tauSelectFile && TAUAnalysisTab.this.selectRadios[2].getSelection()) {
                TAUAnalysisTab.this.selectFieldVal = TAUAnalysisTab.this.tauSelectFile.getText();
            }
            TAUAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }
}

