/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteBuildServiceProvider;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class RemoteProjectContentsLocationArea {
    private static final String FILE_SCHEME = "file";
    private IProject fExistingProject;
    private final IErrorMessageReporter fErrorReporter;
    private final IRunnableContext fContext;
    private RemoteBuildServiceProvider fProvider;
    private IRemoteConnection fSelectedConnection;
    private String fProjectName = "";
    private Button fBrowseButton;
    private Text fLocationText;
    private RemoteConnectionWidget fRemoteConnectionWidget;

    public RemoteProjectContentsLocationArea(IErrorMessageReporter reporter, Composite composite, IRunnableContext context) {
        this.fErrorReporter = reporter;
        this.fContext = context;
        this.createContents(composite);
    }

    public String checkValidLocation() {
        URI projectPath;
        String locationFieldContents = this.fLocationText.getText();
        if (locationFieldContents.length() == 0) {
            return IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        URI newPath = this.getProjectLocationURI();
        if (newPath == null) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
        }
        if (this.fExistingProject != null && (projectPath = this.fExistingProject.getLocationURI()) != null && URIUtil.equals((URI)projectPath, (URI)newPath)) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationIsSelf;
        }
        return null;
    }

    public Button[] getButtons() {
        return new Button[]{this.fBrowseButton, this.fRemoteConnectionWidget.getButton()};
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    public String getProjectLocation() {
        return this.fLocationText.getText();
    }

    public URI getProjectLocationURI() {
        if (this.fSelectedConnection == null) {
            return null;
        }
        return this.fSelectedConnection.getFileManager().toURI(this.fLocationText.getText());
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fSelectedConnection;
    }

    public IRemoteServices getRemoteServices() {
        if (this.fSelectedConnection != null) {
            return this.fSelectedConnection.getRemoteServices();
        }
        return null;
    }

    public boolean isDefault() {
        return false;
    }

    public void setExistingProject(IProject existingProject) {
        this.fProjectName = existingProject.getName();
        this.fExistingProject = existingProject;
    }

    public void updateProjectName(String newName) {
        this.fProjectName = newName;
        if (this.isDefault()) {
            this.fLocationText.setText(this.getDefaultPathDisplayString());
        }
    }

    private void checkConnection() {
        IRemoteUIConnectionManager mgr = this.getUIConnectionManager();
        if (mgr != null) {
            mgr.openConnectionWithProgress(this.fRemoteConnectionWidget.getShell(), this.fContext, this.fSelectedConnection);
        }
    }

    private String getDefaultPathDisplayString() {
        if (this.getRemoteConnection() != null && this.getRemoteConnection().isOpen()) {
            IRemoteFileManager fileMgr = this.getRemoteConnection().getFileManager();
            URI defaultURI = fileMgr.toURI(this.getRemoteConnection().getWorkingDirectory());
            if (defaultURI != null && defaultURI.getScheme().equals(FILE_SCHEME)) {
                return Platform.getLocation().append(this.fProjectName).toOSString();
            }
            if (defaultURI == null) {
                return "";
            }
            return new Path(defaultURI.getPath()).append(this.fProjectName).toOSString();
        }
        return "";
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteUIConnectionManager connectionManager = RemoteUIServices.getRemoteUIServices((IRemoteServices)this.fSelectedConnection.getRemoteServices()).getUIConnectionManager();
        return connectionManager;
    }

    private void handleConnectionSelected() {
        this.fSelectedConnection = this.fRemoteConnectionWidget.getConnection();
        this.fLocationText.setText(this.getDefaultPathDisplayString());
    }

    protected Control createContents(Composite parent) {
        Group container = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        this.fRemoteConnectionWidget = new RemoteConnectionWidget((Composite)container, 0, null, RemoteConnectionWidget.FLAG_FORCE_PROVIDER_SELECTION);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fRemoteConnectionWidget.setLayoutData((Object)gd);
        this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteProjectContentsLocationArea.this.handleConnectionSelected();
            }
        });
        Label locationLabel = new Label((Composite)container, 16384);
        locationLabel.setText(Messages.getString("RemoteProjectContentsLocationArea.3"));
        this.fLocationText = new Text((Composite)container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fLocationText.setLayoutData((Object)gd);
        this.fLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteProjectContentsLocationArea.this.fErrorReporter.reportError(RemoteProjectContentsLocationArea.this.checkValidLocation(), false);
            }
        });
        this.fBrowseButton = new Button((Composite)container, 8);
        this.fBrowseButton.setText(Messages.getString("RemoteProjectContentsLocationArea.4"));
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RemoteProjectContentsLocationArea.this.fSelectedConnection != null) {
                    IRemoteUIFileManager fileMgr;
                    IRemoteUIServices remoteUIServices;
                    RemoteProjectContentsLocationArea.this.checkConnection();
                    if (RemoteProjectContentsLocationArea.this.fSelectedConnection.isOpen() && (remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)RemoteProjectContentsLocationArea.this.fSelectedConnection.getRemoteServices())) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                        fileMgr.setConnection(RemoteProjectContentsLocationArea.this.fSelectedConnection);
                        String correctPath = RemoteProjectContentsLocationArea.this.fLocationText.getText();
                        String selectedPath = fileMgr.browseDirectory(RemoteProjectContentsLocationArea.this.fLocationText.getShell(), Messages.getString("RemoteProjectContentsLocationArea.5", RemoteProjectContentsLocationArea.this.fSelectedConnection.getName()), correctPath, 0);
                        if (selectedPath != null) {
                            RemoteProjectContentsLocationArea.this.fLocationText.setText(selectedPath);
                        }
                    }
                }
            }
        });
        return container;
    }

    protected void okPressed() {
        this.fProvider.setRemoteToolsConnection(this.fSelectedConnection);
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1, boolean var2);
    }
}

