/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.core;

import java.net.PasswordAuthentication;
import org.eclipse.ptp.internal.remote.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.core.IAuthInfo;
import org.eclipse.remote.core.IUserAuthenticator;

public class AuthInfo
implements IAuthInfo {
    private final IUserAuthenticator fAuthenticator;
    private String fPassword;
    private String fPassphrase;
    private boolean fIsPassword;
    private String fKeyPath;
    private String fUsername;

    public AuthInfo(IUserAuthenticator authenticator) {
        this.fAuthenticator = authenticator;
    }

    public String getKeyPath() {
        return this.fKeyPath;
    }

    public String getPassphrase() {
        return this.fPassphrase;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public String getUsername() {
        return this.fUsername;
    }

    public boolean isPasswordAuth() {
        return this.fIsPassword;
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length == 0) {
            return new String[0];
        }
        return this.fAuthenticator.prompt(destination, name, instruction, prompt, echo);
    }

    public boolean promptPassphrase(String message) {
        PasswordAuthentication auth = this.fAuthenticator.prompt(null, message);
        if (auth == null) {
            return false;
        }
        this.fUsername = auth.getUserName();
        this.fPassphrase = new String(auth.getPassword());
        return true;
    }

    public boolean promptPassword(String message) {
        PasswordAuthentication auth = this.fAuthenticator.prompt(null, message);
        if (auth == null) {
            return false;
        }
        this.fUsername = auth.getUserName();
        this.fPassword = new String(auth.getPassword());
        return true;
    }

    public boolean promptYesNo(String str) {
        int prompt = this.fAuthenticator.prompt(3, Messages.AuthInfo_Authentication_message, str, new int[]{2, 3}, 2);
        return prompt == 2;
    }

    public void setKeyPath(String keyPath) {
        this.fKeyPath = keyPath;
    }

    public void setPassphrase(String passphrase) {
        this.fPassphrase = passphrase;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public void setUsePassword(boolean usePassword) {
        this.fIsPassword = usePassword;
    }

    public void setUsername(String username) {
        this.fUsername = username;
    }

    public void showMessage(String message) {
        this.fAuthenticator.prompt(2, Messages.AuthInfo_Authentication_message, message, new int[1], 0);
    }
}

