/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.statesystem.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.internal.statesystem.core.Activator;
import org.eclipse.linuxtools.internal.statesystem.core.AttributeTree;
import org.eclipse.linuxtools.internal.statesystem.core.TransientState;
import org.eclipse.linuxtools.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;

public class StateSystem
implements ITmfStateSystemBuilder {
    private final String ssid;
    private final AttributeTree attributeTree;
    private final TransientState transState;
    private final IStateHistoryBackend backend;
    private final CountDownLatch finishedLatch = new CountDownLatch(1);
    private boolean buildCancelled = false;
    private boolean isDisposed = false;

    public StateSystem(@NonNull String ssid, @NonNull IStateHistoryBackend backend) {
        this.ssid = ssid;
        this.backend = backend;
        this.transState = new TransientState(backend);
        this.attributeTree = new AttributeTree(this);
    }

    public StateSystem(@NonNull String ssid, @NonNull IStateHistoryBackend backend, boolean newFile) throws IOException {
        this.ssid = ssid;
        this.backend = backend;
        this.transState = new TransientState(backend);
        if (newFile) {
            this.attributeTree = new AttributeTree(this);
        } else {
            this.attributeTree = new AttributeTree(this, backend.supplyAttributeTreeReader());
            this.transState.setInactive();
            this.finishedLatch.countDown();
        }
    }

    @Override
    public String getSSID() {
        return this.ssid;
    }

    @Override
    public boolean isCancelled() {
        return this.buildCancelled;
    }

    @Override
    public void waitUntilBuilt() {
        try {
            this.finishedLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean waitUntilBuilt(long timeout) {
        boolean ret = false;
        try {
            ret = this.finishedLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.transState.isActive()) {
            this.transState.setInactive();
            this.buildCancelled = true;
        }
        this.backend.dispose();
    }

    public AttributeTree getAttributeTree() {
        return this.attributeTree;
    }

    public void addEmptyAttribute() {
        this.transState.addEmptyEntry();
    }

    @Override
    public int getNbAttributes() {
        return this.getAttributeTree().getNbAttributes();
    }

    @Override
    public String getAttributeName(int attributeQuark) {
        return this.getAttributeTree().getAttributeName(attributeQuark);
    }

    @Override
    public String getFullAttributePath(int attributeQuark) {
        return this.getAttributeTree().getFullAttributeName(attributeQuark);
    }

    @Override
    public long getStartTime() {
        return this.backend.getStartTime();
    }

    @Override
    public long getCurrentEndTime() {
        return this.backend.getEndTime();
    }

    @Override
    public void closeHistory(long endTime) throws TimeRangeException {
        long realEndTime = endTime;
        if (realEndTime < this.backend.getEndTime()) {
            realEndTime = this.backend.getEndTime();
        }
        this.transState.closeTransientState(realEndTime);
        this.backend.finishedBuilding(realEndTime);
        File attributeTreeFile = this.backend.supplyAttributeTreeWriterFile();
        long attributeTreeFilePos = this.backend.supplyAttributeTreeWriterFilePosition();
        if (attributeTreeFile != null) {
            this.getAttributeTree().writeSelf(attributeTreeFile, attributeTreeFilePos);
        }
        this.finishedLatch.countDown();
    }

    @Override
    public int getQuarkAbsolute(String ... attribute) throws AttributeNotFoundException {
        return this.getAttributeTree().getQuarkDontAdd(-1, attribute);
    }

    @Override
    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        return this.getAttributeTree().getQuarkAndAdd(-1, attribute);
    }

    @Override
    public int getQuarkRelative(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        return this.getAttributeTree().getQuarkDontAdd(startingNodeQuark, subPath);
    }

    @Override
    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        return this.getAttributeTree().getQuarkAndAdd(startingNodeQuark, subPath);
    }

    @Override
    public List<Integer> getSubAttributes(int quark, boolean recursive) throws AttributeNotFoundException {
        return this.getAttributeTree().getSubAttributes(quark, recursive);
    }

    @Override
    public List<Integer> getSubAttributes(int quark, boolean recursive, String pattern) throws AttributeNotFoundException {
        List<Integer> all = this.getSubAttributes(quark, recursive);
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (Integer attQuark : all) {
            String name = this.getAttributeName(attQuark);
            if (!name.matches(pattern)) continue;
            ret.add(attQuark);
        }
        return ret;
    }

    @Override
    public int getParentAttributeQuark(int quark) {
        return this.getAttributeTree().getParentAttributeQuark(quark);
    }

    @Override
    public List<Integer> getQuarks(String ... pattern) {
        List<Integer> directChildren;
        LinkedList<Integer> quarks = new LinkedList<Integer>();
        LinkedList<String> prefix = new LinkedList<String>();
        LinkedList<String> suffix = new LinkedList<String>();
        boolean split = false;
        String[] stringArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (entry.equals("*")) {
                if (split) {
                    return quarks;
                }
                split = true;
            } else if (split) {
                suffix.add(entry);
            } else {
                prefix.add(entry);
            }
            ++n2;
        }
        String[] prefixStr = prefix.toArray(new String[prefix.size()]);
        String[] suffixStr = suffix.toArray(new String[suffix.size()]);
        if (!split) {
            int quark;
            try {
                quark = this.getQuarkAbsolute(prefixStr);
            }
            catch (AttributeNotFoundException e) {
                return quarks;
            }
            quarks.add(quark);
            return quarks;
        }
        try {
            int startingAttribute = prefix.size() == 0 ? -1 : this.getQuarkAbsolute(prefixStr);
            directChildren = this.getSubAttributes(startingAttribute, false);
        }
        catch (AttributeNotFoundException e) {
            return quarks;
        }
        for (int childQuark : directChildren) {
            int matchingQuark;
            try {
                matchingQuark = this.getQuarkRelative(childQuark, suffixStr);
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            quarks.add(matchingQuark);
        }
        return quarks;
    }

    @Override
    public void modifyAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        this.transState.processStateChange(t, value, attributeQuark);
    }

    @Override
    public void incrementAttribute(long t, int attributeQuark) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        ITmfStateValue stateValue = this.queryOngoingState(attributeQuark);
        int prevValue = 0;
        if (!stateValue.isNull()) {
            prevValue = stateValue.unboxInt();
        }
        this.modifyAttribute(t, TmfStateValue.newValueInt(prevValue + 1), attributeQuark);
    }

    @Override
    public void pushAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        int stackDepth;
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV.isNull()) {
            stackDepth = 0;
        } else if (previousSV.getType() == ITmfStateValue.Type.INTEGER) {
            stackDepth = previousSV.unboxInt();
        } else {
            throw new StateValueTypeException();
        }
        if (stackDepth >= 100000) {
            String message = "Stack limit reached, not pushing";
            throw new AttributeNotFoundException(message);
        }
        int subAttributeQuark = this.getQuarkRelativeAndAdd(attributeQuark, String.valueOf(++stackDepth));
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.modifyAttribute(t, value, subAttributeQuark);
    }

    @Override
    public ITmfStateValue popAttribute(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        ITmfStateValue previousSV = this.queryOngoingState(attributeQuark);
        if (previousSV.isNull()) {
            return null;
        }
        if (previousSV.getType() != ITmfStateValue.Type.INTEGER) {
            throw new StateValueTypeException();
        }
        int stackDepth = previousSV.unboxInt();
        if (stackDepth <= 0) {
            String message = "A top-level stack attribute cannot have a value of 0 or less.";
            throw new StateValueTypeException(message);
        }
        int subAttributeQuark = this.getQuarkRelative(attributeQuark, String.valueOf(stackDepth));
        ITmfStateValue poppedValue = this.queryOngoingState(subAttributeQuark);
        TmfStateValue nextSV = --stackDepth == 0 ? TmfStateValue.nullValue() : TmfStateValue.newValueInt(stackDepth);
        this.modifyAttribute(t, nextSV, attributeQuark);
        this.removeAttribute(t, subAttributeQuark);
        return poppedValue;
    }

    @Override
    public void removeAttribute(long t, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        assert (attributeQuark >= 0);
        List<Integer> childAttributes = this.getSubAttributes(attributeQuark, false);
        for (int childNodeQuark : childAttributes) {
            assert (attributeQuark != childNodeQuark);
            this.removeAttribute(t, childNodeQuark);
        }
        try {
            this.transState.processStateChange(t, TmfStateValue.nullValue(), attributeQuark);
        }
        catch (StateValueTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ITmfStateValue queryOngoingState(int attributeQuark) throws AttributeNotFoundException {
        return this.transState.getOngoingStateValue(attributeQuark);
    }

    @Override
    public long getOngoingStartTime(int attribute) throws AttributeNotFoundException {
        return this.transState.getOngoingStartTime(attribute);
    }

    @Override
    public void updateOngoingState(ITmfStateValue newValue, int attributeQuark) throws AttributeNotFoundException {
        this.transState.changeOngoingStateValue(attributeQuark, newValue);
    }

    protected void replaceOngoingState(List<ITmfStateInterval> newStateIntervals) {
        this.transState.replaceOngoingState(newStateIntervals);
    }

    @Override
    public synchronized List<ITmfStateInterval> queryFullState(long t) throws TimeRangeException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        ArrayList<ITmfStateInterval> stateInfo = new ArrayList<ITmfStateInterval>(this.getNbAttributes());
        int i = 0;
        while (i < this.getNbAttributes()) {
            stateInfo.add(null);
            ++i;
        }
        this.backend.doQuery(stateInfo, t);
        if (this.transState.isActive()) {
            this.transState.doQuery(stateInfo, t);
        }
        i = 0;
        while (i < stateInfo.size()) {
            if (stateInfo.get(i) == null) {
                stateInfo.set(i, new TmfStateInterval(t, t, i, TmfStateValue.nullValue()));
            }
            ++i;
        }
        return stateInfo;
    }

    @Override
    public ITmfStateInterval querySingleState(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        ITmfStateInterval ret = this.transState.getIntervalAt(t, attributeQuark);
        if (ret == null) {
            ret = this.backend.doSingularQuery(t, attributeQuark);
        }
        if (ret == null) {
            return new TmfStateInterval(t, this.getCurrentEndTime(), attributeQuark, TmfStateValue.nullValue());
        }
        return ret;
    }

    @Override
    public ITmfStateInterval querySingleStackTop(long t, int stackAttributeQuark) throws StateValueTypeException, AttributeNotFoundException, TimeRangeException, StateSystemDisposedException {
        ITmfStateValue curStackStateValue = this.querySingleState(t, stackAttributeQuark).getStateValue();
        if (curStackStateValue.isNull()) {
            return null;
        }
        int curStackDepth = curStackStateValue.unboxInt();
        if (curStackDepth <= 0) {
            throw new StateValueTypeException();
        }
        int subAttribQuark = this.getQuarkRelative(stackAttributeQuark, String.valueOf(curStackDepth));
        return this.querySingleState(t, subAttribQuark);
    }

    @Override
    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2) throws TimeRangeException, AttributeNotFoundException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        if (t2 < t1) {
            throw new TimeRangeException();
        }
        long tEnd = t2 > this.getCurrentEndTime() ? this.getCurrentEndTime() : t2;
        ArrayList<ITmfStateInterval> intervals = new ArrayList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = this.querySingleState(t1, attributeQuark);
        intervals.add(currentInterval);
        long ts = currentInterval.getEndTime();
        while (ts != -1L && ts < tEnd) {
            currentInterval = this.querySingleState(++ts, attributeQuark);
            intervals.add(currentInterval);
            ts = currentInterval.getEndTime();
        }
        return intervals;
    }

    @Override
    public List<ITmfStateInterval> queryHistoryRange(int attributeQuark, long t1, long t2, long resolution, IProgressMonitor monitor) throws TimeRangeException, AttributeNotFoundException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        LinkedList<ITmfStateInterval> intervals = new LinkedList<ITmfStateInterval>();
        ITmfStateInterval currentInterval = null;
        IProgressMonitor mon = monitor;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if (t2 < t1 || resolution <= 0L) {
            throw new TimeRangeException();
        }
        long tEnd = t2 > this.getCurrentEndTime() ? this.getCurrentEndTime() : t2;
        long ts = t1;
        while (ts <= tEnd) {
            if (mon.isCanceled()) {
                return intervals;
            }
            currentInterval = this.querySingleState(ts, attributeQuark);
            intervals.add(currentInterval);
            ts += ((currentInterval.getEndTime() - ts) / resolution + 1L) * resolution;
        }
        if (currentInterval != null && currentInterval.getEndTime() < tEnd) {
            currentInterval = this.querySingleState(tEnd, attributeQuark);
            intervals.add(currentInterval);
        }
        return intervals;
    }

    static void logMissingInterval(int attribute, long timestamp) {
        Activator.getDefault().logInfo("No data found in history for attribute " + attribute + " at time " + timestamp + ", returning dummy interval");
    }

    public void debugPrint(PrintWriter writer) {
        this.getAttributeTree().debugPrint(writer);
        this.transState.debugPrint(writer);
        this.backend.debugPrint(writer);
    }
}

