/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.statesystem.core;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.linuxtools.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;

public class TransientState {
    @NonNull
    private final IStateHistoryBackend backend;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(false);
    private volatile boolean isActive;
    private volatile long latestTime;
    private List<ITmfStateValue> ongoingStateInfo;
    private List<Long> ongoingStateStartTimes;
    private List<ITmfStateValue.Type> stateValueTypes;

    public TransientState(@NonNull IStateHistoryBackend backend) {
        this.backend = backend;
        this.isActive = true;
        this.ongoingStateInfo = new ArrayList<ITmfStateValue>();
        this.ongoingStateStartTimes = new ArrayList<Long>();
        this.stateValueTypes = new ArrayList<ITmfStateValue.Type>();
        this.latestTime = backend.getStartTime();
    }

    public long getLatestTime() {
        return this.latestTime;
    }

    public ITmfStateValue getOngoingStateValue(int quark) throws AttributeNotFoundException {
        this.rwl.readLock().lock();
        try {
            this.checkValidAttribute(quark);
            ITmfStateValue iTmfStateValue = this.ongoingStateInfo.get(quark);
            return iTmfStateValue;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public long getOngoingStartTime(int quark) throws AttributeNotFoundException {
        this.rwl.readLock().lock();
        try {
            this.checkValidAttribute(quark);
            long l = this.ongoingStateStartTimes.get(quark);
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public void changeOngoingStateValue(int quark, ITmfStateValue newValue) throws AttributeNotFoundException {
        this.rwl.writeLock().lock();
        try {
            this.checkValidAttribute(quark);
            this.ongoingStateInfo.set(quark, newValue);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public ITmfStateInterval getOngoingInterval(int quark) throws AttributeNotFoundException {
        this.rwl.readLock().lock();
        try {
            this.checkValidAttribute(quark);
            TmfStateInterval tmfStateInterval = new TmfStateInterval(this.ongoingStateStartTimes.get(quark), this.latestTime, quark, this.ongoingStateInfo.get(quark));
            return tmfStateInterval;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Nullable
    public ITmfStateInterval getIntervalAt(long time, int quark) {
        this.rwl.readLock().lock();
        try {
            this.checkValidAttribute(quark);
            if (!this.isActive() || time < this.ongoingStateStartTimes.get(quark)) {
                return null;
            }
            TmfStateInterval tmfStateInterval = new TmfStateInterval(this.ongoingStateStartTimes.get(quark), this.latestTime, quark, this.ongoingStateInfo.get(quark));
            return tmfStateInterval;
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private void checkValidAttribute(int quark) throws AttributeNotFoundException {
        if (quark > this.ongoingStateInfo.size() - 1 || quark < 0) {
            throw new AttributeNotFoundException();
        }
    }

    public void replaceOngoingState(List<ITmfStateInterval> newStateIntervals) {
        int size = newStateIntervals.size();
        this.rwl.writeLock().lock();
        try {
            this.ongoingStateInfo = new ArrayList<ITmfStateValue>(size);
            this.ongoingStateStartTimes = new ArrayList<Long>(size);
            this.stateValueTypes = new ArrayList<ITmfStateValue.Type>(size);
            for (ITmfStateInterval interval : newStateIntervals) {
                this.ongoingStateInfo.add(interval.getStateValue());
                this.ongoingStateStartTimes.add(interval.getStartTime());
                this.stateValueTypes.add(interval.getStateValue().getType());
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void addEmptyEntry() {
        this.rwl.writeLock().lock();
        try {
            this.ongoingStateInfo.add(TmfStateValue.nullValue());
            this.stateValueTypes.add(ITmfStateValue.Type.NULL);
            this.ongoingStateStartTimes.add(this.backend.getStartTime());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void processStateChange(long eventTime, ITmfStateValue value, int quark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        this.rwl.writeLock().lock();
        assert (this.isActive);
        try {
            ITmfStateValue.Type expectedSvType = this.stateValueTypes.get(quark);
            this.checkValidAttribute(quark);
            if (expectedSvType == ITmfStateValue.Type.NULL) {
                this.stateValueTypes.set(quark, value.getType());
            } else if (value.getType() != ITmfStateValue.Type.NULL && value.getType() != expectedSvType) {
                throw new StateValueTypeException();
            }
            if (this.ongoingStateInfo.get(quark).equals(value)) {
                return;
            }
            if (this.ongoingStateStartTimes.get(quark) < eventTime) {
                this.backend.insertPastState(this.ongoingStateStartTimes.get(quark), eventTime - 1L, quark, this.ongoingStateInfo.get(quark));
                this.ongoingStateStartTimes.set(quark, eventTime);
            }
            this.ongoingStateInfo.set(quark, value);
            if (this.latestTime < eventTime) {
                this.latestTime = eventTime;
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void doQuery(List<ITmfStateInterval> stateInfo, long t) {
        this.rwl.readLock().lock();
        try {
            if (!this.isActive) {
                return;
            }
            if (stateInfo.size() > this.ongoingStateInfo.size()) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < stateInfo.size()) {
                ITmfStateInterval interval = this.getIntervalAt(t, i);
                if (interval != null) {
                    stateInfo.set(i, interval);
                }
                ++i;
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public void closeTransientState(long endTime) {
        this.rwl.writeLock().lock();
        try {
            assert (this.isActive);
            int i = 0;
            while (i < this.ongoingStateInfo.size()) {
                if (this.ongoingStateStartTimes.get(i) <= endTime) {
                    try {
                        this.backend.insertPastState(this.ongoingStateStartTimes.get(i), endTime, i, this.ongoingStateInfo.get(i));
                    }
                    catch (TimeRangeException e) {
                        throw new IllegalStateException(e);
                    }
                }
                ++i;
            }
            this.ongoingStateInfo.clear();
            this.ongoingStateStartTimes.clear();
            this.isActive = false;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setInactive() {
        this.isActive = false;
    }

    public void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Info stored in the Builder:");
        if (!this.isActive) {
            writer.println("Builder is currently inactive");
            writer.println('\n');
            return;
        }
        writer.println("\nAttribute\tStateValue\tValid since time");
        int i = 0;
        while (i < this.ongoingStateInfo.size()) {
            writer.format("%d\t\t", i);
            writer.print(String.valueOf(this.ongoingStateInfo.get(i).toString()) + "\t\t");
            writer.println(this.ongoingStateStartTimes.get(i).toString());
            ++i;
        }
        writer.println('\n');
    }
}

