/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.statesystem.core.backend.historytree;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.linuxtools.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;

public final class HTInterval
implements ITmfStateInterval,
Comparable<HTInterval> {
    private static final String errMsg = "Invalid interval data. Maybe your file is corrupt?";
    private static final int DATA_ENTRY_SIZE = 25;
    private static final byte TYPE_NULL = -1;
    private static final byte TYPE_INTEGER = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_DOUBLE = 3;
    private static final int NO_ENTRY_SIZE = 0;
    private static final int LONG_ENTRY_SIZE = 8;
    private static final int DOUBLE_ENTRY_SIZE = 8;
    private final long start;
    private final long end;
    private final int attribute;
    private final TmfStateValue sv;
    private final int stringsEntrySize;

    public HTInterval(long intervalStart, long intervalEnd, int attribute, TmfStateValue value) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException();
        }
        this.start = intervalStart;
        this.end = intervalEnd;
        this.attribute = attribute;
        this.sv = value;
        this.stringsEntrySize = this.computeStringsEntrySize();
    }

    private HTInterval(long intervalStart, long intervalEnd, int attribute, TmfStateValue value, int size) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException();
        }
        this.start = intervalStart;
        this.end = intervalEnd;
        this.attribute = attribute;
        this.sv = value;
        this.stringsEntrySize = size;
    }

    public static final HTInterval readFrom(ByteBuffer buffer) throws IOException {
        HTInterval interval;
        int valueSize;
        TmfStateValue value;
        long intervalStart = buffer.getLong();
        long intervalEnd = buffer.getLong();
        int attribute = buffer.getInt();
        byte valueType = buffer.get();
        int valueOrOffset = buffer.getInt();
        switch (valueType) {
            case -1: {
                value = TmfStateValue.nullValue();
                valueSize = 0;
                break;
            }
            case 0: {
                value = TmfStateValue.newValueInt(valueOrOffset);
                valueSize = 0;
                break;
            }
            case 1: {
                buffer.mark();
                buffer.position(valueOrOffset);
                valueSize = buffer.get();
                byte[] array = new byte[valueSize - 2];
                buffer.get(array);
                value = TmfStateValue.newValueString(new String(array));
                byte res = buffer.get();
                if (res != 0) {
                    throw new IOException(errMsg);
                }
                buffer.reset();
                break;
            }
            case 2: {
                buffer.mark();
                buffer.position(valueOrOffset);
                value = TmfStateValue.newValueLong(buffer.getLong());
                valueSize = 8;
                buffer.reset();
                break;
            }
            case 3: {
                buffer.mark();
                buffer.position(valueOrOffset);
                value = TmfStateValue.newValueDouble(buffer.getDouble());
                valueSize = 8;
                buffer.reset();
                break;
            }
            default: {
                throw new IOException(errMsg);
            }
        }
        try {
            interval = new HTInterval(intervalStart, intervalEnd, attribute, value, valueSize);
        }
        catch (TimeRangeException e) {
            throw new IOException(errMsg);
        }
        return interval;
    }

    public int writeInterval(ByteBuffer buffer, int endPosOfStringEntry) {
        buffer.putLong(this.start);
        buffer.putLong(this.end);
        buffer.putInt(this.attribute);
        buffer.put(HTInterval.getByteFromType(this.sv.getType()));
        switch (HTInterval.getByteFromType(this.sv.getType())) {
            case -1: 
            case 0: {
                try {
                    buffer.putInt(this.sv.unboxInt());
                }
                catch (StateValueTypeException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                byte[] byteArrayToWrite;
                try {
                    byteArrayToWrite = this.sv.unboxStr().getBytes();
                }
                catch (StateValueTypeException e1) {
                    throw new RuntimeException();
                }
                buffer.putInt(endPosOfStringEntry - this.stringsEntrySize);
                buffer.mark();
                buffer.position(endPosOfStringEntry - this.stringsEntrySize);
                buffer.put((byte)this.stringsEntrySize);
                buffer.put(byteArrayToWrite);
                buffer.put((byte)0);
                assert (buffer.position() == endPosOfStringEntry);
                buffer.reset();
                break;
            }
            case 2: {
                buffer.putInt(endPosOfStringEntry - this.stringsEntrySize);
                buffer.mark();
                buffer.position(endPosOfStringEntry - this.stringsEntrySize);
                try {
                    buffer.putLong(this.sv.unboxLong());
                }
                catch (StateValueTypeException e) {
                    e.printStackTrace();
                }
                assert (buffer.position() == endPosOfStringEntry);
                buffer.reset();
                break;
            }
            case 3: {
                buffer.putInt(endPosOfStringEntry - this.stringsEntrySize);
                buffer.mark();
                buffer.position(endPosOfStringEntry - this.stringsEntrySize);
                try {
                    buffer.putDouble(this.sv.unboxDouble());
                }
                catch (StateValueTypeException e) {
                    e.printStackTrace();
                }
                if (buffer.position() != endPosOfStringEntry) {
                    throw new IllegalStateException();
                }
                buffer.reset();
                break;
            }
        }
        return this.stringsEntrySize;
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    @Override
    public long getViewerEndTime() {
        return this.end + 1L;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return this.sv;
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.start <= timestamp && this.end >= timestamp;
    }

    int getStringsEntrySize() {
        return this.stringsEntrySize;
    }

    public int getIntervalSize() {
        return this.stringsEntrySize + 25;
    }

    private int computeStringsEntrySize() {
        switch (this.sv.getType()) {
            case NULL: 
            case INTEGER: {
                return 0;
            }
            case LONG: {
                return 8;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                try {
                    return this.sv.unboxStr().getBytes().length + 2;
                }
                catch (StateValueTypeException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int compareTo(HTInterval other) {
        if (this.end < other.end) {
            return -1;
        }
        if (this.end > other.end) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return other instanceof HTInterval && this.compareTo((HTInterval)other) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.start);
        sb.append(", ");
        sb.append(this.end);
        sb.append(']');
        sb.append(", attribute = ");
        sb.append(this.attribute);
        sb.append(", value = ");
        sb.append(this.sv.toString());
        return sb.toString();
    }

    private static byte getByteFromType(ITmfStateValue.Type type) {
        switch (type) {
            case NULL: {
                return -1;
            }
            case INTEGER: {
                return 0;
            }
            case STRING: {
                return 1;
            }
            case LONG: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
        }
        throw new IllegalStateException();
    }
}

