/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.statesystem.core.backend.historytree;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.linuxtools.internal.statesystem.core.Activator;
import org.eclipse.linuxtools.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.linuxtools.statesystem.core.backend.historytree.HistoryTreeBackend;
import org.eclipse.linuxtools.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.statesystem.core.statevalue.TmfStateValue;

public final class ThreadedHistoryTreeBackend
extends HistoryTreeBackend
implements Runnable {
    private BlockingQueue<HTInterval> intervalQueue;
    private final Thread shtThread;

    public ThreadedHistoryTreeBackend(File newStateFile, int blockSize, int maxChildren, long startTime, int providerVersion, int queueSize) throws IOException {
        super(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.intervalQueue = new ArrayBlockingQueue<HTInterval>(queueSize);
        this.shtThread = new Thread((Runnable)this, "History Tree Thread");
        this.shtThread.start();
    }

    public ThreadedHistoryTreeBackend(File newStateFile, long startTime, int providerVersion, int queueSize) throws IOException {
        super(newStateFile, providerVersion, startTime);
        this.intervalQueue = new ArrayBlockingQueue<HTInterval>(queueSize);
        this.shtThread = new Thread((Runnable)this, "History Tree Thread");
        this.shtThread.start();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        try {
            this.intervalQueue.put(interval);
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError("State system interrupted", e);
        }
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.stopRunningThread(endTime);
        this.isFinishedBuilding = true;
    }

    @Override
    public void dispose() {
        if (!this.isFinishedBuilding) {
            this.stopRunningThread(Long.MAX_VALUE);
        }
        super.dispose();
    }

    private void stopRunningThread(long endTime) {
        if (!this.shtThread.isAlive()) {
            return;
        }
        try {
            HTInterval pill = new HTInterval(-1L, endTime, -1, TmfStateValue.nullValue());
            this.intervalQueue.put(pill);
            this.shtThread.join();
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error closing state system", e);
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError("State system interrupted", e);
        }
    }

    @Override
    public void run() {
        if (this.intervalQueue == null) {
            Activator.getDefault().logError("Cannot start the storage backend without its interval queue.");
            return;
        }
        try {
            HTInterval currentInterval = this.intervalQueue.take();
            while (currentInterval.getStartTime() != -1L) {
                this.sht.insertInterval(currentInterval);
                currentInterval = this.intervalQueue.take();
            }
            assert (currentInterval.getAttribute() == -1);
            this.sht.closeTree(currentInterval.getEndTime());
            return;
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError("State History Tree interrupted!", e);
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error starting the state system", e);
        }
    }
}

