/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.cdt.libhover.ClassInfo;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.cdt.libhover.TypedefInfo;
import org.osgi.framework.Bundle;

public class LibHoverLibrary {
    private String name;
    private String location;
    private String docs;
    private String nameSpace;
    private boolean isCPP;
    private LibHoverInfo hoverInfo = new LibHoverInfo();
    private boolean haveReadHoverInfo = false;

    public LibHoverLibrary(String name, String location, String docs, String nameSpace, boolean isCPP) {
        this.name = name;
        this.location = location;
        this.docs = docs;
        this.isCPP = isCPP;
        this.nameSpace = nameSpace;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDocs() {
        return this.docs;
    }

    public void setDocs(String docs) {
        this.docs = docs;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public boolean isCPP() {
        return this.isCPP;
    }

    public synchronized LibHoverInfo getHoverInfo() {
        if (!this.haveReadHoverInfo) {
            try {
                URI acDoc = new URI(this.location);
                IPath p = URIUtil.toPath((URI)acDoc);
                InputStream docStream = null;
                if (p == null) {
                    URL url = acDoc.toURL();
                    URLConnection c = url.openConnection();
                    c.setReadTimeout(5000);
                    docStream = c.getInputStream();
                } else {
                    try {
                        Bundle bundle = LibhoverPlugin.getDefault().getBundle();
                        String nameSpace = this.getNameSpace();
                        if (nameSpace != null) {
                            bundle = Platform.getBundle((String)nameSpace);
                        }
                        docStream = FileLocator.openStream((Bundle)bundle, (IPath)p, (boolean)false);
                    }
                    catch (IOException e) {
                        docStream = new FileInputStream(p.toFile());
                    }
                }
                ObjectInputStream input = new ObjectInputStream(docStream);
                this.hoverInfo = (LibHoverInfo)input.readObject();
                this.haveReadHoverInfo = true;
                input.close();
                docStream.close();
            }
            catch (ClassNotFoundException | MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
            }
            catch (ConnectException | SocketTimeoutException iOException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.hoverInfo;
    }

    public synchronized void setHoverinfo(LibHoverInfo hoverInfo) {
        this.hoverInfo = hoverInfo;
    }

    public ClassInfo getClassInfo(String className, ArrayList<String> templateTypes) {
        int index;
        String typedefName = className.replaceAll("<.*>", "<>");
        TypedefInfo typedef = this.getHoverInfo().typedefs.get(typedefName);
        if (typedef != null) {
            className = typedef.getTransformedType(className);
        }
        if ((index = className.indexOf(60)) != -1) {
            ArrayList<ClassInfo> children;
            this.resolveTemplateTypes(className, templateTypes, index);
            ClassInfo info = this.getHoverInfo().classes.get(className.substring(0, index));
            if (info != null && (children = info.getChildren()) != null && children.size() > 0) {
                int x = 0;
                while (x < children.size()) {
                    ClassInfo child = children.get(x);
                    if (className.matches(child.getClassName())) {
                        info = child;
                        break;
                    }
                    ++x;
                }
            }
            return info;
        }
        return this.getHoverInfo().classes.get(className);
    }

    private void resolveTemplateTypes(String className, ArrayList<String> templateTypes, int index) {
        int startIndex;
        int i = startIndex = index + 1;
        int count = 1;
        while (count > 0 && i < className.length()) {
            char x = className.charAt(i);
            switch (x) {
                case '<': {
                    ++count;
                    break;
                }
                case '>': {
                    if (--count != 0) break;
                    templateTypes.add(className.substring(startIndex, i).trim());
                    break;
                }
                case ',': {
                    if (count != 1) break;
                    templateTypes.add(className.substring(startIndex, i).trim());
                    startIndex = i + 1;
                }
            }
            ++i;
        }
    }

    public FunctionInfo getFunctionInfo(String name) {
        return this.getHoverInfo().functions.get(name);
    }
}

