/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.linuxtools.internal.ctf.core.event.EventDeclaration;

public final class EventDefinition
implements IDefinitionScope {
    @NonNull
    public static final EventDefinition NULL_EVENT = new EventDefinition(new EventDeclaration(), null, -1L, null, null, null, null);
    private final IEventDeclaration fDeclaration;
    private final long fTimestamp;
    private final StructDefinition fEventContext;
    private final StructDefinition fStreamContext;
    private final StructDefinition fPacketContext;
    private final StructDefinition fFields;
    private final CTFStreamInputReader fStreamInputReader;

    public EventDefinition(IEventDeclaration declaration, CTFStreamInputReader streamInputReader, long timestamp, StructDefinition streamContext, StructDefinition eventContext, StructDefinition packetContext, StructDefinition fields) {
        this.fDeclaration = declaration;
        this.fStreamInputReader = streamInputReader;
        this.fTimestamp = timestamp;
        this.fFields = fields;
        this.fEventContext = eventContext;
        this.fPacketContext = packetContext;
        this.fStreamContext = streamContext;
    }

    @Override
    public LexicalScope getScopePath() {
        String eventName = this.fDeclaration.getName();
        if (eventName == null) {
            return null;
        }
        LexicalScope myScope = LexicalScope.EVENT.getChild(eventName);
        if (myScope == null) {
            myScope = new LexicalScope(LexicalScope.EVENT, eventName);
        }
        return myScope;
    }

    public IEventDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public StructDefinition getFields() {
        return this.fFields;
    }

    public StructDefinition getEventContext() {
        return this.fEventContext;
    }

    public StructDefinition getContext() {
        if (this.fStreamContext == null) {
            return this.fEventContext;
        }
        if (this.fEventContext == null) {
            return this.fStreamContext;
        }
        StructDeclaration mergedDeclaration = new StructDeclaration(1L);
        ImmutableList.Builder builder = ImmutableList.builder();
        ArrayList<Definition> fieldValues = new ArrayList<Definition>();
        for (String fieldName : this.fStreamContext.getFieldNames()) {
            Definition definition = this.fStreamContext.getDefinition(fieldName);
            mergedDeclaration.addField(fieldName, definition.getDeclaration());
            builder.add((Object)fieldName);
            fieldValues.add(definition);
        }
        ImmutableList fieldNames = builder.build();
        for (String fieldName : this.fEventContext.getFieldNames()) {
            Definition definition = this.fEventContext.getDefinition(fieldName);
            mergedDeclaration.addField(fieldName, definition.getDeclaration());
            if (fieldNames.contains((Object)fieldName)) {
                fieldValues.set(fieldNames.indexOf((Object)fieldName), definition);
                continue;
            }
            builder.add((Object)fieldName);
            fieldValues.add(definition);
        }
        fieldNames = builder.build();
        StructDefinition mergedContext = new StructDefinition(mergedDeclaration, this, "context", (List<String>)fieldNames, fieldValues.toArray(new Definition[fieldValues.size()]));
        return mergedContext;
    }

    public CTFStreamInputReader getStreamInputReader() {
        return this.fStreamInputReader;
    }

    public StructDefinition getPacketContext() {
        return this.fPacketContext;
    }

    public int getCPU() {
        return this.fStreamInputReader.getCPU();
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals("context")) {
            return this.fEventContext;
        }
        if (lookupPath.equals("fields")) {
            return this.fFields;
        }
        return null;
    }

    public String toString() {
        Iterable<String> list;
        StringBuilder retString = new StringBuilder();
        String cr = System.getProperty("line.separator");
        retString.append("Event type: " + this.fDeclaration.getName() + cr);
        retString.append("Timestamp: " + Long.toString(this.fTimestamp) + cr);
        if (this.fEventContext != null) {
            list = this.fEventContext.getDeclaration().getFieldsList();
            for (String field : list) {
                retString.append(String.valueOf(field) + " : " + this.fEventContext.getDefinition(field).toString() + cr);
            }
        }
        if (this.fFields != null) {
            list = this.fFields.getDeclaration().getFieldsList();
            for (String field : list) {
                retString.append(String.valueOf(field) + " : " + this.fFields.getDefinition(field).toString() + cr);
            }
        }
        return retString.toString();
    }
}

